/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.template.BaseTemplateMap;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BasePathResultsMap
extends BaseTemplateMap {
    protected static Log logger = LogFactory.getLog(BasePathResultsMap.class);

    public BasePathResultsMap(TemplateNode parent, ServiceRegistry services) {
        super(parent, services);
    }

    protected List<TemplateNode> getChildrenByXPath(String xpath, QueryParameterDefinition[] params, boolean firstOnly) {
        List<TemplateNode> result = null;
        if (xpath.length() != 0) {
            if (logger.isDebugEnabled()) {
                String out = "Executing xpath: " + xpath;
                if (params != null) {
                    out = String.valueOf(out) + " with params:";
                    QueryParameterDefinition[] queryParameterDefinitionArray = params;
                    int n = params.length;
                    int n2 = 0;
                    while (n2 < n) {
                        QueryParameterDefinition p = queryParameterDefinitionArray[n2];
                        out = String.valueOf(out) + " " + p.getDefault();
                        ++n2;
                    }
                }
                logger.debug((Object)out);
            }
            List nodes = this.services.getSearchService().selectNodes(this.parent.getNodeRef(), xpath, params, (NamespacePrefixResolver)this.services.getNamespaceService(), false);
            if (firstOnly) {
                if (nodes.size() != 0) {
                    result = new ArrayList<TemplateNode>(1);
                    result.add(new TemplateNode((NodeRef)nodes.get(0), this.services, this.parent.getImageResolver()));
                }
            } else {
                result = new ArrayList<TemplateNode>(nodes.size());
                for (NodeRef ref : nodes) {
                    result.add(new TemplateNode(ref, this.services, this.parent.getImageResolver()));
                }
            }
        }
        return result != null ? result : Collections.emptyList();
    }
}

