/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.PathHelper;
import org.alfresco.repo.transfer.TestTransferCallback;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.TransferServiceImpl2;
import org.alfresco.repo.transfer.TransferTransmitter;
import org.alfresco.repo.transfer.UnitTestInProcessTransmitterImpl;
import org.alfresco.repo.transfer.UnitTestTransferManifestNodeFactory;
import org.alfresco.repo.transfer.manifest.TransferManifestNodeFactory;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferEvent;
import org.alfresco.service.cmr.transfer.TransferEventReport;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.service.cmr.transfer.TransferService;
import org.alfresco.service.cmr.transfer.TransferTarget;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.springframework.test.context.transaction.TestTransaction;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ResourceUtils;

@Category(value={BaseSpringTestsCategory.class, LuceneTests.class})
@Transactional
public class TransferServiceToBeRefactoredTest
extends BaseAlfrescoSpringTest {
    private TransferService transferService;
    private ContentService contentService;
    private TransferServiceImpl2 transferServiceImpl;
    private SearchService searchService;
    private TransactionService transactionService;
    private TransferReceiver receiver;
    private TransferManifestNodeFactory transferManifestNodeFactory;
    private PermissionService permissionService;
    private LockService lockService;
    private PersonService personService;
    private DescriptorService descriptorService;
    private CopyService copyService;
    private Descriptor serverDescriptor;
    private Repository repositoryHelper;
    String COMPANY_HOME_XPATH_QUERY = "/{http://www.alfresco.org/model/application/1.0}company_home";
    String GUEST_HOME_XPATH_QUERY = "/{http://www.alfresco.org/model/application/1.0}company_home/{http://www.alfresco.org/model/application/1.0}guest_home";
    String REPO_ID_A = "RepoIdA";
    String REPO_ID_B;
    String REPO_ID_C = "RepoIdC";

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        TestTransaction.end();
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            TransferServiceToBeRefactoredTest.fail((String)"Dangling transaction at start of test.");
        }
        this.transferService = (TransferService)this.applicationContext.getBean("TransferService");
        this.contentService = (ContentService)this.applicationContext.getBean("ContentService");
        this.transferServiceImpl = (TransferServiceImpl2)this.applicationContext.getBean("transferService2");
        this.searchService = (SearchService)this.applicationContext.getBean("SearchService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("TransactionService");
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        this.receiver = (TransferReceiver)this.applicationContext.getBean("transferReceiver");
        this.transferManifestNodeFactory = (TransferManifestNodeFactory)this.applicationContext.getBean("transferManifestNodeFactory");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.lockService = (LockService)this.applicationContext.getBean("lockService");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.descriptorService = (DescriptorService)this.applicationContext.getBean("DescriptorService");
        this.copyService = (CopyService)this.applicationContext.getBean("CopyService");
        this.serverDescriptor = this.descriptorService.getServerDescriptor();
        this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.REPO_ID_B = this.descriptorService.getCurrentRepositoryDescriptor().getId();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        TransferServiceToBeRefactoredTest.assertNotNull((String)"receiver is null", (Object)this.receiver);
    }

    @Test
    public void testTransferReport() throws Exception {
        final NodeRef guestHome = this.repositoryHelper.getGuestHome();
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath((String)this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath((String)this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        final Locale CONTENT_LOCALE = Locale.GERMAN;
        class TestData {
            NodeRef nodeRefA;
            NodeRef nodeRefB;
            NodeRef testFolder;
            NodeRef transferReport;
            NodeRef transferDestReport;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                String name = GUID.generate();
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
                testData.testFolder = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.testFolder, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.testFolder, ContentModel.PROP_NAME, (Serializable)((Object)name));
                ChildAssociationRef child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.testFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)GUID.generate()), ContentModel.TYPE_CONTENT);
                testData.nodeRefA = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.nodeRefA, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.nodeRefA, ContentModel.PROP_NAME, (Serializable)((Object)"Report Node A"));
                ContentWriter writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.nodeRefA, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.testFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)GUID.generate()), ContentModel.TYPE_CONTENT);
                testData.nodeRefB = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.nodeRefB, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.nodeRefB, ContentModel.PROP_NAME, (Serializable)((Object)"Report Node B"));
                writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.nodeRefB, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                if (!TransferServiceToBeRefactoredTest.this.transferService.targetExists("testTransferReport")) {
                    TransferServiceToBeRefactoredTest.this.createTransferTarget("testTransferReport");
                }
                return null;
            }
        });
        TestTransaction.start();
        try {
            TestTransferCallback callback = new TestTransferCallback();
            HashSet<TestTransferCallback> callbacks = new HashSet<TestTransferCallback>();
            callbacks.add(callback);
            TransferDefinition definition = new TransferDefinition();
            HashSet<NodeRef> nodes = new HashSet<NodeRef>();
            nodes.add(testData.nodeRefA);
            nodes.add(testData.nodeRefB);
            definition.setNodes(nodes);
            try {
                this.transferService.transfer("testTransferReport", definition, callbacks);
                TransferServiceToBeRefactoredTest.fail((String)"transfer should have failed with an orphan not found exception");
            }
            catch (TransferException transferException) {
                this.logger.debug((Object)"deliberatly caught and ignored exception");
            }
            boolean foundSourceReport = false;
            boolean foundDestReport = false;
            for (TransferEvent event : callback.getEvents()) {
                if (!(event instanceof TransferEventReport)) continue;
                TransferEventReport reportEvent = (TransferEventReport)event;
                switch (reportEvent.getReportType()) {
                    case DESTINATION: {
                        foundDestReport = true;
                        testData.transferDestReport = reportEvent.getNodeRef();
                        TransferServiceToBeRefactoredTest.assertNotNull((String)"dest transfer nodeId null", (Object)testData.transferDestReport);
                        break;
                    }
                    case SOURCE: {
                        foundSourceReport = true;
                        testData.transferReport = reportEvent.getNodeRef();
                    }
                }
            }
            TransferServiceToBeRefactoredTest.assertTrue((String)"source report not found", (boolean)foundSourceReport);
            TransferServiceToBeRefactoredTest.assertTrue((String)"dest report not found", (boolean)foundDestReport);
        }
        finally {
            TestTransaction.end();
        }
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentReader reader = TransferServiceToBeRefactoredTest.this.contentService.getReader(testData.transferReport, ContentModel.PROP_CONTENT);
                TransferServiceToBeRefactoredTest.assertNotNull((String)"transfer reader is null", (Object)reader);
                TransferServiceToBeRefactoredTest.assertEquals((String)"client report mimetype not set", (String)reader.getMimetype(), (String)"text/xml");
                String name = (String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testData.transferReport, ContentModel.PROP_NAME));
                TransferServiceToBeRefactoredTest.assertTrue((String)"client report does not end with .xml", (boolean)name.endsWith(".xml"));
                TransferServiceToBeRefactoredTest.this.logger.debug((Object)"This report should have failed");
                if (TransferServiceToBeRefactoredTest.this.logger.isDebugEnabled()) {
                    TransferServiceToBeRefactoredTest.this.dumpToSystemOut(testData.transferReport);
                }
                StreamSource transferReportSource = new StreamSource(reader.getContentInputStream());
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = sf.newSchema(ResourceUtils.getURL((String)"classpath:org/alfresco/repo/transfer/report/TransferReport2.xsd"));
                Validator validator = schema.newValidator();
                try {
                    validator.validate(transferReportSource);
                }
                catch (Exception e) {
                    TransferServiceToBeRefactoredTest.fail((String)e.getMessage());
                }
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TestTransferCallback callback = new TestTransferCallback();
                HashSet<TestTransferCallback> callbacks = new HashSet<TestTransferCallback>();
                callbacks.add(callback);
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.nodeRefA);
                nodes.add(testData.nodeRefB);
                nodes.add(testData.testFolder);
                definition.setNodes(nodes);
                testData.transferReport = TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferReport", definition, callbacks);
                TransferServiceToBeRefactoredTest.assertNotNull((String)"transfer report is null", (Object)testData.transferReport);
                boolean foundSourceReport = false;
                boolean foundDestReport = false;
                for (TransferEvent event : callback.getEvents()) {
                    if (!(event instanceof TransferEventReport)) continue;
                    TransferEventReport reportEvent = (TransferEventReport)event;
                    switch (reportEvent.getReportType()) {
                        case DESTINATION: {
                            foundDestReport = true;
                            testData.transferDestReport = reportEvent.getNodeRef();
                            TransferServiceToBeRefactoredTest.assertNotNull((String)"dest transfer nodeId null", (Object)testData.transferDestReport);
                            TransferServiceToBeRefactoredTest.assertFalse((String)"dest transfer nodeId not correct", (boolean)testData.transferReport.equals((Object)testData.transferDestReport));
                            break;
                        }
                        case SOURCE: {
                            foundSourceReport = true;
                            TransferServiceToBeRefactoredTest.assertEquals((String)"source transfer nodeId not correct", (Object)testData.transferReport, (Object)reportEvent.getNodeRef());
                        }
                    }
                }
                TransferServiceToBeRefactoredTest.assertTrue((String)"source report not found", (boolean)foundSourceReport);
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest report not found", (boolean)foundDestReport);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentReader reader = TransferServiceToBeRefactoredTest.this.contentService.getReader(testData.transferReport, ContentModel.PROP_CONTENT);
                TransferServiceToBeRefactoredTest.assertNotNull((String)"transfer reader is null", (Object)reader);
                TransferServiceToBeRefactoredTest.this.logger.debug((Object)"This report should succeed");
                if (TransferServiceToBeRefactoredTest.this.logger.isDebugEnabled()) {
                    TransferServiceToBeRefactoredTest.this.dumpToSystemOut(testData.transferReport);
                }
                StreamSource transferReportSource = new StreamSource(reader.getContentInputStream());
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = sf.newSchema(ResourceUtils.getURL((String)"classpath:org/alfresco/repo/transfer/report/TransferReport2.xsd"));
                Validator validator = schema.newValidator();
                try {
                    validator.validate(transferReportSource);
                }
                catch (Exception e) {
                    TransferServiceToBeRefactoredTest.fail((String)e.getMessage());
                }
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentReader reader = TransferServiceToBeRefactoredTest.this.contentService.getReader(testData.transferDestReport, ContentModel.PROP_CONTENT);
                TransferServiceToBeRefactoredTest.assertNotNull((String)"transfer reader is null", (Object)reader);
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest report mimetype not set", (String)reader.getMimetype(), (String)"text/xml");
                String name = (String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testData.transferReport, ContentModel.PROP_NAME));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest report does not end with .xml", (boolean)name.endsWith(".xml"));
                if (TransferServiceToBeRefactoredTest.this.logger.isDebugEnabled()) {
                    TransferServiceToBeRefactoredTest.this.dumpToSystemOut(testData.transferDestReport);
                }
                StreamSource transferReportSource = new StreamSource(reader.getContentInputStream());
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = sf.newSchema(ResourceUtils.getURL((String)"classpath:org/alfresco/repo/transfer/reportd/TransferDestinationReport.xsd"));
                Validator validator = schema.newValidator();
                try {
                    validator.validate(transferReportSource);
                }
                catch (Exception e) {
                    TransferServiceToBeRefactoredTest.fail((String)("Destination Transfer Report " + e.getMessage()));
                }
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                String query = "TYPE:\"trx:transferReportDest\"";
                ResultSet results = TransferServiceToBeRefactoredTest.this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "lucene", query);
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = sf.newSchema(ResourceUtils.getURL((String)"classpath:org/alfresco/repo/transfer/reportd/TransferDestinationReport.xsd"));
                Validator validator = schema.newValidator();
                for (ResultSetRow result : results) {
                    NodeRef reportNode = result.getNodeRef();
                    TransferServiceToBeRefactoredTest.this.logger.debug((Object)("validating  reportNode " + String.valueOf(reportNode)));
                    ContentReader reader = TransferServiceToBeRefactoredTest.this.contentService.getReader(reportNode, ContentModel.PROP_CONTENT);
                    TransferServiceToBeRefactoredTest.assertNotNull((String)"transfer reader is null", (Object)reader);
                    if (!reader.getMimetype().equals("text/xml")) continue;
                    StreamSource transferReportSource = new StreamSource(reader.getContentInputStream());
                    try {
                        validator.validate(transferReportSource);
                    }
                    catch (Exception e) {
                        TransferServiceToBeRefactoredTest.fail((String)("Destination Transfer Report reportNode:" + String.valueOf(reportNode) + " message :" + e.getMessage()));
                    }
                }
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.logger.debug((Object)"now delete the target:testTransferReport");
                TransferServiceToBeRefactoredTest.this.transferService.deleteTransferTarget("testTransferReport");
                return null;
            }
        });
    }

    private void dumpToSystemOut(NodeRef nodeRef) throws IOException {
        ContentReader reader2 = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        TransferServiceToBeRefactoredTest.assertNotNull((String)"transfer reader is null", (Object)reader2);
        InputStream is = reader2.getContentInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String s = br.readLine();
        while (s != null) {
            System.out.println(s);
            s = br.readLine();
        }
    }

    @Test
    public void testTransferSyncNodes() throws Exception {
        final Locale CONTENT_LOCALE = Locale.GERMAN;
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        final UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        final List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                pathMap.add(new Pair((Object)PathHelper.stringToPath((String)TransferServiceToBeRefactoredTest.this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath((String)TransferServiceToBeRefactoredTest.this.COMPANY_HOME_XPATH_QUERY)));
                return null;
            }
        });
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        class TestData {
            TransferTarget transferMe;
            NodeRef A1NodeRef;
            NodeRef A2NodeRef;
            NodeRef A3NodeRef;
            NodeRef A4NodeRef;
            NodeRef A5NodeRef;
            NodeRef destNodeRef;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef guestHome = TransferServiceToBeRefactoredTest.this.repositoryHelper.getGuestHome();
                String name = GUID.generate();
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
                testData.A1NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                ChildAssociationRef child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2"), ContentModel.TYPE_FOLDER);
                testData.A2NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A2"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A3"), ContentModel.TYPE_CONTENT);
                testData.A3NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A3"));
                ContentWriter writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.A3NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A4"), ContentModel.TYPE_CONTENT);
                testData.A4NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A4NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A4NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A4"));
                writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.A4NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5"), ContentModel.TYPE_CONTENT);
                testData.A5NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A5NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A5NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A5"));
                writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.A5NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                testData.transferMe = !TransferServiceToBeRefactoredTest.this.transferService.targetExists("testTransferSyncNodes") ? TransferServiceToBeRefactoredTest.this.createTransferTarget("testTransferSyncNodes") : TransferServiceToBeRefactoredTest.this.transferService.getTransferTarget("testTransferSyncNodes");
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.A1NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferSyncNodes", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                TransferServiceToBeRefactoredTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testData.destNodeRef.equals((Object)testData.transferMe.getNodeRef()));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testData.destNodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"title is wrong", (String)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testData.destNodeRef, ContentModel.PROP_TITLE))), (String)"ContentTitle");
                TransferServiceToBeRefactoredTest.assertEquals((String)"type is wrong", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getType(testData.A1NodeRef), (Object)TransferServiceToBeRefactoredTest.this.nodeService.getType(testData.destNodeRef));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testData.destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.A1NodeRef);
                nodes.add(testData.A2NodeRef);
                nodes.add(testData.A3NodeRef);
                nodes.add(testData.A4NodeRef);
                nodes.add(testData.A5NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferSyncNodes", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                TransferServiceToBeRefactoredTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testData.destNodeRef.equals((Object)testData.transferMe.getNodeRef()));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A1 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A1NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A2 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A2NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A3NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A4 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A4NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A5 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A5NodeRef)));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testData.destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.nodeService.deleteNode(testData.A2NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.A1NodeRef);
                nodes.add(testData.A3NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferSyncNodes", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                TransferServiceToBeRefactoredTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testData.destNodeRef.equals((Object)testData.transferMe.getNodeRef()));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A1 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A1NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node ref A2 has not been deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A2NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A3NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node ref A4 has not been deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A4NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node ref A5 has not been deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A5NodeRef)));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testData.destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.nodeService.deleteNode(testData.A3NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.A1NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferSyncNodes", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                TransferServiceToBeRefactoredTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testData.destNodeRef.equals((Object)testData.transferMe.getNodeRef()));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A1 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A1NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node ref A2 has not been deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A2NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node ref A3 has not been deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A3NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node ref A4 has not been deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A4NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node ref A5 has not been deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A5NodeRef)));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testData.destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A3"), ContentModel.TYPE_CONTENT);
                testData.A3NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A3"));
                ContentWriter writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.A3NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.A1NodeRef);
                nodes.add(testData.A3NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferSyncNodes", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                TransferServiceToBeRefactoredTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testData.destNodeRef.equals((Object)testData.transferMe.getNodeRef()));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A1 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A1NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node ref A2 has not been deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A2NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A3NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node ref A4 has not been deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A4NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node ref A5 has not been deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A5NodeRef)));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testData.destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2"), ContentModel.TYPE_FOLDER);
                testData.A2NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A2"));
                child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A4"), ContentModel.TYPE_CONTENT);
                testData.A4NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A4NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A4NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A4"));
                ContentWriter writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.A4NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5"), ContentModel.TYPE_CONTENT);
                testData.A5NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A5NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A5NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A5"));
                writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.A5NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.A1NodeRef);
                nodes.add(testData.A2NodeRef);
                nodes.add(testData.A3NodeRef);
                nodes.add(testData.A4NodeRef);
                nodes.add(testData.A5NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferSyncNodes", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                TransferServiceToBeRefactoredTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testData.destNodeRef.equals((Object)testData.transferMe.getNodeRef()));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A1 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A1NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A2 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A2NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A3NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A4 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A4NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A5 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A5NodeRef)));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testData.destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.logger.debug((Object)"Step 7 - delete node A3");
                TransferServiceToBeRefactoredTest.this.nodeService.deleteNode(testData.A3NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.A1NodeRef);
                nodes.add(testData.A2NodeRef);
                nodes.add(testData.A4NodeRef);
                nodes.add(testData.A5NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferSyncNodes", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A1 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A1NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A2 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A2NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node ref A3 has not been deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A3NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A4 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A4NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A5 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A5NodeRef)));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef archivedNode = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, testData.A3NodeRef.getId());
                NodeRef newNodeRef = TransferServiceToBeRefactoredTest.this.nodeService.restoreNode(archivedNode, testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A3"));
                TransferServiceToBeRefactoredTest.assertEquals((String)"restored node ref is different", (Object)newNodeRef, (Object)testData.A3NodeRef);
                TransferServiceToBeRefactoredTest.this.logger.debug((Object)"Step 7 - restore node A3");
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.A1NodeRef);
                nodes.add(testData.A2NodeRef);
                nodes.add(testData.A3NodeRef);
                nodes.add(testData.A4NodeRef);
                nodes.add(testData.A5NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferSyncNodes", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testData.destNodeRef.equals((Object)testData.transferMe.getNodeRef()));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A1 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A1NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A2 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A2NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A3NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A4 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A4NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A5 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A5NodeRef)));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.nodeService.deleteNode(testData.A2NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.A1NodeRef);
                nodes.add(testData.A3NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferSyncNodes", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                TransferServiceToBeRefactoredTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testData.destNodeRef.equals((Object)testData.transferMe.getNodeRef()));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A1 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A1NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node ref A2 has not been deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A2NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A3NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node ref A4 has not been deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A4NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node ref A5 has not been deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A5NodeRef)));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef archivedNode = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, testData.A2NodeRef.getId());
                TransferServiceToBeRefactoredTest.this.nodeService.restoreNode(archivedNode, testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.A1NodeRef);
                nodes.add(testData.A2NodeRef);
                nodes.add(testData.A3NodeRef);
                nodes.add(testData.A4NodeRef);
                nodes.add(testData.A5NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferSyncNodes", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                TransferServiceToBeRefactoredTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testData.destNodeRef.equals((Object)testData.transferMe.getNodeRef()));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A1 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A1NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A2 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A2NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A3NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A4 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A4NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref A5 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A5NodeRef)));
                return null;
            }
        });
    }

    @Test
    public void testTransferInvadedByLocalAlienNodes() throws Exception {
        final Locale CONTENT_LOCALE = Locale.JAPAN;
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        final UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath((String)this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath((String)this.COMPANY_HOME_XPATH_QUERY)));
        final String localRepositoryId = this.descriptorService.getCurrentRepositoryDescriptor().getId();
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        class TestData {
            TransferTarget transferMe;
            NodeRef A1NodeRef;
            NodeRef A2NodeRef;
            NodeRef A3NodeRef;
            NodeRef A4NodeRef;
            NodeRef A5NodeRef;
            NodeRef A6NodeRef;
            NodeRef A7NodeRef;
            NodeRef A8NodeRef;
            NodeRef B9NodeRef;
            NodeRef B10NodeRef;
            NodeRef B11NodeRef;
            NodeRef B12NodeRef;
            NodeRef B13NodeRef;
            NodeRef B14NodeRef;
            NodeRef destNodeRef;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef guestHome = TransferServiceToBeRefactoredTest.this.repositoryHelper.getGuestHome();
                String name = GUID.generate();
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
                testData.A1NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                ChildAssociationRef child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2"), ContentModel.TYPE_FOLDER);
                testData.A2NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A2"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A3"), ContentModel.TYPE_CONTENT);
                testData.A3NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A3"));
                ContentWriter writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.A3NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A4"), ContentModel.TYPE_FOLDER);
                testData.A4NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A4NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A4NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A4"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5"), ContentModel.TYPE_CONTENT);
                testData.A5NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A5NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A5NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A5"));
                writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.A5NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A6"), ContentModel.TYPE_FOLDER);
                testData.A6NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A6NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A6NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A6"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A4NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A7"), ContentModel.TYPE_CONTENT);
                testData.A7NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A7NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A7NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A7"));
                writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.A7NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A6NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A8"), ContentModel.TYPE_CONTENT);
                testData.A8NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A8NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A8NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A8"));
                writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.A8NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                testData.transferMe = !TransferServiceToBeRefactoredTest.this.transferService.targetExists("testSyncWithAlienNodes") ? TransferServiceToBeRefactoredTest.this.createTransferTarget("testSyncWithAlienNodes") : TransferServiceToBeRefactoredTest.this.transferService.getTransferTarget("testSyncWithAlienNodes");
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.A1NodeRef);
                nodes.add(testData.A2NodeRef);
                nodes.add(testData.A3NodeRef);
                nodes.add(testData.A4NodeRef);
                nodes.add(testData.A5NodeRef);
                nodes.add(testData.A6NodeRef);
                nodes.add(testData.A7NodeRef);
                nodes.add(testData.A8NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testSyncWithAlienNodes", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                TransferServiceToBeRefactoredTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)A1destNodeRef.equals((Object)testData.transferMe.getNodeRef()));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(A1destNodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"title is wrong", (String)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, ContentModel.PROP_TITLE))), (String)"ContentTitle");
                TransferServiceToBeRefactoredTest.assertEquals((String)"type is wrong", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getType(testData.A1NodeRef), (Object)TransferServiceToBeRefactoredTest.this.nodeService.getType(A1destNodeRef));
                TransferServiceToBeRefactoredTest.assertFalse((String)"A1 is alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.destNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B9"), ContentModel.TYPE_CONTENT);
                testData.B9NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B9NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B9NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B9"));
                ContentWriter writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.B9NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(A1destNodeRef));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A1 is not alien aspect", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"repository id is null", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"from repository id is null", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID))));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node B9 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testData.B9NodeRef, TransferModel.ASPECT_ALIEN));
                List invaders = (List)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_INVADED_BY));
                TransferServiceToBeRefactoredTest.assertTrue((String)"invaders contains local repository Id", (boolean)invaders.contains(localRepositoryId));
                TransferServiceToBeRefactoredTest.assertFalse((String)"invaders contains REPO_ID_A", (boolean)invaders.contains(TransferServiceToBeRefactoredTest.this.REPO_ID_A));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.logger.debug((Object)"delete node B9");
                TransferServiceToBeRefactoredTest.this.nodeService.deleteNode(testData.B9NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                NodeRef A3destNodeRef = testNodeFactory.getMappedNodeRef(testData.A3NodeRef);
                List cfr_ignored_0 = (List)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_INVADED_BY));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(A1destNodeRef));
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A1 is still alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A3 is alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A3destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"repository id is null", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"from repository id is null", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID))));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.A2NodeRef);
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.destNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B10"), ContentModel.TYPE_CONTENT);
                testData.B10NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B10NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B10NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B10"));
                ContentWriter writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.B10NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                NodeRef A2destNodeRef = testNodeFactory.getMappedNodeRef(testData.A2NodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A1 is not alien aspect", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A2 is not alien aspect", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.logger.debug((Object)"delete node B10");
                TransferServiceToBeRefactoredTest.this.nodeService.deleteNode(testData.B10NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                NodeRef A2destNodeRef = testNodeFactory.getMappedNodeRef(testData.A2NodeRef);
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A1 is still alien aspect", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A2 is still alien aspect", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.A6NodeRef);
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.destNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B12"), ContentModel.TYPE_FOLDER);
                testData.B12NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B12NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B12NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B12"));
                child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.B12NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B14"), ContentModel.TYPE_CONTENT);
                testData.B14NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B14NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B14NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B14"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                NodeRef A2destNodeRef = testNodeFactory.getMappedNodeRef(testData.A2NodeRef);
                NodeRef A6destNodeRef = testNodeFactory.getMappedNodeRef(testData.A6NodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A1 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A2 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A6 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A6destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node B14 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testData.B14NodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node B12 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testData.B12NodeRef, TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.nodeService.deleteNode(testData.B14NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                NodeRef A2destNodeRef = testNodeFactory.getMappedNodeRef(testData.A2NodeRef);
                NodeRef A6destNodeRef = testNodeFactory.getMappedNodeRef(testData.A6NodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A1 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A2 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A6 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A6destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node B12 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testData.B12NodeRef, TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.A6NodeRef);
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.destNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B13"), ContentModel.TYPE_CONTENT);
                testData.B13NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B13NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B13NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B13"));
                ContentWriter writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.B13NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                NodeRef A2destNodeRef = testNodeFactory.getMappedNodeRef(testData.A2NodeRef);
                NodeRef A6destNodeRef = testNodeFactory.getMappedNodeRef(testData.A6NodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A1 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A2 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A6 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A6destNodeRef, TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.nodeService.deleteNode(testData.B13NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                NodeRef A2destNodeRef = testNodeFactory.getMappedNodeRef(testData.A2NodeRef);
                NodeRef A6destNodeRef = testNodeFactory.getMappedNodeRef(testData.A6NodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A1 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A2 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A6 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A6destNodeRef, TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.nodeService.deleteNode(testData.B12NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                NodeRef A2destNodeRef = testNodeFactory.getMappedNodeRef(testData.A2NodeRef);
                NodeRef A6destNodeRef = testNodeFactory.getMappedNodeRef(testData.A6NodeRef);
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A1 is still alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A2 is still alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A6 is still alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A6destNodeRef, TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.destNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B9"), ContentModel.TYPE_CONTENT);
                testData.B9NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B9NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B9NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B9"));
                ContentWriter writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.B9NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.A2NodeRef);
                child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.destNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B10"), ContentModel.TYPE_CONTENT);
                testData.B10NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B10NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B10NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B10"));
                writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.B10NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                NodeRef A2destNodeRef = testNodeFactory.getMappedNodeRef(testData.A2NodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A1 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A2 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.nodeService.deleteNode(testData.B10NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                NodeRef A2destNodeRef = testNodeFactory.getMappedNodeRef(testData.A2NodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A1 is still alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A2 is still alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
        this.logger.debug((Object)"Step 12 Add Node B11, Delete A2 and sync");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.A4NodeRef);
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.destNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B11"), ContentModel.TYPE_CONTENT);
                testData.B11NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B11NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B11NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B11"));
                ContentWriter writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.B11NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                TransferServiceToBeRefactoredTest.this.nodeService.deleteNode(testData.A2NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                NodeRef A2destNodeRef = testNodeFactory.getMappedNodeRef(testData.A2NodeRef);
                NodeRef A4destNodeRef = testNodeFactory.getMappedNodeRef(testData.A4NodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A1 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A2 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A4 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A4destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"test error: node A2 not deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testData.A2NodeRef));
                TransferServiceToBeRefactoredTest.assertFalse((String)"test error: node A4 not deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testData.A4NodeRef));
                TransferServiceToBeRefactoredTest.assertFalse((String)"test error: node A5 not deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testData.A5NodeRef));
                TransferServiceToBeRefactoredTest.assertFalse((String)"test error: node A6 not deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testData.A6NodeRef));
                TransferServiceToBeRefactoredTest.assertFalse((String)"test error: node A7 not deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testData.A7NodeRef));
                TransferServiceToBeRefactoredTest.assertFalse((String)"test error: node A8 not deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testData.A8NodeRef));
                TransferServiceToBeRefactoredTest.assertTrue((String)"test error: node does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testData.A3NodeRef));
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.A1NodeRef);
                nodes.add(testData.A3NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testSyncWithAlienNodes", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                NodeRef A2destNodeRef = testNodeFactory.getMappedNodeRef(testData.A2NodeRef);
                NodeRef A3destNodeRef = testNodeFactory.getMappedNodeRef(testData.A3NodeRef);
                NodeRef A4destNodeRef = testNodeFactory.getMappedNodeRef(testData.A4NodeRef);
                NodeRef A5destNodeRef = testNodeFactory.getMappedNodeRef(testData.A5NodeRef);
                NodeRef A6destNodeRef = testNodeFactory.getMappedNodeRef(testData.A6NodeRef);
                NodeRef A7destNodeRef = testNodeFactory.getMappedNodeRef(testData.A7NodeRef);
                NodeRef A8destNodeRef = testNodeFactory.getMappedNodeRef(testData.A8NodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A1 not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A2 not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A4 not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A4destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node B11 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testData.B11NodeRef));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A3 deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(A3destNodeRef));
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A5 not deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(A5destNodeRef));
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A6 not deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(A6destNodeRef));
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A7 not deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(A7destNodeRef));
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A8 not deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(A8destNodeRef));
                return null;
            }
        });
    }

    @Test
    public void testLocalAlienRestore() throws Exception {
        class TestData {
            TransferTarget transferMe;
            NodeRef S0NodeRef;
            NodeRef A0NodeRef;
            NodeRef A1NodeRef;
            NodeRef B1NodeRef;
            NodeRef B2NodeRef;
            NodeRef B3NodeRef;
            NodeRef destNodeRef;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef guestHome = TransferServiceToBeRefactoredTest.this.repositoryHelper.getGuestHome();
                String name = GUID.generate();
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
                testData.S0NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.S0NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.S0NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                ChildAssociationRef child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A0"), ContentModel.TYPE_FOLDER);
                testData.A0NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A0NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A0NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A0"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A1"), ContentModel.TYPE_FOLDER);
                testData.A1NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A1"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B1"), ContentModel.TYPE_FOLDER);
                testData.B1NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B1"));
                testData.transferMe = !TransferServiceToBeRefactoredTest.this.transferService.targetExists("testRestoreOfAlienNodes") ? TransferServiceToBeRefactoredTest.this.createTransferTarget("testRestoreOfAlienNodes") : TransferServiceToBeRefactoredTest.this.transferService.getTransferTarget("testRestoreOfAlienNodes");
                return null;
            }
        });
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        final UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        final List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                pathMap.add(new Pair((Object)TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.A0NodeRef), (Object)TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.B1NodeRef)));
                return null;
            }
        });
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.A1NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testRestoreOfAlienNodes", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(A1destNodeRef));
                TransferServiceToBeRefactoredTest.assertFalse((String)"A1 is alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.destNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B2"), ContentModel.TYPE_FOLDER);
                testData.B2NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B2"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(A1destNodeRef));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A1 is not alien aspect", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"repository id is null", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"from repository id is null", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID))));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node B2 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testData.B2NodeRef, TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.logger.debug((Object)"delete node B2");
                TransferServiceToBeRefactoredTest.this.nodeService.deleteNode(testData.B2NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                List cfr_ignored_0 = (List)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_INVADED_BY));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(A1destNodeRef));
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A1 is still alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"repository id is null", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"from repository id is null", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID))));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.logger.debug((Object)"restore node B2");
                NodeRef B2ArchiveNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, testData.B2NodeRef.getId());
                TransferServiceToBeRefactoredTest.this.nodeService.restoreNode(B2ArchiveNodeRef, testNodeFactory.getMappedNodeRef(testData.A1NodeRef), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B2"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(A1destNodeRef));
                TransferServiceToBeRefactoredTest.assertTrue((String)"node A1 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"repository id is null", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"from repository id is null", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID))));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.B2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B3"), ContentModel.TYPE_FOLDER);
                testData.B3NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B3"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"node B3 is not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testData.B3NodeRef, TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.logger.debug((Object)"delete node B2");
                TransferServiceToBeRefactoredTest.this.nodeService.deleteNode(testData.B2NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A1destNodeRef = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                List cfr_ignored_0 = (List)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_INVADED_BY));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(A1destNodeRef));
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A1 is still alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"repository id is null", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                TransferServiceToBeRefactoredTest.assertNotNull((String)"from repository id is null", (Object)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID))));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.logger.debug((Object)"restore node B2");
                NodeRef B2ArchiveNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, testData.B2NodeRef.getId());
                TransferServiceToBeRefactoredTest.this.nodeService.restoreNode(B2ArchiveNodeRef, testData.B1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B2"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A1 is still alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.A1NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A2 is still alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testData.B2NodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"node A3 is still alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testData.B3NodeRef, TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
    }

    @Test
    public void testTransferWithPermissions() throws Exception {
        final Locale CONTENT_LOCALE = Locale.GERMAN;
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        final UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath((String)this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath((String)this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        class TestData {
            TransferTarget transferMe;
            NodeRef contentNodeRef;
            NodeRef destNodeRef;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef guestHome = TransferServiceToBeRefactoredTest.this.repositoryHelper.getGuestHome();
                String name = GUID.generate();
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_CONTENT);
                testData.contentNodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                ContentWriter writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.contentNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                TransferServiceToBeRefactoredTest.this.permissionService.setInheritParentPermissions(testData.contentNodeRef, false);
                TransferServiceToBeRefactoredTest.this.permissionService.setPermission(testData.contentNodeRef, "admin", "Read", true);
                testData.transferMe = !TransferServiceToBeRefactoredTest.this.transferService.targetExists("testTransferWithPermissions") ? TransferServiceToBeRefactoredTest.this.createTransferTarget("testTransferWithPermissions") : TransferServiceToBeRefactoredTest.this.transferService.getTransferTarget("testTransferWithPermissions");
                return null;
            }
        });
        this.logger.debug((Object)"First transfer - create new node with inheritParent permission off");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.contentNodeRef);
                definition.setNodes(nodes);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferWithPermissions", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.contentNodeRef);
                TransferServiceToBeRefactoredTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testData.destNodeRef.equals((Object)testData.transferMe.getNodeRef()));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testData.destNodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"title is wrong", (String)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testData.destNodeRef, ContentModel.PROP_TITLE))), (String)"ContentTitle");
                TransferServiceToBeRefactoredTest.assertEquals((String)"type is wrong", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getType(testData.contentNodeRef), (Object)TransferServiceToBeRefactoredTest.this.nodeService.getType(testData.destNodeRef));
                boolean srcInherit = TransferServiceToBeRefactoredTest.this.permissionService.getInheritParentPermissions(testData.contentNodeRef);
                Set srcPerm = TransferServiceToBeRefactoredTest.this.permissionService.getAllSetPermissions(testData.contentNodeRef);
                boolean destInherit = TransferServiceToBeRefactoredTest.this.permissionService.getInheritParentPermissions(testData.destNodeRef);
                Set destPerm = TransferServiceToBeRefactoredTest.this.permissionService.getAllSetPermissions(testData.destNodeRef);
                TransferServiceToBeRefactoredTest.assertFalse((String)"inherit parent permissions (src) flag is incorrect", (boolean)srcInherit);
                TransferServiceToBeRefactoredTest.assertFalse((String)"inherit parent permissions (dest) flag is incorrect", (boolean)destInherit);
                for (AccessPermission p : srcPerm) {
                    TransferServiceToBeRefactoredTest.this.logger.debug((Object)("checking permission :" + String.valueOf(p)));
                    TransferServiceToBeRefactoredTest.assertTrue((String)"permission is missing", (boolean)destPerm.contains(p));
                }
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.permissionService.setPermission(testData.contentNodeRef, "EVERYONE", "Read", false);
                TransferServiceToBeRefactoredTest.this.permissionService.setPermission(testData.contentNodeRef, "admin", "FullControl", true);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.contentNodeRef);
                definition.setNodes(nodes);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferWithPermissions", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.contentNodeRef);
                boolean srcInherit = TransferServiceToBeRefactoredTest.this.permissionService.getInheritParentPermissions(testData.contentNodeRef);
                Set srcPerm = TransferServiceToBeRefactoredTest.this.permissionService.getAllSetPermissions(testData.contentNodeRef);
                boolean destInherit = TransferServiceToBeRefactoredTest.this.permissionService.getInheritParentPermissions(testData.destNodeRef);
                Set destPerm = TransferServiceToBeRefactoredTest.this.permissionService.getAllSetPermissions(testData.destNodeRef);
                TransferServiceToBeRefactoredTest.assertFalse((String)"inherit parent permissions (src) flag is incorrect", (boolean)srcInherit);
                TransferServiceToBeRefactoredTest.assertFalse((String)"inherit parent permissions (dest) flag is incorrect", (boolean)destInherit);
                for (AccessPermission p : srcPerm) {
                    TransferServiceToBeRefactoredTest.this.logger.debug((Object)("checking permission :" + String.valueOf(p)));
                    TransferServiceToBeRefactoredTest.assertTrue((String)"Step2, permission is missing", (boolean)destPerm.contains(p));
                }
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.permissionService.deletePermission(testData.contentNodeRef, "admin", "FullControl");
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.contentNodeRef);
                definition.setNodes(nodes);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferWithPermissions", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.contentNodeRef);
                boolean srcInherit = TransferServiceToBeRefactoredTest.this.permissionService.getInheritParentPermissions(testData.contentNodeRef);
                Set srcPerm = TransferServiceToBeRefactoredTest.this.permissionService.getAllSetPermissions(testData.contentNodeRef);
                boolean destInherit = TransferServiceToBeRefactoredTest.this.permissionService.getInheritParentPermissions(testData.destNodeRef);
                Set destPerm = TransferServiceToBeRefactoredTest.this.permissionService.getAllSetPermissions(testData.destNodeRef);
                TransferServiceToBeRefactoredTest.assertFalse((String)"inherit parent permissions (src) flag is incorrect", (boolean)srcInherit);
                TransferServiceToBeRefactoredTest.assertFalse((String)"inherit parent permissions (dest) flag is incorrect", (boolean)destInherit);
                for (AccessPermission p : srcPerm) {
                    TransferServiceToBeRefactoredTest.this.logger.debug((Object)("checking permission :" + String.valueOf(p)));
                    TransferServiceToBeRefactoredTest.assertTrue((String)"permission is missing", (boolean)destPerm.contains(p));
                }
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.permissionService.setInheritParentPermissions(testData.contentNodeRef, true);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.contentNodeRef);
                definition.setNodes(nodes);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferWithPermissions", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.destNodeRef = testNodeFactory.getMappedNodeRef(testData.contentNodeRef);
                TransferServiceToBeRefactoredTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testData.destNodeRef.equals((Object)testData.transferMe.getNodeRef()));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testData.destNodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"title is wrong", (String)((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testData.destNodeRef, ContentModel.PROP_TITLE))), (String)"ContentTitle");
                TransferServiceToBeRefactoredTest.assertEquals((String)"type is wrong", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getType(testData.contentNodeRef), (Object)TransferServiceToBeRefactoredTest.this.nodeService.getType(testData.destNodeRef));
                boolean srcInherit = TransferServiceToBeRefactoredTest.this.permissionService.getInheritParentPermissions(testData.contentNodeRef);
                Set srcPerm = TransferServiceToBeRefactoredTest.this.permissionService.getAllSetPermissions(testData.contentNodeRef);
                boolean destInherit = TransferServiceToBeRefactoredTest.this.permissionService.getInheritParentPermissions(testData.destNodeRef);
                Set destPerm = TransferServiceToBeRefactoredTest.this.permissionService.getAllSetPermissions(testData.destNodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"inherit parent permissions (src) flag is incorrect", (boolean)srcInherit);
                TransferServiceToBeRefactoredTest.assertTrue((String)"inherit parent permissions (dest) flag is incorrect", (boolean)destInherit);
                for (AccessPermission p : srcPerm) {
                    if (!p.isSetDirectly()) continue;
                    TransferServiceToBeRefactoredTest.this.logger.debug((Object)("checking permission :" + String.valueOf(p)));
                    TransferServiceToBeRefactoredTest.assertTrue((String)("permission is missing:" + String.valueOf(p)), (boolean)destPerm.contains(p));
                }
                return null;
            }
        });
    }

    @Test
    public void testReadOnlyFlag() throws Exception {
        final Locale CONTENT_LOCALE = Locale.GERMAN;
        final HashSet nodes = new HashSet();
        class TestData {
            NodeRef nodeA;
            NodeRef nodeB;
            NodeRef nodeC;
            NodeRef nodeD;
            ChildAssociationRef child;
            TransferTarget transferMe;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        final UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath((String)this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath((String)this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef guestHome = TransferServiceToBeRefactoredTest.this.repositoryHelper.getGuestHome();
                String guid = GUID.generate();
                testData.child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)guid), ContentModel.TYPE_FOLDER);
                testData.nodeA = testData.child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.nodeA, ContentModel.PROP_TITLE, (Serializable)((Object)guid));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.nodeA, ContentModel.PROP_NAME, (Serializable)((Object)guid));
                nodes.add(testData.nodeA);
                testData.child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.nodeA, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"testNodeB"), ContentModel.TYPE_CONTENT);
                testData.nodeB = testData.child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.nodeB, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitleB"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.nodeB, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeB"));
                ContentWriter writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.nodeB, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("The quick brown fox");
                nodes.add(testData.nodeB);
                testData.child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.nodeA, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeC"), ContentModel.TYPE_FOLDER);
                testData.nodeC = testData.child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.nodeC, ContentModel.PROP_TITLE, (Serializable)((Object)"TestNodeC"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.nodeC, ContentModel.PROP_NAME, (Serializable)((Object)"TestNodeC"));
                nodes.add(testData.nodeC);
                testData.child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.nodeC, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"testNodeD"), ContentModel.TYPE_CONTENT);
                testData.nodeD = testData.child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.nodeD, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitleD"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.nodeD, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeD"));
                writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.nodeD, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("The quick brown fox");
                nodes.add(testData.nodeD);
                TransferServiceToBeRefactoredTest.this.createUser("TransferServiceImplTest", "TransferServiceImplTest", "Password");
                testData.transferMe = !TransferServiceToBeRefactoredTest.this.transferService.targetExists("testReadOnlyFlag") ? TransferServiceToBeRefactoredTest.this.createTransferTarget("testReadOnlyFlag") : TransferServiceToBeRefactoredTest.this.transferService.getTransferTarget("testReadOnlyFlag");
                return null;
            }
        });
        this.logger.debug((Object)"transfer read only - step 1");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                definition.setNodes((Collection)nodes);
                definition.setReadOnly(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testReadOnlyFlag", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeA)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node B does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeB)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeC)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node D does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeD)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeA), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node B not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeB), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeC), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node D not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeD), ContentModel.ASPECT_LOCKABLE));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                AuthenticationUtil.pushAuthentication();
                AuthenticationUtil.setFullyAuthenticatedUser((String)"TransferServiceImplTest");
                TransferServiceToBeRefactoredTest.this.lockService.lock(testData.nodeB, LockType.READ_ONLY_LOCK);
                TransferServiceToBeRefactoredTest.assertEquals((String)"test error: dest node B lock ownership", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testData.nodeB, ContentModel.PROP_LOCK_OWNER), (Object)"TransferServiceImplTest");
                AuthenticationUtil.popAuthentication();
                return null;
            }
        });
        this.logger.debug((Object)"transfer read only - step 2");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                definition.setNodes((Collection)nodes);
                definition.setReadOnly(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testReadOnlyFlag", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeA)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node B does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeB)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeC)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node D does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeD)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeA), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node B not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeB), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeC), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node D not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeD), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertTrue((String)"lock owner not changed", (!"TransferServiceImplTest".equalsIgnoreCase((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.nodeB), ContentModel.PROP_LOCK_OWNER))) ? 1 : 0) != 0);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                AuthenticationUtil.pushAuthentication();
                AuthenticationUtil.setFullyAuthenticatedUser((String)"TransferServiceImplTest");
                TransferServiceToBeRefactoredTest.this.lockService.lock(testData.nodeC, LockType.READ_ONLY_LOCK);
                TransferServiceToBeRefactoredTest.assertEquals((String)"test error: dest node C lock ownership", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testData.nodeC, ContentModel.PROP_LOCK_OWNER), (Object)"TransferServiceImplTest");
                AuthenticationUtil.popAuthentication();
                return null;
            }
        });
        this.logger.debug((Object)"transfer read only - step 3");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                definition.setNodes((Collection)nodes);
                definition.setReadOnly(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testReadOnlyFlag", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeA)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node B does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeB)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeC)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node D does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeD)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeA), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node B not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeB), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeC), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node D not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeD), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertTrue((String)"lock owner not changed", (!"TransferServiceImplTest".equalsIgnoreCase((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.nodeB), ContentModel.PROP_LOCK_OWNER))) ? 1 : 0) != 0);
                TransferServiceToBeRefactoredTest.assertTrue((String)"lock owner not changed", (!"TransferServiceImplTest".equalsIgnoreCase((String)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.nodeC), ContentModel.PROP_LOCK_OWNER))) ? 1 : 0) != 0);
                return null;
            }
        });
        this.logger.debug((Object)"transfer read only - step 4");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                definition.setNodes((Collection)nodes);
                definition.setReadOnly(false);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testReadOnlyFlag", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeA)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node B does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeB)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeC)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node D does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeD)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node A not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeA), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node B not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeB), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeC), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node D not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeD), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node B lock ownership", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.nodeB), ContentModel.PROP_LOCK_OWNER), (Object)"TransferServiceImplTest");
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node C lock ownership", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.nodeC), ContentModel.PROP_LOCK_OWNER), (Object)"TransferServiceImplTest");
                return null;
            }
        });
        this.logger.debug((Object)"transfer read only - step 5");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.lockService.unlock(testData.nodeB);
                TransferServiceToBeRefactoredTest.this.lockService.unlock(testData.nodeC);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                definition.setNodes((Collection)nodes);
                definition.setReadOnly(false);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testReadOnlyFlag", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeA)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node B does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeB)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeC)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node D does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.nodeD)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"test fail: dest node B is still locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testData.nodeB, ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertFalse((String)"test fail: dest node C is still locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testData.nodeC, ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node A not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeA), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node B not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeB), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node C not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeC), ContentModel.ASPECT_LOCKABLE));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node D not locked", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.nodeD), ContentModel.ASPECT_LOCKABLE));
                return null;
            }
        });
    }

    @Test
    public void testTwoRepoSync() throws Exception {
        final Locale CONTENT_LOCALE = Locale.GERMAN;
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        final UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath((String)this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath((String)this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        final String repositoryId = this.REPO_ID_A;
        class TestData {
            TransferTarget transferMe;
            NodeRef A1NodeRef;
            NodeRef A2NodeRef;
            NodeRef A3NodeRef;
            NodeRef A4NodeRef;
            NodeRef A5NodeRef;
            NodeRef B6NodeRef;
            NodeRef A7NodeRef;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef guestHome = TransferServiceToBeRefactoredTest.this.repositoryHelper.getGuestHome();
                String name = GUID.generate();
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
                testData.A1NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                ChildAssociationRef child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2"), ContentModel.TYPE_FOLDER);
                testData.A2NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A2"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A3"), ContentModel.TYPE_CONTENT);
                testData.A3NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A3"));
                ContentWriter writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.A3NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A4"), ContentModel.TYPE_CONTENT);
                testData.A4NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A4NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A4NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A4"));
                writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.A4NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5"), ContentModel.TYPE_CONTENT);
                testData.A5NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A5NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A5NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A5"));
                writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.A5NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                testData.transferMe = !TransferServiceToBeRefactoredTest.this.transferService.targetExists("testTransferSyncNodes") ? TransferServiceToBeRefactoredTest.this.createTransferTarget("testTransferSyncNodes") : TransferServiceToBeRefactoredTest.this.transferService.getTransferTarget("testTransferSyncNodes");
                return null;
            }
        });
        final HashSet<NodeRef> nodes = new HashSet<NodeRef>();
        nodes.add(testData.A1NodeRef);
        nodes.add(testData.A2NodeRef);
        nodes.add(testData.A3NodeRef);
        nodes.add(testData.A4NodeRef);
        nodes.add(testData.A5NodeRef);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                definition.setNodes((Collection)nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferSyncNodes", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef a1Dest = testNodeFactory.getMappedNodeRef(testData.A1NodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A1NodeRef)));
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A1 From RepositoryId", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A1NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)repositoryId);
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A1 Repository Id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A1NodeRef), TransferModel.PROP_REPOSITORY_ID), (Object)repositoryId);
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A2 From RepositoryId", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A2NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)repositoryId);
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A2 Repository Id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A2NodeRef), TransferModel.PROP_REPOSITORY_ID), (Object)repositoryId);
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A3 From RepositoryId", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A3NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)repositoryId);
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A3 Repository Id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A3NodeRef), TransferModel.PROP_REPOSITORY_ID), (Object)repositoryId);
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A4 From RepositoryId", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A4NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)repositoryId);
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A4 Repository Id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A4NodeRef), TransferModel.PROP_REPOSITORY_ID), (Object)repositoryId);
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A5 From RepositoryId", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A5NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)repositoryId);
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A5 Repository Id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A5NodeRef), TransferModel.PROP_REPOSITORY_ID), (Object)repositoryId);
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(a1Dest, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B6"), ContentModel.TYPE_CONTENT);
                testData.B6NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B6NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B6NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B6"));
                ContentWriter writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.B6NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                definition.setNodes((Collection)nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferSyncNodes", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node B6 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testData.B6NodeRef));
                TransferServiceToBeRefactoredTest.assertTrue((String)"B6 not alien", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testData.B6NodeRef, TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Chain sync"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, TransferModel.PROP_FROM_REPOSITORY_ID, (Serializable)((Object)TransferServiceToBeRefactoredTest.this.REPO_ID_B));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, TransferModel.PROP_REPOSITORY_ID, (Serializable)((Object)TransferServiceToBeRefactoredTest.this.REPO_ID_B));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Chain sync"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A2NodeRef, TransferModel.PROP_FROM_REPOSITORY_ID, (Serializable)((Object)TransferServiceToBeRefactoredTest.this.REPO_ID_B));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A2NodeRef, TransferModel.PROP_REPOSITORY_ID, (Serializable)((Object)TransferServiceToBeRefactoredTest.this.REPO_ID_B));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Chain sync"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3NodeRef, TransferModel.PROP_FROM_REPOSITORY_ID, (Serializable)((Object)TransferServiceToBeRefactoredTest.this.REPO_ID_B));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3NodeRef, TransferModel.PROP_REPOSITORY_ID, (Serializable)((Object)TransferServiceToBeRefactoredTest.this.REPO_ID_B));
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A7"), ContentModel.TYPE_CONTENT);
                testData.A7NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A7NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Chain sync"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A7NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A7"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A7NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Chain sync"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A7NodeRef, TransferModel.PROP_FROM_REPOSITORY_ID, (Serializable)((Object)TransferServiceToBeRefactoredTest.this.REPO_ID_B));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A7NodeRef, TransferModel.PROP_REPOSITORY_ID, (Serializable)((Object)TransferServiceToBeRefactoredTest.this.REPO_ID_B));
                ContentWriter writer = TransferServiceToBeRefactoredTest.this.contentService.getWriter(testData.A3NodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                return null;
            }
        });
        nodes.add(testData.A7NodeRef);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                definition.setNodes((Collection)nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testTransferSyncNodes", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A7 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A7NodeRef)));
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A1 Title", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A1NodeRef), ContentModel.PROP_TITLE), (Object)"Chain sync");
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A1 Repository Id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A1NodeRef), TransferModel.PROP_REPOSITORY_ID), (Object)TransferServiceToBeRefactoredTest.this.REPO_ID_B);
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A1 Repository Id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A1NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)repositoryId);
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A2 Title", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A2NodeRef), ContentModel.PROP_TITLE), (Object)"Chain sync");
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A2 Repository Id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A2NodeRef), TransferModel.PROP_REPOSITORY_ID), (Object)TransferServiceToBeRefactoredTest.this.REPO_ID_B);
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A2 Repository Id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A2NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)repositoryId);
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A3 Title", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A3NodeRef), ContentModel.PROP_TITLE), (Object)"Chain sync");
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A3 Repository Id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A3NodeRef), TransferModel.PROP_REPOSITORY_ID), (Object)TransferServiceToBeRefactoredTest.this.REPO_ID_B);
                TransferServiceToBeRefactoredTest.assertEquals((String)"dest node A3 Repository Id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A3NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)repositoryId);
                return null;
            }
        });
    }

    @Test
    public void testMultiRepoTransfer() throws Exception {
        class TestData {
            TransferTarget transferMe;
            NodeRef S0NodeRef;
            NodeRef A1NodeRef;
            NodeRef A2NodeRef;
            NodeRef A3NodeRef;
            NodeRef B1NodeRef;
            NodeRef C1NodeRef;
            NodeRef C2NodeRef;
            NodeRef C3NodeRef;
            NodeRef C4NodeRef;
            NodeRef A3Dummy;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef guestHome = TransferServiceToBeRefactoredTest.this.repositoryHelper.getGuestHome();
                String name = GUID.generate();
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
                testData.S0NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.S0NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.S0NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                ChildAssociationRef child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A1"), ContentModel.TYPE_FOLDER);
                testData.A1NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A1"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A1"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"images"), ContentModel.TYPE_FOLDER);
                testData.A2NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"images"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"images"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A3"), ContentModel.TYPE_FOLDER);
                testData.A3NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A3"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A3"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B1"), ContentModel.TYPE_FOLDER);
                testData.B1NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"B1"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B1"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"C1"), ContentModel.TYPE_FOLDER);
                testData.C1NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"C1"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C1"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.C1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"images"), ContentModel.TYPE_FOLDER);
                testData.C2NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"images"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.C2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"C3"), ContentModel.TYPE_FOLDER);
                testData.C3NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C3"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.C2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A3"), ContentModel.TYPE_FOLDER);
                testData.A3Dummy = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3Dummy, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3Dummy, ContentModel.PROP_NAME, (Serializable)((Object)"A3 Dummy"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A3Dummy, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"C4"), ContentModel.TYPE_FOLDER);
                testData.C4NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C4NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C4NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C4"));
                testData.transferMe = !TransferServiceToBeRefactoredTest.this.transferService.targetExists("testMultiRepoTransfer") ? TransferServiceToBeRefactoredTest.this.createTransferTarget("testMultiRepoTransfer") : TransferServiceToBeRefactoredTest.this.transferService.getTransferTarget("testMultiRepoTransfer");
                return null;
            }
        });
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        final UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        final List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.A2NodeRef);
                pathMap.add(new Pair((Object)TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.A1NodeRef), (Object)TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.B1NodeRef)));
                pathMap.add(new Pair((Object)TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.C1NodeRef), (Object)TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.B1NodeRef)));
                return null;
            }
        }, true);
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
                nodes.add(testData.A1NodeRef);
                nodes.add(testData.A2NodeRef);
                nodes.add(testData.A3NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testMultiRepoTransfer", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A2 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A2NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A3NodeRef)));
                ChildAssociationRef A3Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(testData.A3NodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"A3 dest is connected to the wrong node", (Object)A3Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(testData.A2NodeRef));
                ChildAssociationRef A2Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(testData.A2NodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"A2 dest is connected to the wrong node", (Object)A2Ref.getParentRef(), (Object)testData.B1NodeRef);
                TransferServiceToBeRefactoredTest.assertEquals((String)"A2 dest owned by wrong repo", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A2NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)TransferServiceToBeRefactoredTest.this.REPO_ID_A);
                TransferServiceToBeRefactoredTest.assertEquals((String)"A3 dest owned by wrong repo", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A3NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)TransferServiceToBeRefactoredTest.this.REPO_ID_A);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                DescriptorService mockedDescriptorService = TransferServiceToBeRefactoredTest.this.getMockDescriptorService(TransferServiceToBeRefactoredTest.this.REPO_ID_C);
                TransferServiceToBeRefactoredTest.this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
                TransferDefinition definition = new TransferDefinition();
                ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
                nodes.add(testData.C1NodeRef);
                nodes.add(testData.C2NodeRef);
                nodes.add(testData.C3NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testMultiRepoTransfer", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A3NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C3NodeRef)));
                ChildAssociationRef A3Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(testData.A3NodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"A3 dest is connected to the wrong node", (Object)A3Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(testData.A2NodeRef));
                ChildAssociationRef C3Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(testData.A3NodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"C3 dest is connected to the wrong node", (Object)C3Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(testData.A2NodeRef));
                ChildAssociationRef A2Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(testData.A2NodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"A2 dest is connected to the wrong node", (Object)A2Ref.getParentRef(), (Object)testData.B1NodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"A2 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.A2NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"C3 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.C3NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"A3 dest is invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.A3NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertEquals((String)"A2 dest owned by wrong repo", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A2NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)TransferServiceToBeRefactoredTest.this.REPO_ID_A);
                TransferServiceToBeRefactoredTest.assertEquals((String)"A3 dest owned by wrong repo", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A3NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)TransferServiceToBeRefactoredTest.this.REPO_ID_A);
                TransferServiceToBeRefactoredTest.assertEquals((String)"C3 dest owned by wrong repo", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.C3NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)TransferServiceToBeRefactoredTest.this.REPO_ID_C);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                DescriptorService mockedDescriptorService = TransferServiceToBeRefactoredTest.this.getMockDescriptorService(TransferServiceToBeRefactoredTest.this.REPO_ID_C);
                TransferServiceToBeRefactoredTest.this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
                TransferDefinition definition = new TransferDefinition();
                ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
                nodes.add(testData.C4NodeRef);
                definition.setNodes(nodes);
                definition.setSync(false);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testMultiRepoTransfer", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A3NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C3NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C4 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C4NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"C4 is not an invader", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.C4NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"A3 is not an invader", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.A3NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertEquals((String)"A2 dest owned by wrong repo", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A2NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)TransferServiceToBeRefactoredTest.this.REPO_ID_A);
                TransferServiceToBeRefactoredTest.assertEquals((String)"A3 dest owned by wrong repo", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A3NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)TransferServiceToBeRefactoredTest.this.REPO_ID_A);
                TransferServiceToBeRefactoredTest.assertEquals((String)"C3 dest owned by wrong repo", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.C3NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)TransferServiceToBeRefactoredTest.this.REPO_ID_C);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.nodeService.deleteNode(testData.C4NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                DescriptorService mockedDescriptorService = TransferServiceToBeRefactoredTest.this.getMockDescriptorService(TransferServiceToBeRefactoredTest.this.REPO_ID_C);
                TransferServiceToBeRefactoredTest.this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
                TransferDefinition definition = new TransferDefinition();
                ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
                nodes.add(testData.A3Dummy);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testMultiRepoTransfer", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A3NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C3NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node C4 not deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C4NodeRef)));
                TransferServiceToBeRefactoredTest.this.logger.debug((Object)("A3 Dest is " + String.valueOf(testNodeFactory.getMappedNodeRef(testData.A3NodeRef))));
                TransferServiceToBeRefactoredTest.assertFalse((String)"A3 Dest still invaded by C4", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.A3NodeRef), TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.nodeService.deleteNode(testData.C3NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                DescriptorService mockedDescriptorService = TransferServiceToBeRefactoredTest.this.getMockDescriptorService(TransferServiceToBeRefactoredTest.this.REPO_ID_C);
                TransferServiceToBeRefactoredTest.this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
                TransferDefinition definition = new TransferDefinition();
                ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
                NodeRef C3Deleted = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, testData.C3NodeRef.getId());
                nodes.add(C3Deleted);
                definition.setNodes(nodes);
                definition.setSync(false);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testMultiRepoTransfer", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A3NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node C3 not deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C3NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"dest node C4 not deleted", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C4NodeRef)));
                TransferServiceToBeRefactoredTest.assertFalse((String)"A3 still invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.A3NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"A2 still invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.A2NodeRef), TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
    }

    private TransferTarget createTransferTarget(String name) {
        String title = "title";
        String description = "description";
        String endpointProtocol = "http";
        String endpointHost = "MARKR02";
        int endpointPort = 7080;
        String endpointPath = "/alfresco/service/api/transfer";
        String username = "admin";
        char[] password = "admin".toCharArray();
        TransferTarget target = this.transferService.createAndSaveTransferTarget(name, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
        return target;
    }

    @Test
    public void testMultiRepoTransferMove() throws Exception {
        final String localRepositoryId = this.descriptorService.getCurrentRepositoryDescriptor().getId();
        class TestData {
            TransferTarget transferMe;
            NodeRef S0NodeRef;
            NodeRef A1NodeRef;
            NodeRef B1NodeRef;
            NodeRef C1NodeRef;
            NodeRef C2NodeRef;
            NodeRef C3NodeRef;
            NodeRef A4NodeRef;
            NodeRef A5NodeRef;
            NodeRef B6NodeRef;
            NodeRef C2DummyNodeRef;
            NodeRef C3DummyNodeRef;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        final QName C2Path = QName.createQName((String)"p2");
        final QName C3Path = QName.createQName((String)"p3");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef guestHome = TransferServiceToBeRefactoredTest.this.repositoryHelper.getGuestHome();
                String name = GUID.generate();
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
                testData.S0NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.S0NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.S0NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                ChildAssociationRef child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A1"), ContentModel.TYPE_FOLDER);
                testData.A1NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A1"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A1"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B1"), ContentModel.TYPE_FOLDER);
                testData.B1NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"B1"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B1"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"C1"), ContentModel.TYPE_FOLDER);
                testData.C1NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"C1"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C1"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.C1NodeRef, ContentModel.ASSOC_CONTAINS, C2Path, ContentModel.TYPE_FOLDER);
                testData.C2NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"C2"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C2"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.C1NodeRef, ContentModel.ASSOC_CONTAINS, C3Path, ContentModel.TYPE_FOLDER);
                testData.C3NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"C3"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C3"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, C2Path, ContentModel.TYPE_FOLDER);
                testData.C2DummyNodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C2DummyNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C2DummyNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C2 Dummy"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, C3Path, ContentModel.TYPE_FOLDER);
                testData.C3DummyNodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C3DummyNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C3DummyNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C3 Dummy"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"C4"), ContentModel.TYPE_FOLDER);
                testData.A4NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A4NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A4"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A4NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A4"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.C2DummyNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5"), ContentModel.TYPE_FOLDER);
                testData.A5NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A5NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A5"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A5NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A5"));
                testData.transferMe = !TransferServiceToBeRefactoredTest.this.transferService.targetExists("testMultiRepoTransferMove") ? TransferServiceToBeRefactoredTest.this.createTransferTarget("testMultiRepoTransferMove") : TransferServiceToBeRefactoredTest.this.transferService.getTransferTarget("testMultiRepoTransferMove");
                return null;
            }
        });
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        final UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        final List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                pathMap.add(new Pair((Object)TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.A1NodeRef), (Object)TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.B1NodeRef)));
                pathMap.add(new Pair((Object)TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.C1NodeRef), (Object)TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.B1NodeRef)));
                return null;
            }
        }, true);
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_C);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
                nodes.add(testData.C1NodeRef);
                nodes.add(testData.C2NodeRef);
                nodes.add(testData.C3NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testMultiRepoTransferMove", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C2 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C2NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C3NodeRef)));
                ChildAssociationRef C3Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(testData.C3NodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"A3 dest is connected to the wrong node", (Object)C3Ref.getParentRef(), (Object)testData.B1NodeRef);
                ChildAssociationRef C2Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(testData.C2NodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"A2 dest is connected to the wrong node", (Object)C2Ref.getParentRef(), (Object)testData.B1NodeRef);
                return null;
            }
        });
        mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
                nodes.add(testData.A4NodeRef);
                nodes.add(testData.A5NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testMultiRepoTransferMove", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A5 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A5NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C3NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C2 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C2NodeRef)));
                ChildAssociationRef A5Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(testData.A5NodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"A5 dest is connected to the wrong node", (Object)A5Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(testData.C2NodeRef));
                TransferServiceToBeRefactoredTest.assertTrue((String)"C2 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.C2NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"C3 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.C3NodeRef), TransferModel.ASPECT_ALIEN));
                ChildAssociationRef A4Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(testData.A4NodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"A4 dest is connected to the wrong node", (Object)A4Ref.getParentRef(), (Object)testData.B1NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.nodeService.moveNode(testData.A5NodeRef, testData.C3DummyNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"C4"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
                nodes.add(testData.A5NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testMultiRepoTransferMove", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A5 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A5NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C3NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C2 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C2NodeRef)));
                ChildAssociationRef A5Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(testData.A5NodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"A5 dest is connected to the wrong node", (Object)A5Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(testData.C3NodeRef));
                TransferServiceToBeRefactoredTest.assertTrue((String)"A5 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.A5NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"C3 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.C3NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"C2 dest is still invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.C2NodeRef), TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.nodeService.moveNode(testData.A5NodeRef, testData.C2DummyNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B6"));
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testNodeFactory.getMappedNodeRef(testData.A5NodeRef), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B6"), ContentModel.TYPE_FOLDER);
                testData.B6NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B6NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"B6"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B6NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B6"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
                nodes.add(testData.A5NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testMultiRepoTransferMove", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A5 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A5NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C3NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C2 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C2NodeRef)));
                ChildAssociationRef A5Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(testData.A5NodeRef));
                ChildAssociationRef B6Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testData.B6NodeRef);
                TransferServiceToBeRefactoredTest.assertEquals((String)"A5 dest is connected to the wrong node", (Object)A5Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(testData.C2NodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"B6 connected to the wrong node", (Object)B6Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(testData.A5NodeRef));
                TransferServiceToBeRefactoredTest.assertTrue((String)"A5 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.A5NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"C2 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.C2NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"C3 dest is still invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.C3NodeRef), TransferModel.ASPECT_ALIEN));
                List invaders = (List)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.C2NodeRef), TransferModel.PROP_INVADED_BY));
                TransferServiceToBeRefactoredTest.assertTrue((String)"invaders is too small", (invaders.size() > 1 ? 1 : 0) != 0);
                TransferServiceToBeRefactoredTest.assertTrue((String)"invaders does not contain REPO A", (boolean)invaders.contains(TransferServiceToBeRefactoredTest.this.REPO_ID_A));
                TransferServiceToBeRefactoredTest.assertTrue((String)"invaders does not contain REPO B", (boolean)invaders.contains(localRepositoryId));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.this.nodeService.moveNode(testData.A5NodeRef, testData.A4NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
                nodes.add(testData.A5NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testMultiRepoTransferMove", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A5 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A5NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C3NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C2 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C2NodeRef)));
                ChildAssociationRef A5Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(testData.A5NodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"A5 dest is connected to the wrong node", (Object)A5Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(testData.A4NodeRef));
                TransferServiceToBeRefactoredTest.assertTrue((String)"A4 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.A4NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"A5 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.A5NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"B6 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testData.B6NodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"C2 dest is still invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.C2NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"C3 dest is still invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.C3NodeRef), TransferModel.ASPECT_ALIEN));
                List invaders = (List)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A4NodeRef), TransferModel.PROP_INVADED_BY));
                TransferServiceToBeRefactoredTest.assertTrue((String)"invaders is too big", (invaders.size() < 2 ? 1 : 0) != 0);
                TransferServiceToBeRefactoredTest.assertFalse((String)"invaders contains REPO A", (boolean)invaders.contains(TransferServiceToBeRefactoredTest.this.REPO_ID_A));
                TransferServiceToBeRefactoredTest.assertTrue((String)"invaders does not contains REPO B", (boolean)invaders.contains(TransferServiceToBeRefactoredTest.this.REPO_ID_B));
                return null;
            }
        });
    }

    @Test
    public void testCopyTransferredNode() throws Exception {
        class TestData {
            TransferTarget transferMe;
            NodeRef S0NodeRef;
            NodeRef A1NodeRef;
            NodeRef A2NodeRef;
            NodeRef A3NodeRef;
            NodeRef B1NodeRef;
            NodeRef B2NodeRef;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef guestHome = TransferServiceToBeRefactoredTest.this.repositoryHelper.getGuestHome();
                String name = GUID.generate();
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
                testData.S0NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.S0NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.S0NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                ChildAssociationRef child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A1"), ContentModel.TYPE_FOLDER);
                testData.A1NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A1"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A1"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2"), ContentModel.TYPE_FOLDER);
                testData.A2NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A2"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A2"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A3"), ContentModel.TYPE_FOLDER);
                testData.A3NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A3"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A3"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B1"), ContentModel.TYPE_FOLDER);
                testData.B1NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"B1"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B1"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B2"), ContentModel.TYPE_FOLDER);
                testData.B2NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"B2"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B2"));
                testData.transferMe = !TransferServiceToBeRefactoredTest.this.transferService.targetExists("testCopyTransferredNode") ? TransferServiceToBeRefactoredTest.this.createTransferTarget("testCopyTransferredNode") : TransferServiceToBeRefactoredTest.this.transferService.getTransferTarget("testCopyTransferredNode");
                return null;
            }
        });
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        final UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        final List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                pathMap.add(new Pair((Object)TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.A1NodeRef), (Object)TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.B1NodeRef)));
                return null;
            }
        });
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.logger.debug((Object)"First transfer - ");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testData.A2NodeRef);
                nodes.add(testData.A3NodeRef);
                definition.setNodes(nodes);
                definition.setReadOnly(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testCopyTransferredNode", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef A2destNodeRef = testNodeFactory.getMappedNodeRef(testData.A2NodeRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(A2destNodeRef));
                NodeRef copiedNode = TransferServiceToBeRefactoredTest.this.copyService.copy(A2destNodeRef, testData.B2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2Copy"));
                TransferServiceToBeRefactoredTest.assertTrue((String)"copied node does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(copiedNode));
                System.out.println("copied node is " + String.valueOf(copiedNode));
                TransferServiceToBeRefactoredTest.assertFalse((String)"copied node still has transferred aspect", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(copiedNode, TransferModel.ASPECT_TRANSFERRED));
                TransferServiceToBeRefactoredTest.assertNull((String)"copied node still has from repository id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(copiedNode, TransferModel.PROP_FROM_REPOSITORY_ID));
                TransferServiceToBeRefactoredTest.assertNull((String)"copied node still has original repository id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(copiedNode, TransferModel.PROP_REPOSITORY_ID));
                TransferServiceToBeRefactoredTest.this.nodeService.getAspects(copiedNode);
                copiedNode = TransferServiceToBeRefactoredTest.this.copyService.copy(A2destNodeRef, testData.B2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2Copy2"), true);
                TransferServiceToBeRefactoredTest.assertTrue((String)"copied node does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(copiedNode));
                System.out.println("copied node is " + String.valueOf(copiedNode));
                TransferServiceToBeRefactoredTest.assertFalse((String)"copied node still has transferred aspect", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(copiedNode, TransferModel.ASPECT_TRANSFERRED));
                TransferServiceToBeRefactoredTest.assertNull((String)"copied node still has from repository id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(copiedNode, TransferModel.PROP_FROM_REPOSITORY_ID));
                TransferServiceToBeRefactoredTest.assertNull((String)"copied node still has original repository id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(copiedNode, TransferModel.PROP_REPOSITORY_ID));
                List children = TransferServiceToBeRefactoredTest.this.nodeService.getChildAssocs(copiedNode);
                for (ChildAssociationRef child : children) {
                    TransferServiceToBeRefactoredTest.assertFalse((String)"copied node still has transferred aspect", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(child.getChildRef(), TransferModel.ASPECT_TRANSFERRED));
                    TransferServiceToBeRefactoredTest.assertNull((String)"copied node still has from repository id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(child.getChildRef(), TransferModel.PROP_FROM_REPOSITORY_ID));
                    TransferServiceToBeRefactoredTest.assertNull((String)"copied node still has original repository id", (Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(child.getChildRef(), TransferModel.PROP_REPOSITORY_ID));
                }
                return null;
            }
        });
    }

    @Test
    public void testCopyAlien() throws Exception {
        class TestData {
            TransferTarget transferMe;
            NodeRef S0NodeRef;
            NodeRef A1NodeRef;
            NodeRef B1NodeRef;
            NodeRef C1NodeRef;
            NodeRef C2NodeRef;
            NodeRef C3NodeRef;
            NodeRef A4NodeRef;
            NodeRef A5NodeRef;
            NodeRef B6NodeRef;
            NodeRef C2DummyNodeRef;
            NodeRef C3DummyNodeRef;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        final QName C2Path = QName.createQName((String)"p2");
        final QName C3Path = QName.createQName((String)"p3");
        final String localRepositoryId = this.descriptorService.getCurrentRepositoryDescriptor().getId();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef guestHome = TransferServiceToBeRefactoredTest.this.repositoryHelper.getGuestHome();
                String name = GUID.generate();
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
                testData.S0NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.S0NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.S0NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                ChildAssociationRef child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A1"), ContentModel.TYPE_FOLDER);
                testData.A1NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A1"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A1"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B1"), ContentModel.TYPE_FOLDER);
                testData.B1NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"B1"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B1"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"C1"), ContentModel.TYPE_FOLDER);
                testData.C1NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"C1"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C1"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.C1NodeRef, ContentModel.ASSOC_CONTAINS, C2Path, ContentModel.TYPE_FOLDER);
                testData.C2NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"C2"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C2"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.C1NodeRef, ContentModel.ASSOC_CONTAINS, C3Path, ContentModel.TYPE_FOLDER);
                testData.C3NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"C3"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C3"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, C2Path, ContentModel.TYPE_FOLDER);
                testData.C2DummyNodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C2DummyNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C2DummyNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C2 Dummy"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, C3Path, ContentModel.TYPE_FOLDER);
                testData.C3DummyNodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C3DummyNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.C3DummyNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C3 Dummy"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"C4"), ContentModel.TYPE_FOLDER);
                testData.A4NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A4NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A4"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A4NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A4"));
                child2 = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testData.C2DummyNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5"), ContentModel.TYPE_FOLDER);
                testData.A5NodeRef = child2.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A5NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A5"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.A5NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A5"));
                testData.transferMe = !TransferServiceToBeRefactoredTest.this.transferService.targetExists("testCopyAlien") ? TransferServiceToBeRefactoredTest.this.createTransferTarget("testCopyAlien") : TransferServiceToBeRefactoredTest.this.transferService.getTransferTarget("testCopyAlien");
                return null;
            }
        });
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        final UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        final List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                pathMap.add(new Pair((Object)TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.A1NodeRef), (Object)TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.B1NodeRef)));
                pathMap.add(new Pair((Object)TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.C1NodeRef), (Object)TransferServiceToBeRefactoredTest.this.nodeService.getPath(testData.B1NodeRef)));
                return null;
            }
        });
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_C);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
                nodes.add(testData.C1NodeRef);
                nodes.add(testData.C2NodeRef);
                nodes.add(testData.C3NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testCopyAlien", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C2 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C2NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C3NodeRef)));
                ChildAssociationRef C3Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(testData.C3NodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"A3 dest is connected to the wrong node", (Object)C3Ref.getParentRef(), (Object)testData.B1NodeRef);
                ChildAssociationRef C2Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(testData.C2NodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"A2 dest is connected to the wrong node", (Object)C2Ref.getParentRef(), (Object)testData.B1NodeRef);
                return null;
            }
        });
        mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
                nodes.add(testData.A4NodeRef);
                nodes.add(testData.A5NodeRef);
                definition.setNodes(nodes);
                definition.setSync(true);
                TransferServiceToBeRefactoredTest.this.transferService.transfer("testCopyAlien", definition);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A5 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A5NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C3NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C2 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C2NodeRef)));
                ChildAssociationRef A5Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(testData.A5NodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"A5 dest is connected to the wrong node", (Object)A5Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(testData.C2NodeRef));
                TransferServiceToBeRefactoredTest.assertTrue((String)"C2 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.C2NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"C3 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.C3NodeRef), TransferModel.ASPECT_ALIEN));
                ChildAssociationRef A4Ref = TransferServiceToBeRefactoredTest.this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(testData.A4NodeRef));
                TransferServiceToBeRefactoredTest.assertEquals((String)"A4 dest is connected to the wrong node", (Object)A4Ref.getParentRef(), (Object)testData.B1NodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef copyRef = TransferServiceToBeRefactoredTest.this.copyService.copy(testNodeFactory.getMappedNodeRef(testData.A5NodeRef), testNodeFactory.getMappedNodeRef(testData.C3NodeRef), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5 Copy 1"));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C3 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C3NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C2 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C2NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"A5(copy 1) is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(copyRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"C3 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.C3NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"C2 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.C2NodeRef), TransferModel.ASPECT_ALIEN));
                List C2invaders = (List)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.C2NodeRef), TransferModel.PROP_INVADED_BY));
                List C3invaders = (List)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.C3NodeRef), TransferModel.PROP_INVADED_BY));
                TransferServiceToBeRefactoredTest.assertTrue((String)"C3 invaders contains local repository Id", (boolean)C3invaders.contains(localRepositoryId));
                TransferServiceToBeRefactoredTest.assertFalse((String)"C3 invaders contains REPO_ID_A", (boolean)C3invaders.contains(TransferServiceToBeRefactoredTest.this.REPO_ID_A));
                TransferServiceToBeRefactoredTest.assertFalse((String)"C2 invaders contains local repository Id", (boolean)C2invaders.contains(localRepositoryId));
                TransferServiceToBeRefactoredTest.assertTrue((String)"C2 invaders contains REPO_ID_A", (boolean)C2invaders.contains(TransferServiceToBeRefactoredTest.this.REPO_ID_A));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef copyRef = TransferServiceToBeRefactoredTest.this.copyService.copy(testNodeFactory.getMappedNodeRef(testData.A5NodeRef), testNodeFactory.getMappedNodeRef(testData.A4NodeRef), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5 Copy 2"));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node A4 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.A4NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"dest node C2 does not exist", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testData.C2NodeRef)));
                TransferServiceToBeRefactoredTest.assertTrue((String)"A5(copy 2) is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(copyRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"A4 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.A4NodeRef), TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertTrue((String)"C2 dest is not invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.C2NodeRef), TransferModel.ASPECT_ALIEN));
                List C2invaders = (List)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.C2NodeRef), TransferModel.PROP_INVADED_BY));
                List A4invaders = (List)((Object)TransferServiceToBeRefactoredTest.this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(testData.A4NodeRef), TransferModel.PROP_INVADED_BY));
                TransferServiceToBeRefactoredTest.assertTrue((String)"A4 invaders contains local repository Id", (boolean)A4invaders.contains(localRepositoryId));
                TransferServiceToBeRefactoredTest.assertFalse((String)"C2 invaders contains local repository Id", (boolean)C2invaders.contains(localRepositoryId));
                TransferServiceToBeRefactoredTest.assertTrue((String)"C2 invaders contains REPO_ID_A", (boolean)C2invaders.contains(TransferServiceToBeRefactoredTest.this.REPO_ID_A));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ChildAssociationRef child = TransferServiceToBeRefactoredTest.this.nodeService.createNode(testNodeFactory.getMappedNodeRef(testData.A5NodeRef), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B6"), ContentModel.TYPE_FOLDER);
                testData.B6NodeRef = child.getChildRef();
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B6NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"B6"));
                TransferServiceToBeRefactoredTest.this.nodeService.setProperty(testData.B6NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B6"));
                TransferServiceToBeRefactoredTest.assertTrue((String)"A4 dest is not invaded prior to test - test error", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(testData.A4NodeRef), TransferModel.ASPECT_ALIEN));
                NodeRef copyRef = TransferServiceToBeRefactoredTest.this.copyService.copy(testNodeFactory.getMappedNodeRef(testData.A5NodeRef), testData.B1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5 Copy 3"));
                TransferServiceToBeRefactoredTest.assertFalse((String)"B1 is invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testData.B1NodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"A5 copy 3 is invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(copyRef, TransferModel.ASPECT_ALIEN));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceToBeRefactoredTest.assertFalse((String)"B1 is invaded prior to test - test error", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testData.B1NodeRef, TransferModel.ASPECT_ALIEN));
                NodeRef copyRef = TransferServiceToBeRefactoredTest.this.copyService.copy(testNodeFactory.getMappedNodeRef(testData.A5NodeRef), testData.B1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5 Copy 4"), true);
                TransferServiceToBeRefactoredTest.assertFalse((String)"B1 is invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(testData.B1NodeRef, TransferModel.ASPECT_ALIEN));
                TransferServiceToBeRefactoredTest.assertFalse((String)"A5 copy 4 is invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(copyRef, TransferModel.ASPECT_ALIEN));
                List refs = TransferServiceToBeRefactoredTest.this.nodeService.getChildAssocs(copyRef);
                TransferServiceToBeRefactoredTest.assertTrue((String)"can't find child of A5 copy 4", (refs.size() == 1 ? 1 : 0) != 0);
                for (ChildAssociationRef ref : refs) {
                    TransferServiceToBeRefactoredTest.assertFalse((String)"B6 copy is invaded", (boolean)TransferServiceToBeRefactoredTest.this.nodeService.hasAspect(ref.getChildRef(), TransferModel.ASPECT_ALIEN));
                }
                return null;
            }
        });
    }

    private DescriptorService getMockDescriptorService(String repositoryId) {
        DescriptorService descriptorService = (DescriptorService)Mockito.mock(DescriptorService.class);
        Descriptor descriptor = (Descriptor)Mockito.mock(Descriptor.class);
        Mockito.when((Object)descriptor.getId()).thenReturn((Object)repositoryId);
        Mockito.when((Object)descriptorService.getCurrentRepositoryDescriptor()).thenReturn((Object)descriptor);
        Mockito.when((Object)descriptorService.getServerDescriptor()).thenReturn((Object)this.serverDescriptor);
        return descriptorService;
    }
}

