/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.acegisecurity.Authentication;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.AlfrescoCmisService;
import org.alfresco.opencmis.AlfrescoCmisServiceCall;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.opencmis.CMISNodeInfoImpl;
import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.dictionary.CMISObjectVariant;
import org.alfresco.opencmis.dictionary.FolderTypeDefintionWrapper;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.Authorization;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.Pair;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.chemistry.opencmis.commons.impl.CmisEnumHelper;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BulkUpdateObjectIdAndChangeTokenImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FailedToDeleteDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectParentDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionListImpl;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractCmisService;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.impl.server.RenditionInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.shared.QueryStringHttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlfrescoCmisServiceImpl
extends AbstractCmisService
implements AlfrescoCmisService {
    private static Log logger = LogFactory.getLog(AlfrescoCmisService.class);
    private static final String MIN_FILTER = "cmis:name,cmis:baseTypeId,cmis:objectTypeId,cmis:createdBy,cmis:creationDate,cmis:lastModifiedBy,cmis:lastModificationDate,cmis:contentStreamLength,cmis:contentStreamMimeType,cmis:contentStreamFileName,cmis:contentStreamId";
    private CMISConnector connector;
    private Authentication authentication;
    private Map<String, CMISNodeInfo> nodeInfoMap;
    private Map<String, ObjectInfo> objectInfoMap;
    private Set<String> cmisRequestRenditionsOnCreateDoc = null;

    public Set<String> getCmisRequestRenditionsOnCreateDoc() {
        return this.cmisRequestRenditionsOnCreateDoc;
    }

    public void setCmisRequestRenditionsOnCreateDoc(Set<String> cmisRequestRenditionsOnCreateDoc) {
        this.cmisRequestRenditionsOnCreateDoc = cmisRequestRenditionsOnCreateDoc;
    }

    public AlfrescoCmisServiceImpl(CMISConnector connector) {
        this.connector = connector;
        this.nodeInfoMap = new HashMap<String, CMISNodeInfo>();
        this.objectInfoMap = new HashMap<String, ObjectInfo>();
    }

    @Override
    public void open(CallContext context) {
        AlfrescoCmisServiceCall.set(context);
    }

    protected CallContext getContext() {
        CallContext context = AlfrescoCmisServiceCall.get();
        return context;
    }

    public void close() {
        AlfrescoCmisServiceCall.clear();
        this.nodeInfoMap.clear();
        this.objectInfoMap.clear();
    }

    protected CMISNodeInfoImpl createNodeInfo(NodeRef nodeRef) {
        return this.createNodeInfo(nodeRef, null, true);
    }

    protected CMISNodeInfoImpl createNodeInfo(NodeRef nodeRef, VersionHistory versionHistory, boolean checkExists) {
        return this.createNodeInfo(nodeRef, null, null, versionHistory, checkExists);
    }

    protected CMISNodeInfoImpl createNodeInfo(NodeRef nodeRef, QName nodeType, Map<QName, Serializable> nodeProps, VersionHistory versionHistory, boolean checkExists) {
        CMISNodeInfoImpl result = this.connector.createNodeInfo(nodeRef, nodeType, nodeProps, versionHistory, checkExists);
        this.nodeInfoMap.put(result.getObjectId(), result);
        return result;
    }

    protected CMISNodeInfo createNodeInfo(AssociationRef assocRef) {
        CMISNodeInfoImpl result = this.connector.createNodeInfo(assocRef);
        this.nodeInfoMap.put(result.getObjectId(), result);
        return result;
    }

    protected CMISNodeInfo getOrCreateNodeInfo(String objectId) {
        CMISNodeInfo result = this.nodeInfoMap.get(objectId);
        if (result == null) {
            result = this.connector.createNodeInfo(objectId);
            this.nodeInfoMap.put(objectId, result);
        }
        return result;
    }

    protected CMISNodeInfo getOrCreateNodeInfo(String objectId, String what) {
        CMISNodeInfo result = this.getOrCreateNodeInfo(objectId);
        if (result instanceof CMISNodeInfoImpl) {
            ((CMISNodeInfoImpl)result).checkIfUseful(what);
        }
        return result;
    }

    protected CMISNodeInfo getOrCreateFolderInfo(String folderId, String what) {
        CMISNodeInfo result = this.getOrCreateNodeInfo(folderId);
        if (result instanceof CMISNodeInfoImpl) {
            ((CMISNodeInfoImpl)result).checkIfFolder(what);
        }
        return result;
    }

    protected CMISNodeInfo addNodeInfo(CMISNodeInfo info) {
        this.nodeInfoMap.put(info.getObjectId(), info);
        return info;
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        CmisVersion cmisVersion = this.getContext().getCmisVersion();
        return Collections.singletonList(this.connector.getRepositoryInfo(cmisVersion));
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CmisVersion cmisVersion = this.getContext().getCmisVersion();
        return this.connector.getRepositoryInfo(cmisVersion);
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        List childrenList;
        this.checkRepositoryId(repositoryId);
        int max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        int skip = skipCount == null || skipCount.intValue() < 0 ? 0 : skipCount.intValue();
        TypeDefinitionListImpl result = new TypeDefinitionListImpl();
        ArrayList<TypeDefinition> list = new ArrayList<TypeDefinition>();
        result.setList(list);
        if (typeId == null) {
            childrenList = this.connector.getOpenCMISDictionaryService().getBaseTypes(true);
        } else {
            TypeDefinitionWrapper tdw = this.connector.getOpenCMISDictionaryService().findType(typeId);
            if (tdw == null) {
                throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
            }
            childrenList = this.connector.getOpenCMISDictionaryService().getChildren(typeId);
        }
        if (max > 0) {
            int lastIndex = (max + skip > childrenList.size() ? childrenList.size() : max + skip) - 1;
            int i = skip;
            while (i <= lastIndex) {
                list.add(((TypeDefinitionWrapper)childrenList.get(i)).getTypeDefinition(includePropertyDefinitions.booleanValue()));
                ++i;
            }
        }
        result.setHasMoreItems(Boolean.valueOf(childrenList.size() - skip > result.getList().size()));
        result.setNumItems(BigInteger.valueOf(childrenList.size()));
        return result;
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        TypeDefinitionWrapper tdw = this.connector.getOpenCMISDictionaryService().findType(typeId);
        if (tdw == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        return tdw.getTypeDefinition(true);
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        ArrayList<TypeDefinitionContainer> result;
        block5: {
            int d;
            block4: {
                this.checkRepositoryId(repositoryId);
                result = new ArrayList<TypeDefinitionContainer>();
                int n = d = depth == null ? -1 : depth.intValue();
                if (d == 0) {
                    throw new CmisInvalidArgumentException("Depth must not be 0!");
                }
                if (typeId != null) break block4;
                for (TypeDefinitionWrapper tdw : this.connector.getOpenCMISDictionaryService().getBaseTypes(true)) {
                    result.add(this.getTypesDescendants(d, tdw, includePropertyDefinitions));
                }
                break block5;
            }
            TypeDefinitionWrapper tdw = this.connector.getOpenCMISDictionaryService().findType(typeId);
            if (tdw == null) {
                throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
            }
            List children = this.connector.getOpenCMISDictionaryService().getChildren(typeId);
            if (children == null) break block5;
            for (TypeDefinitionWrapper child : children) {
                result.add(this.getTypesDescendants(d, child, includePropertyDefinitions));
            }
        }
        return result;
    }

    private TypeDefinitionContainer getTypesDescendants(int depth, TypeDefinitionWrapper tdw, boolean includePropertyDefinitions) {
        TypeDefinitionContainerImpl result = new TypeDefinitionContainerImpl();
        result.setTypeDefinition(tdw.getTypeDefinition(includePropertyDefinitions));
        if (depth != 0) {
            String typeId = tdw.getTypeId();
            List children = this.connector.getOpenCMISDictionaryService().getChildren(typeId);
            if (children != null) {
                result.setChildren(new ArrayList());
                for (TypeDefinitionWrapper tdc : children) {
                    result.getChildren().add(this.getTypesDescendants(depth < 0 ? -1 : depth - 1, tdc, includePropertyDefinitions));
                }
            }
        }
        return result;
    }

    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        long start = System.currentTimeMillis();
        this.checkRepositoryId(repositoryId);
        int max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        int skip = skipCount == null || skipCount.intValue() < 0 ? 0 : skipCount.intValue();
        ObjectInFolderListImpl result = new ObjectInFolderListImpl();
        ArrayList<ObjectInFolderDataImpl> list = new ArrayList<ObjectInFolderDataImpl>();
        result.setObjects(list);
        NodeRef folderNodeRef = this.getOrCreateFolderInfo(folderId, "Folder").getNodeRef();
        ArrayList<Pair<QName, Boolean>> sortProps = null;
        if (orderBy != null) {
            sortProps = new ArrayList<Pair<QName, Boolean>>(1);
            String[] parts = orderBy.split(",");
            int len = parts.length;
            int origLen = len;
            if (origLen > 0) {
                int maxSortProps = 3;
                if (len > maxSortProps) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Too many sort properties in 'orderBy' - ignore those above max (max=" + maxSortProps + ",actual=" + len + ")"));
                    }
                    len = maxSortProps;
                }
                int i = 0;
                while (i < len) {
                    String[] sort = parts[i].split(" +");
                    if (sort.length > 0) {
                        int index = sort[0].isEmpty() ? 1 : 0;
                        Pair<QName, Boolean> sortProp = this.connector.getSortProperty((String)sort[index], (String)(sort.length > index + 1 ? sort[index + 1] : null));
                        sortProps.add(sortProp);
                    }
                    ++i;
                }
            }
            if (sortProps.size() < origLen) {
                logger.warn((Object)("Sort properties trimmed - either too many and/or not found: \n   orig:  " + orderBy + "\n   final: " + String.valueOf(sortProps)));
            }
        }
        PagingRequest pageRequest = new PagingRequest(skip, max, null);
        pageRequest.setRequestTotalCountMax(skip + 10000);
        HashSet<QName> typeqnames = new HashSet<QName>();
        List allTypes = this.connector.getOpenCMISDictionaryService().getAllTypes();
        for (TypeDefinitionWrapper type : allTypes) {
            typeqnames.add(type.getAlfrescoClass());
        }
        PagingResults<FileInfo> pageOfNodeInfos = this.connector.getFileFolderService().list(folderNodeRef, typeqnames, null, sortProps, pageRequest);
        if (max > 0) {
            for (FileInfo child : pageOfNodeInfos.getPage()) {
                try {
                    CMISNodeInfoImpl ni;
                    if (this.connector.filter(child.getNodeRef()) || (ni = this.createNodeInfo(child.getNodeRef(), child.getType(), child.getProperties(), null, false)).getObjectVariant() == CMISObjectVariant.INVALID_ID || ni.getObjectVariant() == CMISObjectVariant.NOT_EXISTING || ni.getObjectVariant() == CMISObjectVariant.NOT_A_CMIS_OBJECT || ni.getObjectVariant() == CMISObjectVariant.PERMISSION_DENIED) continue;
                    ObjectData object = this.connector.createCMISObject(ni, filter, includeAllowableActions, includeRelationships, renditionFilter, false, false);
                    boolean isObjectInfoRequired = this.getContext().isObjectInfoRequired();
                    if (isObjectInfoRequired) {
                        this.getObjectInfo(repositoryId, ni.getObjectId(), includeRelationships);
                    }
                    ObjectInFolderDataImpl childData = new ObjectInFolderDataImpl();
                    childData.setObject(object);
                    if (includePathSegment.booleanValue()) {
                        childData.setPathSegment(child.getName());
                    }
                    list.add(childData);
                }
                catch (InvalidNodeRefException invalidNodeRefException) {
                }
                catch (CmisObjectNotFoundException cmisObjectNotFoundException) {}
            }
        }
        result.setHasMoreItems(Boolean.valueOf(pageOfNodeInfos.hasMoreItems()));
        Pair totalCounts = pageOfNodeInfos.getTotalResultCount();
        if (totalCounts != null) {
            Integer totalCountLower = (Integer)totalCounts.getFirst();
            Integer totalCountUpper = (Integer)totalCounts.getSecond();
            if (totalCountLower != null && totalCountLower.equals(totalCountUpper)) {
                result.setNumItems(BigInteger.valueOf(totalCountLower.intValue()));
            }
        }
        this.logGetObjectsCall("getChildren", start, folderId, list.size(), filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, extension, skipCount, maxItems, orderBy, null);
        return result;
    }

    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        long start = System.currentTimeMillis();
        this.checkRepositoryId(repositoryId);
        ArrayList<ObjectInFolderContainer> result = new ArrayList<ObjectInFolderContainer>();
        this.getDescendantsTree(repositoryId, this.getOrCreateFolderInfo(folderId, "Folder").getNodeRef(), depth.intValue(), filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, false, result);
        this.logGetObjectsCall("getDescendants", start, folderId, this.countDescendantsTree(result), filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, extension, null, null, null, depth);
        return result;
    }

    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        long start = System.currentTimeMillis();
        this.checkRepositoryId(repositoryId);
        ArrayList<ObjectInFolderContainer> result = new ArrayList<ObjectInFolderContainer>();
        this.getDescendantsTree(repositoryId, this.getOrCreateFolderInfo(folderId, "Folder").getNodeRef(), depth.intValue(), filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, true, result);
        this.logGetObjectsCall("getFolderTree", start, folderId, this.countDescendantsTree(result), filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, extension, null, null, null, depth);
        return result;
    }

    protected void logGetObjectsCall(String methodName, long start, String folderId, int itemCount, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extensionsData, BigInteger skipCount, BigInteger maxItems, String orderBy, BigInteger depth) {
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName).append(": ").append(folderId).append(" - ").append(itemCount).append(" in ").append(System.currentTimeMillis() - start).append(" ms").append(" [includeAllowableActions=").append(includeAllowableActions).append(",includeRelationships=").append(includeRelationships).append(",renditionFilter=").append(renditionFilter);
            if (includePathSegment != null) {
                sb.append(methodName.equals("getObjectParents") ? ",includeRelativePathSegment=" : ",includePathSegment=").append(includePathSegment);
            }
            if (filter != null) {
                sb.append(",filter=").append(filter);
            }
            if (skipCount != null) {
                sb.append(",skipCount=").append(skipCount);
            }
            if (maxItems != null) {
                sb.append(",maxItems=").append(maxItems);
            }
            if (orderBy != null) {
                sb.append(",orderBy=").append(orderBy);
            }
            if (depth != null) {
                sb.append(",depth=").append(depth);
            }
            if (extensionsData != null) {
                sb.append(",extensionsData=").append(extensionsData);
            }
            sb.append("]");
            logger.debug((Object)sb.toString());
        } else if (logger.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName).append(": ").append(folderId).append(" - ").append(itemCount).append(" in ").append(System.currentTimeMillis() - start).append(" ms");
            logger.info((Object)sb.toString());
        }
    }

    private int countDescendantsTree(List<ObjectInFolderContainer> tree) {
        int c = tree.size();
        for (ObjectInFolderContainer o : tree) {
            c += this.countDescendantsTree(o.getChildren());
        }
        return c;
    }

    protected void logGetObjectCall(String methodName, long start, String idOrPath, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, Boolean isObjectInfoRequired, ExtensionsData extensionsData) {
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName).append(": ").append(idOrPath).append(" in ").append(System.currentTimeMillis() - start).append(" ms").append(" [includeAllowableActions=").append(includeAllowableActions).append(",includeRelationships=").append(includeRelationships).append(",renditionFilter=").append(renditionFilter).append(",includePolicyIds=").append(includePolicyIds).append(",includeAcl=").append(includeAcl).append(",isObjectInfoRequired=").append(isObjectInfoRequired);
            if (filter != null) {
                sb.append(",filter=").append(filter);
            }
            if (extensionsData != null) {
                sb.append(",extensionsData=").append(extensionsData);
            }
            sb.append("]");
            logger.debug((Object)sb.toString());
        } else if (logger.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName).append(": ").append(idOrPath).append(" in ").append(System.currentTimeMillis() - start).append(" ms");
            logger.info((Object)sb.toString());
        }
    }

    private void getDescendantsTree(String repositoryId, NodeRef folderNodeRef, int depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, boolean foldersOnly, List<ObjectInFolderContainer> list) {
        List childrenList = this.connector.getNodeService().getChildAssocs(folderNodeRef);
        for (ChildAssociationRef child : childrenList) {
            try {
                TypeDefinitionWrapper type = this.connector.getType(child.getChildRef());
                if (type == null) continue;
                boolean isFolder = type instanceof FolderTypeDefintionWrapper;
                if (foldersOnly && !isFolder || isFolder && type.getAlfrescoClass().equals((Object)ContentModel.TYPE_SYSTEM_FOLDER) || this.connector.isHidden(child.getChildRef()) || this.connector.filter(child.getChildRef())) continue;
                boolean isObjectInfoRequired = this.getContext().isObjectInfoRequired();
                ObjectInFolderDataImpl object = new ObjectInFolderDataImpl();
                CMISNodeInfoImpl ni = this.createNodeInfo(child.getChildRef(), null, false);
                object.setObject(this.connector.createCMISObject(ni, filter, includeAllowableActions, includeRelationships, renditionFilter, false, false));
                if (isObjectInfoRequired) {
                    this.getObjectInfo(repositoryId, ni.getObjectId(), includeRelationships);
                }
                if (includePathSegment.booleanValue()) {
                    object.setPathSegment(this.connector.getName(child.getChildRef()));
                }
                ObjectInFolderContainerImpl container = new ObjectInFolderContainerImpl();
                container.setObject((ObjectInFolderData)object);
                if (depth != 1 && isFolder) {
                    container.setChildren(new ArrayList());
                    this.getDescendantsTree(repositoryId, child.getChildRef(), depth - 1, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, foldersOnly, container.getChildren());
                }
                list.add((ObjectInFolderContainer)container);
            }
            catch (InvalidNodeRefException invalidNodeRefException) {
            }
            catch (CmisObjectNotFoundException cmisObjectNotFoundException) {}
        }
    }

    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateFolderInfo(folderId, "Folder");
        if (info.isRootFolder()) {
            throw new CmisInvalidArgumentException("Root folder has no parent!");
        }
        List parentInfos = info.getParents();
        if (parentInfos.isEmpty()) {
            throw new CmisRuntimeException("Folder has no parent and is not the root folder?!");
        }
        CMISNodeInfo parentInfo = this.addNodeInfo((CMISNodeInfo)parentInfos.get(0));
        ObjectData result = this.connector.createCMISObject(parentInfo, filter, false, IncludeRelationships.NONE, "cmis:none", false, false);
        boolean isObjectInfoRequired = this.getContext().isObjectInfoRequired();
        if (isObjectInfoRequired) {
            this.getObjectInfo(repositoryId, parentInfo.getObjectId(), IncludeRelationships.NONE);
        }
        return result;
    }

    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        long start = System.currentTimeMillis();
        this.checkRepositoryId(repositoryId);
        ArrayList<ObjectParentData> result = new ArrayList<ObjectParentData>();
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (info.isRelationship()) {
            throw new CmisConstraintException("Relationships are not fileable!");
        }
        if (info.isItem() || info.isFolder() && !info.isRootFolder()) {
            List parentInfos = info.getParents();
            if (!parentInfos.isEmpty()) {
                for (CMISNodeInfo parent : parentInfos) {
                    CMISNodeInfo parentInfo = this.addNodeInfo(parent);
                    ObjectData object = this.connector.createCMISObject(parentInfo, filter, includeAllowableActions, includeRelationships, renditionFilter, false, false);
                    boolean isObjectInfoRequired = this.getContext().isObjectInfoRequired();
                    if (isObjectInfoRequired) {
                        this.getObjectInfo(repositoryId, object.getId(), includeRelationships);
                    }
                    ObjectParentDataImpl objectParent = new ObjectParentDataImpl();
                    objectParent.setObject(object);
                    if (includeRelativePathSegment.booleanValue()) {
                        objectParent.setRelativePathSegment(info.getName());
                    }
                    result.add((ObjectParentData)objectParent);
                }
            }
        } else if (info.isCurrentVersion() || info.isPWC()) {
            List parentInfos = info.getParents();
            for (CMISNodeInfo parentInfo : parentInfos) {
                this.addNodeInfo(parentInfo);
                ObjectData object = this.connector.createCMISObject(parentInfo, filter, includeAllowableActions, includeRelationships, renditionFilter, false, false);
                boolean isObjectInfoRequired = this.getContext().isObjectInfoRequired();
                if (isObjectInfoRequired) {
                    this.getObjectInfo(repositoryId, object.getId(), includeRelationships);
                }
                ObjectParentDataImpl objectParent = new ObjectParentDataImpl();
                objectParent.setObject(object);
                if (includeRelativePathSegment.booleanValue()) {
                    objectParent.setRelativePathSegment(info.getName());
                }
                result.add((ObjectParentData)objectParent);
            }
        }
        this.logGetObjectsCall("getObjectParents", start, objectId, result.size(), filter, includeAllowableActions, includeRelationships, renditionFilter, includeRelativePathSegment, extension, null, null, null, null);
        return result;
    }

    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        List nodeRefs;
        long start = System.currentTimeMillis();
        this.checkRepositoryId(repositoryId);
        int max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        int skip = skipCount == null || skipCount.intValue() < 0 ? 0 : skipCount.intValue();
        SearchParameters params = new SearchParameters();
        params.setLanguage("fts-alfresco");
        if (folderId == null) {
            params.setQuery("+=cm:workingCopyOwner:\"" + AuthenticationUtil.getFullyAuthenticatedUser() + "\"");
            params.addStore(this.connector.getRootStoreRef());
        } else {
            CMISNodeInfo folderInfo = this.getOrCreateFolderInfo(folderId, "Folder");
            params.setQuery("+=cm:workingCopyOwner:\"" + AuthenticationUtil.getFullyAuthenticatedUser() + "\" AND +=PARENT:\"" + folderInfo.getNodeRef().toString() + "\"");
            params.addStore(folderInfo.getNodeRef().getStoreRef());
        }
        if (orderBy != null) {
            String[] parts = orderBy.split(",");
            int i = 0;
            while (i < parts.length) {
                String[] sort = parts[i].split(" +");
                if (sort.length >= 1) {
                    PropertyDefinitionWrapper propDef = this.connector.getOpenCMISDictionaryService().findPropertyByQueryName(sort[0]);
                    if (propDef != null) {
                        if (propDef.getPropertyDefinition().isOrderable().booleanValue()) {
                            QName sortProp = propDef.getPropertyAccessor().getMappedProperty();
                            if (sortProp != null) {
                                boolean sortAsc = sort.length == 1 || sort[1].equalsIgnoreCase("asc");
                                params.addSort(propDef.getPropertyLuceneBuilder().getLuceneFieldName(), sortAsc);
                            } else if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Ignore sort property '" + sort[0] + " - mapping not found"));
                            }
                        } else if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Ignore sort property '" + sort[0] + " - not orderable"));
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Ignore sort property '" + sort[0] + " - query name not found"));
                    }
                }
                ++i;
            }
        }
        try (ResultSet resultSet = null;){
            resultSet = this.connector.getSearchService().query(params);
            nodeRefs = resultSet.getNodeRefs();
        }
        ObjectListImpl result = new ObjectListImpl();
        ArrayList<ObjectData> list = new ArrayList<ObjectData>();
        result.setObjects(list);
        int skipCounter = skip;
        if (max > 0) {
            for (NodeRef nodeRef : nodeRefs) {
                if (this.connector.filter(nodeRef)) continue;
                if (skipCounter > 0) {
                    --skipCounter;
                    continue;
                }
                if (list.size() == max) break;
                try {
                    CMISNodeInfoImpl ni = this.createNodeInfo(nodeRef);
                    ObjectData object = this.connector.createCMISObject(ni, filter, includeAllowableActions, includeRelationships, renditionFilter, false, false);
                    boolean isObjectInfoRequired = this.getContext().isObjectInfoRequired();
                    if (isObjectInfoRequired) {
                        this.getObjectInfo(repositoryId, ni.getObjectId(), includeRelationships);
                    }
                    list.add(object);
                }
                catch (InvalidNodeRefException invalidNodeRefException) {
                }
                catch (CmisObjectNotFoundException cmisObjectNotFoundException) {}
            }
        }
        result.setHasMoreItems(Boolean.valueOf(nodeRefs.size() - skip > list.size()));
        this.logGetObjectsCall("getCheckedOutDocs", start, folderId, list.size(), filter, includeAllowableActions, includeRelationships, renditionFilter, null, extension, skipCount, maxItems, orderBy, null);
        return result;
    }

    public String create(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        if (properties == null || properties.getProperties() == null) {
            throw new CmisInvalidArgumentException("Properties must be set!");
        }
        String objectTypeId = this.connector.getObjectTypeIdProperty(properties);
        TypeDefinitionWrapper type = this.connector.getOpenCMISDictionaryService().findType(objectTypeId);
        if (type == null) {
            throw new CmisInvalidArgumentException("Type '" + objectTypeId + "' is unknown!");
        }
        String newId = null;
        switch (type.getBaseTypeId()) {
            case CMIS_DOCUMENT: {
                versioningState = this.getDocumentDefaultVersioningState(versioningState, type);
                newId = this.createDocument(repositoryId, properties, folderId, contentStream, versioningState, policies, null, null, extension);
                break;
            }
            case CMIS_FOLDER: {
                newId = this.createFolder(repositoryId, properties, folderId, policies, null, null, extension);
                break;
            }
            case CMIS_POLICY: {
                newId = this.createPolicy(repositoryId, properties, folderId, policies, null, null, extension);
                break;
            }
            case CMIS_ITEM: {
                newId = this.createItem(repositoryId, properties, folderId, policies, null, null, extension);
                break;
            }
        }
        if (newId == null) {
            throw new CmisRuntimeException("Creation failed!");
        }
        boolean isObjectInfoRequired = this.getContext().isObjectInfoRequired();
        if (isObjectInfoRequired) {
            try {
                this.getObjectInfo(repositoryId, newId, "*", IncludeRelationships.NONE);
            }
            catch (InvalidNodeRefException invalidNodeRefException) {
                throw new CmisRuntimeException("Creation failed! New object not found!");
            }
        }
        return newId;
    }

    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo parentInfo = this.getOrCreateFolderInfo(folderId, "Folder");
        String name = this.connector.getNameProperty(properties, null);
        String objectTypeId = this.connector.getObjectTypeIdProperty(properties);
        TypeDefinitionWrapper type = this.connector.getTypeForCreate(objectTypeId, BaseTypeId.CMIS_FOLDER);
        this.connector.checkChildObjectType(parentInfo, type.getTypeId());
        FileInfo fileInfo = this.connector.getFileFolderService().create(parentInfo.getNodeRef(), name, type.getAlfrescoClass());
        NodeRef nodeRef = fileInfo.getNodeRef();
        this.connector.setProperties(nodeRef, type, properties, "cmis:name", "cmis:objectTypeId");
        this.connector.applyPolicies(nodeRef, type, policies);
        this.connector.applyACL(nodeRef, type, addAces, removeAces);
        this.connector.getActivityPoster().postFileFolderAdded(nodeRef);
        String objectId = this.connector.createObjectId(nodeRef);
        return objectId;
    }

    public String createItem(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo parentInfo = this.getOrCreateFolderInfo(folderId, "Folder");
        String name = this.connector.getNameProperty(properties, null);
        String objectTypeId = this.connector.getObjectTypeIdProperty(properties);
        TypeDefinitionWrapper type = this.connector.getTypeForCreate(objectTypeId, BaseTypeId.CMIS_ITEM);
        this.connector.checkChildObjectType(parentInfo, type.getTypeId());
        QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)name));
        HashMap<QName, String> props = new HashMap<QName, String>(11);
        props.put(ContentModel.PROP_NAME, assocQName.getLocalName());
        ChildAssociationRef newRef = this.connector.getNodeService().createNode(parentInfo.getNodeRef(), ContentModel.ASSOC_CONTAINS, assocQName, type.getAlfrescoClass(), props);
        NodeRef nodeRef = newRef.getChildRef();
        this.connector.setProperties(nodeRef, type, properties, "cmis:name", "cmis:objectTypeId");
        this.connector.getNodeService().setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)assocQName.getLocalName()));
        this.connector.applyPolicies(nodeRef, type, policies);
        this.connector.applyACL(nodeRef, type, addAces, removeAces);
        String objectId = this.connector.createObjectId(nodeRef);
        return objectId;
    }

    private String parseMimeType(ContentStream contentStream) {
        String mimeType = null;
        String tmp = contentStream.getMimeType();
        if (tmp != null) {
            int idx = tmp.indexOf(";");
            mimeType = idx != -1 ? tmp.substring(0, idx).trim() : tmp;
        }
        return mimeType;
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo parentInfo = this.getOrCreateFolderInfo(folderId, "Parent folder");
        String name = this.connector.getNameProperty(properties, null);
        String objectTypeId = this.connector.getObjectTypeIdProperty(properties);
        TypeDefinitionWrapper type = this.connector.getTypeForCreate(objectTypeId, BaseTypeId.CMIS_DOCUMENT);
        this.connector.checkChildObjectType(parentInfo, type.getTypeId());
        DocumentTypeDefinition docType = (DocumentTypeDefinition)type.getTypeDefinition(false);
        if (docType.getContentStreamAllowed() == ContentStreamAllowed.NOTALLOWED && contentStream != null) {
            throw new CmisConstraintException("This document type does not support content!");
        }
        if (docType.getContentStreamAllowed() == ContentStreamAllowed.REQUIRED && contentStream == null) {
            throw new CmisConstraintException("This document type does requires content!");
        }
        if (!docType.isVersionable().booleanValue() && versioningState != VersioningState.NONE) {
            throw new CmisConstraintException("This document type is not versionable!");
        }
        versioningState = this.getDocumentDefaultVersioningState(versioningState, type);
        FileInfo fileInfo = this.connector.getFileFolderService().create(parentInfo.getNodeRef(), name, type.getAlfrescoClass());
        NodeRef nodeRef = fileInfo.getNodeRef();
        this.connector.setProperties(nodeRef, type, properties, "cmis:name", "cmis:objectTypeId");
        this.connector.applyPolicies(nodeRef, type, policies);
        this.connector.applyACL(nodeRef, type, addAces, removeAces);
        if (contentStream != null) {
            String mimeType = this.parseMimeType(contentStream);
            String encoding = this.getEncoding(contentStream.getStream(), mimeType);
            ContentWriter writer = this.connector.getFileFolderService().getWriter(nodeRef);
            writer.setMimetype(mimeType);
            writer.setEncoding(encoding);
            writer.putContent(contentStream.getStream());
        }
        this.connector.extractMetadata(nodeRef);
        this.connector.createThumbnails(nodeRef, this.getCmisRequestRenditionsOnCreateDoc());
        this.connector.applyVersioningState(nodeRef, versioningState);
        String objectId = this.connector.createObjectId(nodeRef);
        this.connector.getActivityPoster().postFileFolderAdded(nodeRef);
        return objectId;
    }

    private VersioningState getDocumentDefaultVersioningState(VersioningState versioningState, TypeDefinitionWrapper type) {
        if (versioningState == null) {
            DocumentTypeDefinition docType = (DocumentTypeDefinition)type.getTypeDefinition(false);
            versioningState = docType.isVersionable() != false ? VersioningState.MAJOR : VersioningState.NONE;
        }
        return versioningState;
    }

    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo parentInfo = this.getOrCreateFolderInfo(folderId, "Parent folder");
        CMISNodeInfo info = this.getOrCreateNodeInfo(sourceId, "Source");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            throw new CmisConstraintException("Source object is not a document!");
        }
        NodeRef sourceNodeRef = info.getNodeRef();
        if (!info.isDocument()) {
            throw new CmisConstraintException("Source object is not a document!");
        }
        String name = this.connector.getNameProperty(properties, info.getName());
        TypeDefinitionWrapper type = info.getType();
        this.connector.checkChildObjectType(parentInfo, type.getTypeId());
        versioningState = this.getDocumentDefaultVersioningState(versioningState, type);
        try {
            FileInfo fileInfo = this.connector.getFileFolderService().copy(sourceNodeRef, parentInfo.getNodeRef(), name);
            NodeRef nodeRef = fileInfo.getNodeRef();
            this.connector.setProperties(nodeRef, type, properties, "cmis:name", "cmis:objectTypeId");
            this.connector.applyPolicies(nodeRef, type, policies);
            this.connector.applyACL(nodeRef, type, addAces, removeAces);
            this.connector.extractMetadata(nodeRef);
            this.connector.createThumbnails(nodeRef, this.getCmisRequestRenditionsOnCreateDoc());
            this.connector.applyVersioningState(nodeRef, versioningState);
            this.connector.getActivityPoster().postFileFolderAdded(nodeRef);
            return this.connector.createObjectId(nodeRef);
        }
        catch (FileNotFoundException e) {
            throw new CmisContentAlreadyExistsException("An object with this name already exists!", (Throwable)e);
        }
    }

    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.getOrCreateFolderInfo(folderId, "Parent Folder");
        String objectTypeId = this.connector.getObjectTypeIdProperty(properties);
        this.connector.getTypeForCreate(objectTypeId, BaseTypeId.CMIS_POLICY);
        throw new CmisRuntimeException("Polcies cannot be created!");
    }

    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        String objectTypeId = this.connector.getObjectTypeIdProperty(properties);
        TypeDefinitionWrapper type = this.connector.getTypeForCreate(objectTypeId, BaseTypeId.CMIS_RELATIONSHIP);
        String sourceId = this.connector.getSourceIdProperty(properties);
        CMISNodeInfo sourceInfo = this.getOrCreateNodeInfo(sourceId, "Source");
        if (!(sourceInfo.isVariant(CMISObjectVariant.CURRENT_VERSION) || sourceInfo.isVariant(CMISObjectVariant.FOLDER) || sourceInfo.isVariant(CMISObjectVariant.ITEM))) {
            throw new CmisInvalidArgumentException("Source is not the latest version of a document, a folder or an item object!");
        }
        NodeRef sourceNodeRef = sourceInfo.getNodeRef();
        String targetId = this.connector.getTargetIdProperty(properties);
        CMISNodeInfo targetInfo = this.getOrCreateNodeInfo(targetId, "Target");
        if (!(targetInfo.isVariant(CMISObjectVariant.CURRENT_VERSION) || targetInfo.isVariant(CMISObjectVariant.FOLDER) || targetInfo.isVariant(CMISObjectVariant.ITEM))) {
            throw new CmisInvalidArgumentException("Target is not the latest version of a document, a folder or an item object!!");
        }
        NodeRef targetNodeRef = targetInfo.getNodeRef();
        if (policies != null && !policies.isEmpty()) {
            throw new CmisConstraintException("Relationships are not policy controllable!");
        }
        if (addAces != null && addAces.getAces() != null && !addAces.getAces().isEmpty()) {
            throw new CmisConstraintException("Relationships are not ACL controllable!");
        }
        if (removeAces != null && removeAces.getAces() != null && !removeAces.getAces().isEmpty()) {
            throw new CmisConstraintException("Relationships are not ACL controllable!");
        }
        boolean wasEnabled = this.connector.disableBehaviour(ContentModel.ASPECT_AUDITABLE, sourceNodeRef);
        try {
            AssociationRef assocRef = this.connector.getNodeService().createAssociation(sourceNodeRef, targetNodeRef, type.getAlfrescoClass());
            String string = "assoc:" + String.valueOf(assocRef.getId());
            return string;
        }
        finally {
            if (wasEnabled) {
                this.connector.enableBehaviour(ContentModel.ASPECT_AUDITABLE, sourceNodeRef);
            }
        }
    }

    public void appendContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, final ContentStream contentStream, final boolean isLastChunk, ExtensionsData extension) {
        if (contentStream == null || contentStream.getStream() == null) {
            throw new CmisInvalidArgumentException("No content!");
        }
        this.checkRepositoryId(repositoryId);
        final CMISNodeInfo info = this.getOrCreateNodeInfo((String)objectId.getValue(), "Object");
        final NodeRef nodeRef = info.getNodeRef();
        if (((DocumentTypeDefinition)info.getType().getTypeDefinition(false)).getContentStreamAllowed() == ContentStreamAllowed.NOTALLOWED) {
            throw new CmisStreamNotSupportedException("Document type doesn't allow content!");
        }
        RetryingTransactionHelper helper = this.connector.getRetryingTransactionHelper();
        helper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                try {
                    AlfrescoCmisServiceImpl.this.connector.appendContent(info, contentStream, isLastChunk);
                }
                catch (IOException e) {
                    throw new ContentIOException("", (Throwable)e);
                }
                return null;
            }
        }, false, true);
        String objId = helper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            @Override
            public String execute() throws Throwable {
                return AlfrescoCmisServiceImpl.this.connector.createObjectId(nodeRef);
            }
        }, true, true);
        objectId.setValue((Object)objId);
    }

    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, final ContentStream contentStream, ExtensionsData extension) {
        boolean existed;
        this.checkRepositoryId(repositoryId);
        final CMISNodeInfo info = this.getOrCreateNodeInfo((String)objectId.getValue(), "Object");
        if (!info.isVariant(CMISObjectVariant.CURRENT_VERSION) && !info.isVariant(CMISObjectVariant.PWC)) {
            throw new CmisStreamNotSupportedException("Content can only be set on private working copies or current versions.");
        }
        final NodeRef nodeRef = info.getNodeRef();
        if (((DocumentTypeDefinition)info.getType().getTypeDefinition(false)).getContentStreamAllowed() == ContentStreamAllowed.NOTALLOWED) {
            throw new CmisStreamNotSupportedException("Document type doesn't allow content!");
        }
        boolean bl = existed = this.connector.getContentService().getReader(nodeRef, ContentModel.PROP_CONTENT) != null;
        if (existed && !overwriteFlag.booleanValue()) {
            throw new CmisContentAlreadyExistsException("Content already exists!");
        }
        if (contentStream == null || contentStream.getStream() == null) {
            throw new CmisInvalidArgumentException("No content!");
        }
        RetryingTransactionHelper helper = this.connector.getRetryingTransactionHelper();
        helper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                String mimeType = AlfrescoCmisServiceImpl.this.parseMimeType(contentStream);
                String encoding = AlfrescoCmisServiceImpl.this.getEncoding(contentStream.getStream(), mimeType);
                ContentWriter writer = AlfrescoCmisServiceImpl.this.connector.getFileFolderService().getWriter(nodeRef);
                writer.setMimetype(mimeType);
                writer.setEncoding(encoding);
                writer.putContent(contentStream.getStream());
                AlfrescoCmisServiceImpl.this.connector.getActivityPoster().postFileFolderUpdated(info.isFolder(), nodeRef);
                return null;
            }
        }, false, true);
        String objId = helper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            @Override
            public String execute() throws Throwable {
                return AlfrescoCmisServiceImpl.this.connector.createObjectId(nodeRef);
            }
        }, true, true);
        objectId.setValue((Object)objId);
    }

    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        final CMISNodeInfo info = this.getOrCreateNodeInfo((String)objectId.getValue(), "Object");
        if (!info.isVariant(CMISObjectVariant.CURRENT_VERSION) && !info.isVariant(CMISObjectVariant.PWC)) {
            throw new CmisStreamNotSupportedException("Content can only be deleted from ondocuments!");
        }
        final NodeRef nodeRef = info.getNodeRef();
        if (((DocumentTypeDefinition)info.getType().getTypeDefinition(false)).getContentStreamAllowed() == ContentStreamAllowed.REQUIRED) {
            throw new CmisInvalidArgumentException("Document type requires content!");
        }
        RetryingTransactionHelper helper = this.connector.getRetryingTransactionHelper();
        helper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AlfrescoCmisServiceImpl.this.connector.getNodeService().setProperty(nodeRef, ContentModel.PROP_CONTENT, null);
                AlfrescoCmisServiceImpl.this.connector.getActivityPoster().postFileFolderUpdated(info.isFolder(), nodeRef);
                return null;
            }
        }, false, true);
        String objId = helper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            @Override
            public String execute() throws Throwable {
                return AlfrescoCmisServiceImpl.this.connector.createObjectId(nodeRef);
            }
        }, true, true);
        objectId.setValue((Object)objId);
    }

    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo((String)objectId.getValue(), "Object");
        NodeRef nodeRef = info.getCurrentNodeNodeRef();
        CMISNodeInfo sourceInfo = this.getOrCreateFolderInfo(sourceFolderId, "Source Folder");
        CMISNodeInfo targetInfo = this.getOrCreateFolderInfo(targetFolderId, "Target Folder");
        this.connector.checkChildObjectType(targetInfo, info.getType().getTypeId());
        ChildAssociationRef primaryParentRef = this.connector.getNodeService().getPrimaryParent(nodeRef);
        if (primaryParentRef.getParentRef().equals((Object)sourceInfo.getNodeRef())) {
            this.connector.getNodeService().moveNode(nodeRef, targetInfo.getNodeRef(), primaryParentRef.getTypeQName(), primaryParentRef.getQName());
        } else {
            boolean found = false;
            for (ChildAssociationRef parent : this.connector.getNodeService().getParentAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL)) {
                if (!parent.getParentRef().equals((Object)sourceInfo.getNodeRef())) continue;
                this.connector.getNodeService().removeChildAssociation(parent);
                this.connector.getNodeService().addChild(targetInfo.getNodeRef(), nodeRef, ContentModel.ASSOC_CONTAINS, parent.getQName());
                found = true;
            }
            if (!found) {
                throw new IllegalArgumentException((Throwable)new CmisInvalidArgumentException("Document is not a child of the source folder that was specified!"));
            }
        }
    }

    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo((String)objectId.getValue(), "Object");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            throw new CmisInvalidArgumentException("Relationship properties cannot be updated!");
        }
        if (info.isVariant(CMISObjectVariant.VERSION)) {
            throw new CmisInvalidArgumentException("Document is not the latest version!");
        }
        NodeRef nodeRef = info.getNodeRef();
        this.connector.setProperties(nodeRef, info.getType(), properties, new String[0]);
        objectId.setValue((Object)this.connector.createObjectId(nodeRef));
        boolean isObjectInfoRequired = this.getContext().isObjectInfoRequired();
        if (isObjectInfoRequired) {
            this.getObjectInfo(repositoryId, (String)objectId.getValue(), "*", IncludeRelationships.NONE);
        }
        this.connector.getActivityPoster().postFileFolderUpdated(info.isFolder(), nodeRef);
    }

    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.deleteObjectOrCancelCheckOut(repositoryId, objectId, allVersions, extension);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void deleteObjectOrCancelCheckOut(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            AssociationRef assocRef = info.getAssociationRef();
            this.connector.getNodeService().removeAssociation(assocRef.getSourceRef(), assocRef.getTargetRef(), assocRef.getTypeQName());
            return;
        }
        NodeRef nodeRef = info.getNodeRef();
        if (info.isVariant(CMISObjectVariant.PWC)) {
            this.connector.getCheckOutCheckInService().cancelCheckout(nodeRef);
            return;
        }
        if (info.isFolder()) {
            if (this.connector.getNodeService().getChildAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL, 1, false).size() > 0) {
                throw new CmisConstraintException("Could not delete folder with at least one child!");
            }
            this.connector.deleteNode(nodeRef, true);
            return;
        }
        if (info.hasPWC()) {
            throw new CmisConstraintException("Could not delete/cancel checkout on the original checked out document");
        }
        if (info.isVariant(CMISObjectVariant.VERSION)) {
            nodeRef = info.getCurrentNodeNodeRef();
        }
        if (allVersions.booleanValue()) {
            NodeRef workingCopy = this.connector.getCheckOutCheckInService().getWorkingCopy(nodeRef);
            if (workingCopy != null) {
                this.connector.getCheckOutCheckInService().cancelCheckout(workingCopy);
            }
        } else if (info.isVariant(CMISObjectVariant.VERSION)) {
            AccessStatus perm = this.connector.getServiceRegistry().getPermissionService().hasPermission(nodeRef, "Delete");
            if (AccessStatus.ALLOWED != perm) {
                throw new CmisPermissionDeniedException("Cannot delete the node version.");
            }
            Version version = ((CMISNodeInfoImpl)info).getVersion();
            this.connector.getVersionService().deleteVersion(nodeRef, version);
            return;
        }
        if (allVersions.booleanValue()) {
            this.connector.deleteNode(nodeRef, true);
            return;
        }
        CMISNodeInfoImpl infoImpl = (CMISNodeInfoImpl)info;
        Version version = infoImpl.getVersion();
        if (infoImpl.getVersionHistory().getPredecessor(version) == null) {
            this.connector.deleteNode(nodeRef, true);
            return;
        }
        AccessStatus perm = this.connector.getServiceRegistry().getPermissionService().hasPermission(nodeRef, "Delete");
        if (AccessStatus.ALLOWED != perm) {
            throw new CmisPermissionDeniedException("Cannot delete the node version.");
        }
        this.connector.getVersionService().deleteVersion(nodeRef, version);
        this.connector.getVersionService().revert(nodeRef);
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        if (!allVersions.booleanValue()) {
            throw new CmisInvalidArgumentException("Only allVersions=true supported!");
        }
        if (unfileObjects == UnfileObject.UNFILE) {
            throw new CmisInvalidArgumentException("Unfiling not supported!");
        }
        NodeRef folderNodeRef = this.getOrCreateFolderInfo(folderId, "Folder").getNodeRef();
        FailedToDeleteDataImpl result = new FailedToDeleteDataImpl();
        try {
            this.connector.deleteNode(folderNodeRef, true);
        }
        catch (Exception exception) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(folderId);
            result.setIds(ids);
        }
        return result;
    }

    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        long start = System.currentTimeMillis();
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        ObjectData object = this.connector.createCMISObject(info, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl);
        boolean isObjectInfoRequired = this.getContext().isObjectInfoRequired();
        if (isObjectInfoRequired) {
            this.getObjectInfo(repositoryId, info.getObjectId(), includeRelationships);
        }
        this.logGetObjectCall("getObject", start, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, isObjectInfoRequired, extension);
        return object;
    }

    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(String repositoryId, List<BulkUpdateObjectIdAndChangeToken> objectIdAndChangeTokens, final Properties properties, final List<String> addSecondaryTypeIds, final List<String> removeSecondaryTypeIds, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        if (objectIdAndChangeTokens.size() > this.connector.getBulkMaxItems()) {
            throw new CmisConstraintException("Bulk update not supported for more than " + this.connector.getBulkMaxItems() + " objects.");
        }
        final CallContext cmisCallContext = AlfrescoCmisServiceCall.get();
        BulkUpdateContext context = new BulkUpdateContext(objectIdAndChangeTokens.size());
        RetryingTransactionHelper helper = this.connector.getRetryingTransactionHelper();
        final String runAsUser = AuthenticationUtil.getRunAsUser();
        BatchProcessor.BatchProcessWorker<BulkEntry> worker = new BatchProcessor.BatchProcessWorker<BulkEntry>(){

            @Override
            public void process(BulkEntry entry) throws Throwable {
                entry.update();
            }

            @Override
            public String getIdentifier(BulkEntry entry) {
                return entry.getObjectIdAndChangeToken().getId();
            }

            @Override
            public void beforeProcess() throws Throwable {
                AuthenticationUtil.pushAuthentication();
                AuthenticationUtil.setFullyAuthenticatedUser((String)runAsUser);
                AlfrescoCmisServiceCall.set(cmisCallContext);
            }

            @Override
            public void afterProcess() throws Throwable {
                AuthenticationUtil.popAuthentication();
            }
        };
        class WorkProvider
        implements BatchProcessWorkProvider<BulkEntry> {
            private final Iterator<BulkUpdateObjectIdAndChangeToken> iterator;
            private final int size;
            private final int batchSize;
            private BulkUpdateContext context;

            public WorkProvider(List<BulkUpdateObjectIdAndChangeToken> objectIdAndChangeTokens, BulkUpdateContext context, int batchSize) {
                this.iterator = objectIdAndChangeTokens.iterator();
                this.size = objectIdAndChangeTokens.size();
                this.context = context;
                this.batchSize = batchSize;
            }

            @Override
            public synchronized int getTotalEstimatedWorkSize() {
                return this.size;
            }

            @Override
            public synchronized long getTotalEstimatedWorkSizeLong() {
                return this.size;
            }

            @Override
            public synchronized Collection<BulkEntry> getNextWork() {
                ArrayList<BulkEntry> results = new ArrayList<BulkEntry>(this.batchSize);
                while (results.size() < this.batchSize && this.iterator.hasNext()) {
                    results.add(new BulkEntry(this.context, this.iterator.next(), properties, addSecondaryTypeIds, removeSecondaryTypeIds, this.getContext().isObjectInfoRequired()));
                }
                return results;
            }
        }
        BatchProcessor<BulkEntry> processor = new BatchProcessor<BulkEntry>("CMISbulkUpdateProperties", helper, new WorkProvider(objectIdAndChangeTokens, context, this.connector.getBulkBatchSize()), this.connector.getBulkWorkerThreads(), this.connector.getBulkBatchSize(), null, logger, 100);
        processor.process(worker, true);
        for (CMISNodeInfo info : context.getSuccesses()) {
            NodeRef nodeRef = info.getNodeRef();
            this.connector.getActivityPoster().postFileFolderUpdated(info.isFolder(), nodeRef);
        }
        return context.getChanges();
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        ObjectData object;
        long start = System.currentTimeMillis();
        boolean isObjectInfoRequired = false;
        this.checkRepositoryId(repositoryId);
        NodeRef rootNodeRef = this.connector.getRootNodeRef();
        if (path.equals("/")) {
            object = this.connector.createCMISObject(this.createNodeInfo(rootNodeRef), filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl);
        } else {
            try {
                FileInfo fileInfo = this.connector.getFileFolderService().resolveNamePath(rootNodeRef, Arrays.asList(path.substring(1).split("/")));
                if (this.connector.filter(fileInfo.getNodeRef())) {
                    throw new CmisObjectNotFoundException("Object not found: " + path);
                }
                CMISNodeInfoImpl info = this.createNodeInfo(fileInfo.getNodeRef(), fileInfo.getType(), fileInfo.getProperties(), null, false);
                object = this.connector.createCMISObject(info, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl);
                isObjectInfoRequired = this.getContext().isObjectInfoRequired();
                if (isObjectInfoRequired) {
                    this.getObjectInfo(repositoryId, info.getObjectId(), includeRelationships);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CmisObjectNotFoundException("Object not found: " + path);
            }
        }
        this.logGetObjectCall("getObjectByPath", start, path, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, isObjectInfoRequired, extension);
        return object;
    }

    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        boolean isObjectInfoRequired = this.getContext().isObjectInfoRequired();
        if (isObjectInfoRequired) {
            this.getObjectInfo(repositoryId, info.getObjectId(), IncludeRelationships.NONE);
        }
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            return this.connector.getAssocProperties(info, filter);
        }
        return this.connector.getNodeProperties(info, filter);
    }

    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        return this.connector.getAllowableActions(info);
    }

    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            throw new CmisInvalidArgumentException("Object is a relationship and cannot have content!");
        }
        return this.connector.getContentStream(info, streamId, offset, length);
    }

    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            return Collections.emptyList();
        }
        return this.connector.getRenditions(info.getNodeRef(), renditionFilter, maxItems, skipCount);
    }

    public void checkOut(String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo((String)objectId.getValue(), "Object");
        if (!info.isVariant(CMISObjectVariant.CURRENT_VERSION)) {
            if (info.isVariant(CMISObjectVariant.VERSION)) {
                throw new CmisInvalidArgumentException("Can't check out an old version of a document");
            }
            throw new CmisInvalidArgumentException("Only documents can be checked out! Object was a " + info.getObjectVariant().toString());
        }
        NodeRef nodeRef = info.getNodeRef();
        if (!((DocumentTypeDefinition)info.getType().getTypeDefinition(false)).isVersionable().booleanValue()) {
            throw new CmisConstraintException("Document is not versionable!");
        }
        NodeRef pwcNodeRef = this.connector.getCheckOutCheckInService().checkout(nodeRef);
        CMISNodeInfoImpl pwcNodeInfo = this.createNodeInfo(pwcNodeRef);
        objectId.setValue((Object)pwcNodeInfo.getObjectId());
        if (contentCopied != null) {
            contentCopied.setValue((Object)(this.connector.getFileFolderService().getReader(pwcNodeRef) != null ? 1 : 0));
        }
    }

    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        NodeRef nodeRef;
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (!info.isVariant(CMISObjectVariant.PWC)) {
            nodeRef = info.getNodeRef();
            NodeRef workingCopyNodeRef = this.connector.getCheckOutCheckInService().getWorkingCopy(nodeRef);
            info = this.getOrCreateNodeInfo(workingCopyNodeRef.getId());
            if (!info.isVariant(CMISObjectVariant.PWC)) {
                throw new CmisVersioningException("Object is not a PWC!");
            }
        }
        nodeRef = info.getNodeRef();
        this.connector.getCheckOutCheckInService().cancelCheckout(nodeRef);
    }

    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo((String)objectId.getValue(), "Object");
        if (!info.isVariant(CMISObjectVariant.PWC)) {
            throw new CmisVersioningException("Object is not a PWC!");
        }
        NodeRef nodeRef = info.getNodeRef();
        TypeDefinitionWrapper type = info.getType();
        this.connector.setProperties(nodeRef, type, properties, "cmis:objectTypeId");
        this.connector.applyPolicies(nodeRef, type, policies);
        this.connector.applyACL(nodeRef, type, addAces, removeAces);
        if (contentStream != null) {
            String mimeType = this.parseMimeType(contentStream);
            String encoding = this.getEncoding(contentStream.getStream(), mimeType);
            ContentWriter writer = this.connector.getFileFolderService().getWriter(nodeRef);
            writer.setMimetype(mimeType);
            writer.setEncoding(encoding);
            writer.putContent(contentStream.getStream());
        }
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>(5);
        versionProperties.put("versionType", (Serializable)((Object)(major != false ? VersionType.MAJOR : VersionType.MINOR)));
        if (checkinComment != null) {
            versionProperties.put("description", (Serializable)((Object)checkinComment));
        }
        NodeRef newNodeRef = this.connector.getCheckOutCheckInService().checkin(nodeRef, versionProperties);
        this.connector.getActivityPoster().postFileFolderUpdated(info.isFolder(), newNodeRef);
        objectId.setValue((Object)this.connector.createObjectId(newNodeRef));
    }

    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        if (versionSeriesId == null && objectId != null) {
            versionSeriesId = this.connector.getCurrentVersionId(objectId);
        }
        if (versionSeriesId == null) {
            throw new CmisInvalidArgumentException("Object Id or Object Series Id must be set!");
        }
        ArrayList<ObjectData> result = new ArrayList<ObjectData>();
        CMISNodeInfo info = this.getOrCreateNodeInfo(versionSeriesId, "Version Series");
        if (!info.isVariant(CMISObjectVariant.CURRENT_VERSION)) {
            throw new CmisInvalidArgumentException("Version Series does not exist!");
        }
        NodeRef nodeRef = info.getNodeRef();
        VersionHistory versionHistory = ((CMISNodeInfoImpl)info).getVersionHistory();
        if (versionHistory == null) {
            result.add(this.connector.createCMISObject(info, filter, includeAllowableActions, IncludeRelationships.NONE, "cmis:none", false, false));
            boolean isObjectInfoRequired = this.getContext().isObjectInfoRequired();
            if (isObjectInfoRequired) {
                this.getObjectInfo(repositoryId, info.getObjectId(), IncludeRelationships.NONE);
            }
        } else {
            if (info.hasPWC()) {
                CMISNodeInfoImpl pwcInfo = this.createNodeInfo(this.connector.getCheckOutCheckInService().getWorkingCopy(nodeRef));
                result.add(this.connector.createCMISObject(pwcInfo, filter, includeAllowableActions, IncludeRelationships.NONE, "cmis:none", false, false));
                boolean isObjectInfoRequired = this.getContext().isObjectInfoRequired();
                if (isObjectInfoRequired) {
                    this.getObjectInfo(repositoryId, pwcInfo.getObjectId(), IncludeRelationships.NONE);
                }
            }
            for (Version version : versionHistory.getAllVersions()) {
                CMISNodeInfoImpl versionInfo = this.createNodeInfo(version.getFrozenStateNodeRef(), versionHistory, true);
                if (versionHistory.getHeadVersion().equals(version)) {
                    versionInfo = this.createNodeInfo(nodeRef);
                }
                result.add(this.connector.createCMISObject(versionInfo, filter, includeAllowableActions, IncludeRelationships.NONE, "cmis:none", false, false));
                boolean isObjectInfoRequired = this.getContext().isObjectInfoRequired();
                if (!isObjectInfoRequired) continue;
                this.getObjectInfo(repositoryId, versionInfo.getObjectId(), IncludeRelationships.NONE);
            }
        }
        return result;
    }

    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        long start = System.currentTimeMillis();
        this.checkRepositoryId(repositoryId);
        if (objectId != null) {
            versionSeriesId = this.connector.getCurrentVersionId(objectId);
        }
        CMISNodeInfo info = this.getOrCreateNodeInfo(versionSeriesId, "Version Series");
        CMISNodeInfoImpl versionInfo = this.createNodeInfo(((CMISNodeInfoImpl)info).getLatestVersionNodeRef(major));
        ObjectData object = this.connector.createCMISObject(versionInfo, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl);
        boolean isObjectInfoRequired = this.getContext().isObjectInfoRequired();
        if (isObjectInfoRequired) {
            this.getObjectInfo(repositoryId, info.getObjectId(), includeRelationships);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(objectId).append("-").append(versionSeriesId);
        this.logGetObjectCall("getObjectOfLatestVersion", start, sb.toString(), filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, isObjectInfoRequired, extension);
        return object;
    }

    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        CMISNodeInfo info;
        this.checkRepositoryId(repositoryId);
        if (objectId != null) {
            versionSeriesId = this.connector.getCurrentVersionId(objectId);
        }
        if ((info = this.getOrCreateNodeInfo(versionSeriesId, "Version Series")).isVariant(CMISObjectVariant.ASSOC)) {
            return this.connector.getAssocProperties(info, filter);
        }
        CMISNodeInfoImpl versionInfo = this.createNodeInfo(((CMISNodeInfoImpl)info).getLatestVersionNodeRef(major));
        this.addNodeInfo(versionInfo);
        return this.connector.getNodeProperties(versionInfo, filter);
    }

    public void addObjectToFolder(String repositoryId, String objectId, String folderId, Boolean allVersions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        if (!allVersions.booleanValue()) {
            throw new CmisInvalidArgumentException("Only allVersions=true supported!");
        }
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (!info.isDocument()) {
            throw new CmisInvalidArgumentException("Object is not a document!");
        }
        NodeRef nodeRef = info.getNodeRef();
        CMISNodeInfo folderInfo = this.getOrCreateFolderInfo(folderId, "Folder");
        this.connector.checkChildObjectType(folderInfo, info.getType().getTypeId());
        QName name = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)((String)((Object)this.connector.getNodeService().getProperty(nodeRef, ContentModel.PROP_NAME)))));
        this.connector.getNodeService().addChild(folderInfo.getNodeRef(), nodeRef, ContentModel.ASSOC_CONTAINS, name);
    }

    public void removeObjectFromFolder(String repositoryId, String objectId, String folderId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (!info.isDocument()) {
            throw new CmisInvalidArgumentException("Object is not a document!");
        }
        NodeRef nodeRef = info.getNodeRef();
        NodeRef folderNodeRef = this.getOrCreateFolderInfo(folderId, "Folder").getNodeRef();
        if (this.connector.getNodeService().getPrimaryParent(nodeRef).getParentRef().equals((Object)folderNodeRef)) {
            throw new CmisConstraintException("Unfiling from primary parent folder is not supported! Use deleteObject() instead.");
        }
        this.connector.getNodeService().removeChild(folderNodeRef, nodeRef);
    }

    public ObjectList getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeAcl, BigInteger maxItems, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        return this.connector.getContentChanges(changeLogToken, maxItems);
    }

    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        if (searchAllVersions.booleanValue()) {
            throw new CmisInvalidArgumentException("Search all version is not supported!");
        }
        return this.connector.query(statement, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount);
    }

    public ObjectList getObjectRelationships(String repositoryId, String objectId, Boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, String typeId, String filter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            throw new CmisInvalidArgumentException("Object is a relationship!");
        }
        if (info.isVariant(CMISObjectVariant.VERSION)) {
            throw new CmisInvalidArgumentException("Object is a document version!");
        }
        if (BaseTypeId.CMIS_RELATIONSHIP.value().equals(typeId)) {
            boolean isrt;
            boolean bl = isrt = includeSubRelationshipTypes == null ? false : includeSubRelationshipTypes;
            if (isrt) {
                typeId = null;
            } else {
                ObjectListImpl result = new ObjectListImpl();
                result.setHasMoreItems(Boolean.valueOf(false));
                result.setNumItems(BigInteger.ZERO);
                result.setObjects(new ArrayList());
                return result;
            }
        }
        return this.connector.getObjectRelationships(info.getNodeRef(), relationshipDirection, typeId, filter, includeAllowableActions, maxItems, skipCount);
    }

    public void applyPolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        TypeDefinitionWrapper type = info.getType();
        if (type == null) {
            throw new CmisObjectNotFoundException("No corresponding type found! Not a CMIS object?");
        }
        this.connector.applyPolicies(info.getNodeRef(), type, Collections.singletonList(policyId));
    }

    public void removePolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        TypeDefinitionWrapper type = info.getType();
        if (type == null) {
            throw new CmisObjectNotFoundException("No corresponding type found! Not a CMIS object?");
        }
        throw new CmisConstraintException("Object is not policy controllable!");
    }

    public List<ObjectData> getAppliedPolicies(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.getOrCreateNodeInfo(objectId, "Object");
        return Collections.emptyList();
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl addAces, Acl removeAces, AclPropagation aclPropagation, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            throw new CmisConstraintException("Relationships are not ACL controllable!");
        }
        NodeRef nodeRef = info.getCurrentNodeNodeRef();
        TypeDefinitionWrapper type = info.getType();
        this.connector.applyACL(nodeRef, type, addAces, removeAces);
        return this.connector.getACL(nodeRef, false);
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl aces, AclPropagation aclPropagation) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            throw new CmisConstraintException("Relationships are not ACL controllable!");
        }
        NodeRef nodeRef = info.getCurrentNodeNodeRef();
        TypeDefinitionWrapper type = info.getType();
        this.connector.applyACL(nodeRef, type, aces);
        return this.connector.getACL(nodeRef, false);
    }

    public Acl getAcl(String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        CMISNodeInfo info = this.getOrCreateNodeInfo(objectId, "Object");
        if (info.isVariant(CMISObjectVariant.ASSOC)) {
            return new AccessControlListImpl(Collections.EMPTY_LIST);
        }
        return this.connector.getACL(info.getCurrentNodeNodeRef(), onlyBasicPermissions);
    }

    public ObjectInfo getObjectInfo(String repositoryId, String objectId) {
        return this.getObjectInfo(repositoryId, objectId, null, IncludeRelationships.BOTH);
    }

    protected ObjectInfo getObjectInfo(String repositoryId, String objectId, IncludeRelationships includeRelationships) {
        return this.getObjectInfo(repositoryId, objectId, null, includeRelationships);
    }

    protected ObjectInfo getObjectInfo(String repositoryId, String objectId, String filter, IncludeRelationships includeRelationships) {
        ObjectInfo info = this.objectInfoMap.get(objectId);
        if (info == null) {
            CMISNodeInfo nodeInfo = this.getOrCreateNodeInfo(objectId);
            if (nodeInfo.getObjectVariant() == CMISObjectVariant.INVALID_ID || nodeInfo.getObjectVariant() == CMISObjectVariant.NOT_EXISTING || nodeInfo.getObjectVariant() == CMISObjectVariant.NOT_A_CMIS_OBJECT || nodeInfo.getObjectVariant() == CMISObjectVariant.PERMISSION_DENIED) {
                info = null;
            } else {
                try {
                    if (filter == null) {
                        filter = MIN_FILTER;
                    } else if (!((String)filter).equals("*")) {
                        filter = (String)filter + ",cmis:name,cmis:baseTypeId,cmis:objectTypeId,cmis:createdBy,cmis:creationDate,cmis:lastModifiedBy,cmis:lastModificationDate,cmis:contentStreamLength,cmis:contentStreamMimeType,cmis:contentStreamFileName,cmis:contentStreamId";
                    }
                    ObjectData object = this.connector.createCMISObject(nodeInfo, (String)filter, false, includeRelationships, null, false, false);
                    info = this.getObjectInfoIntern(repositoryId, object);
                    this.objectInfoMap.put(objectId, info);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    info = null;
                }
            }
        }
        return info;
    }

    public String getRequestParameterRenditionFilter() {
        QueryStringHttpServletRequestWrapper httpServletRequest = this.getHttpServletRequest();
        String value = httpServletRequest == null ? null : httpServletRequest.getParameter("renditionFilter");
        return value == null ? "cmis:none" : value;
    }

    public IncludeRelationships getRequestParameterIncludeRelationships() {
        QueryStringHttpServletRequestWrapper httpServletRequest = this.getHttpServletRequest();
        String value = httpServletRequest == null ? null : httpServletRequest.getParameter("includeRelationships");
        return value == null ? IncludeRelationships.NONE : (IncludeRelationships)CmisEnumHelper.fromValue((String)value, IncludeRelationships.class);
    }

    private QueryStringHttpServletRequestWrapper getHttpServletRequest() {
        CallContext context = this.getContext();
        return (QueryStringHttpServletRequestWrapper)context.get("httpServletRequest");
    }

    protected ObjectInfo getObjectInfoIntern(String repositoryId, ObjectData object) {
        if (object.getProperties() == null || object.getProperties().getProperties() == null) {
            throw new CmisRuntimeException("No properties!");
        }
        String objectId = object.getId();
        CMISNodeInfo ni = this.getOrCreateNodeInfo(objectId);
        ObjectInfoImpl info = new ObjectInfoImpl();
        info.setObject(object);
        info.setId(objectId);
        info.setName(this.getStringProperty(object, "cmis:name"));
        info.setCreatedBy(this.getStringProperty(object, "cmis:createdBy"));
        info.setCreationDate(this.getDateTimeProperty(object, "cmis:creationDate"));
        info.setLastModificationDate(this.getDateTimeProperty(object, "cmis:lastModificationDate"));
        info.setTypeId(this.getIdProperty(object, "cmis:objectTypeId"));
        info.setBaseType(object.getBaseTypeId());
        if (ni.isRelationship()) {
            info.setWorkingCopyId(null);
            info.setWorkingCopyOriginalId(null);
            info.setVersionSeriesId(null);
            info.setIsCurrentVersion(true);
            info.setWorkingCopyId(null);
            info.setWorkingCopyOriginalId(null);
            info.setHasContent(false);
            info.setContentType(null);
            info.setFileName(null);
            info.setHasParent(false);
            info.setSupportsRelationships(false);
            info.setSupportsPolicies(false);
            info.setRenditionInfos(null);
            info.setRelationshipSourceIds(null);
            info.setRelationshipTargetIds(null);
            info.setHasAcl(false);
            info.setSupportsDescendants(false);
            info.setSupportsFolderTree(false);
        } else if (ni.isFolder()) {
            info.setWorkingCopyId(null);
            info.setWorkingCopyOriginalId(null);
            info.setVersionSeriesId(null);
            info.setIsCurrentVersion(true);
            info.setWorkingCopyId(null);
            info.setWorkingCopyOriginalId(null);
            info.setHasContent(false);
            info.setContentType(null);
            info.setFileName(null);
            info.setHasParent(!ni.isRootFolder());
            info.setSupportsRelationships(true);
            info.setSupportsPolicies(true);
            info.setRenditionInfos(null);
            this.setRelaionshipsToObjectInfo(object, info);
            info.setHasAcl(true);
            info.setSupportsDescendants(true);
            info.setSupportsFolderTree(true);
        } else if (ni.isDocument()) {
            boolean hasContent;
            info.setWorkingCopyId(null);
            info.setWorkingCopyOriginalId(null);
            info.setVersionSeriesId(ni.getCurrentNodeId());
            if (ni.isPWC()) {
                info.setIsCurrentVersion(false);
                info.setWorkingCopyId(ni.getObjectId());
                info.setWorkingCopyOriginalId(ni.getCurrentObjectId());
            } else {
                info.setIsCurrentVersion(ni.isCurrentVersion());
                if (ni.hasPWC()) {
                    info.setWorkingCopyId(ni.getCurrentNodeId() + ";pwc");
                    info.setWorkingCopyOriginalId(ni.getCurrentObjectId());
                } else {
                    info.setWorkingCopyId(null);
                    info.setWorkingCopyOriginalId(null);
                }
            }
            String fileName = this.getStringProperty(object, "cmis:contentStreamFileName");
            String mimeType = this.getStringProperty(object, "cmis:contentStreamMimeType");
            String streamId = this.getIdProperty(object, "cmis:contentStreamId");
            BigInteger length = this.getIntegerProperty(object, "cmis:contentStreamLength");
            boolean bl = hasContent = fileName != null || mimeType != null || streamId != null || length != null;
            if (hasContent) {
                info.setHasContent(hasContent);
                info.setContentType(mimeType);
                info.setFileName(fileName);
            } else {
                info.setHasContent(false);
                info.setContentType(null);
                info.setFileName(null);
            }
            info.setHasParent(ni.isCurrentVersion() || ni.isPWC());
            info.setSupportsRelationships(true);
            info.setSupportsPolicies(true);
            String renditionFilter = this.getRequestParameterRenditionFilter();
            ArrayList<RenditionInfoImpl> renditionInfos = new ArrayList<RenditionInfoImpl>();
            CMISNodeInfo nodeInfo = this.getOrCreateNodeInfo(objectId);
            NodeRef nodeRef = nodeInfo.getNodeRef();
            if (nodeRef != null) {
                List<RenditionData> renditions = this.connector.getRenditions(nodeRef, renditionFilter, null, null);
                for (RenditionData rendition : renditions) {
                    RenditionInfoImpl renditionInfo = new RenditionInfoImpl();
                    renditionInfo.setId(rendition.getStreamId());
                    renditionInfo.setKind(rendition.getKind());
                    renditionInfo.setContentType(rendition.getMimeType());
                    renditionInfo.setTitle(rendition.getTitle());
                    renditionInfo.setLength(rendition.getBigLength());
                    renditionInfos.add(renditionInfo);
                }
            }
            info.setRenditionInfos(renditionInfos);
            this.setRelaionshipsToObjectInfo(object, info);
            info.setHasAcl(true);
            info.setSupportsDescendants(true);
            info.setSupportsFolderTree(true);
        } else if (ni.isItem()) {
            info.setHasAcl(true);
            info.setHasContent(false);
        }
        return info;
    }

    private void setRelaionshipsToObjectInfo(ObjectData object, ObjectInfoImpl info) {
        List relationships;
        info.setRelationshipSourceIds(null);
        info.setRelationshipTargetIds(null);
        IncludeRelationships includeRelationships = this.getRequestParameterIncludeRelationships();
        if (includeRelationships != IncludeRelationships.NONE && (relationships = object.getRelationships()) != null && relationships.size() > 0) {
            ArrayList<String> sourceIds = new ArrayList<String>();
            ArrayList<String> targetIds = new ArrayList<String>();
            for (ObjectData relationship : relationships) {
                String sourceId = this.getIdProperty(relationship, "cmis:sourceId");
                String targetId = this.getIdProperty(relationship, "cmis:targetId");
                if (object.getId().equals(sourceId)) {
                    sourceIds.add(relationship.getId());
                }
                if (!object.getId().equals(targetId)) continue;
                targetIds.add(relationship.getId());
            }
            if (sourceIds.size() > 0 && (includeRelationships == IncludeRelationships.SOURCE || includeRelationships == IncludeRelationships.BOTH)) {
                info.setRelationshipSourceIds(sourceIds);
            }
            if (targetIds.size() > 0 && (includeRelationships == IncludeRelationships.TARGET || includeRelationships == IncludeRelationships.BOTH)) {
                info.setRelationshipTargetIds(targetIds);
            }
        }
    }

    protected void checkRepositoryId(String repositoryId) {
        if (!this.connector.getRepositoryId().equals(repositoryId)) {
            throw new CmisObjectNotFoundException("Unknown repository '" + repositoryId + "'!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getEncoding(InputStream inputStream, String mimeType) {
        String string;
        String defaultEncoding = "UTF-8";
        if (inputStream == null) {
            return defaultEncoding;
        }
        BufferedInputStream tfis = null;
        try {
            tfis = new BufferedInputStream(inputStream);
            ContentCharsetFinder charsetFinder = this.connector.getMimetypeService().getContentCharsetFinder();
            string = charsetFinder.getCharset((InputStream)tfis, mimeType).name();
            if (tfis == null) return string;
        }
        catch (Exception e) {
            try {
                throw new CmisStorageException("Unable to read content: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (tfis == null) throw throwable;
                try {
                    ((InputStream)tfis).close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            ((InputStream)tfis).close();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    @Override
    public void beforeCall() {
        AuthenticationUtil.pushAuthentication();
        if (this.authentication != null) {
            AuthenticationUtil.setFullAuthentication((Authentication)this.authentication);
        } else {
            CallContext context = this.getContext();
            if (context == null) {
                return;
            }
            if (this.connector.openHttpSession()) {
                ((HttpServletRequest)context.get("httpServletRequest")).getSession();
            }
            if (this.authentication != null) {
                AuthenticationUtil.setFullAuthentication((Authentication)this.authentication);
            } else {
                if (AuthenticationUtil.getFullyAuthenticatedUser() == null) {
                    String password;
                    String user = context.getUsername();
                    Authorization auth = new Authorization(user, password = context.getPassword());
                    if (auth.isTicket()) {
                        this.connector.getAuthenticationService().validate(auth.getTicket());
                    } else {
                        this.connector.getAuthenticationService().authenticate(auth.getUserName(), auth.getPasswordCharArray());
                    }
                }
                this.authentication = AuthenticationUtil.getFullAuthentication();
            }
        }
    }

    @Override
    public void afterCall() {
        AuthenticationUtil.popAuthentication();
    }

    private class BulkEntry {
        private String repositoryId;
        private BulkUpdateContext bulkUpdateContext;
        private BulkUpdateObjectIdAndChangeToken objectIdAndChangeToken;
        private Properties properties;
        private List<String> addSecondaryTypeIds;
        private List<String> removeSecondaryTypeIds;
        private boolean isObjectInfoRequired;

        BulkEntry(BulkUpdateContext bulkUpdateContext, BulkUpdateObjectIdAndChangeToken objectIdAndChangeToken, Properties properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, boolean isObjectInfoRequired) {
            this.bulkUpdateContext = bulkUpdateContext;
            this.objectIdAndChangeToken = objectIdAndChangeToken;
            this.properties = properties;
            this.addSecondaryTypeIds = addSecondaryTypeIds;
            this.removeSecondaryTypeIds = removeSecondaryTypeIds;
            this.isObjectInfoRequired = isObjectInfoRequired;
        }

        public void update() {
            String objectId = this.objectIdAndChangeToken.getId();
            CMISNodeInfo info = AlfrescoCmisServiceImpl.this.getOrCreateNodeInfo(objectId, "Object");
            if (!info.isVariant(CMISObjectVariant.ASSOC) && !info.isVariant(CMISObjectVariant.VERSION)) {
                NodeRef nodeRef = info.getNodeRef();
                AlfrescoCmisServiceImpl.this.connector.setProperties(nodeRef, info.getType(), this.properties, new String[0]);
                if (this.isObjectInfoRequired) {
                    AlfrescoCmisServiceImpl.this.getObjectInfo(this.repositoryId, objectId, "*", IncludeRelationships.NONE);
                }
                AlfrescoCmisServiceImpl.this.connector.addSecondaryTypes(nodeRef, this.addSecondaryTypeIds);
                AlfrescoCmisServiceImpl.this.connector.removeSecondaryTypes(nodeRef, this.removeSecondaryTypeIds);
                if (this.properties.getProperties().size() > 0 || this.addSecondaryTypeIds.size() > 0 || this.removeSecondaryTypeIds.size() > 0) {
                    this.bulkUpdateContext.success(info);
                }
            }
        }

        public BulkUpdateObjectIdAndChangeToken getObjectIdAndChangeToken() {
            return this.objectIdAndChangeToken;
        }
    }

    private static class BulkUpdateContext {
        private Set<CMISNodeInfo> successes = Collections.newSetFromMap(new ConcurrentHashMap());

        BulkUpdateContext(int size) {
        }

        void success(CMISNodeInfo info) {
            this.successes.add(info);
        }

        Set<CMISNodeInfo> getSuccesses() {
            return this.successes;
        }

        List<BulkUpdateObjectIdAndChangeToken> getChanges() {
            ArrayList<BulkUpdateObjectIdAndChangeToken> changes = new ArrayList<BulkUpdateObjectIdAndChangeToken>(this.successes.size());
            for (CMISNodeInfo info : this.successes) {
                BulkUpdateObjectIdAndChangeTokenImpl a = new BulkUpdateObjectIdAndChangeTokenImpl();
                a.setId(info.getObjectId());
                changes.add((BulkUpdateObjectIdAndChangeToken)a);
            }
            return changes;
        }
    }
}

