/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteService;
import org.springframework.extensions.surf.util.I18NUtil;

public class AddSurfConfigFoldersPatch
extends AbstractPatch {
    private static final String MSG_START = "patch.addSurfConfigFolders.start";
    private static final String MSG_RESULT = "patch.addSurfConfigFolders.result";
    private static final String MSG_EXIST = "patch.addSurfConfigFolders.exist";
    private static final String MSG_MISSING_SURFCONFIG = "patch.addSurfConfigFolders.missingSurfConfig";
    private SiteService siteService;
    private FileFolderService fileFolderService;
    private PermissionService permissionService;
    private AuthorityService authorityService;
    private HiddenAspect hiddenAspect;
    private List<FolderDetails> folderDetailsList;

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.hiddenAspect = hiddenAspect;
    }

    public void setFolderDetailsList(List<FolderDetails> folderDetailsList) {
        this.folderDetailsList = folderDetailsList;
    }

    @Override
    protected String applyInternal() throws Exception {
        StringBuilder result = new StringBuilder(I18NUtil.getMessage((String)MSG_START));
        NodeRef siteRoot = this.siteService.getSiteRoot();
        NodeRef surfConfigNodeRef = this.nodeService.getChildByName(siteRoot, ContentModel.ASSOC_CONTAINS, "surf-config");
        if (surfConfigNodeRef == null) {
            result.append(I18NUtil.getMessage((String)MSG_MISSING_SURFCONFIG));
            return result.toString();
        }
        LinkedHashMap<String, Boolean> createdFolders = new LinkedHashMap<String, Boolean>();
        LinkedHashMap<String, Boolean> skippedFolders = new LinkedHashMap<String, Boolean>();
        for (FolderDetails fd : this.folderDetailsList) {
            boolean appliedPermission = false;
            NodeRef childFolder = this.nodeService.getChildByName(surfConfigNodeRef, ContentModel.ASSOC_CONTAINS, fd.folderName);
            if (childFolder == null) {
                childFolder = this.fileFolderService.create(surfConfigNodeRef, fd.folderName, ContentModel.TYPE_FOLDER).getNodeRef();
                this.hiddenAspect.hideNode(childFolder, false, false, false);
                appliedPermission = this.setPermission(childFolder, fd);
                createdFolders.put(fd.folderName, appliedPermission);
                continue;
            }
            if (fd.applyPermissionIfFolderExist) {
                appliedPermission = this.setPermission(childFolder, fd);
            }
            skippedFolders.put(fd.folderName, appliedPermission);
        }
        if (createdFolders.size() > 0) {
            result.append(I18NUtil.getMessage((String)MSG_RESULT, (Object[])new Object[]{this.toString(createdFolders, false), this.toString(createdFolders, true)}));
        }
        if (skippedFolders.size() > 0) {
            result.append(I18NUtil.getMessage((String)MSG_EXIST, (Object[])new Object[]{this.toString(skippedFolders, false), this.toString(skippedFolders, true)}));
        }
        return result.toString();
    }

    private boolean setPermission(NodeRef nodeRef, FolderDetails details) {
        if (details.authority != null && details.permission != null) {
            if (this.authorityService.getAuthorityNodeRef(details.authority) == null) {
                throw new PatchException("The [" + details.authority + "] is not a valid authority name");
            }
            this.permissionService.setPermission(nodeRef, details.authority, details.permission, true);
            return true;
        }
        return false;
    }

    private String toString(Map<String, Boolean> map, boolean onlyAppliedPermission) {
        StringBuilder sb = new StringBuilder(map.size() * 2);
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            if (onlyAppliedPermission) {
                if (!entry.getValue().booleanValue()) continue;
                sb.append(entry.getKey()).append(", ");
                continue;
            }
            sb.append(entry.getKey()).append(", ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    public static class FolderDetails {
        private String folderName;
        private String authority;
        private String permission;
        private boolean applyPermissionIfFolderExist;

        public void setFolderName(String folderName) {
            this.folderName = folderName;
        }

        public void setAuthority(String authority) {
            this.authority = authority;
        }

        public void setPermission(String permission) {
            this.permission = permission;
        }

        public void setApplyPermissionIfFolderExist(boolean applyPermissionIfFolderExist) {
            this.applyPermissionIfFolderExist = applyPermissionIfFolderExist;
        }
    }
}

