/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.util.List;
import org.alfresco.repo.security.authority.AbstractAuthorityBridgeDAO;
import org.alfresco.repo.security.authority.AuthorityBridgeLink;
import org.alfresco.repo.security.authority.AuthorityBridgeParametersEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mybatis.spring.SqlSessionTemplate;

public class AuthorityBridgeDAOImpl
extends AbstractAuthorityBridgeDAO {
    private static final String QUERY_SELECT_GET_AUTHORITY_BRIDGE_ENTRIES = "alfresco.query.authorities.select_GetAuthorityBridgeEntries";
    private static final String QUERY_SELECT_GET_DIRECT_AUTHORITIES_FOR_UESR = "alfresco.query.authorities.select_GetDirectAuthoritiesForUser";
    private Log logger = LogFactory.getLog(this.getClass());
    private SqlSessionTemplate template;

    public void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    @Override
    protected List<AuthorityBridgeLink> selectAuthorityBridgeLinks(Long authorityContainerTypeQNameId, Long memberAssocQNameId, Long authorityNameQNameId, Long storeId) {
        Long start = this.logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        AuthorityBridgeParametersEntity authorityBridgeParametersEntity = new AuthorityBridgeParametersEntity(authorityContainerTypeQNameId, memberAssocQNameId, authorityNameQNameId, storeId);
        List links = this.template.selectList(QUERY_SELECT_GET_AUTHORITY_BRIDGE_ENTRIES, (Object)authorityBridgeParametersEntity);
        if (start != null) {
            this.logger.debug((Object)("Authority bridge query: " + links.size() + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return links;
    }

    @Override
    protected List<AuthorityBridgeLink> selectDirectAuthoritiesForUser(Long authorityContainerTypeQNameId, Long memberAssocQNameId, Long authorityNameQNameId, Long storeId, Long nodeId) {
        Long start = this.logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        AuthorityBridgeParametersEntity authorityBridgeParametersEntity = new AuthorityBridgeParametersEntity(authorityContainerTypeQNameId, memberAssocQNameId, authorityNameQNameId, storeId, nodeId);
        List links = this.template.selectList(QUERY_SELECT_GET_DIRECT_AUTHORITIES_FOR_UESR, (Object)authorityBridgeParametersEntity);
        if (start != null) {
            this.logger.debug((Object)("Direct authority: " + links.size() + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return links;
    }
}

