/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.template;

import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.VirtualizationException;
import org.alfresco.repo.virtual.template.VirtualQuery;
import org.alfresco.repo.virtual.template.VirtualQueryConstraint;
import org.alfresco.repo.virtual.template.VirtualQueryConstraintDecorator;
import org.alfresco.service.cmr.search.SearchParameters;

public class FilesFoldersConstraint
extends VirtualQueryConstraintDecorator {
    private boolean files;
    private boolean folders;

    public FilesFoldersConstraint(VirtualQueryConstraint decoratedConstraint, boolean files, boolean folders) {
        super(decoratedConstraint);
        this.files = files;
        this.folders = folders;
    }

    @Override
    protected SearchParameters applyDecorations(ActualEnvironment environment, SearchParameters searchParameters, VirtualQuery query) {
        String queryString = searchParameters.getQuery();
        String language = searchParameters.getLanguage();
        String filteredQuery = this.filter(language, queryString, this.files, this.folders);
        SearchParameters searchParametersCopy = searchParameters.copy();
        searchParametersCopy.setQuery(filteredQuery);
        return searchParametersCopy;
    }

    private String filter(String language, String query, boolean files, boolean folders) throws VirtualizationException {
        Object filteredQuery = query;
        if (files ^ folders) {
            if ("fts-alfresco".equals(language)) {
                filteredQuery = !files ? "(" + (String)filteredQuery + ") and TYPE:\"cm:folder\"" : "(" + (String)filteredQuery + ") and TYPE:\"cm:content\"";
            } else {
                throw new VirtualizationException("Disjunctive file-folder filters are only supported on fts-alfresco virtual query language.");
            }
        }
        return filteredQuery;
    }
}

