/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.ExternalResource;

public class WellKnownNodes
extends ExternalResource {
    private static final Log log = LogFactory.getLog(WellKnownNodes.class);
    private final ApplicationContextInit appContextRule;
    private final Repository repositoryHelper;
    private final NodeService nodeService;
    private static QName SYSTEM_FOLDER_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"system");

    public WellKnownNodes(ApplicationContextInit appContextRule) {
        this.appContextRule = appContextRule;
        this.repositoryHelper = (Repository)appContextRule.getApplicationContext().getBean("repositoryHelper");
        this.nodeService = (NodeService)appContextRule.getApplicationContext().getBean("NodeService");
    }

    protected void before() throws Throwable {
    }

    protected void after() {
    }

    public NodeRef getWorkspaceRoot() {
        return this.repositoryHelper.getRootHome();
    }

    public NodeRef getCompanyHome() {
        return this.repositoryHelper.getCompanyHome();
    }

    public NodeRef getSystemRoot() {
        NodeRef root = this.getWorkspaceRoot();
        List sysRefs = this.nodeService.getChildAssocs(root, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)SYSTEM_FOLDER_QNAME);
        if (sysRefs.size() != 1) {
            throw new IllegalStateException("System folder missing / duplicated! Found " + String.valueOf(sysRefs));
        }
        NodeRef system = ((ChildAssociationRef)sysRefs.get(0)).getChildRef();
        return system;
    }

    public NodeRef getSystemContainer(QName containerName) {
        NodeRef system = this.getSystemRoot();
        List containerRefs = this.nodeService.getChildAssocs(system, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)containerName);
        if (containerRefs.size() != 1) {
            throw new IllegalStateException("System Container " + String.valueOf(containerName) + " missing / duplicated! Found " + String.valueOf(containerRefs));
        }
        NodeRef container = ((ChildAssociationRef)containerRefs.get(0)).getChildRef();
        return container;
    }
}

