/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.test.exportdb;

import org.alfresco.util.schemacomp.ExportDb;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class AbstractExportTester {
    protected ExportDb exporter;
    protected PlatformTransactionManager tx;
    protected JdbcTemplate jdbcTemplate;
    private static final Log log = LogFactory.getLog(AbstractExportTester.class);

    public AbstractExportTester(ExportDb exporter, PlatformTransactionManager tx, JdbcTemplate jdbcTemplate) {
        this.exporter = exporter;
        this.tx = tx;
        this.jdbcTemplate = jdbcTemplate;
    }

    protected abstract void doExportTest() throws Exception;

    protected abstract void doDatabaseSetup();

    public void runExportTest() throws Exception {
        this.doDatabaseSetup();
        this.exporter.execute();
        this.dumpSchema();
        this.commonPostExportChecks();
        this.doExportTest();
    }

    protected void commonPostExportChecks() {
        Schema schema = this.getSchema();
        Assert.assertNull((String)"Schema shouldn't have a parent", (Object)this.getSchema().getParent());
        this.checkResultsFiltered(schema, "export_test_");
    }

    public Schema getSchema() {
        return this.exporter.getSchema();
    }

    protected void checkResultsFiltered(Schema schema, String prefix) {
        for (DbObject dbo : schema) {
            if (dbo.getName().startsWith(prefix)) continue;
            Assert.fail((String)("Database object's name does not start with '" + prefix + "': " + String.valueOf(dbo)));
        }
    }

    private void dumpSchema() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Iterating through Schema objects:");
        }
        int i = 0;
        for (DbObject dbo : this.getSchema()) {
            ++i;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("    " + String.valueOf(dbo)));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Schema object contains " + i + " objects."));
        }
    }
}

