/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import org.alfresco.service.cmr.transfer.TransferVersion;
import org.alfresco.service.descriptor.Descriptor;

public class TransferVersionImpl
implements TransferVersion {
    private String versionMajor;
    private String versionMinor;
    private String versionRevision;
    private String edition;

    public TransferVersionImpl(String versionMajor, String versionMinor, String versionRevision, String edition) {
        this.versionMajor = versionMajor;
        this.versionMinor = versionMinor;
        this.versionRevision = versionRevision;
        this.edition = edition;
    }

    public TransferVersionImpl(Descriptor d) {
        this.versionMajor = d.getVersionMajor();
        this.versionMinor = d.getVersionMinor();
        this.versionRevision = d.getVersionRevision();
        this.edition = d.getEdition();
    }

    @Override
    public String getVersionMajor() {
        return this.versionMajor;
    }

    @Override
    public String getVersionMinor() {
        return this.versionMinor;
    }

    @Override
    public String getVersionRevision() {
        return this.versionRevision;
    }

    @Override
    public String getEdition() {
        return this.edition;
    }

    public String toString() {
        StringBuilder version = new StringBuilder();
        version.append(this.getEdition());
        version.append(".");
        version.append(this.getVersionMajor());
        version.append(".");
        version.append(this.getVersionMinor());
        version.append(".");
        version.append(this.getVersionRevision());
        return version.toString();
    }

    public int hashCode() {
        if (this.edition != null && this.versionMinor != null) {
            return this.edition.hashCode() + this.versionMinor.hashCode() * 37;
        }
        return 1;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof TransferVersion) {
            TransferVersion v = (TransferVersion)other;
            if (!this.edition.equalsIgnoreCase(v.getEdition())) {
                return false;
            }
            if (!this.versionMajor.equalsIgnoreCase(v.getVersionMajor())) {
                return false;
            }
            if (!this.versionMinor.equalsIgnoreCase(v.getVersionMinor())) {
                return false;
            }
            if (!this.versionRevision.equalsIgnoreCase(v.getVersionRevision())) {
                return false;
            }
        }
        return true;
    }
}

