/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.workflow.PackageManager;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TaskUpdater {
    private static final Log LOGGER = LogFactory.getLog(TaskUpdater.class);
    private final String taskId;
    private final WorkflowService workflowService;
    private final PackageManager packageMgr;
    private final Map<QName, Serializable> properties = new HashMap<QName, Serializable>();
    private final Map<QName, List<NodeRef>> add = new HashMap<QName, List<NodeRef>>();
    private final Map<QName, List<NodeRef>> remove = new HashMap<QName, List<NodeRef>>();

    public TaskUpdater(String taskId, WorkflowService workflowService, NodeService nodeService, BehaviourFilter behaviourFilter) {
        this.taskId = taskId;
        this.workflowService = workflowService;
        this.packageMgr = new PackageManager(workflowService, nodeService, behaviourFilter, LOGGER);
    }

    public void addProperty(QName name, Serializable value) {
        this.properties.put(name, value);
    }

    public void addAssociation(QName name, List<NodeRef> value) {
        this.add.put(name, value);
    }

    public void removeAssociation(QName name, List<NodeRef> value) {
        this.remove.put(name, value);
    }

    public boolean changeAssociation(QName name, String nodeRefs, boolean isAdd) {
        List value = NodeRef.getNodeRefs((String)nodeRefs, (Log)LOGGER);
        if (value == null) {
            return false;
        }
        Map<QName, List<NodeRef>> map = this.getAssociationMap(isAdd);
        if (map != null) {
            map.put(name, value);
            return true;
        }
        return false;
    }

    private Map<QName, List<NodeRef>> getAssociationMap(boolean isAdd) {
        Map<QName, List<NodeRef>> map = null;
        map = isAdd ? this.add : this.remove;
        return map;
    }

    public void addPackageItems(List<NodeRef> items) {
        this.packageMgr.addItems(items);
    }

    public void removePackageItems(List<NodeRef> items) {
        this.packageMgr.removeItems(items);
    }

    public WorkflowTask transition() {
        return this.transition(null);
    }

    public WorkflowTask transition(String transitionId) {
        this.update();
        return this.workflowService.endTask(this.taskId, transitionId);
    }

    public WorkflowTask update() {
        WorkflowTask task = this.workflowService.getTaskById(this.taskId);
        NodeRef packageNode = task.getPath().getInstance().getWorkflowPackage();
        this.packageMgr.update(packageNode);
        WorkflowTask result = this.workflowService.updateTask(this.taskId, this.properties, this.add, this.remove);
        this.properties.clear();
        this.add.clear();
        this.remove.clear();
        return result;
    }
}

