/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2.shared;

import java.util.HashSet;
import java.util.Set;
import org.alfresco.service.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QNameMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(QNameMatcher.class);
    private static final String WILDCARD = "*";
    private final Set<QName> matchingTypes = new HashSet<QName>();
    private final Set<String> matchingNamespaceURIs = new HashSet<String>();

    public QNameMatcher(Set<QName> qNamesToMatch) {
        qNamesToMatch.forEach(qName -> {
            if (WILDCARD.equals(qName.getLocalName())) {
                this.matchingNamespaceURIs.add(qName.getNamespaceURI());
            } else {
                this.matchingTypes.add((QName)qName);
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Matching namespace URIs:" + String.valueOf(this.matchingNamespaceURIs));
            LOGGER.debug("Matching types:" + String.valueOf(this.matchingTypes));
        }
    }

    public boolean isMatching(QName qName) {
        if (qName != null) {
            return this.matchingTypes.contains(qName) || this.matchingNamespaceURIs.contains(qName.getNamespaceURI());
        }
        return false;
    }
}

