/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock.mem;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.alfresco.repo.lock.mem.LockState;
import org.alfresco.repo.lock.mem.LockStore;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ParameterCheck;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractLockStore<T extends ConcurrentMap<NodeRef, LockState>>
implements LockStore {
    protected T map;

    public AbstractLockStore(T map) {
        this.map = map;
    }

    @Override
    public LockState get(NodeRef nodeRef) {
        LockState lockState;
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        Map<NodeRef, LockState> txMap = this.getTxMap();
        if (txMap != null && txMap.containsKey(nodeRef)) {
            lockState = txMap.get(nodeRef);
        } else {
            lockState = (LockState)this.map.get(nodeRef);
            if (txMap != null) {
                txMap.put(nodeRef, lockState);
            }
        }
        return lockState;
    }

    @Override
    public void set(NodeRef nodeRef, LockState lockState) {
        Map<NodeRef, LockState> txMap = this.getTxMap();
        LockState previousLockState = null;
        previousLockState = txMap != null ? (txMap.containsKey(nodeRef) ? txMap.get(nodeRef) : this.get(nodeRef)) : this.get(nodeRef);
        boolean updated = false;
        if (previousLockState != null) {
            updated = this.map.replace((NodeRef)nodeRef, (LockState)previousLockState, (LockState)lockState);
        } else if (this.map.putIfAbsent((NodeRef)nodeRef, (LockState)lockState) == null) {
            updated = true;
        }
        if (!updated) {
            String msg = String.format("Attempt to update lock state failed, old=%s, new=%s, noderef=%s", previousLockState, lockState, nodeRef);
            throw new ConcurrencyFailureException(msg);
        }
        if (txMap != null) {
            txMap.put(nodeRef, lockState);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        Map<NodeRef, LockState> txMap = this.getTxMap();
        if (txMap != null) {
            txMap.clear();
        }
    }

    protected Map<NodeRef, LockState> getTxMap() {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            return null;
        }
        Map<NodeRef, LockState> map = TransactionalResourceHelper.getMap(this.getClass().getName() + ".repeatableReadMap");
        return map;
    }

    @Override
    public Set<NodeRef> getNodes() {
        return this.map.keySet();
    }
}

