/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.JoinType;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderJoinCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderJoinCommandType;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommandType;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class TypeSupport
implements DBQueryBuilderComponent {
    List<Long> qnameIds = new ArrayList<Long>();
    DBQueryBuilderPredicatePartCommandType commandType;
    private JoinType joinType = JoinType.NONE;

    public void setQnameIds(List<Long> qnameIds) {
        this.qnameIds = qnameIds;
    }

    public void setCommandType(DBQueryBuilderPredicatePartCommandType commandType) {
        this.commandType = commandType;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public void prepare(NamespaceService namespaceService, DictionaryService dictionaryService, QNameDAO qnameDAO, NodeDAO nodeDAO, TenantService tenantService, Set<String> selectors, Map<String, Argument> functionArgs, FunctionEvaluationContext functionContext, boolean supportBooleanFloatAndDouble) {
    }

    @Override
    public void buildJoins(Map<QName, DBQueryBuilderJoinCommand> singleJoins, List<DBQueryBuilderJoinCommand> multiJoins) {
    }

    @Override
    public void buildPredicateCommands(List<DBQueryBuilderPredicatePartCommand> predicatePartCommands) {
        switch (this.joinType) {
            case LEFT: 
            case RIGHT: {
                DBQueryBuilderPredicatePartCommand command = new DBQueryBuilderPredicatePartCommand();
                command.setJoinCommandType(DBQueryBuilderJoinCommandType.NODE);
                command.setType(DBQueryBuilderPredicatePartCommandType.NP_MATCHES);
                predicatePartCommands.add(command);
                break;
            }
            default: {
                DBQueryBuilderPredicatePartCommand command = new DBQueryBuilderPredicatePartCommand();
                command.setJoinCommandType(DBQueryBuilderJoinCommandType.NODE);
                command.setAlias("node");
                command.setFieldName("type_qname_id");
                command.setType(this.commandType);
                if (this.qnameIds.size() > 0) {
                    command.setValues(this.qnameIds.toArray(new Long[0]));
                } else {
                    command.setValues(new Long[]{-1L});
                }
                predicatePartCommands.add(command);
            }
        }
    }

    public void setJoinType(JoinType joinType) {
        this.joinType = joinType;
    }
}

