/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import org.alfresco.repo.domain.dialect.Dialect;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;

public abstract class DialectUtil {
    public static final String PLACEHOLDER_DIALECT = "\\$\\{db\\.script\\.dialect\\}";

    public static Resource getDialectResource(ResourcePatternResolver resourcePatternResolver, Class<?> dialectClass, String resourceUrl) {
        String dialectResourceUrl = DialectUtil.resolveDialectUrl(dialectClass, resourceUrl);
        Resource resource = resourcePatternResolver.getResource(dialectResourceUrl);
        if (!resource.exists()) {
            Class<?> superClass = dialectClass.getSuperclass();
            if (Dialect.class.isAssignableFrom(superClass)) {
                return DialectUtil.getDialectResource(resourcePatternResolver, superClass, resourceUrl);
            }
            return null;
        }
        return resource;
    }

    public static String resolveDialectUrl(Class<?> dialectClass, String resourceUrl) {
        return resourceUrl.replaceAll(PLACEHOLDER_DIALECT, dialectClass.getName());
    }
}

