/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server;

import com.sun.mail.smtp.SMTPMessage;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;
import org.alfresco.email.server.EmailServiceImpl;
import org.alfresco.email.server.handler.FolderEmailMessageHandler;
import org.alfresco.email.server.impl.subetha.SubethaEmailMessage;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.service.cmr.email.EmailDelivery;
import org.alfresco.service.cmr.email.EmailMessage;
import org.alfresco.service.cmr.email.EmailMessageException;
import org.alfresco.service.cmr.email.EmailService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class EmailServiceImplTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private static Log logger = LogFactory.getLog(EmailServiceImplTest.class);
    private NodeService nodeService;
    private EmailService emailService;
    private PersonService personService;
    private AuthorityService authorityService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private FolderEmailMessageHandler folderEmailMessageHandler;
    private RetryingTransactionHelper transactionHelper;
    String TEST_USER = "EmailServiceImplTestUser";

    public void setUp() throws Exception {
        AuthenticationUtil.setRunAsUserSystem();
        this.nodeService = (NodeService)ctx.getBean("NodeService");
        EmailServiceImplTest.assertNotNull((String)"nodeService", (Object)this.nodeService);
        this.authorityService = (AuthorityService)ctx.getBean("AuthorityService");
        EmailServiceImplTest.assertNotNull((String)"authorityService", (Object)this.authorityService);
        ChildApplicationContextFactory emailSubsystem = (ChildApplicationContextFactory)ctx.getBean("InboundSMTP");
        EmailServiceImplTest.assertNotNull((String)"emailSubsystem", (Object)emailSubsystem);
        ApplicationContext emailCtx = emailSubsystem.getApplicationContext();
        this.emailService = (EmailService)emailCtx.getBean("emailService");
        EmailServiceImplTest.assertNotNull((String)"emailService", (Object)this.emailService);
        this.personService = (PersonService)emailCtx.getBean("PersonService");
        EmailServiceImplTest.assertNotNull((String)"personService", (Object)this.personService);
        this.namespaceService = (NamespaceService)emailCtx.getBean("NamespaceService");
        EmailServiceImplTest.assertNotNull((String)"namespaceService", (Object)this.namespaceService);
        this.searchService = (SearchService)emailCtx.getBean("SearchService");
        EmailServiceImplTest.assertNotNull((String)"searchService", (Object)this.searchService);
        this.folderEmailMessageHandler = (FolderEmailMessageHandler)emailCtx.getBean("folderEmailMessageHandler");
        EmailServiceImplTest.assertNotNull((String)"folderEmailMessageHandler", (Object)this.folderEmailMessageHandler);
        this.transactionHelper = (RetryingTransactionHelper)emailCtx.getBean("retryingTransactionHelper");
        EmailServiceImplTest.assertNotNull((String)"transactionHelper", (Object)this.transactionHelper);
    }

    public void tearDown() throws Exception {
        AuthenticationUtil.setRunAsUserSystem();
        try {
            this.personService.deletePerson(this.TEST_USER);
        }
        catch (Exception exception) {}
    }

    public void testFromName() throws Exception {
        EmailDelivery delivery;
        SubethaEmailMessage m;
        InputStream is;
        ByteArrayOutputStream bos;
        InternetAddress[] toa;
        SMTPMessage msg;
        Session sess;
        String content;
        Object to;
        Object from;
        this.folderEmailMessageHandler.setOverwriteDuplicates(true);
        logger.debug((Object)"Start testFromName");
        String TEST_EMAIL = "buffy@sunnydale.high";
        NodeRef person = this.personService.getPerson(this.TEST_USER);
        if (person == null) {
            logger.debug((Object)"new person created");
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(ContentModel.PROP_USERNAME, this.TEST_USER);
            props.put(ContentModel.PROP_EMAIL, TEST_EMAIL);
            person = this.personService.createPerson(props);
        }
        this.nodeService.setProperty(person, ContentModel.PROP_EMAIL, (Serializable)((Object)TEST_EMAIL));
        Set auths = this.authorityService.getContainedAuthorities(null, "GROUP_EMAIL_CONTRIBUTORS", true);
        if (!auths.contains(this.TEST_USER)) {
            this.authorityService.addAuthority("GROUP_EMAIL_CONTRIBUTORS", this.TEST_USER);
        }
        String companyHomePathInStore = "/app:company_home";
        String storePath = "workspace://SpacesStore";
        StoreRef storeRef = new StoreRef(storePath);
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, companyHomePathInStore, null, (NamespacePrefixResolver)this.namespaceService, false);
        NodeRef companyHomeNodeRef = (NodeRef)nodeRefs.get(0);
        EmailServiceImplTest.assertNotNull((String)"company home is null", (Object)companyHomeNodeRef);
        String cfr_ignored_0 = ((Long)this.nodeService.getProperty(companyHomeNodeRef, ContentModel.PROP_NODE_DBID)).toString() + "@Alfresco.com";
        String cfr_ignored_1 = ((Long)this.nodeService.getProperty(person, ContentModel.PROP_NODE_DBID)).toString() + "@Alfresco.com";
        NodeRef testUserHomeFolder = (NodeRef)this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER);
        EmailServiceImplTest.assertNotNull((String)"testUserHomeFolder is null", (Object)testUserHomeFolder);
        String testUserHomeDBID = ((Long)this.nodeService.getProperty(testUserHomeFolder, ContentModel.PROP_NODE_DBID)).toString() + "@Alfresco.com";
        try {
            from = "admin";
            to = "bertie";
            content = "hello world";
            sess = Session.getDefaultInstance((Properties)new Properties());
            EmailServiceImplTest.assertNotNull((String)"sess is null", (Object)sess);
            msg = new SMTPMessage(sess);
            toa = new InternetAddress[]{new InternetAddress((String)to)};
            msg.setFrom((Address)new InternetAddress("Bert"));
            msg.setRecipients(Message.RecipientType.TO, (Address[])toa);
            msg.setSubject("JavaMail APIs transport.java Test");
            msg.setContent((Object)content, "text/plain");
            new StringBuffer();
            bos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)bos);
            is = IOUtils.toInputStream((String)bos.toString());
            EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
            m = new SubethaEmailMessage(is);
            delivery = new EmailDelivery((String)to, (String)from, null);
            this.emailService.importMessage(delivery, (EmailMessage)m);
            EmailServiceImplTest.fail((String)"anonymous user not rejected");
        }
        catch (EmailMessageException e) {
            EmailServiceImplTest.assertTrue((String)"Message is not for anonymous", (boolean)e.getMessage().contains("anonymous"));
        }
        logger.debug((Object)"Step 2");
        from = TEST_EMAIL;
        to = testUserHomeDBID;
        content = "hello world";
        sess = Session.getDefaultInstance((Properties)new Properties());
        EmailServiceImplTest.assertNotNull((String)"sess is null", (Object)sess);
        msg = new SMTPMessage(sess);
        toa = new InternetAddress[]{new InternetAddress((String)to)};
        msg.setFrom((Address)new InternetAddress(TEST_EMAIL));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toa);
        msg.setSubject("JavaMail APIs transport.java Test");
        msg.setContent((Object)content, "text/plain");
        new StringBuffer();
        bos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos);
        is = IOUtils.toInputStream((String)bos.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        m = new SubethaEmailMessage(is);
        delivery = new EmailDelivery((String)to, (String)from, null);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        logger.debug((Object)"Step 3");
        from = " \"Joe Bloggs\" <" + TEST_EMAIL + ">";
        to = testUserHomeDBID;
        content = "hello world";
        sess = Session.getDefaultInstance((Properties)new Properties());
        EmailServiceImplTest.assertNotNull((String)"sess is null", (Object)sess);
        msg = new SMTPMessage(sess);
        toa = new InternetAddress[]{new InternetAddress((String)to)};
        msg.setFrom((Address)new InternetAddress((String)from));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toa);
        msg.setSubject("JavaMail APIs transport.java Test");
        msg.setContent((Object)content, "text/plain");
        new StringBuffer();
        bos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)System.out);
        msg.writeTo((OutputStream)bos);
        is = IOUtils.toInputStream((String)bos.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        m = new SubethaEmailMessage(is);
        delivery = new EmailDelivery((String)to, "dummy", null);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        logger.debug((Object)"Step 4");
        from = " \"Joe Bloggs\" <" + TEST_EMAIL + ">";
        to = testUserHomeDBID;
        content = "hello world";
        sess = Session.getDefaultInstance((Properties)new Properties());
        EmailServiceImplTest.assertNotNull((String)"sess is null", (Object)sess);
        msg = new SMTPMessage(sess);
        toa = new InternetAddress[]{new InternetAddress((String)to)};
        msg.setFrom((Address)new InternetAddress((String)from));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toa);
        msg.setSubject("JavaMail APIs transport.java Test");
        msg.setContent((Object)content, "text/plain");
        new StringBuffer();
        bos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)System.out);
        msg.writeTo((OutputStream)bos);
        is = IOUtils.toInputStream((String)bos.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        m = new SubethaEmailMessage(is);
        InternetAddress a = new InternetAddress((String)from);
        String x = a.getAddress();
        EmailDelivery delivery2 = new EmailDelivery((String)to, x, null);
        this.emailService.importMessage(delivery2, (EmailMessage)m);
    }

    public void testFolderSubject() throws Exception {
        logger.debug((Object)"Start testFromName");
        String TEST_EMAIL = "buffy@sunnydale.high";
        this.folderEmailMessageHandler.setOverwriteDuplicates(true);
        NodeRef person = this.personService.getPerson(this.TEST_USER);
        if (person == null) {
            logger.debug((Object)"new person created");
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(ContentModel.PROP_USERNAME, this.TEST_USER);
            props.put(ContentModel.PROP_EMAIL, TEST_EMAIL);
            person = this.personService.createPerson(props);
        }
        this.nodeService.setProperty(person, ContentModel.PROP_EMAIL, (Serializable)((Object)TEST_EMAIL));
        Set auths = this.authorityService.getContainedAuthorities(null, "GROUP_EMAIL_CONTRIBUTORS", true);
        if (!auths.contains(this.TEST_USER)) {
            this.authorityService.addAuthority("GROUP_EMAIL_CONTRIBUTORS", this.TEST_USER);
        }
        String companyHomePathInStore = "/app:company_home";
        String storePath = "workspace://SpacesStore";
        StoreRef storeRef = new StoreRef(storePath);
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, companyHomePathInStore, null, (NamespacePrefixResolver)this.namespaceService, false);
        NodeRef companyHomeNodeRef = (NodeRef)nodeRefs.get(0);
        EmailServiceImplTest.assertNotNull((String)"company home is null", (Object)companyHomeNodeRef);
        String cfr_ignored_0 = ((Long)this.nodeService.getProperty(companyHomeNodeRef, ContentModel.PROP_NODE_DBID)).toString() + "@Alfresco.com";
        String cfr_ignored_1 = ((Long)this.nodeService.getProperty(person, ContentModel.PROP_NODE_DBID)).toString() + "@Alfresco.com";
        NodeRef testUserHomeFolder = (NodeRef)this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER);
        EmailServiceImplTest.assertNotNull((String)"testUserHomeFolder is null", (Object)testUserHomeFolder);
        String testUserHomeDBID = ((Long)this.nodeService.getProperty(testUserHomeFolder, ContentModel.PROP_NODE_DBID)).toString() + "@Alfresco.com";
        String from = TEST_EMAIL;
        String to = testUserHomeDBID;
        String content = "hello world";
        Session sess = Session.getDefaultInstance((Properties)new Properties());
        EmailServiceImplTest.assertNotNull((String)"sess is null", (Object)sess);
        SMTPMessage msg = new SMTPMessage(sess);
        InternetAddress[] toa = new InternetAddress[]{new InternetAddress(to)};
        msg.setFrom((Address)new InternetAddress(TEST_EMAIL));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toa);
        msg.setSubject("This is a very very long name in particular it is greater than eitghty six characters which was a problem explored in ALF-9544");
        msg.setContent((Object)content, "text/plain");
        new StringBuffer();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos);
        InputStream is = IOUtils.toInputStream((String)bos.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        SubethaEmailMessage m = new SubethaEmailMessage(is);
        EmailDelivery delivery = new EmailDelivery(to, from, null);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        sess = Session.getDefaultInstance((Properties)new Properties());
        EmailServiceImplTest.assertNotNull((String)"sess is null", (Object)sess);
        msg = new SMTPMessage(sess);
        toa = new InternetAddress[]{new InternetAddress(to)};
        msg.setFrom((Address)new InternetAddress(TEST_EMAIL));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toa);
        msg.setSubject("Illegal<>!*/\\.txt");
        msg.setContent((Object)content, "text/plain");
        new StringBuffer();
        bos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos);
        is = IOUtils.toInputStream((String)bos.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        m = new SubethaEmailMessage(is);
        delivery = new EmailDelivery(to, from, null);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        sess = Session.getDefaultInstance((Properties)new Properties());
        EmailServiceImplTest.assertNotNull((String)"sess is null", (Object)sess);
        msg = new SMTPMessage(sess);
        toa = new InternetAddress[]{new InternetAddress(to)};
        msg.setFrom((Address)new InternetAddress(TEST_EMAIL));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toa);
        msg.setContent((Object)content, "text/plain");
        new StringBuffer();
        bos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos);
        is = IOUtils.toInputStream((String)bos.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        m = new SubethaEmailMessage(is);
        delivery = new EmailDelivery(to, from, null);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        sess = Session.getDefaultInstance((Properties)new Properties());
        EmailServiceImplTest.assertNotNull((String)"sess is null", (Object)sess);
        msg = new SMTPMessage(sess);
        toa = new InternetAddress[]{new InternetAddress(to)};
        msg.setFrom((Address)new InternetAddress(TEST_EMAIL));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toa);
        msg.setSubject("Foobar.");
        msg.setContent((Object)content, "text/plain");
        new StringBuffer();
        bos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos);
        is = IOUtils.toInputStream((String)bos.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        m = new SubethaEmailMessage(is);
        delivery = new EmailDelivery(to, from, null);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        sess = Session.getDefaultInstance((Properties)new Properties());
        EmailServiceImplTest.assertNotNull((String)"sess is null", (Object)sess);
        msg = new SMTPMessage(sess);
        toa = new InternetAddress[]{new InternetAddress(to)};
        msg.setFrom((Address)new InternetAddress(TEST_EMAIL));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toa);
        msg.setSubject("Foobar...");
        msg.setContent((Object)content, "text/plain");
        new StringBuffer();
        bos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos);
        is = IOUtils.toInputStream((String)bos.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        m = new SubethaEmailMessage(is);
        delivery = new EmailDelivery(to, from, null);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        sess = Session.getDefaultInstance((Properties)new Properties());
        EmailServiceImplTest.assertNotNull((String)"sess is null", (Object)sess);
        msg = new SMTPMessage(sess);
        toa = new InternetAddress[]{new InternetAddress(to)};
        msg.setFrom((Address)new InternetAddress(TEST_EMAIL));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toa);
        msg.setSubject(" ... ");
        msg.setContent((Object)content, "text/plain");
        new StringBuffer();
        bos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos);
        is = IOUtils.toInputStream((String)bos.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        m = new SubethaEmailMessage(is);
        delivery = new EmailDelivery(to, from, null);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        sess = Session.getDefaultInstance((Properties)new Properties());
        EmailServiceImplTest.assertNotNull((String)"sess is null", (Object)sess);
        msg = new SMTPMessage(sess);
        toa = new InternetAddress[]{new InternetAddress(to)};
        msg.setFrom((Address)new InternetAddress(TEST_EMAIL));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toa);
        msg.setSubject(".");
        msg.setContent((Object)content, "text/plain");
        new StringBuffer();
        bos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos);
        is = IOUtils.toInputStream((String)bos.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        m = new SubethaEmailMessage(is);
        delivery = new EmailDelivery(to, from, null);
        this.emailService.importMessage(delivery, (EmailMessage)m);
    }

    public void testMultipleMessagesToFolder() throws Exception {
        logger.debug((Object)"Start testFromName");
        String TEST_EMAIL = "buffy@sunnydale.high";
        String TEST_SUBJECT = "Practical Bee Keeping";
        String TEST_LONG_SUBJECT = "This is a very very long name in particular it is greater than eitghty six characters which was a problem explored in ALF-9544";
        NodeRef person = this.personService.getPerson(this.TEST_USER);
        if (person == null) {
            logger.debug((Object)"new person created");
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(ContentModel.PROP_USERNAME, this.TEST_USER);
            props.put(ContentModel.PROP_EMAIL, TEST_EMAIL);
            person = this.personService.createPerson(props);
        }
        this.nodeService.setProperty(person, ContentModel.PROP_EMAIL, (Serializable)((Object)TEST_EMAIL));
        Set auths = this.authorityService.getContainedAuthorities(null, "GROUP_EMAIL_CONTRIBUTORS", true);
        if (!auths.contains(this.TEST_USER)) {
            this.authorityService.addAuthority("GROUP_EMAIL_CONTRIBUTORS", this.TEST_USER);
        }
        String companyHomePathInStore = "/app:company_home";
        String storePath = "workspace://SpacesStore";
        StoreRef storeRef = new StoreRef(storePath);
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, companyHomePathInStore, null, (NamespacePrefixResolver)this.namespaceService, false);
        NodeRef companyHomeNodeRef = (NodeRef)nodeRefs.get(0);
        EmailServiceImplTest.assertNotNull((String)"company home is null", (Object)companyHomeNodeRef);
        String cfr_ignored_0 = ((Long)this.nodeService.getProperty(companyHomeNodeRef, ContentModel.PROP_NODE_DBID)).toString() + "@Alfresco.com";
        String cfr_ignored_1 = ((Long)this.nodeService.getProperty(person, ContentModel.PROP_NODE_DBID)).toString() + "@Alfresco.com";
        NodeRef testUserHomeFolder = (NodeRef)this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER);
        EmailServiceImplTest.assertNotNull((String)"testUserHomeFolder is null", (Object)testUserHomeFolder);
        String testUserHomeDBID = ((Long)this.nodeService.getProperty(testUserHomeFolder, ContentModel.PROP_NODE_DBID)).toString() + "@Alfresco.com";
        List assocs = this.nodeService.getChildAssocs(testUserHomeFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef assoc : assocs) {
            this.nodeService.deleteNode(assoc.getChildRef());
        }
        String from = TEST_EMAIL;
        String to = testUserHomeDBID;
        String content = "hello world";
        Session sess = Session.getDefaultInstance((Properties)new Properties());
        EmailServiceImplTest.assertNotNull((String)"sess is null", (Object)sess);
        SMTPMessage msg = new SMTPMessage(sess);
        InternetAddress[] toa = new InternetAddress[]{new InternetAddress(to)};
        msg.setFrom((Address)new InternetAddress(TEST_EMAIL));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toa);
        msg.setSubject(TEST_SUBJECT);
        msg.setContent((Object)content, "text/plain");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos);
        InputStream is = IOUtils.toInputStream((String)bos.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        SubethaEmailMessage m = new SubethaEmailMessage(is);
        logger.debug((Object)"Step 1: turn on Overwite Duplicates");
        this.folderEmailMessageHandler.setOverwriteDuplicates(true);
        EmailDelivery delivery = new EmailDelivery(to, from, null);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        assocs = this.nodeService.getChildAssocs(testUserHomeFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        EmailServiceImplTest.assertEquals((String)"assocs not 1", (int)1, (int)assocs.size());
        EmailServiceImplTest.assertEquals((String)"name of link not as expected", (Object)((ChildAssociationRef)assocs.get(0)).getQName(), (Object)QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)TEST_SUBJECT));
        this.emailService.importMessage(delivery, (EmailMessage)m);
        assocs = this.nodeService.getChildAssocs(testUserHomeFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        EmailServiceImplTest.assertEquals((String)"assocs not 1", (int)1, (int)assocs.size());
        logger.debug((Object)"Step 2: turn off Overwite Duplicates");
        this.folderEmailMessageHandler.setOverwriteDuplicates(false);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        assocs = this.nodeService.getChildAssocs(testUserHomeFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        EmailServiceImplTest.assertEquals((String)"assocs not 2", (int)2, (int)assocs.size());
        this.emailService.importMessage(delivery, (EmailMessage)m);
        assocs = this.nodeService.getChildAssocs(testUserHomeFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        EmailServiceImplTest.assertEquals((String)"assocs not 3", (int)3, (int)assocs.size());
        logger.debug((Object)"Step 3: turn off Overwite Duplicates with long subject name");
        msg.setSubject(TEST_LONG_SUBJECT);
        ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos2);
        is = IOUtils.toInputStream((String)bos2.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        m = new SubethaEmailMessage(is);
        this.folderEmailMessageHandler.setOverwriteDuplicates(false);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        assocs = this.nodeService.getChildAssocs(testUserHomeFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        EmailServiceImplTest.assertEquals((String)"assocs not 4", (int)4, (int)assocs.size());
        this.emailService.importMessage(delivery, (EmailMessage)m);
        assocs = this.nodeService.getChildAssocs(testUserHomeFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        EmailServiceImplTest.assertEquals((String)"assocs not 5", (int)5, (int)assocs.size());
        logger.debug((Object)"Step 4: turn off Overwite Duplicates with long subject name with extension");
        String EXT_NAME = "Blob.xls";
        msg.setSubject(EXT_NAME);
        ByteArrayOutputStream bos3 = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos3);
        is = IOUtils.toInputStream((String)bos3.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        m = new SubethaEmailMessage(is);
        this.folderEmailMessageHandler.setOverwriteDuplicates(false);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        assocs = this.nodeService.getChildAssocs(testUserHomeFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        Vector<QName> assocNames = new Vector<QName>();
        for (ChildAssociationRef assoc : assocs) {
            logger.debug((Object)("assocName: " + String.valueOf(assoc.getQName())));
            System.out.println(assoc.getQName());
            assocNames.add(assoc.getQName());
        }
        EmailServiceImplTest.assertTrue((String)(EXT_NAME + "not found"), (boolean)assocNames.contains(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Blob.xls")));
        EmailServiceImplTest.assertTrue((String)"Blob(1).xls not found", (boolean)assocNames.contains(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Blob(1).xls")));
        EmailServiceImplTest.assertTrue((String)"Blob(2).xls not found", (boolean)assocNames.contains(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Blob(2).xls")));
        EmailServiceImplTest.assertTrue((String)(TEST_SUBJECT + "not found"), (boolean)assocNames.contains(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)TEST_SUBJECT)));
        EmailServiceImplTest.assertTrue((String)(TEST_SUBJECT + "(1) not found"), (boolean)assocNames.contains(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Practical Bee Keeping(1)")));
        logger.debug((Object)"Step 5: turn off Overwite Duplicates and check concurrent deliver of the same message");
        this.folderEmailMessageHandler.setOverwriteDuplicates(false);
        assocs = this.nodeService.getChildAssocs(testUserHomeFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        int numBeforeConcurrentDeliver = assocs.size();
        this.deliverConcurrently(delivery, m);
        assocs = this.nodeService.getChildAssocs(testUserHomeFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        int numAfterConcurrentDeliver = assocs.size();
        EmailServiceImplTest.assertEquals((String)"Two messages must be added", (int)(numBeforeConcurrentDeliver + 2), (int)numAfterConcurrentDeliver);
    }

    private void deliverConcurrently(final EmailDelivery delivery, final SubethaEmailMessage m) throws Exception {
        final CountDownLatch cdl = new CountDownLatch(1);
        class ConcurrentMessageImporter
        implements Runnable {
            private Throwable throwable;
            private final /* synthetic */ CountDownLatch val$cdl;
            private final /* synthetic */ EmailDelivery val$delivery;
            private final /* synthetic */ SubethaEmailMessage val$m;

            ConcurrentMessageImporter(CountDownLatch countDownLatch, EmailDelivery emailDelivery, SubethaEmailMessage subethaEmailMessage) {
                this.val$cdl = countDownLatch;
                this.val$delivery = emailDelivery;
                this.val$m = subethaEmailMessage;
            }

            @Override
            public void run() {
                try {
                    EmailServiceImplTest.this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        public Void execute() throws Throwable {
                            val$cdl.countDown();
                            ((ConcurrentMessageImporter)this).EmailServiceImplTest.this.emailService.importMessage(val$delivery, (EmailMessage)val$m);
                            return null;
                        }
                    }, false, true);
                }
                catch (Throwable t) {
                    this.throwable = t;
                }
            }
        }
        ConcurrentMessageImporter messageImporter = new ConcurrentMessageImporter(cdl, delivery, m);
        final Thread messageImporterThread = new Thread(messageImporter);
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                EmailServiceImplTest.this.emailService.importMessage(delivery, (EmailMessage)m);
                messageImporterThread.start();
                cdl.await();
                return null;
            }
        }, false, true);
        messageImporterThread.join();
        if (messageImporter.throwable != null) {
            EmailServiceImplTest.fail((String)messageImporter.throwable.getMessage());
        }
    }

    public void testCaseSensitivity() throws Exception {
        NodeRef person = this.personService.getPerson(this.TEST_USER);
        String TEST_EMAIL = "buffy@sunnydale.high";
        NodeRef testUserHomeFolder = (NodeRef)this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER);
        if (person == null) {
            logger.debug((Object)"new person created");
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(ContentModel.PROP_USERNAME, this.TEST_USER);
            props.put(ContentModel.PROP_EMAIL, TEST_EMAIL);
            person = this.personService.createPerson(props);
        }
        this.nodeService.setProperty(person, ContentModel.PROP_EMAIL, (Serializable)((Object)TEST_EMAIL));
        Set auths = this.authorityService.getContainedAuthorities(null, "GROUP_EMAIL_CONTRIBUTORS", true);
        if (!auths.contains(this.TEST_USER)) {
            this.authorityService.addAuthority("GROUP_EMAIL_CONTRIBUTORS", this.TEST_USER);
        }
        String companyHomePathInStore = "/app:company_home";
        String storePath = "workspace://SpacesStore";
        StoreRef storeRef = new StoreRef(storePath);
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, companyHomePathInStore, null, (NamespacePrefixResolver)this.namespaceService, false);
        NodeRef companyHomeNodeRef = (NodeRef)nodeRefs.get(0);
        EmailServiceImplTest.assertNotNull((String)"company home is null", (Object)companyHomeNodeRef);
        String TEST_CASE_SENSITIVITY_SUBJECT = "Test (Mail)";
        String testUserHomeDBID = ((Long)this.nodeService.getProperty(testUserHomeFolder, ContentModel.PROP_NODE_DBID)).toString() + "@Alfresco.com";
        String from = TEST_EMAIL;
        String to = testUserHomeDBID;
        String content = "hello world";
        Session sess = Session.getDefaultInstance((Properties)new Properties());
        EmailServiceImplTest.assertNotNull((String)"sess is null", (Object)sess);
        SMTPMessage msg = new SMTPMessage(sess);
        InternetAddress[] toa = new InternetAddress[]{new InternetAddress(to)};
        EmailDelivery delivery = new EmailDelivery(to, from, null);
        msg.setFrom((Address)new InternetAddress(TEST_EMAIL));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toa);
        msg.setContent((Object)content, "text/plain");
        msg.setSubject(TEST_CASE_SENSITIVITY_SUBJECT);
        ByteArrayOutputStream bos1 = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos1);
        InputStream is = IOUtils.toInputStream((String)bos1.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        SubethaEmailMessage m = new SubethaEmailMessage(is);
        this.folderEmailMessageHandler.setOverwriteDuplicates(false);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        QName safeQName = QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/content/1.0", (String)TEST_CASE_SENSITIVITY_SUBJECT);
        List assocs = this.nodeService.getChildAssocs(testUserHomeFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)safeQName);
        EmailServiceImplTest.assertEquals((int)1, (int)assocs.size());
        msg.setSubject(TEST_CASE_SENSITIVITY_SUBJECT.toUpperCase());
        ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos2);
        is = IOUtils.toInputStream((String)bos2.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        m = new SubethaEmailMessage(is);
        this.folderEmailMessageHandler.setOverwriteDuplicates(false);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        safeQName = QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/content/1.0", (String)(TEST_CASE_SENSITIVITY_SUBJECT.toUpperCase() + "(1)"));
        assocs = this.nodeService.getChildAssocs(testUserHomeFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)safeQName);
        EmailServiceImplTest.assertEquals((int)1, (int)assocs.size());
    }

    public void testMessagesToDocument() throws Exception {
        logger.debug((Object)"Start testMessagesToDocument");
        String TEST_EMAIL = "buffy@sunnydale.high";
        String TEST_SUBJECT = "Practical Bee Keeping";
        NodeRef person = this.personService.getPerson(this.TEST_USER);
        if (person == null) {
            logger.debug((Object)"new person created");
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(ContentModel.PROP_USERNAME, this.TEST_USER);
            props.put(ContentModel.PROP_EMAIL, TEST_EMAIL);
            person = this.personService.createPerson(props);
        }
        this.nodeService.setProperty(person, ContentModel.PROP_EMAIL, (Serializable)((Object)TEST_EMAIL));
        Set auths = this.authorityService.getContainedAuthorities(null, "GROUP_EMAIL_CONTRIBUTORS", true);
        if (!auths.contains(this.TEST_USER)) {
            this.authorityService.addAuthority("GROUP_EMAIL_CONTRIBUTORS", this.TEST_USER);
        }
        String companyHomePathInStore = "/app:company_home";
        String storePath = "workspace://SpacesStore";
        StoreRef storeRef = new StoreRef(storePath);
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, companyHomePathInStore, null, (NamespacePrefixResolver)this.namespaceService, false);
        NodeRef companyHomeNodeRef = (NodeRef)nodeRefs.get(0);
        EmailServiceImplTest.assertNotNull((String)"company home is null", (Object)companyHomeNodeRef);
        String cfr_ignored_0 = ((Long)this.nodeService.getProperty(companyHomeNodeRef, ContentModel.PROP_NODE_DBID)).toString() + "@Alfresco.com";
        NodeRef testUserHomeFolder = (NodeRef)this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER);
        EmailServiceImplTest.assertNotNull((String)"testUserHomeFolder is null", (Object)testUserHomeFolder);
        List assocs = this.nodeService.getChildAssocs(testUserHomeFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef assoc : assocs) {
            this.nodeService.deleteNode(assoc.getChildRef());
        }
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_NAME, "bees");
        properties.put(ContentModel.PROP_DESCRIPTION, "bees - test doc for email tests");
        ChildAssociationRef testDoc = this.nodeService.createNode(testUserHomeFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"bees"), ContentModel.TYPE_CONTENT, properties);
        NodeRef testDocNodeRef = testDoc.getChildRef();
        String testDocDBID = ((Long)this.nodeService.getProperty(testDocNodeRef, ContentModel.PROP_NODE_DBID)).toString();
        String from = TEST_EMAIL;
        String to = testDocDBID + "@alfresco.com";
        String content = "hello world";
        Session sess = Session.getDefaultInstance((Properties)new Properties());
        EmailServiceImplTest.assertNotNull((String)"sess is null", (Object)sess);
        SMTPMessage msg = new SMTPMessage(sess);
        InternetAddress[] toa = new InternetAddress[]{new InternetAddress(to)};
        msg.setFrom((Address)new InternetAddress(TEST_EMAIL));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toa);
        msg.setSubject(TEST_SUBJECT);
        msg.setContent((Object)content, "text/plain");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos);
        InputStream is = IOUtils.toInputStream((String)bos.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        SubethaEmailMessage m = new SubethaEmailMessage(is);
        logger.debug((Object)"Step 1: send an email to a doc");
        EmailDelivery delivery = new EmailDelivery(to, from, null);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        EmailServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(testDocNodeRef, ForumModel.ASPECT_DISCUSSABLE));
    }

    public void testMessagesToSubTypeOfDocument() throws Exception {
        logger.debug((Object)"Start testMessagesToSubTypesOfDocument");
        String TEST_EMAIL = "buffy@sunnydale.high";
        String TEST_SUBJECT = "Practical Bee Keeping";
        NodeRef person = this.personService.getPerson(this.TEST_USER);
        if (person == null) {
            logger.debug((Object)"new person created");
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(ContentModel.PROP_USERNAME, this.TEST_USER);
            props.put(ContentModel.PROP_EMAIL, TEST_EMAIL);
            person = this.personService.createPerson(props);
        }
        this.nodeService.setProperty(person, ContentModel.PROP_EMAIL, (Serializable)((Object)TEST_EMAIL));
        Set auths = this.authorityService.getContainedAuthorities(null, "GROUP_EMAIL_CONTRIBUTORS", true);
        if (!auths.contains(this.TEST_USER)) {
            this.authorityService.addAuthority("GROUP_EMAIL_CONTRIBUTORS", this.TEST_USER);
        }
        String companyHomePathInStore = "/app:company_home";
        String storePath = "workspace://SpacesStore";
        StoreRef storeRef = new StoreRef(storePath);
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, companyHomePathInStore, null, (NamespacePrefixResolver)this.namespaceService, false);
        NodeRef companyHomeNodeRef = (NodeRef)nodeRefs.get(0);
        EmailServiceImplTest.assertNotNull((String)"company home is null", (Object)companyHomeNodeRef);
        String cfr_ignored_0 = ((Long)this.nodeService.getProperty(companyHomeNodeRef, ContentModel.PROP_NODE_DBID)).toString() + "@Alfresco.com";
        NodeRef testUserHomeFolder = (NodeRef)this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER);
        EmailServiceImplTest.assertNotNull((String)"testUserHomeFolder is null", (Object)testUserHomeFolder);
        List assocs = this.nodeService.getChildAssocs(testUserHomeFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef assoc : assocs) {
            this.nodeService.deleteNode(assoc.getChildRef());
        }
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_NAME, "hamster");
        properties.put(ContentModel.PROP_DESCRIPTION, "syrian hamsters - test doc for email tests, sending to a subtype of cm:content");
        ChildAssociationRef testDoc = this.nodeService.createNode(testUserHomeFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"bees"), TransferModel.TYPE_TRANSFER_REPORT, properties);
        NodeRef testDocNodeRef = testDoc.getChildRef();
        String testDocDBID = ((Long)this.nodeService.getProperty(testDocNodeRef, ContentModel.PROP_NODE_DBID)).toString();
        String from = TEST_EMAIL;
        String to = testDocDBID + "@alfresco.com";
        String content = "hello world";
        Session sess = Session.getDefaultInstance((Properties)new Properties());
        EmailServiceImplTest.assertNotNull((String)"sess is null", (Object)sess);
        SMTPMessage msg = new SMTPMessage(sess);
        InternetAddress[] toa = new InternetAddress[]{new InternetAddress(to)};
        msg.setFrom((Address)new InternetAddress(TEST_EMAIL));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toa);
        msg.setSubject(TEST_SUBJECT);
        msg.setContent((Object)content, "text/plain");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos);
        InputStream is = IOUtils.toInputStream((String)bos.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        SubethaEmailMessage m = new SubethaEmailMessage(is);
        logger.debug((Object)"Step 1: send an email to a transfer report");
        EmailDelivery delivery = new EmailDelivery(to, from, null);
        this.emailService.importMessage(delivery, (EmailMessage)m);
    }

    public void testEmailContributorsAuthority() throws Exception {
        EmailServiceImpl emailServiceImpl = (EmailServiceImpl)this.emailService;
        this.folderEmailMessageHandler.setOverwriteDuplicates(true);
        logger.debug((Object)"Start testEmailContributorsAuthority");
        String TEST_EMAIL = "buffy@sunnydale.high";
        NodeRef person = this.personService.getPerson(this.TEST_USER);
        if (person == null) {
            logger.debug((Object)"new person created");
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(ContentModel.PROP_USERNAME, this.TEST_USER);
            props.put(ContentModel.PROP_EMAIL, TEST_EMAIL);
            person = this.personService.createPerson(props);
        }
        this.nodeService.setProperty(person, ContentModel.PROP_EMAIL, (Serializable)((Object)TEST_EMAIL));
        Set auths = this.authorityService.getContainedAuthorities(null, "GROUP_EMAIL_CONTRIBUTORS", true);
        if (auths.contains(this.TEST_USER)) {
            this.authorityService.removeAuthority("GROUP_EMAIL_CONTRIBUTORS", this.TEST_USER);
        }
        String companyHomePathInStore = "/app:company_home";
        String storePath = "workspace://SpacesStore";
        StoreRef storeRef = new StoreRef(storePath);
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, companyHomePathInStore, null, (NamespacePrefixResolver)this.namespaceService, false);
        NodeRef companyHomeNodeRef = (NodeRef)nodeRefs.get(0);
        EmailServiceImplTest.assertNotNull((String)"company home is null", (Object)companyHomeNodeRef);
        String cfr_ignored_0 = ((Long)this.nodeService.getProperty(companyHomeNodeRef, ContentModel.PROP_NODE_DBID)).toString() + "@Alfresco.com";
        String cfr_ignored_1 = ((Long)this.nodeService.getProperty(person, ContentModel.PROP_NODE_DBID)).toString() + "@Alfresco.com";
        NodeRef testUserHomeFolder = (NodeRef)this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER);
        EmailServiceImplTest.assertNotNull((String)"testUserHomeFolder is null", (Object)testUserHomeFolder);
        String testUserHomeDBID = ((Long)this.nodeService.getProperty(testUserHomeFolder, ContentModel.PROP_NODE_DBID)).toString() + "@Alfresco.com";
        emailServiceImpl.setEmailContributorsAuthority("EVERYONE");
        String from = "admin";
        String to = testUserHomeDBID;
        String content = "hello world";
        Session sess = Session.getDefaultInstance((Properties)new Properties());
        EmailServiceImplTest.assertNotNull((String)"sess is null", (Object)sess);
        SMTPMessage msg = new SMTPMessage(sess);
        InternetAddress[] toa = new InternetAddress[]{new InternetAddress(to)};
        msg.setFrom((Address)new InternetAddress(TEST_EMAIL));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toa);
        msg.setSubject("JavaMail APIs transport.java Test");
        msg.setContent((Object)content, "text/plain");
        new StringBuffer();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos);
        InputStream is = IOUtils.toInputStream((String)bos.toString());
        EmailServiceImplTest.assertNotNull((String)"is is null", (Object)is);
        SubethaEmailMessage m = new SubethaEmailMessage(is);
        EmailDelivery delivery = new EmailDelivery(to, from, null);
        this.emailService.importMessage(delivery, (EmailMessage)m);
        try {
            logger.debug((Object)"Step 2");
            emailServiceImpl.setEmailContributorsAuthority("EMAIL_CONTRIBUTORS");
            this.emailService.importMessage(delivery, (EmailMessage)m);
            EmailServiceImplTest.fail((String)"not thrown out");
        }
        catch (EmailMessageException emailMessageException) {}
    }
}

