/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.IOException;
import java.util.StringJoiner;
import org.alfresco.httpclient.HttpClientConfig;
import org.alfresco.repo.content.transform.RemoteTransformerClient;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.Pair;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.apache.commons.logging.Log;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.springframework.test.util.AssertionErrors;

@Deprecated
@Category(value={NeverRunsTests.class})
public class RemoteTransformerClientTest {
    public static final int STARTUP_RETRY_PERIOD_SECONDS = 2;
    @Mock
    private ContentReader mockReader;
    @Mock
    private ContentWriter mockWriter;
    @Mock
    private Log mockLogger;
    @Mock
    private CloseableHttpResponse mockHttpResponse;
    @Mock
    private HttpEntity mockRequestEntity;
    @Mock
    private HttpEntity mockResponseEntity;
    @Mock
    private Header mockResponseContentType;
    @Mock
    private Header mockResponseContentEncoding;
    @Mock
    private StatusLine mockStatusLine;
    @Mock
    private HttpEntity mockReqEntity;
    @Spy
    private RemoteTransformerClient remoteTransformerClient = new RemoteTransformerClient("TRANSFORMER", "http://localhost:1234/test", new HttpClientConfig());
    private String sourceMimetype = "application/msword";
    private String sourceExtension = "doc";
    private String targetExtension = "pdf";
    private long timeoutMs = 120000L;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.remoteTransformerClient.setStartupRetryPeriodSeconds(2);
        ((RemoteTransformerClient)Mockito.doReturn((Object)this.mockHttpResponse).when((Object)this.remoteTransformerClient)).execute((CloseableHttpClient)ArgumentMatchers.any(), (HttpGet)ArgumentMatchers.any(HttpGet.class));
        ((RemoteTransformerClient)Mockito.doReturn((Object)this.mockHttpResponse).when((Object)this.remoteTransformerClient)).execute((CloseableHttpClient)ArgumentMatchers.any(), (HttpPost)ArgumentMatchers.any(HttpPost.class));
        ((RemoteTransformerClient)Mockito.doReturn((Object)this.mockRequestEntity).when((Object)this.remoteTransformerClient)).getRequestEntity((ContentReader)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (String[])ArgumentMatchers.any(), (StringJoiner)ArgumentMatchers.any());
        Mockito.when((Object)this.mockHttpResponse.getStatusLine()).thenReturn((Object)this.mockStatusLine);
        Mockito.when((Object)this.mockHttpResponse.getEntity()).thenReturn((Object)this.mockResponseEntity);
        Mockito.when((Object)this.mockStatusLine.getStatusCode()).thenReturn((Object)200);
    }

    private void assertRequestTransformError(String expectedMessage) {
        try {
            this.requestTransform();
            Assert.fail((String)"There should have been an exception");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)expectedMessage, (Object)this.getMessage(e));
        }
    }

    private void requestTransform() throws IllegalAccessException {
        this.remoteTransformerClient.request(this.mockReader, this.mockWriter, this.sourceMimetype, this.sourceExtension, this.targetExtension, this.timeoutMs, this.mockLogger, new String[0]);
    }

    private String getMessage(Exception e) {
        String msg = e.getMessage();
        return this.getMessage(msg);
    }

    private String getMessage(String msg) {
        int i = msg.indexOf(32);
        if (i > 0) {
            msg = msg.substring(i + 1);
        }
        return msg;
    }

    @Test
    public void successCheckTest() throws Exception {
        this.remoteTransformerClient.check(this.mockLogger);
    }

    @Test
    public void successRequestTest() throws Exception {
        this.requestTransform();
    }

    @Test
    public void non200CheckTest() throws Exception {
        Mockito.when((Object)this.mockStatusLine.getStatusCode()).thenReturn((Object)1234);
        ((RemoteTransformerClient)Mockito.doReturn((Object)"\"message\":\"AN ERROR MESSAGE\",\"path\":").when((Object)this.remoteTransformerClient)).getContent((HttpEntity)ArgumentMatchers.any());
        Pair available = this.remoteTransformerClient.check(this.mockLogger);
        Assert.assertFalse((String)"Any failure should result in false", (boolean)((Boolean)available.getFirst()));
        Assert.assertEquals((Object)"TRANSFORMER check returned a 1234 status AN ERROR MESSAGE http://localhost:1234/test/version", (Object)this.getMessage((String)available.getSecond()));
    }

    @Test
    public void non200RequestTest() throws Exception {
        Mockito.when((Object)this.mockStatusLine.getStatusCode()).thenReturn((Object)1234);
        ((RemoteTransformerClient)Mockito.doReturn((Object)"\"message\":\"AN ERROR MESSAGE\",\"path\":").when((Object)this.remoteTransformerClient)).getContent((HttpEntity)ArgumentMatchers.any());
        this.assertRequestTransformError("TRANSFORMER returned a 1234 status AN ERROR MESSAGE http://localhost:1234/test/transform");
    }

    @Test
    public void noConnectionCheckTest() throws Exception {
        ((RemoteTransformerClient)Mockito.doThrow(IOException.class).when((Object)this.remoteTransformerClient)).execute((CloseableHttpClient)ArgumentMatchers.any(), (HttpGet)ArgumentMatchers.any(HttpGet.class));
        Pair available = this.remoteTransformerClient.check(this.mockLogger);
        Assert.assertFalse((String)"Any failure should result in false", (boolean)((Boolean)available.getFirst()));
        Assert.assertEquals((Object)"TRANSFORMER check failed to connect or to read the response", (Object)this.getMessage((String)available.getSecond()));
        this.assertTransformerBecomesAvailableAgainAfterFailure();
    }

    @Test
    public void noConnectionRequestTest() throws Exception {
        this.requestTransform();
        ((RemoteTransformerClient)Mockito.doThrow(IOException.class).when((Object)this.remoteTransformerClient)).execute((CloseableHttpClient)ArgumentMatchers.any(), (HttpPost)ArgumentMatchers.any(HttpPost.class));
        this.assertRequestTransformError("TRANSFORMER failed to connect or to read the response");
        Assert.assertFalse((boolean)this.remoteTransformerClient.isAvailable());
        ((RemoteTransformerClient)Mockito.doReturn((Object)this.mockHttpResponse).when((Object)this.remoteTransformerClient)).execute((CloseableHttpClient)ArgumentMatchers.any(), (HttpPost)ArgumentMatchers.any(HttpPost.class));
        ((RemoteTransformerClient)Mockito.doThrow(IOException.class).when((Object)this.remoteTransformerClient)).execute((CloseableHttpClient)ArgumentMatchers.any(), (HttpGet)ArgumentMatchers.any(HttpGet.class));
        this.assertTransformerBecomesAvailableAgainAfterFailure();
        this.requestTransform();
    }

    @Test
    public void assertOnceAvailableAlwaysAvailable() throws Exception {
        ((RemoteTransformerClient)Mockito.doThrow(IOException.class).when((Object)this.remoteTransformerClient)).execute((CloseableHttpClient)ArgumentMatchers.any(), (HttpGet)ArgumentMatchers.any(HttpGet.class));
        Pair available = this.remoteTransformerClient.check(this.mockLogger);
        Assert.assertFalse((String)"Any failure should result in false", (boolean)((Boolean)available.getFirst()));
        ((RemoteTransformerClient)Mockito.doReturn((Object)this.mockHttpResponse).when((Object)this.remoteTransformerClient)).execute((CloseableHttpClient)ArgumentMatchers.any(), (HttpGet)ArgumentMatchers.any(HttpGet.class));
        Thread.sleep(2000L);
        available = this.remoteTransformerClient.check(this.mockLogger);
        AssertionErrors.assertTrue((String)"No failure so should result in true", (boolean)((Boolean)available.getFirst()));
        ((RemoteTransformerClient)Mockito.doThrow(IOException.class).when((Object)this.remoteTransformerClient)).execute((CloseableHttpClient)ArgumentMatchers.any(), (HttpGet)ArgumentMatchers.any(HttpGet.class));
        available = this.remoteTransformerClient.check(this.mockLogger);
        AssertionErrors.assertTrue((String)"Should return true as it has before", (boolean)((Boolean)available.getFirst()));
    }

    protected void assertTransformerBecomesAvailableAgainAfterFailure() throws InterruptedException, IOException {
        Assert.assertFalse((boolean)this.remoteTransformerClient.isAvailable());
        Thread.sleep(2000L);
        Pair available = this.remoteTransformerClient.check(this.mockLogger);
        Assert.assertFalse((String)"Any failure should result in false", (boolean)((Boolean)available.getFirst()));
        Assert.assertFalse((boolean)this.remoteTransformerClient.isAvailable());
        ((RemoteTransformerClient)Mockito.doReturn((Object)this.mockHttpResponse).when((Object)this.remoteTransformerClient)).execute((CloseableHttpClient)ArgumentMatchers.any(), (HttpGet)ArgumentMatchers.any(HttpGet.class));
        available = this.remoteTransformerClient.check(this.mockLogger);
        AssertionErrors.assertTrue((String)"During the wait period null should be returned", (available.getFirst() == null ? 1 : 0) != 0);
        AssertionErrors.assertTrue((String)"During the wait period null should be returned", (available.getSecond() == null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.remoteTransformerClient.isAvailable());
        Thread.sleep(1000L);
        available = this.remoteTransformerClient.check(this.mockLogger);
        AssertionErrors.assertTrue((String)"During the wait period null should be returned", (available.getFirst() == null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.remoteTransformerClient.isAvailable());
        Thread.sleep(1000L);
        available = this.remoteTransformerClient.check(this.mockLogger);
        AssertionErrors.assertTrue((String)"Any failure should result in false", (boolean)((Boolean)available.getFirst()));
        AssertionErrors.assertTrue((String)"The transformer should have come back", (boolean)this.remoteTransformerClient.isAvailable());
    }
}

