/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.util.List;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptAction;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;

public final class Actions
extends BaseScopableProcessorExtension {
    private ServiceRegistry services;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.services = serviceRegistry;
    }

    public String[] getRegistered() {
        ActionService actionService = this.services.getActionService();
        List<ActionDefinition> defs = actionService.getActionDefinitions();
        String[] registered = new String[defs.size()];
        int i = 0;
        for (ActionDefinition def : defs) {
            registered[i++] = def.getName();
        }
        return registered;
    }

    public ScriptAction create(String actionName) {
        ScriptAction scriptAction = null;
        ActionService actionService = this.services.getActionService();
        ActionDefinition actionDef = actionService.getActionDefinition(actionName);
        if (actionDef != null) {
            Action action = actionService.createAction(actionName);
            scriptAction = new ScriptAction(this.services, action, actionDef);
            scriptAction.setScope(this.getScope());
        }
        return scriptAction;
    }
}

