/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DoNothingCopyBehaviourCallback;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure1;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure11;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure13;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure15;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure17;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure19;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure21;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure23;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure25;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure27;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure29;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure3;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure31;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure33;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure35;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure37;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure39;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure41;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure43;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure5;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure7;
import org.alfresco.repo.lock.LockServiceImpl$AjcClosure9;
import org.alfresco.repo.lock.LockServicePolicies;
import org.alfresco.repo.lock.LockUtils;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.lock.mem.LockState;
import org.alfresco.repo.lock.mem.LockStore;
import org.alfresco.repo.lock.mem.LockableAspectInterceptor;
import org.alfresco.repo.lock.traitextender.LockServiceExtension;
import org.alfresco.repo.lock.traitextender.LockServiceTrait;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.repo.version.VersionServicePolicies;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.lock.UnableToAquireLockException;
import org.alfresco.service.cmr.lock.UnableToReleaseLockException;
import org.alfresco.service.cmr.repository.AspectMissingException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.traitextender.AJProxyTrait;
import org.alfresco.traitextender.Extend;
import org.alfresco.traitextender.ExtendedTrait;
import org.alfresco.traitextender.Extensible;
import org.alfresco.traitextender.RouteExtensions;
import org.alfresco.traitextender.Trait;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.util.Assert;

public class LockServiceImpl
implements LockService,
NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.BeforeUpdateNodePolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnMoveNodePolicy,
CopyServicePolicies.OnCopyNodePolicy,
VersionServicePolicies.OnCreateVersionPolicy,
TransactionListener,
Extensible {
    public static final int MAX_EPHEMERAL_LOCK_SECONDS = 172800;
    private static final String KEY_IGNORE_NODES = "lockService.ignoreNodes";
    private static final Object KEY_MODIFIED_NODES;
    private NodeService nodeService;
    private TenantService tenantService;
    private AuthenticationService authenticationService;
    private SearchService searchService;
    private BehaviourFilter behaviourFilter;
    private LockStore lockStore;
    private PolicyComponent policyComponent;
    private LockableAspectInterceptor lockableAspectInterceptor;
    private ClassPolicyDelegate<LockServicePolicies.BeforeLock> beforeLock;
    private ClassPolicyDelegate<LockServicePolicies.BeforeUnlock> beforeUnlock;
    private int ephemeralExpiryThreshold;
    private final ExtendedTrait<LockServiceTrait> lockServiceTrait = new ExtendedTrait<LockServiceTrait>(AJProxyTrait.create(this, LockServiceTrait.class));
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ Annotation ajc$anno$9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ Annotation ajc$anno$10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ Annotation ajc$anno$11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ Annotation ajc$anno$12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ Annotation ajc$anno$13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ Annotation ajc$anno$14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ Annotation ajc$anno$15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ Annotation ajc$anno$16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ Annotation ajc$anno$17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ Annotation ajc$anno$18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ Annotation ajc$anno$19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ Annotation ajc$anno$20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ Annotation ajc$anno$21;

    static {
        LockServiceImpl.ajc$preClinit();
        KEY_MODIFIED_NODES = "lockService.lockedNode";
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setLockStore(LockStore lockStore) {
        this.lockStore = lockStore;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setLockableAspectInterceptor(LockableAspectInterceptor lockableAspectInterceptor) {
        this.lockableAspectInterceptor = lockableAspectInterceptor;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"tenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)this, (String)"authenticationService", (Object)this.authenticationService);
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.searchService);
        PropertyCheck.mandatory((Object)this, (String)"behaviourFilter", (Object)this.behaviourFilter);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        this.beforeLock = this.policyComponent.registerClassPolicy(LockServicePolicies.BeforeLock.class);
        this.beforeUnlock = this.policyComponent.registerClassPolicy(LockServicePolicies.BeforeUnlock.class);
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "onCreateChildAssociation"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeUpdateNodePolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "beforeUpdateNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "onMoveNode"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(VersionServicePolicies.OnCreateVersionPolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "onCreateVersion"));
    }

    private List<QName> getInvokeClasses(NodeRef nodeRef) {
        ArrayList<QName> result = new ArrayList<QName>(10);
        result.add(this.nodeService.getType(nodeRef));
        Set aspects = this.nodeService.getAspects(nodeRef);
        for (QName aspect : aspects) {
            result.add(aspect);
        }
        return result;
    }

    private void invokeBeforeLock(NodeRef nodeRef, LockType lockType) {
        if (!this.nodeService.exists(nodeRef)) {
            return;
        }
        List<QName> classes = this.getInvokeClasses(nodeRef);
        for (QName invokeClass : classes) {
            Collection<LockServicePolicies.BeforeLock> policies = this.beforeLock.getList(invokeClass);
            for (LockServicePolicies.BeforeLock policy : policies) {
                policy.beforeLock(nodeRef, lockType);
            }
        }
    }

    private void invokeBeforeUnlock(NodeRef nodeRef) {
        if (!this.nodeService.exists(nodeRef)) {
            return;
        }
        List<QName> classes = this.getInvokeClasses(nodeRef);
        for (QName invokeClass : classes) {
            Collection<LockServicePolicies.BeforeUnlock> policies = this.beforeUnlock.getList(invokeClass);
            for (LockServicePolicies.BeforeUnlock policy : policies) {
                policy.beforeUnlock(nodeRef);
            }
        }
    }

    private void addToIgnoreSet(NodeRef nodeRef) {
        HashSet<NodeRef> ignoreNodeRefs = (HashSet<NodeRef>)AlfrescoTransactionSupport.getResource((Object)KEY_IGNORE_NODES);
        if (ignoreNodeRefs == null) {
            ignoreNodeRefs = new HashSet<NodeRef>();
            AlfrescoTransactionSupport.bindResource((Object)KEY_IGNORE_NODES, ignoreNodeRefs);
        }
        ignoreNodeRefs.add(nodeRef);
    }

    private void removeFromIgnoreSet(NodeRef nodeRef) {
        Set ignoreNodeRefs = (Set)AlfrescoTransactionSupport.getResource((Object)KEY_IGNORE_NODES);
        if (ignoreNodeRefs != null) {
            ignoreNodeRefs.remove(nodeRef);
        }
    }

    private boolean ignore(NodeRef nodeRef) {
        Set ignoreNodeRefs = (Set)AlfrescoTransactionSupport.getResource((Object)KEY_IGNORE_NODES);
        if (ignoreNodeRefs != null) {
            return ignoreNodeRefs.contains(nodeRef);
        }
        return false;
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public void lock(NodeRef nodeRef, LockType lockType) {
        NodeRef nodeRef2 = nodeRef;
        LockType lockType2 = lockType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)nodeRef2, (Object)((Object)lockType2));
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, lockType2, joinPoint};
        LockServiceImpl$AjcClosure1 lockServiceImpl$AjcClosure1 = new LockServiceImpl$AjcClosure1(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = LockServiceImpl.class.getDeclaredMethod("lock", NodeRef.class, LockType.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public void lock(NodeRef nodeRef, LockType lockType, int timeToExpire) {
        NodeRef nodeRef2 = nodeRef;
        LockType lockType2 = lockType;
        int n = timeToExpire;
        Object[] objectArray = new Object[]{nodeRef2, lockType2, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef2, lockType2, Conversions.intObject((int)n), joinPoint};
        LockServiceImpl$AjcClosure3 lockServiceImpl$AjcClosure3 = new LockServiceImpl$AjcClosure3(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = LockServiceImpl.class.getDeclaredMethod("lock", NodeRef.class, LockType.class, Integer.TYPE).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public void lock(NodeRef nodeRef, LockType lockType, int timeToExpire, Lifetime lifetime) {
        NodeRef nodeRef2 = nodeRef;
        LockType lockType2 = lockType;
        int n = timeToExpire;
        Lifetime lifetime2 = lifetime;
        Object[] objectArray = new Object[]{nodeRef2, lockType2, Conversions.intObject((int)n), lifetime2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef2, lockType2, Conversions.intObject((int)n), lifetime2, joinPoint};
        LockServiceImpl$AjcClosure5 lockServiceImpl$AjcClosure5 = new LockServiceImpl$AjcClosure5(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = LockServiceImpl.class.getDeclaredMethod("lock", NodeRef.class, LockType.class, Integer.TYPE, Lifetime.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public void lock(NodeRef nodeRef, LockType lockType, int timeToExpire, Lifetime lifetime, boolean lockChildren) {
        NodeRef nodeRef2 = nodeRef;
        LockType lockType2 = lockType;
        int n = timeToExpire;
        Lifetime lifetime2 = lifetime;
        boolean bl = lockChildren;
        Object[] objectArray = new Object[]{nodeRef2, lockType2, Conversions.intObject((int)n), lifetime2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef2, lockType2, Conversions.intObject((int)n), lifetime2, Conversions.booleanObject((boolean)bl), joinPoint};
        LockServiceImpl$AjcClosure7 lockServiceImpl$AjcClosure7 = new LockServiceImpl$AjcClosure7(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure7.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = LockServiceImpl.class.getDeclaredMethod("lock", NodeRef.class, LockType.class, Integer.TYPE, Lifetime.class, Boolean.TYPE).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public void lock(NodeRef nodeRef, LockType lockType, int timeToExpire, Lifetime lifetime, String additionalInfo) {
        NodeRef nodeRef2 = nodeRef;
        LockType lockType2 = lockType;
        int n = timeToExpire;
        Lifetime lifetime2 = lifetime;
        String string = additionalInfo;
        Object[] objectArray = new Object[]{nodeRef2, lockType2, Conversions.intObject((int)n), lifetime2, string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef2, lockType2, Conversions.intObject((int)n), lifetime2, string, joinPoint};
        LockServiceImpl$AjcClosure9 lockServiceImpl$AjcClosure9 = new LockServiceImpl$AjcClosure9(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure9.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = LockServiceImpl.class.getDeclaredMethod("lock", NodeRef.class, LockType.class, Integer.TYPE, Lifetime.class, String.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    private void validateTimeToExpire(int timeToExpire, Lifetime lifetime) {
        if (lifetime.equals((Object)Lifetime.EPHEMERAL) && timeToExpire > 172800) {
            throw new IllegalArgumentException("Attempt to create ephemeral lock for " + timeToExpire + " seconds - exceeds maximum allowed time.");
        }
    }

    private Lifetime switchLifetimeMode(int timeToExpire, Lifetime lifetime) {
        if (lifetime.equals((Object)Lifetime.EPHEMERAL) && timeToExpire > this.ephemeralExpiryThreshold) {
            return Lifetime.PERSISTENT;
        }
        return lifetime;
    }

    private void persistLockProps(NodeRef nodeRef, LockType lockType, Lifetime lifetime, String userName, Date expiryDate, String additionalInfo) {
        this.addToIgnoreSet(nodeRef);
        try {
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_LOCK_OWNER, (Serializable)((Object)userName));
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_LOCK_TYPE, (Serializable)((Object)lockType.toString()));
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_LOCK_LIFETIME, (Serializable)((Object)lifetime.toString()));
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_EXPIRY_DATE, (Serializable)expiryDate);
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_LOCK_ADDITIONAL_INFO, (Serializable)((Object)additionalInfo));
        }
        finally {
            this.removeFromIgnoreSet(nodeRef);
        }
    }

    private Date makeExpiryDate(int timeToExpire) {
        boolean permanent;
        boolean bl = permanent = timeToExpire <= 0;
        if (permanent) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(13, timeToExpire);
        Date expiryDate = calendar.getTime();
        return expiryDate;
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public void lock(NodeRef nodeRef, LockType lockType, int timeToExpire, boolean lockChildren) throws UnableToAquireLockException {
        NodeRef nodeRef2 = nodeRef;
        LockType lockType2 = lockType;
        int n = timeToExpire;
        boolean bl = lockChildren;
        Object[] objectArray = new Object[]{nodeRef2, lockType2, Conversions.intObject((int)n), Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef2, lockType2, Conversions.intObject((int)n), Conversions.booleanObject((boolean)bl), joinPoint};
        LockServiceImpl$AjcClosure11 lockServiceImpl$AjcClosure11 = new LockServiceImpl$AjcClosure11(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure11.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = LockServiceImpl.class.getDeclaredMethod("lock", NodeRef.class, LockType.class, Integer.TYPE, Boolean.TYPE).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public void lock(Collection<NodeRef> nodeRefs, LockType lockType, int timeToExpire) throws UnableToAquireLockException {
        Collection<NodeRef> collection = nodeRefs;
        LockType lockType2 = lockType;
        int n = timeToExpire;
        Object[] objectArray = new Object[]{collection, lockType2, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, collection, lockType2, Conversions.intObject((int)n), joinPoint};
        LockServiceImpl$AjcClosure13 lockServiceImpl$AjcClosure13 = new LockServiceImpl$AjcClosure13(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure13.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = LockServiceImpl.class.getDeclaredMethod("lock", Collection.class, LockType.class, Integer.TYPE).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public void unlock(NodeRef nodeRef) throws UnableToReleaseLockException {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        LockServiceImpl$AjcClosure15 lockServiceImpl$AjcClosure15 = new LockServiceImpl$AjcClosure15(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure15.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = LockServiceImpl.class.getDeclaredMethod("unlock", NodeRef.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public void unlock(NodeRef nodeRef, boolean lockChildren) throws UnableToReleaseLockException {
        NodeRef nodeRef2 = nodeRef;
        boolean bl = lockChildren;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)nodeRef2, (Object)Conversions.booleanObject((boolean)bl));
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, Conversions.booleanObject((boolean)bl), joinPoint};
        LockServiceImpl$AjcClosure17 lockServiceImpl$AjcClosure17 = new LockServiceImpl$AjcClosure17(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure17.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = LockServiceImpl.class.getDeclaredMethod("unlock", NodeRef.class, Boolean.TYPE).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public void unlock(NodeRef nodeRef, boolean unlockChildren, boolean allowCheckedOut) throws UnableToReleaseLockException {
        NodeRef nodeRef2 = nodeRef;
        boolean bl = unlockChildren;
        boolean bl2 = allowCheckedOut;
        Object[] objectArray = new Object[]{nodeRef2, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef2, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2), joinPoint};
        LockServiceImpl$AjcClosure19 lockServiceImpl$AjcClosure19 = new LockServiceImpl$AjcClosure19(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure19.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = LockServiceImpl.class.getDeclaredMethod("unlock", NodeRef.class, Boolean.TYPE, Boolean.TYPE).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public void unlock(Collection<NodeRef> nodeRefs) throws UnableToReleaseLockException {
        Collection<NodeRef> collection = nodeRefs;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, collection);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, collection, joinPoint};
        LockServiceImpl$AjcClosure21 lockServiceImpl$AjcClosure21 = new LockServiceImpl$AjcClosure21(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure21.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$10;
        if (annotation == null) {
            annotation = ajc$anno$10 = LockServiceImpl.class.getDeclaredMethod("unlock", Collection.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public LockStatus getLockStatus(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        LockServiceImpl$AjcClosure23 lockServiceImpl$AjcClosure23 = new LockServiceImpl$AjcClosure23(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure23.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$11;
        if (annotation == null) {
            annotation = ajc$anno$11 = LockServiceImpl.class.getDeclaredMethod("getLockStatus", NodeRef.class).getAnnotation(Extend.class);
        }
        return (LockStatus)((Object)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation));
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public LockStatus getLockStatus(NodeRef nodeRef, String userName) {
        NodeRef nodeRef2 = nodeRef;
        String string = userName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)nodeRef2, (Object)string);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, string, joinPoint};
        LockServiceImpl$AjcClosure25 lockServiceImpl$AjcClosure25 = new LockServiceImpl$AjcClosure25(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure25.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$12;
        if (annotation == null) {
            annotation = ajc$anno$12 = LockServiceImpl.class.getDeclaredMethod("getLockStatus", NodeRef.class, String.class).getAnnotation(Extend.class);
        }
        return (LockStatus)((Object)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation));
    }

    private Pair<LockState, LockStatus> getLockStateAndStatus(NodeRef nodeRef, String userName) {
        LockState lockState = this.getLockState(nodeRef);
        String lockOwner = lockState.getOwner();
        Date expiryDate = lockState.getExpires();
        LockStatus status = LockUtils.lockStatus(userName, lockOwner, expiryDate);
        return new Pair((Object)lockState, (Object)status);
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public LockType getLockType(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        LockServiceImpl$AjcClosure27 lockServiceImpl$AjcClosure27 = new LockServiceImpl$AjcClosure27(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure27.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$13;
        if (annotation == null) {
            annotation = ajc$anno$13 = LockServiceImpl.class.getDeclaredMethod("getLockType", NodeRef.class).getAnnotation(Extend.class);
        }
        return (LockType)((Object)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation));
    }

    private void ensureLockAspect(NodeRef nodeRef) {
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        }
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public void checkForLock(NodeRef nodeRef) throws NodeLockedException {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        LockServiceImpl$AjcClosure29 lockServiceImpl$AjcClosure29 = new LockServiceImpl$AjcClosure29(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure29.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$14;
        if (annotation == null) {
            annotation = ajc$anno$14 = LockServiceImpl.class.getDeclaredMethod("checkForLock", NodeRef.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean isNewNode) {
        LockType lockType = this.getLockType(childAssocRef.getParentRef());
        if (lockType != null) {
            switch (lockType) {
                case READ_ONLY_LOCK: 
                case WRITE_LOCK: {
                    this.checkForLock(childAssocRef.getParentRef());
                }
            }
        }
    }

    @Override
    public void beforeUpdateNode(NodeRef nodeRef) {
        this.checkForLock(nodeRef);
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_CHECKED_OUT)) {
            this.checkForLock(nodeRef);
        }
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return DoNothingCopyBehaviourCallback.getInstance();
    }

    @Override
    public void onCreateVersion(QName classRef, NodeRef versionableNode, Map<String, Serializable> versionProperties, PolicyScope nodeDetails) {
        nodeDetails.addAspect(ContentModel.ASPECT_LOCKABLE);
    }

    private String getUserName() {
        return this.authenticationService.getCurrentUserName();
    }

    @Deprecated
    public List<NodeRef> getLocks(StoreRef storeRef) {
        return this.getLocks(storeRef, "ASPECT:\"" + ContentModel.ASPECT_LOCKABLE.toString() + "\" +@\\{http\\://www.alfresco.org/model/content/1.0\\}" + ContentModel.PROP_LOCK_OWNER.getLocalName() + ":\"" + this.getUserName() + "\"");
    }

    @Deprecated
    private List<NodeRef> getLocks(StoreRef storeRef, String query) {
        ArrayList<NodeRef> result = new ArrayList();
        try (ResultSet resultSet = null;){
            resultSet = this.searchService.query(storeRef, "lucene", query);
            result = resultSet.getNodeRefs();
        }
        return result;
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public boolean isLocked(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        LockServiceImpl$AjcClosure31 lockServiceImpl$AjcClosure31 = new LockServiceImpl$AjcClosure31(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure31.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$15;
        if (annotation == null) {
            annotation = ajc$anno$15 = LockServiceImpl.class.getDeclaredMethod("isLocked", NodeRef.class).getAnnotation(Extend.class);
        }
        return Conversions.booleanValue((Object)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation));
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public boolean isLockedAndReadOnly(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        LockServiceImpl$AjcClosure33 lockServiceImpl$AjcClosure33 = new LockServiceImpl$AjcClosure33(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure33.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$16;
        if (annotation == null) {
            annotation = ajc$anno$16 = LockServiceImpl.class.getDeclaredMethod("isLockedAndReadOnly", NodeRef.class).getAnnotation(Extend.class);
        }
        return Conversions.booleanValue((Object)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation));
    }

    @Deprecated
    public List<NodeRef> getLocks(StoreRef storeRef, LockType lockType) {
        return this.getLocks(storeRef, "ASPECT:\"" + ContentModel.ASPECT_LOCKABLE.toString() + "\" +@\\{http\\://www.alfresco.org/model/content/1.0\\}" + ContentModel.PROP_LOCK_OWNER.getLocalName() + ":\"" + this.getUserName() + "\" +@\\{http\\://www.alfresco.org/model/content/1.0\\}" + ContentModel.PROP_LOCK_TYPE.getLocalName() + ":\"" + lockType.toString() + "\"");
    }

    @Override
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        NodeRef nodeRef = oldChildAssocRef.getChildRef();
        this.checkForLock(nodeRef);
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public void suspendLocks() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        LockServiceImpl$AjcClosure35 lockServiceImpl$AjcClosure35 = new LockServiceImpl$AjcClosure35(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure35.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$17;
        if (annotation == null) {
            annotation = ajc$anno$17 = LockServiceImpl.class.getDeclaredMethod("suspendLocks", new Class[0]).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public void enableLocks() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        LockServiceImpl$AjcClosure37 lockServiceImpl$AjcClosure37 = new LockServiceImpl$AjcClosure37(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure37.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$18;
        if (annotation == null) {
            annotation = ajc$anno$18 = LockServiceImpl.class.getDeclaredMethod("enableLocks", new Class[0]).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public String getAdditionalInfo(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        LockServiceImpl$AjcClosure39 lockServiceImpl$AjcClosure39 = new LockServiceImpl$AjcClosure39(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure39.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$19;
        if (annotation == null) {
            annotation = ajc$anno$19 = LockServiceImpl.class.getDeclaredMethod("getAdditionalInfo", NodeRef.class).getAnnotation(Extend.class);
        }
        return (String)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public LockState getLockState(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        LockServiceImpl$AjcClosure41 lockServiceImpl$AjcClosure41 = new LockServiceImpl$AjcClosure41(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure41.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$20;
        if (annotation == null) {
            annotation = ajc$anno$20 = LockServiceImpl.class.getDeclaredMethod("getLockState", NodeRef.class).getAnnotation(Extend.class);
        }
        return (LockState)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public BehaviourFilter getBehaviourFilter() {
        return this.behaviourFilter;
    }

    @Override
    public void flush() {
    }

    @Override
    public void beforeCommit(boolean readOnly) {
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void afterCommit() {
    }

    @Override
    public void afterRollback() {
        Map lockedNodes = TransactionalResourceHelper.getMap(KEY_MODIFIED_NODES);
        for (LockState lockInfo : lockedNodes.values()) {
            this.lockStore.set(lockInfo.getNodeRef(), lockInfo);
        }
    }

    @Override
    @Extend(traitAPI=LockServiceTrait.class, extensionAPI=LockServiceExtension.class)
    public void setEphemeralExpiryThreshold(int threshSecs) {
        int n = threshSecs;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), joinPoint};
        LockServiceImpl$AjcClosure43 lockServiceImpl$AjcClosure43 = new LockServiceImpl$AjcClosure43(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = lockServiceImpl$AjcClosure43.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$21;
        if (annotation == null) {
            annotation = ajc$anno$21 = LockServiceImpl.class.getDeclaredMethod("setEphemeralExpiryThreshold", Integer.TYPE).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    public int getEphemeralExpiryThreshold() {
        return this.ephemeralExpiryThreshold;
    }

    public <M extends Trait> ExtendedTrait<M> getTrait(Class<? extends M> traitAPI) {
        return this.lockServiceTrait;
    }

    static final /* synthetic */ void lock_aroundBody0(LockServiceImpl ajc$this, NodeRef nodeRef, LockType lockType, JoinPoint joinPoint) {
        ajc$this.lock(nodeRef, lockType, 0);
    }

    static final /* synthetic */ void lock_aroundBody2(LockServiceImpl ajc$this, NodeRef nodeRef, LockType lockType, int timeToExpire, JoinPoint joinPoint) {
        ajc$this.lock(nodeRef, lockType, timeToExpire, Lifetime.PERSISTENT);
    }

    static final /* synthetic */ void lock_aroundBody4(LockServiceImpl ajc$this, NodeRef nodeRef, LockType lockType, int timeToExpire, Lifetime lifetime, JoinPoint joinPoint) {
        ajc$this.lock(nodeRef, lockType, timeToExpire, lifetime, null);
    }

    static final /* synthetic */ void lock_aroundBody6(LockServiceImpl ajc$this, NodeRef nodeRef, LockType lockType, int timeToExpire, Lifetime lifetime, boolean lockChildren, JoinPoint joinPoint) {
        ajc$this.lock(nodeRef, lockType, timeToExpire, lifetime);
        if (lockChildren) {
            List childAssocRefs = ajc$this.nodeService.getChildAssocs(nodeRef);
            for (ChildAssociationRef childAssocRef : childAssocRefs) {
                ajc$this.lock(childAssocRef.getChildRef(), lockType, timeToExpire, lifetime, lockChildren);
            }
        }
    }

    static final /* synthetic */ void lock_aroundBody8(LockServiceImpl ajc$this, NodeRef nodeRef, LockType lockType, int timeToExpire, Lifetime lifetime, String additionalInfo, JoinPoint joinPoint) {
        ajc$this.invokeBeforeLock(nodeRef, lockType);
        ajc$this.validateTimeToExpire(timeToExpire, lifetime);
        lifetime = ajc$this.switchLifetimeMode(timeToExpire, lifetime);
        nodeRef = ajc$this.tenantService.getName(nodeRef);
        String userName = ajc$this.getUserName();
        if (lockType == null) {
            lockType = LockType.WRITE_LOCK;
        }
        Pair<LockState, LockStatus> statusAndState = ajc$this.getLockStateAndStatus(nodeRef, userName);
        LockState currentLockInfo = (LockState)statusAndState.getFirst();
        LockStatus currentLockStatus = (LockStatus)((Object)statusAndState.getSecond());
        if (LockStatus.LOCKED.equals((Object)currentLockStatus)) {
            throw new UnableToAquireLockException(nodeRef);
        }
        if (LockStatus.NO_LOCK.equals((Object)currentLockStatus) || LockStatus.LOCK_EXPIRED.equals((Object)currentLockStatus) || LockStatus.LOCK_OWNER.equals((Object)currentLockStatus)) {
            Date expiryDate = ajc$this.makeExpiryDate(timeToExpire);
            if (lifetime == Lifetime.PERSISTENT) {
                ajc$this.lockableAspectInterceptor.disableForThread();
                try {
                    ajc$this.ensureLockAspect(nodeRef);
                    ajc$this.persistLockProps(nodeRef, lockType, lifetime, userName, expiryDate, additionalInfo);
                }
                finally {
                    ajc$this.lockableAspectInterceptor.enableForThread();
                }
            } else if (lifetime == Lifetime.EPHEMERAL) {
                LockState lock = LockState.createLock(nodeRef, lockType, userName, expiryDate, lifetime, additionalInfo);
                ajc$this.lockStore.set(nodeRef, lock);
                TransactionalResourceHelper.getMap(KEY_MODIFIED_NODES).put(nodeRef, currentLockInfo);
                AlfrescoTransactionSupport.bindListener(ajc$this);
            } else {
                throw new IllegalStateException(((Object)((Object)lifetime)).getClass().getSimpleName() + " is not a valid value: " + lifetime.toString());
            }
        }
    }

    static final /* synthetic */ void lock_aroundBody10(LockServiceImpl ajc$this, NodeRef nodeRef, LockType lockType, int timeToExpire, boolean lockChildren, JoinPoint joinPoint) {
        ajc$this.lock(nodeRef, lockType, timeToExpire, Lifetime.PERSISTENT, lockChildren);
    }

    static final /* synthetic */ void lock_aroundBody12(LockServiceImpl ajc$this, Collection nodeRefs, LockType lockType, int timeToExpire, JoinPoint joinPoint) {
        for (NodeRef nodeRef : nodeRefs) {
            ajc$this.lock(nodeRef, lockType, timeToExpire);
        }
    }

    static final /* synthetic */ void unlock_aroundBody14(LockServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        ajc$this.unlock(nodeRef, false, false);
    }

    static final /* synthetic */ void unlock_aroundBody16(LockServiceImpl ajc$this, NodeRef nodeRef, boolean lockChildren, JoinPoint joinPoint) {
        ajc$this.unlock(nodeRef, lockChildren, false);
    }

    /*
     * Unable to fully structure code
     */
    static final /* synthetic */ void unlock_aroundBody18(LockServiceImpl ajc$this, NodeRef nodeRef, boolean unlockChildren, boolean allowCheckedOut, JoinPoint var4_4) {
        ajc$this.invokeBeforeUnlock(nodeRef);
        nodeRef = ajc$this.tenantService.getName(nodeRef);
        lockState = ajc$this.getLockState(nodeRef);
        if (lockState.isLockInfo()) {
            if (!allowCheckedOut && ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_CHECKED_OUT)) {
                throw new UnableToReleaseLockException(nodeRef, UnableToReleaseLockException.CAUSE.CHECKED_OUT);
            }
            lifetime = lockState.getLifetime();
            if (lifetime == Lifetime.PERSISTENT) {
                ajc$this.addToIgnoreSet(nodeRef);
                ajc$this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                ajc$this.lockableAspectInterceptor.disableForThread();
                try {
                    if (!ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) ** GOTO lbl25
                    ajc$this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_LOCKABLE);
                }
                finally {
                    ajc$this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                    ajc$this.lockableAspectInterceptor.enableForThread();
                    ajc$this.removeFromIgnoreSet(nodeRef);
                }
            } else if (lifetime == Lifetime.EPHEMERAL) {
                ajc$this.lockStore.set(nodeRef, LockState.createUnlocked(nodeRef));
            } else {
                throw new IllegalStateException("Unhandled Lifetime value: " + String.valueOf((Object)lifetime));
            }
        }
lbl25:
        // 5 sources

        if (unlockChildren) {
            childAssocRefs = ajc$this.nodeService.getChildAssocs(nodeRef);
            for (ChildAssociationRef childAssocRef : childAssocRefs) {
                ajc$this.unlock(childAssocRef.getChildRef(), unlockChildren);
            }
        }
    }

    static final /* synthetic */ void unlock_aroundBody20(LockServiceImpl ajc$this, Collection nodeRefs, JoinPoint joinPoint) {
        for (NodeRef nodeRef : nodeRefs) {
            ajc$this.unlock(nodeRef);
        }
    }

    static final /* synthetic */ LockStatus getLockStatus_aroundBody22(LockServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        nodeRef = ajc$this.tenantService.getName(nodeRef);
        return ajc$this.getLockStatus(nodeRef, ajc$this.getUserName());
    }

    static final /* synthetic */ LockStatus getLockStatus_aroundBody24(LockServiceImpl ajc$this, NodeRef nodeRef, String userName, JoinPoint joinPoint) {
        Pair<LockState, LockStatus> stateAndStatus = ajc$this.getLockStateAndStatus(nodeRef, userName);
        LockStatus lockStatus = (LockStatus)((Object)stateAndStatus.getSecond());
        return lockStatus;
    }

    static final /* synthetic */ LockType getLockType_aroundBody26(LockServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        String lockTypeString;
        LockType result = null;
        if (ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE) && (lockTypeString = (String)((Object)ajc$this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_TYPE))) != null) {
            result = LockType.valueOf(lockTypeString);
        }
        return result;
    }

    static final /* synthetic */ void checkForLock_aroundBody28(LockServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        String userName = ajc$this.getUserName();
        if ((nodeRef = ajc$this.tenantService.getName(nodeRef)) != null && userName != null) {
            String effectiveUserName = AuthenticationUtil.getRunAsUser();
            if (!ajc$this.ignore(nodeRef) && !ajc$this.tenantService.getBaseNameUser(effectiveUserName).equals(AuthenticationUtil.getSystemUserName())) {
                try {
                    LockStatus currentLockStatus = ajc$this.getLockStatus(nodeRef, userName);
                    LockType lockType = ajc$this.getLockType(nodeRef);
                    if (LockType.WRITE_LOCK.equals((Object)lockType) && LockStatus.LOCKED.equals((Object)currentLockStatus)) {
                        throw new NodeLockedException(nodeRef);
                    }
                    if (LockType.READ_ONLY_LOCK.equals((Object)lockType) && (LockStatus.LOCKED.equals((Object)currentLockStatus) || LockStatus.LOCK_OWNER.equals((Object)currentLockStatus))) {
                        throw new NodeLockedException(nodeRef);
                    }
                    if (LockType.NODE_LOCK.equals((Object)lockType) && (LockStatus.LOCKED.equals((Object)currentLockStatus) || LockStatus.LOCK_OWNER.equals((Object)currentLockStatus))) {
                        throw new NodeLockedException(nodeRef);
                    }
                }
                catch (AspectMissingException aspectMissingException) {}
            }
        }
    }

    static final /* synthetic */ boolean isLocked_aroundBody30(LockServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        LockStatus lockStatus = ajc$this.getLockStatus(nodeRef);
        switch (lockStatus) {
            case LOCKED: 
            case LOCK_OWNER: {
                return true;
            }
        }
        return false;
    }

    static final /* synthetic */ boolean isLockedAndReadOnly_aroundBody32(LockServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        LockStatus lockStatus = ajc$this.getLockStatus(nodeRef);
        switch (lockStatus) {
            case NO_LOCK: 
            case LOCK_EXPIRED: {
                return false;
            }
            case LOCK_OWNER: {
                return ajc$this.getLockType(nodeRef) != LockType.WRITE_LOCK;
            }
        }
        return true;
    }

    static final /* synthetic */ void suspendLocks_aroundBody34(LockServiceImpl ajc$this, JoinPoint joinPoint) {
        ajc$this.getBehaviourFilter().disableBehaviour(ContentModel.ASPECT_LOCKABLE);
        ajc$this.lockableAspectInterceptor.disableForThread();
    }

    static final /* synthetic */ void enableLocks_aroundBody36(LockServiceImpl ajc$this, JoinPoint joinPoint) {
        ajc$this.getBehaviourFilter().enableBehaviour(ContentModel.ASPECT_LOCKABLE);
        ajc$this.lockableAspectInterceptor.enableForThread();
    }

    static final /* synthetic */ String getAdditionalInfo_aroundBody38(LockServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        LockState lockState = ajc$this.getLockState(nodeRef);
        String additionalInfo = lockState.getAdditionalInfo();
        return additionalInfo;
    }

    static final /* synthetic */ LockState getLockState_aroundBody40(LockServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        Date expiryDate;
        String lockOwner;
        LockStatus status;
        LockState lockState = ajc$this.lockStore.get(nodeRef = ajc$this.tenantService.getName(nodeRef));
        if (lockState != null && (status = LockUtils.lockStatus(lockOwner = lockState.getOwner(), lockOwner, expiryDate = lockState.getExpires())).equals((Object)LockStatus.LOCK_EXPIRED)) {
            lockState = null;
        }
        if (lockState == null || !lockState.isLockInfo()) {
            if (ajc$this.nodeService.exists(nodeRef) && ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
                lockOwner = (String)((Object)ajc$this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_OWNER));
                expiryDate = (Date)ajc$this.nodeService.getProperty(nodeRef, ContentModel.PROP_EXPIRY_DATE);
                String lockTypeStr = (String)((Object)ajc$this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_TYPE));
                LockType lockType = lockTypeStr != null ? LockType.valueOf(lockTypeStr) : null;
                String lifetimeStr = (String)((Object)ajc$this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_LIFETIME));
                Lifetime lifetime = lifetimeStr != null ? Lifetime.valueOf(lifetimeStr) : null;
                String additionalInfo = (String)((Object)ajc$this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_ADDITIONAL_INFO));
                lockState = LockState.createLock(nodeRef, lockType, lockOwner, expiryDate, lifetime, additionalInfo);
            } else {
                lockState = LockState.createUnlocked(nodeRef);
            }
        }
        Assert.notNull((Object)lockState, (String)"The lockState should not be null");
        return lockState;
    }

    static final /* synthetic */ void setEphemeralExpiryThreshold_aroundBody42(LockServiceImpl ajc$this, int threshSecs, JoinPoint joinPoint) {
        ajc$this.ephemeralExpiryThreshold = threshSecs;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LockServiceImpl.java", LockServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "lock", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:org.alfresco.service.cmr.lock.LockType", "nodeRef:lockType", "", "void"), 326);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "lock", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:org.alfresco.service.cmr.lock.LockType:int", "nodeRef:lockType:timeToExpire", "", "void"), 337);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unlock", "org.alfresco.repo.lock.LockServiceImpl", "java.util.Collection", "nodeRefs", "org.alfresco.service.cmr.lock.UnableToReleaseLockException", "void"), 616);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLockStatus", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "org.alfresco.service.cmr.lock.LockStatus"), 628);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLockStatus", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.lang.String", "nodeRef:userName", "", "org.alfresco.service.cmr.lock.LockStatus"), 645);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLockType", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "org.alfresco.service.cmr.lock.LockType"), 666);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkForLock", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "org.alfresco.service.cmr.lock.NodeLockedException", "void"), 702);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isLocked", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "boolean"), 881);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isLockedAndReadOnly", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "boolean"), 898);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "suspendLocks", "org.alfresco.repo.lock.LockServiceImpl", "", "", "", "void"), 935);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "enableLocks", "org.alfresco.repo.lock.LockServiceImpl", "", "", "", "void"), 943);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAdditionalInfo", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "java.lang.String"), 951);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "lock", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:org.alfresco.service.cmr.lock.LockType:int:org.alfresco.repo.lock.mem.Lifetime", "nodeRef:lockType:timeToExpire:lifetime", "", "void"), 347);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLockState", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "org.alfresco.repo.lock.mem.LockState"), 960);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEphemeralExpiryThreshold", "org.alfresco.repo.lock.LockServiceImpl", "int", "threshSecs", "", "void"), 1055);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "lock", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:org.alfresco.service.cmr.lock.LockType:int:org.alfresco.repo.lock.mem.Lifetime:boolean", "nodeRef:lockType:timeToExpire:lifetime:lockChildren", "", "void"), 357);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "lock", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:org.alfresco.service.cmr.lock.LockType:int:org.alfresco.repo.lock.mem.Lifetime:java.lang.String", "nodeRef:lockType:timeToExpire:lifetime:additionalInfo", "", "void"), 376);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "lock", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:org.alfresco.service.cmr.lock.LockType:int:boolean", "nodeRef:lockType:timeToExpire:lockChildren", "org.alfresco.service.cmr.lock.UnableToAquireLockException", "void"), 505);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "lock", "org.alfresco.repo.lock.LockServiceImpl", "java.util.Collection:org.alfresco.service.cmr.lock.LockType:int", "nodeRefs:lockType:timeToExpire", "org.alfresco.service.cmr.lock.UnableToAquireLockException", "void"), 515);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unlock", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "org.alfresco.service.cmr.lock.UnableToReleaseLockException", "void"), 530);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unlock", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:boolean", "nodeRef:lockChildren", "org.alfresco.service.cmr.lock.UnableToReleaseLockException", "void"), 540);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unlock", "org.alfresco.repo.lock.LockServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:boolean:boolean", "nodeRef:unlockChildren:allowCheckedOut", "org.alfresco.service.cmr.lock.UnableToReleaseLockException", "void"), 550);
    }
}

