/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.util.schemacomp.ExportDb;
import org.alfresco.util.schemacomp.SchemaToXML;
import org.alfresco.util.schemacomp.model.Schema;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class DbToXML {
    private ApplicationContext context;
    private File outputFile;
    private String namePrefix = "alf_";
    private String dbSchemaName;

    public DbToXML(ApplicationContext context, File outputFile) {
        this.context = context;
        this.outputFile = outputFile;
    }

    public DbToXML(ApplicationContext context, File outputFile, String namePrefix) {
        this(context, outputFile);
        this.namePrefix = namePrefix;
    }

    public void setDbSchemaName(String dbSchemaName) {
        this.dbSchemaName = dbSchemaName;
    }

    public void execute() {
        ExportDb exporter = new ExportDb(this.context);
        exporter.setNamePrefix(this.namePrefix);
        exporter.setDbSchemaName(this.dbSchemaName);
        exporter.execute();
        Schema schema = exporter.getSchema();
        StringWriter stringWriter = new StringWriter();
        SchemaToXML schemaToXML = new SchemaToXML(schema, new StreamResult(stringWriter));
        schemaToXML.execute();
        this.writeToFile(stringWriter.getBuffer().toString());
    }

    private void writeToFile(String content) {
        String[] lines;
        PrintWriter pw = DbToXML.printWriter(this.outputFile, "UTF-8", "\r\n");
        String[] stringArray = lines = content.split(System.getProperty("line.separator"));
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            pw.println(line);
            ++n2;
        }
        pw.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PrintWriter printWriter(File file, String charSet, String lineSeparator) {
        Properties props;
        Properties properties = props = System.getProperties();
        synchronized (properties) {
            String oldLineSep = null;
            try {
                oldLineSep = (String)props.setProperty("line.separator", lineSeparator);
                PrintWriter printWriter = new PrintWriter(file, charSet);
                return printWriter;
            }
            catch (FileNotFoundException error) {
                throw new RuntimeException("Unable to write to file " + String.valueOf(file), error);
            }
            catch (UnsupportedEncodingException error) {
                throw new RuntimeException("Unsupported encoding" + charSet, error);
            }
            finally {
                if (oldLineSep != null) {
                    props.put("line.separator", oldLineSep);
                }
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage:");
            System.err.println("java " + DbToXML.class.getName() + " <context.xml> <output.xml>");
            System.exit(1);
        }
        String contextPath = args[0];
        File outputFile = new File(args[1]);
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(contextPath);
        DbToXML dbToXML = new DbToXML((ApplicationContext)context, outputFile);
        dbToXML.execute();
        context.close();
    }
}

