/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.rawevents.types.OnContentUpdatePolicyEvent;
import org.alfresco.repo.rendition2.RenditionEventProcessor;
import org.alfresco.repo.rendition2.RenditionService2Impl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.support.DefaultExchange;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.springframework.context.ApplicationContext;

@Category(value={NeverRunsTests.class})
public class RenditionEventProcessorTest {
    private RenditionEventProcessor renditionEventProcessor;
    private CamelContext camelContext;
    private ObjectMapper messagingObjectMapper;
    @Mock
    private RenditionService2Impl renditionService2;
    @Rule
    public TestName name = new TestName();
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();

    @Before
    public void setUp() throws Exception {
        ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
        this.camelContext = (CamelContext)ctx.getBean("alfrescoCamelContext");
        this.messagingObjectMapper = (ObjectMapper)ctx.getBean("alfrescoEventObjectMapper");
        TransactionService transactionService = (TransactionService)ctx.getBean("transactionService");
        this.renditionEventProcessor = new RenditionEventProcessor();
        this.renditionEventProcessor.setMessagingObjectMapper(this.messagingObjectMapper);
        this.renditionEventProcessor.setTransactionService(transactionService);
        this.renditionEventProcessor.setRenditionService2(this.renditionService2);
    }

    @Test
    public void processEmptyExchange() throws Exception {
        this.renditionEventProcessor.process(this.createExchange());
    }

    @Test(expected=IllegalArgumentException.class)
    public void processMissingNodeRef() throws Exception {
        Exchange exchange = this.createExchange(new OnContentUpdatePolicyEvent());
        this.renditionEventProcessor.process(exchange);
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void processInvalidExchange() throws Exception {
        Exchange exchange = this.createExchange("invalidContent");
        this.renditionEventProcessor.process(exchange);
    }

    @Test
    public void process() throws Exception {
        NodeRef nodeRef = new NodeRef("workspace://spacesStore/test-id");
        OnContentUpdatePolicyEvent policyEvent = new OnContentUpdatePolicyEvent();
        policyEvent.setNodeRef(nodeRef.toString());
        policyEvent.setNewContent(true);
        Exchange exchange = this.createExchange(policyEvent);
        this.renditionEventProcessor.process(exchange);
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void processException() throws Exception {
        NodeRef nodeRef = new NodeRef("workspace://spacesStore/test-id");
        OnContentUpdatePolicyEvent policyEvent = new OnContentUpdatePolicyEvent();
        policyEvent.setNodeRef(nodeRef.toString());
        policyEvent.setNewContent(true);
        Exchange exchange = this.createExchange(policyEvent);
        ((RenditionService2Impl)Mockito.doThrow((Throwable[])new Throwable[]{new AlfrescoRuntimeException("any")}).when((Object)this.renditionService2)).onContentUpdate(nodeRef, true);
        this.renditionEventProcessor.process(exchange);
    }

    private Exchange createExchange() {
        return new DefaultExchange(this.camelContext);
    }

    private Exchange createExchange(Object event) throws JsonProcessingException {
        Exchange exchange = this.createExchange();
        Message in = exchange.getIn();
        if (!(event instanceof String)) {
            event = this.messagingObjectMapper.writeValueAsString(event);
        }
        in.setBody(event);
        return exchange;
    }
}

