/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.impl.AbstractReadPermissionTest;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.junit.experimental.categories.Category;

@Category(value={OwnJVMTestsCategory.class, LuceneTests.class, RedundantTests.class})
public class ReadPermissionTest
extends AbstractReadPermissionTest {
    public void testAdminCanRead() {
        this.runAs("Web1");
        this.buildNodes("1001", "Read", 10, true);
        this.runAs("admin");
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        ResultSet results = this.serviceRegistry.getSearchService().query(sp);
        results.setBulkFetch(false);
        ReadPermissionTest.assertEquals((int)10, (int)results.length());
        results.close();
    }

    public void testReadDeny() {
        this.build1000NodesReadDenied("1001");
        this.runAs("1001");
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        ResultSet results = this.serviceRegistry.getSearchService().query(sp);
        int length = results.length();
        results.close();
        ReadPermissionTest.assertEquals((int)0, (int)length);
    }

    public void testNoRead() {
        this.build1000Nodes("1001", "Write", true);
        this.runAs("1001");
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        ResultSet results = this.serviceRegistry.getSearchService().query(sp);
        int length = results.length();
        results.close();
        ReadPermissionTest.assertEquals((int)0, (int)length);
    }

    protected void buildContainers(final String username, final String permission) {
        this.runAs("admin");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                String cfr_ignored_0 = "simple" + System.currentTimeMillis();
                NodeRef n1 = ReadPermissionTest.this.nodeService.createNode(ReadPermissionTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}01"), ContentModel.TYPE_CONTAINER).getChildRef();
                ReadPermissionTest.this.permissionService.setPermission(n1, username, permission, true);
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)cb, false, false);
    }

    public void testNodeOwner() {
        this.buildOwnedNodes("1001", 0);
        this.runAs(AuthenticationUtil.getAdminUserName());
        this.runAs("1001");
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//*\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        ResultSet results = this.serviceRegistry.getSearchService().query(sp);
        int length = results.length();
        results.close();
        ReadPermissionTest.assertEquals((int)1001, (int)length);
    }

    public void testChangePermissions() {
        NodeRef[] nodes = this.build1000Nodes("1001", 4, false);
        this.runAs("1001");
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        ResultSet results = this.serviceRegistry.getSearchService().query(sp);
        int length = results.length();
        results.close();
        ReadPermissionTest.assertEquals((int)1000, (int)length);
        int i = 0;
        while (i < 4) {
            this.permissionService.deletePermission(nodes[i], "1001", "Read");
            ++i;
        }
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        results = this.serviceRegistry.getSearchService().query(sp);
        length = results.length();
        results.close();
        ReadPermissionTest.assertEquals((int)996, (int)length);
    }

    public void testQueryReadPermission() {
        this.buildNodes();
        this.runAs("1000");
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        ResultSet results = this.serviceRegistry.getSearchService().query(sp);
        results.setBulkFetch(false);
        ReadPermissionTest.assertEquals((int)(1000 * this.COUNT), (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        results = this.serviceRegistry.getSearchService().query(sp);
        results.setBulkFetch(false);
        ReadPermissionTest.assertEquals((int)(1000 * this.COUNT), (int)results.length());
        results.close();
        this.runAs("100");
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        results = this.serviceRegistry.getSearchService().query(sp);
        results.setBulkFetch(false);
        ReadPermissionTest.assertEquals((int)(100 * this.COUNT), (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        results = this.serviceRegistry.getSearchService().query(sp);
        results.setBulkFetch(false);
        ReadPermissionTest.assertEquals((int)(100 * this.COUNT), (int)results.length());
        results.close();
        this.runAs("10");
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        results = this.serviceRegistry.getSearchService().query(sp);
        results.setBulkFetch(false);
        ReadPermissionTest.assertEquals((int)(10 * this.COUNT), (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        results = this.serviceRegistry.getSearchService().query(sp);
        results.setBulkFetch(false);
        ReadPermissionTest.assertEquals((int)(10 * this.COUNT), (int)results.length());
        results.close();
        this.runAs("10_1");
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        results = this.serviceRegistry.getSearchService().query(sp);
        results.setBulkFetch(false);
        ReadPermissionTest.assertEquals((int)(10 * this.COUNT), (int)results.length());
        results.close();
        this.runAs("1");
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        results = this.serviceRegistry.getSearchService().query(sp);
        results.setBulkFetch(false);
        ReadPermissionTest.assertEquals((int)this.COUNT, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        results = this.serviceRegistry.getSearchService().query(sp);
        results.setBulkFetch(false);
        ReadPermissionTest.assertEquals((int)this.COUNT, (int)results.length());
        results.close();
        this.runAs("01");
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        results = this.serviceRegistry.getSearchService().query(sp);
        results.setBulkFetch(false);
        ReadPermissionTest.assertEquals((int)this.c01.count(), (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        results = this.serviceRegistry.getSearchService().query(sp);
        results.setBulkFetch(false);
        ReadPermissionTest.assertEquals((int)this.c01.count(), (int)results.length());
        results.close();
        this.runAs("001");
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        results = this.serviceRegistry.getSearchService().query(sp);
        results.setBulkFetch(false);
        ReadPermissionTest.assertEquals((int)this.c001.count(), (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        results = this.serviceRegistry.getSearchService().query(sp);
        results.setBulkFetch(false);
        ReadPermissionTest.assertEquals((int)this.c001.count(), (int)results.length());
        results.close();
        this.runAs("0001");
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        results = this.serviceRegistry.getSearchService().query(sp);
        results.setBulkFetch(false);
        ReadPermissionTest.assertEquals((int)this.c0001.count(), (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        sp.setMaxItems(Integer.MAX_VALUE);
        sp.setMaxPermissionChecks(Integer.MAX_VALUE);
        sp.setMaxPermissionCheckTimeMillis(Integer.MAX_VALUE);
        results = this.serviceRegistry.getSearchService().query(sp);
        results.setBulkFetch(false);
        ReadPermissionTest.assertEquals((int)this.c0001.count(), (int)results.length());
        results.close();
    }
}

