/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual;

import jakarta.transaction.UserTransaction;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.search.impl.SearchServiceSubSystemDelegator;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.TypeAndAspectsFormProcessor;
import org.alfresco.repo.virtual.VirtualContentModel;
import org.alfresco.repo.virtual.VirtualizationConfigTestBootstrap;
import org.alfresco.repo.virtual.VirtualizationTest;
import org.alfresco.repo.virtual.model.SystemTemplateLocationsConstraint;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.traitextender.SpringExtensionBundle;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.context.ApplicationContext;

@Category(value={LuceneTests.class})
public abstract class VirtualizationIntegrationTest
implements VirtualizationTest {
    private static Log logger = LogFactory.getLog(VirtualizationIntegrationTest.class);
    private static final String PROP_VM_TEMPLATE_CLASSPATH = "prop_smf_system-template-location";
    protected static final String VIRTUAL_FOLDER_1_NAME = "VirtualFolder1";
    protected static final String VIRTUAL_FOLDER_2_NAME = "VirtualFolder2";
    protected static final String VIRTUAL_FOLDER_3_NAME = "VirtualFolder3";
    protected static final String TEST_ROOT_FOLDER_NAME = "TestFolder";
    protected static final String TEST_TEMPLATE_CLASSPATH = "/org/alfresco/repo/virtual/template/";
    protected static final String TEST_TEMPLATE_1_JS_NAME = "testTemplate1.js";
    protected static final String TEST_TEMPLATE_1_JSON_NAME = "testTemplate1.json";
    protected static final String TEST_TEMPLATE_2_JSON_NAME = "testTemplate2.json";
    protected static final String TEST_TEMPLATE_3_JSON_NAME = "testTemplate3.json";
    protected static final String TEST_TEMPLATE_4_JSON_NAME = "testTemplate4.json";
    protected static final String TEST_TEMPLATE_5_JSON_NAME = "testTemplate5.json";
    protected static final String TEST_TEMPLATE_6_JSON_NAME = "testTemplate6.json";
    protected static final String TEST_TEMPLATE_1_JS_CLASSPATH = "/org/alfresco/repo/virtual/template/testTemplate1.js";
    protected static final String TEST_TEMPLATE_1_JSON_CLASSPATH = "/org/alfresco/repo/virtual/template/testTemplate1.json";
    protected static final String TEST_TEMPLATE_2_JSON_CLASSPATH = "/org/alfresco/repo/virtual/template/testTemplate2.json";
    protected static final String TEST_TEMPLATE_3_JSON_CLASSPATH = "/org/alfresco/repo/virtual/template/testTemplate3.json";
    protected static final String TEST_TEMPLATE_4_JSON_CLASSPATH = "/org/alfresco/repo/virtual/template/testTemplate4.json";
    protected static final String TEST_TEMPLATE_5_JSON_CLASSPATH = "/org/alfresco/repo/virtual/template/testTemplate5.json";
    protected static final String TEST_TEMPLATE_6_JSON_CLASSPATH = "/org/alfresco/repo/virtual/template/testTemplate6.json";
    protected static final String TEST_TEMPLATE_1_JSON_SYS_PATH = "C/org/alfresco/repo/virtual/template/testTemplate1.json";
    protected static final String TEST_TEMPLATE_2_JSON_SYS_PATH = "C/org/alfresco/repo/virtual/template/testTemplate2.json";
    protected static final String TEST_TEMPLATE_3_JSON_SYS_PATH = "C/org/alfresco/repo/virtual/template/testTemplate3.json";
    protected static final String TEST_TEMPLATE_4_JSON_SYS_PATH = "C/org/alfresco/repo/virtual/template/testTemplate4.json";
    protected static final String TEST_TEMPLATE_5_JSON_SYS_PATH = "C/org/alfresco/repo/virtual/template/testTemplate5.json";
    protected static final String TEST_TEMPLATE_6_JSON_SYS_PATH = "C/org/alfresco/repo/virtual/template/testTemplate6.json";
    protected static final String TEST_TEMPLATE_1_JS_SYS_PATH = "C/org/alfresco/repo/virtual/template/testTemplate1.js";
    public static final String VANILLA_PROCESSOR_JS_CLASSPATH = "/org/alfresco/repo/virtual/node/vanilla.js";
    protected static final String FORM_DATA_PROP_NAME = "prop_cm_name";
    protected static final String FORM_DATA_PROP_ALF_DEF = "alf_destination";
    protected ApplicationContext ctx;
    protected FileFolderService fileAndFolderService;
    protected ContentService contentService;
    protected TransactionService transactionService;
    protected NodeService nodeService;
    protected PermissionService permissionService;
    protected RetryingTransactionHelper retryingTransactionHelper;
    protected FileInfo testRootFolder;
    protected NodeRef virtualFolder1NodeRef;
    protected NodeRef rootNodeRef;
    protected NodeRef companyHomeNodeRef;
    protected ActualEnvironment environment;
    protected TypeAndAspectsFormProcessor typeAndAspectsFormProcessor;
    protected String txnTamperHint;
    protected UserTransaction txn;
    protected AuthenticationComponent authenticationComponent;
    protected VirtualizationConfigTestBootstrap virtualizationConfigTestBootstrap;
    protected SystemTemplateLocationsConstraint constraints;
    protected String configuredTemplatesClassPath = null;
    @Mock
    private ResultSet dbResults;
    @Mock
    private ResultSetRow resultSetRow;
    private SearchServiceSubSystemDelegator searchServiceDelegatorSpy;
    private String queryMatcher;

    @Before
    public void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext((String[])VirtualizationTest.CONFIG_LOCATIONS);
        this.virtualizationConfigTestBootstrap = (VirtualizationConfigTestBootstrap)this.ctx.getBean("virtualizationConfigTestBootstrap", VirtualizationConfigTestBootstrap.class);
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.retryingTransactionHelper = serviceRegistry.getRetryingTransactionHelper();
        this.nodeService = serviceRegistry.getNodeService();
        this.contentService = serviceRegistry.getContentService();
        this.fileAndFolderService = serviceRegistry.getFileFolderService();
        this.permissionService = serviceRegistry.getPermissionService();
        this.authenticationComponent = (AuthenticationComponent)this.ctx.getBean("authenticationComponent", AuthenticationComponent.class);
        this.environment = (ActualEnvironment)this.ctx.getBean("actualEnvironment", ActualEnvironment.class);
        this.typeAndAspectsFormProcessor = (TypeAndAspectsFormProcessor)((Object)this.ctx.getBean("typeAndAspectsFormProcessor", TypeAndAspectsFormProcessor.class));
        this.constraints = (SystemTemplateLocationsConstraint)this.ctx.getBean("systemTemplateLocations", SystemTemplateLocationsConstraint.class);
        Repository repository = (Repository)this.ctx.getBean("repositoryHelper", Repository.class);
        if (!this.virtualizationConfigTestBootstrap.areVirtualFoldersEnabled()) {
            SpringExtensionBundle vfBundle = (SpringExtensionBundle)this.ctx.getBean("smartFoldersBundle", SpringExtensionBundle.class);
            vfBundle.start();
        } else {
            logger.info((Object)"Virtual folders are spring-enabled.");
        }
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.companyHomeNodeRef = repository.getCompanyHome();
        this.testRootFolder = this.fileAndFolderService.create(this.companyHomeNodeRef, TEST_ROOT_FOLDER_NAME, ContentModel.TYPE_FOLDER);
        this.virtualFolder1NodeRef = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), VIRTUAL_FOLDER_1_NAME, TEST_TEMPLATE_1_JSON_SYS_PATH);
        this.rootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.setupMocks();
    }

    @After
    public void tearDown() throws Exception {
        if (!this.virtualizationConfigTestBootstrap.areVirtualFoldersEnabled()) {
            SpringExtensionBundle vfBundle = (SpringExtensionBundle)this.ctx.getBean("smartFoldersBundle", SpringExtensionBundle.class);
            vfBundle.stop();
        }
        if (this.configuredTemplatesClassPath != null) {
            this.constraints.setTemplatesParentClasspath(this.configuredTemplatesClassPath);
            this.configuredTemplatesClassPath = null;
        }
        this.authenticationComponent.clearCurrentSecurityContext();
        try {
            this.txn.rollback();
        }
        catch (Exception e) {
            logger.error((Object)("Test tear down failed. Has the test setup transaction been tempered with ? Hint : " + this.txnTamperHint), (Throwable)e);
        }
    }

    protected NodeRef createVirtualizedFolder(NodeRef parent, String name, String templateSysPath) {
        Item testItem = new Item("typeAndAspects", "cm:folder,smf:systemConfigSmartFolder");
        FormData testFormData = new FormData();
        testFormData.addFieldData(FORM_DATA_PROP_NAME, (Object)name);
        if (templateSysPath != null) {
            testFormData.addFieldData(PROP_VM_TEMPLATE_CLASSPATH, (Object)templateSysPath);
        }
        testFormData.addFieldData(FORM_DATA_PROP_ALF_DEF, (Object)parent.toString());
        return (NodeRef)this.typeAndAspectsFormProcessor.persist(testItem, testFormData);
    }

    protected void assertVirtualNode(NodeRef nodeRef) {
        this.assertVirtualNode(nodeRef, Collections.emptyMap());
    }

    protected void assertVirtualNode(NodeRef nodeRef, Map<QName, Serializable> expectedProperties) {
        Assert.assertNotNull((Object)Reference.fromNodeRef((NodeRef)nodeRef));
        Assert.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, VirtualContentModel.ASPECT_VIRTUAL));
        Set aspects = this.nodeService.getAspects(nodeRef);
        Assert.assertTrue((String)"Smart virtual node missing virtual aspect", (boolean)aspects.contains(VirtualContentModel.ASPECT_VIRTUAL));
        Assert.assertTrue((String)"Smaft virtual node missing titled aspect", (boolean)aspects.contains(ContentModel.ASPECT_TITLED));
        Map nodeProperties = this.nodeService.getProperties(nodeRef);
        List<QName> mandatoryProperties = Arrays.asList(ContentModel.PROP_STORE_IDENTIFIER, ContentModel.PROP_STORE_PROTOCOL, ContentModel.PROP_LOCALE, ContentModel.PROP_MODIFIED, ContentModel.PROP_MODIFIER, ContentModel.PROP_CREATED, ContentModel.PROP_CREATOR, ContentModel.PROP_NODE_DBID, ContentModel.PROP_DESCRIPTION);
        HashSet<QName> missingPropreties = new HashSet<QName>(mandatoryProperties);
        missingPropreties.removeAll(nodeProperties.keySet());
        Assert.assertTrue((String)("Mandatory properties are missing" + String.valueOf(missingPropreties)), (boolean)missingPropreties.isEmpty());
        Assert.assertFalse((String)"ACE-5303 : ContentModel.PROP_TITLE should remain unset", (boolean)nodeProperties.containsKey(ContentModel.PROP_TITLE));
        Set<Map.Entry<QName, Serializable>> epEntries = expectedProperties.entrySet();
        StringBuilder unexpectedBuilder = new StringBuilder();
        for (Map.Entry<QName, Serializable> entry : epEntries) {
            Serializable actualValue = (Serializable)nodeProperties.get(entry.getKey());
            Serializable expectedValue = expectedProperties.get(entry.getKey());
            boolean fail = false;
            String expectedValueStr = null;
            if (expectedValue != null) {
                expectedValueStr = expectedValue.toString();
                if (!expectedValue.equals(actualValue)) {
                    fail = true;
                }
            } else if (actualValue != null) {
                fail = true;
                expectedValueStr = "<null>";
            }
            if (!fail) continue;
            unexpectedBuilder.append("\n");
            unexpectedBuilder.append(entry.getKey());
            unexpectedBuilder.append(" expected[");
            unexpectedBuilder.append(expectedValueStr);
            unexpectedBuilder.append("] != actua[");
            unexpectedBuilder.append(actualValue);
            unexpectedBuilder.append("]");
        }
        String unexpectedStr = unexpectedBuilder.toString();
        Assert.assertTrue((String)("Unexpected property values : " + unexpectedStr), (boolean)unexpectedStr.isEmpty());
    }

    protected ChildAssociationRef createTypedNode(NodeRef parent, String name, QName type) {
        return this.createTypedNode(parent, name, type, new HashMap<QName, Serializable>());
    }

    protected ChildAssociationRef createTypedNode(NodeRef parent, String name, QName type, HashMap<QName, Serializable> properties) {
        HashMap<QName, Serializable> newProperties = new HashMap<QName, Serializable>(properties);
        newProperties.put(ContentModel.PROP_NAME, (Serializable)((Object)name));
        QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)name));
        return this.nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, assocQName, type, newProperties);
    }

    protected ChildAssociationRef createFolder(NodeRef parent, String name) {
        return this.createTypedNode(parent, name, ContentModel.TYPE_FOLDER);
    }

    protected ChildAssociationRef createFolder(NodeRef parent, String name, HashMap<QName, Serializable> properties) {
        return this.createTypedNode(parent, name, ContentModel.TYPE_FOLDER, properties);
    }

    protected ChildAssociationRef createContent(NodeRef parent, String name) {
        return this.createTypedNode(parent, name, ContentModel.TYPE_CONTENT);
    }

    protected ChildAssociationRef createContent(NodeRef parent, String name, InputStream stream, String mimeType, String encoding) {
        return this.createContent(parent, name, stream, mimeType, encoding, ContentModel.TYPE_CONTENT);
    }

    protected ChildAssociationRef createContent(NodeRef parent, String name, InputStream stream, String mimeType, String encoding, QName nodeType) {
        ChildAssociationRef nodeAssoc = this.createTypedNode(parent, name, nodeType);
        NodeRef child = nodeAssoc.getChildRef();
        ContentWriter writer = this.contentService.getWriter(child, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(mimeType);
        writer.setEncoding(encoding);
        writer.putContent(stream);
        return nodeAssoc;
    }

    protected ChildAssociationRef createContent(NodeRef parent, String name, String contentString, String mimeType, String encoding) {
        ChildAssociationRef nodeAssoc = this.createTypedNode(parent, name, ContentModel.TYPE_CONTENT);
        NodeRef child = nodeAssoc.getChildRef();
        ContentWriter writer = this.contentService.getWriter(child, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(mimeType);
        writer.setEncoding(encoding);
        writer.putContent(contentString);
        return nodeAssoc;
    }

    protected void setupMocks() {
        SearchServiceSubSystemDelegator searchServiceDelegator = (SearchServiceSubSystemDelegator)this.ctx.getBean("searchService");
        this.searchServiceDelegatorSpy = (SearchServiceSubSystemDelegator)Mockito.spy((Object)searchServiceDelegator);
        searchServiceDelegator.setSubSystem((SearchService)this.searchServiceDelegatorSpy);
        ((SearchServiceSubSystemDelegator)Mockito.doReturn((Object)this.dbResults).when((Object)this.searchServiceDelegatorSpy)).query((SearchParameters)ArgumentMatchers.argThat(this.getArgMatcher()));
    }

    protected void prepareMocks(String queryMatcher, NodeRef realNodeToReturn) {
        this.queryMatcher = queryMatcher;
        ArrayList<ResultSetRow> dbRows = new ArrayList<ResultSetRow>();
        dbRows.add(this.resultSetRow);
        Mockito.when((Object)this.resultSetRow.getNodeRef()).thenReturn((Object)realNodeToReturn);
        this.prepareMocksCommon(dbRows);
    }

    protected void prepareMocks(String queryMatcher, List<NodeRef> realNodesToReturn) {
        this.queryMatcher = queryMatcher;
        ArrayList<ResultSetRow> dbRows = new ArrayList<ResultSetRow>();
        for (NodeRef node : realNodesToReturn) {
            ResultSetRow mock = (ResultSetRow)Mockito.mock(ResultSetRow.class);
            dbRows.add(mock);
            Mockito.when((Object)mock.getNodeRef()).thenReturn((Object)node);
        }
        this.prepareMocksCommon(dbRows);
    }

    protected void prepareMocksCommon(final List<ResultSetRow> dbRows) {
        Mockito.when((Object)this.dbResults.iterator()).thenAnswer((Answer)new Answer<Iterator<ResultSetRow>>(){

            public Iterator<ResultSetRow> answer(InvocationOnMock invocation) throws Throwable {
                return dbRows.iterator();
            }
        });
        Mockito.when((Object)this.dbResults.hasMore()).thenReturn((Object)false);
        Mockito.when((Object)this.dbResults.getNumberFound()).thenReturn((Object)dbRows.size());
        Mockito.when((Object)this.dbResults.getStart()).thenReturn((Object)0);
    }

    protected void resetMocks() {
        this.queryMatcher = null;
    }

    protected ArgumentMatcher<SearchParameters> getArgMatcher() {
        return argument -> {
            String matchingString;
            return argument != null && (matchingString = this.getMatchingString()) != null && argument.toString().contains(matchingString);
        };
    }

    protected String getMatchingString() {
        return this.queryMatcher;
    }
}

