/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.archive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.node.archive.ArchivedNodeEntity;
import org.alfresco.repo.node.archive.GetArchivedNodesCannedQueryParams;
import org.alfresco.repo.security.permissions.impl.acegi.AbstractCannedQueryPermissions;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetArchivedNodesCannedQuery
extends AbstractCannedQueryPermissions<ArchivedNodeEntity> {
    private Log logger = LogFactory.getLog(GetArchivedNodesCannedQuery.class);
    private static final String QUERY_NAMESPACE = "alfresco.query.archivednodes";
    private static final String QUERY_SELECT_GET_ARCHIVED_NODES = "select_GetArchivedNodesCannedQuery";
    private static final String QUERY_SELECT_COUNT_ARCHIVED_NODES = "select_CountAllArchivedNodes";
    private CannedQueryDAO cannedQueryDAO;
    private NodeDAO nodeDAO;

    public GetArchivedNodesCannedQuery(CannedQueryDAO cannedQueryDAO, NodeDAO nodeDAO, MethodSecurityBean<ArchivedNodeEntity> methodSecurity, CannedQueryParameters params) {
        super(params, methodSecurity);
        this.cannedQueryDAO = cannedQueryDAO;
        this.nodeDAO = nodeDAO;
    }

    protected List<ArchivedNodeEntity> queryAndFilter(CannedQueryParameters parameters) {
        Long start = this.logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        Object paramBeanObj = parameters.getParameterBean();
        if (paramBeanObj == null) {
            throw new NullPointerException("Null GetArchivedNodes query params");
        }
        GetArchivedNodesCannedQueryParams paramBean = (GetArchivedNodesCannedQueryParams)paramBeanObj;
        if (paramBean.getParentNodeId() == null || paramBean.getParentNodeId() < 0L) {
            return Collections.emptyList();
        }
        int offset = parameters.getPageDetails().getSkipResults();
        int limit = parameters.getPageDetails().getPageSize();
        List<ArchivedNodeEntity> results = this.cannedQueryDAO.executeQuery(QUERY_NAMESPACE, QUERY_SELECT_GET_ARCHIVED_NODES, paramBean, offset, limit);
        ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>(results.size());
        for (ArchivedNodeEntity entity : results) {
            nodeRefs.add(entity.getNodeRef());
        }
        this.preload(nodeRefs);
        if (start != null) {
            this.logger.debug((Object)("Base query: " + nodeRefs.size() + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return results;
    }

    private void preload(List<NodeRef> nodeRefs) {
        Long start = this.logger.isTraceEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        this.nodeDAO.cacheNodes(nodeRefs);
        if (start != null) {
            this.logger.trace((Object)("Pre-load: " + nodeRefs.size() + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
    }

    @Override
    protected Pair<Integer, Integer> getTotalResultCount(List<ArchivedNodeEntity> results) {
        Object paramBeanObj = super.getParameters().getParameterBean();
        if (paramBeanObj == null) {
            throw new NullPointerException("Required parameters not provided for GetArchivedNodes canned query, unexpected null value for query params");
        }
        GetArchivedNodesCannedQueryParams paramBean = (GetArchivedNodesCannedQueryParams)paramBeanObj;
        if (paramBean.getParentNodeId() == null) {
            throw new NullPointerException("Required parameters not provided for GetArchivedNodes canned queryUnexpected null value for parentNodeId");
        }
        Long totalResultCountLongValue = this.cannedQueryDAO.executeCountQuery(QUERY_NAMESPACE, QUERY_SELECT_COUNT_ARCHIVED_NODES, paramBean);
        int totalResultCount = totalResultCountLongValue.intValue();
        if (totalResultCount < 0) {
            totalResultCount = Integer.MAX_VALUE;
        }
        return new Pair((Object)totalResultCount, (Object)totalResultCount);
    }

    protected boolean isApplyPostQueryPaging() {
        return false;
    }
}

