/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remoteconnector;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorRequest;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class RemoteConnectorRequestImpl
implements RemoteConnectorRequest {
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    private final String url;
    private final String methodName;
    private final HttpMethodBase method;
    private final List<Header> headers = new ArrayList<Header>();
    private RequestEntity requestBody;

    public RemoteConnectorRequestImpl(String url, String methodName) {
        this(url, RemoteConnectorRequestImpl.buildHttpClientMethod(url, methodName));
    }

    public RemoteConnectorRequestImpl(String url, Class<? extends HttpMethodBase> method) {
        this(url, RemoteConnectorRequestImpl.buildHttpClientMethod(url, method));
    }

    private RemoteConnectorRequestImpl(String url, HttpMethodBase method) {
        this.url = url;
        this.method = method;
        this.methodName = method.getName();
    }

    protected static HttpMethodBase buildHttpClientMethod(String url, String method) {
        if ("GET".equals(method)) {
            return new GetMethod(url);
        }
        if ("POST".equals(method)) {
            return new PostMethod(url);
        }
        if ("PUT".equals(method)) {
            return new PutMethod(url);
        }
        if ("DELETE".equals(method)) {
            return new DeleteMethod(url);
        }
        if ("TESTING".equals(method)) {
            return new TestingMethod(url);
        }
        throw new UnsupportedOperationException("Method '" + method + "' not supported");
    }

    protected static HttpMethodBase buildHttpClientMethod(String url, Class<? extends HttpMethodBase> method) {
        HttpMethodBase request = null;
        try {
            request = method.getConstructor(String.class).newInstance(url);
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("HttpClient broken", (Throwable)e);
        }
        return request;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getMethod() {
        return this.methodName;
    }

    public HttpMethodBase getMethodInstance() {
        return this.method;
    }

    @Override
    public String getContentType() {
        for (Header hdr : this.headers) {
            if (!HEADER_CONTENT_TYPE.equals(hdr.getName())) continue;
            return hdr.getValue();
        }
        return null;
    }

    @Override
    public void setContentType(String contentType) {
        for (Header hdr : this.headers) {
            if (!HEADER_CONTENT_TYPE.equals(hdr.getName())) continue;
            hdr.setValue(contentType);
            return;
        }
        this.headers.add(new Header(HEADER_CONTENT_TYPE, contentType));
    }

    public RequestEntity getRequestBody() {
        return this.requestBody;
    }

    @Override
    public void setRequestBody(String body) {
        try {
            this.requestBody = new StringRequestEntity(body, this.getContentType(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    @Override
    public void setRequestBody(byte[] body) {
        this.requestBody = new ByteArrayRequestEntity(body);
    }

    @Override
    public void setRequestBody(InputStream body) {
        this.requestBody = new InputStreamRequestEntity(body);
    }

    @Override
    public void setRequestBody(RequestEntity body) {
        this.requestBody = body;
    }

    @Override
    public Header[] getRequestHeaders() {
        return this.headers.toArray(new Header[this.headers.size()]);
    }

    @Override
    public void addRequestHeader(Header header) {
        this.addRequestHeaders(new Header[]{header});
    }

    @Override
    public void addRequestHeader(String name, String value) {
        this.addRequestHeader(new Header(name, value));
    }

    @Override
    public void addRequestHeaders(Header[] headers) {
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header newHdr = headerArray[n2];
            Header existingHdr = null;
            for (Header hdr : this.headers) {
                if (!newHdr.getName().equals(hdr.getName())) continue;
                existingHdr = hdr;
            }
            if (existingHdr != null) {
                existingHdr.setValue(newHdr.getValue());
            } else {
                this.headers.add(newHdr);
            }
            ++n2;
        }
    }

    private static class TestingMethod
    extends GetMethod {
        private static final String METHOD_NAME = "TESTING";

        private TestingMethod(String url) {
            super(url);
        }

        public String getName() {
            return METHOD_NAME;
        }
    }
}

