/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class FileFolderDuplicateChildTest
extends TestCase {
    private static final ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuthenticationComponent authenticationComponent;
    private TransactionService transactionService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private NodeRef rootNodeRef;
    private NodeRef workingRootNodeRef;
    private static ThreadGroup threadGroup = new ThreadGroup("FileFolderDuplicateChildTest");
    private static int threadNumber = -1;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.retryingTransactionHelper = this.transactionService.getRetryingTransactionHelper();
        this.nodeService = serviceRegistry.getNodeService();
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> callback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                FileFolderDuplicateChildTest.this.authenticationComponent.setCurrentUser(FileFolderDuplicateChildTest.this.authenticationComponent.getSystemUserName());
                StoreRef storeRef = FileFolderDuplicateChildTest.this.nodeService.createStore("workspace", FileFolderDuplicateChildTest.this.getName() + System.currentTimeMillis());
                FileFolderDuplicateChildTest.this.rootNodeRef = FileFolderDuplicateChildTest.this.nodeService.getRootNode(storeRef);
                NodeRef nodeRef = FileFolderDuplicateChildTest.this.nodeService.createNode(FileFolderDuplicateChildTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"working root"), ContentModel.TYPE_FOLDER).getChildRef();
                return nodeRef;
            }
        };
        this.workingRootNodeRef = (NodeRef)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
    }

    public void tearDown() throws Exception {
    }

    public void testDuplicateChildNameDetection() throws Exception {
        CreateFileCallback callback = new CreateFileCallback(0);
        FileInfo fileInfo = (FileInfo)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        FileFolderDuplicateChildTest.assertEquals((String)"Incorrect initial filename", (String)"F0", (String)fileInfo.getName());
        int threadCount = 10;
        CountDownLatch endLatch = new CountDownLatch(threadCount);
        WorkerThread[] workers = new WorkerThread[threadCount];
        int i = 0;
        while (i < threadCount) {
            workers[i] = new WorkerThread(endLatch);
            workers[i].start();
            ++i;
        }
        endLatch.await(300L, TimeUnit.SECONDS);
        int failureCount = 0;
        int didNotCompleteCount = 0;
        int i2 = 0;
        while (i2 < threadCount) {
            if (workers[i2].error != null) {
                ++failureCount;
            } else if (workers[i2].success == null) {
                ++didNotCompleteCount;
            }
            ++i2;
        }
        System.out.println(failureCount + " of the " + threadCount + " threads failed and " + didNotCompleteCount + " did not finish.");
        FileFolderDuplicateChildTest.assertEquals((String)"Some failures", (int)0, (int)failureCount);
        FileFolderDuplicateChildTest.assertEquals((String)"Some non-finishes", (int)0, (int)didNotCompleteCount);
    }

    private class CreateFileCallback
    implements RetryingTransactionHelper.RetryingTransactionCallback<FileInfo> {
        private final int number;

        public CreateFileCallback(int number) {
            this.number = number;
        }

        public FileInfo execute() throws Throwable {
            FileFolderDuplicateChildTest.this.authenticationComponent.setCurrentUser(FileFolderDuplicateChildTest.this.authenticationComponent.getSystemUserName());
            return FileFolderDuplicateChildTest.this.fileFolderService.create(FileFolderDuplicateChildTest.this.workingRootNodeRef, "F" + this.number, ContentModel.TYPE_CONTENT);
        }
    }

    private class WorkerThread
    extends Thread {
        private CountDownLatch endLatch;
        private Throwable error;
        private FileInfo success;

        public WorkerThread(CountDownLatch endLatch) {
            super(threadGroup, "Worker " + ++threadNumber);
            this.endLatch = endLatch;
        }

        @Override
        public void run() {
            FileInfo fileInfo = null;
            int number = 0;
            while (true) {
                CreateFileCallback callback = new CreateFileCallback(number);
                try {
                    System.out.println("Thread " + this.getName() + " attempting file: " + number);
                    System.out.flush();
                    this.success = fileInfo = (FileInfo)FileFolderDuplicateChildTest.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
                }
                catch (FileExistsException fileExistsException) {
                    ++number;
                    continue;
                }
                catch (Throwable e) {
                    this.error = e;
                }
                break;
            }
            if (this.error != null) {
                System.err.println("Thread " + this.getName() + " failed to create file " + number + ":");
                System.err.flush();
                this.error.printStackTrace();
            } else {
                System.out.println("\t\t\tThread " + this.getName() + " created file: " + this.success.getName());
                System.out.flush();
            }
            this.endLatch.countDown();
        }
    }
}

