/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.mapping.AbstractProperty;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

public class ContentStreamMimetypeProperty
extends AbstractProperty {
    public ContentStreamMimetypeProperty(ServiceRegistry serviceRegistry, CMISConnector connector) {
        super(serviceRegistry, connector, "cmis:contentStreamMimeType");
    }

    @Override
    public Serializable getValueInternal(CMISNodeInfo nodeInfo) {
        ContentData contentData = this.getContentData(nodeInfo);
        if (contentData != null) {
            return contentData.getMimetype();
        }
        return null;
    }

    public String getLuceneFieldName() {
        StringBuilder field = new StringBuilder(128);
        field.append("@");
        field.append(ContentModel.PROP_CONTENT);
        field.append(".mimetype");
        return field.toString();
    }

    @Override
    public QName getMappedProperty() {
        return GetChildrenCannedQuery.SORT_QNAME_CONTENT_MIMETYPE;
    }

    protected String getValueAsString(Serializable value) {
        Object converted = DefaultTypeConverter.INSTANCE.convert(this.getServiceRegistry().getDictionaryService().getDataType(DataTypeDefinition.TEXT), (Object)value);
        String asString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, converted);
        return asString;
    }

    protected QName getQNameForExists() {
        return ContentModel.PROP_CONTENT;
    }

    protected DataTypeDefinition getInDataType() {
        return this.getServiceRegistry().getDictionaryService().getDataType(DataTypeDefinition.TEXT);
    }
}

