/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.icegreen.greenmail.foedus.util.MsgRangeFilter;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.FolderListener;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.MessageFlags;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import jakarta.mail.Flags;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.search.SearchTerm;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ImapModel;
import org.alfresco.repo.imap.AbstractImapFolder;
import org.alfresco.repo.imap.AbstractMimeMessage;
import org.alfresco.repo.imap.AlfrescoImapConst;
import org.alfresco.repo.imap.ImapModelMessage;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.repo.imap.IncomingImapMessage;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.GUID;
import org.alfresco.util.Utf7;

public class AlfrescoImapFolder
extends AbstractImapFolder
implements Serializable {
    private static final long serialVersionUID = -7223111284066976111L;
    private final FileInfo folderInfo;
    private final String folderName;
    private final String folderPath;
    private final String userName;
    private final int mountPointId;
    private final AlfrescoImapConst.ImapViewMode viewMode;
    private final ImapService imapService;
    private final boolean selectable;
    private final boolean extractAttachmentsEnabled;
    private ImapService.FolderStatus folderStatus;
    private static final Flags PERMANENT_FLAGS = new Flags();

    static {
        PERMANENT_FLAGS.add(Flags.Flag.ANSWERED);
        PERMANENT_FLAGS.add(Flags.Flag.DELETED);
        PERMANENT_FLAGS.add(Flags.Flag.DRAFT);
        PERMANENT_FLAGS.add(Flags.Flag.FLAGGED);
        PERMANENT_FLAGS.add(Flags.Flag.SEEN);
    }

    public boolean isExtractAttachmentsEnabled() {
        return this.extractAttachmentsEnabled;
    }

    AlfrescoImapFolder(String userName, ImapService imapService, ServiceRegistry serviceRegistry) {
        this(null, userName, "", "", null, imapService, serviceRegistry, false, false, 0);
    }

    public AlfrescoImapFolder(FileInfo folderInfo, String userName, String folderName, String folderPath, AlfrescoImapConst.ImapViewMode viewMode, boolean extractAttachmentsEnabled, ImapService imapService, ServiceRegistry serviceRegistry, int mountPointId) {
        this(folderInfo, userName, folderName, folderPath, viewMode, imapService, serviceRegistry, null, extractAttachmentsEnabled, mountPointId);
    }

    public AlfrescoImapFolder(FileInfo folderInfo, String userName, String folderName, String folderPath, AlfrescoImapConst.ImapViewMode viewMode, ImapService imapService, ServiceRegistry serviceRegistry, Boolean selectable, boolean extractAttachmentsEnabled, int mountPointId) {
        super(serviceRegistry);
        Boolean storedSelectable;
        this.folderInfo = folderInfo;
        this.userName = userName;
        this.folderName = folderName != null ? folderName : (folderInfo != null ? folderInfo.getName() : null);
        this.folderPath = folderPath;
        this.viewMode = viewMode != null ? viewMode : AlfrescoImapConst.ImapViewMode.ARCHIVE;
        this.extractAttachmentsEnabled = extractAttachmentsEnabled;
        this.imapService = imapService;
        this.selectable = folderInfo != null ? (selectable == null ? ((storedSelectable = Boolean.valueOf(!serviceRegistry.getNodeService().hasAspect(folderInfo.getNodeRef(), ImapModel.ASPECT_IMAP_FOLDER_NONSELECTABLE))) == null ? true : storedSelectable) : selectable) : false;
        this.mountPointId = mountPointId;
    }

    public String getFullName() {
        return Utf7.encode("#mail/" + this.userName + "/" + this.getFolderPath(), "X-MODIFIED-UTF-7");
    }

    public String getName() {
        return this.folderName;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    private NavigableMap<Long, FileInfo> searchMails() {
        return this.getFolderStatus().search;
    }

    public boolean reset() {
        this.folderStatus = null;
        return (Boolean)new AbstractImapFolder.CommandCallback<Boolean>((AbstractImapFolder)this){

            @Override
            public Boolean command() throws Throwable {
                return AlfrescoImapFolder.this.serviceRegistry.getNodeService().exists(AlfrescoImapFolder.this.folderInfo.getNodeRef());
            }
        }.run(true);
    }

    protected ImapService.FolderStatus getFolderStatus() {
        AbstractImapFolder.CommandCallback<ImapService.FolderStatus> command = new AbstractImapFolder.CommandCallback<ImapService.FolderStatus>((AbstractImapFolder)this){

            @Override
            public ImapService.FolderStatus command() throws Throwable {
                return AlfrescoImapFolder.this.imapService.getFolderStatus(AlfrescoImapFolder.this.userName, AlfrescoImapFolder.this.folderInfo.getNodeRef(), AlfrescoImapFolder.this.viewMode);
            }
        };
        this.folderStatus = (ImapService.FolderStatus)command.run();
        return this.folderStatus;
    }

    @Override
    protected long appendMessageInternal(MimeMessage message, Flags flags, Date internalDate) throws FileExistsException, FileNotFoundException, IOException, MessagingException {
        NodeRef sourceNodeRef = this.extractNodeRef(message);
        long uid = sourceNodeRef != null ? this.copyOrMoveNode(this.folderInfo, message, flags, sourceNodeRef, false) : this.createMimeMessageInFolder(this.folderInfo, message, flags);
        this.folderStatus = null;
        return uid;
    }

    private long copyOrMoveNode(FileInfo folderInfo, MimeMessage message, Flags flags, NodeRef sourceNodeRef, boolean move) throws FileExistsException, FileNotFoundException {
        FileFolderService fileFolderService = this.serviceRegistry.getFileFolderService();
        FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.imap);
        FileInfo messageFile = null;
        if (move) {
            fileFolderService.setHidden(sourceNodeRef, false);
            messageFile = fileFolderService.move(sourceNodeRef, folderInfo.getNodeRef(), null);
        } else {
            NodeRef newNodeRef = this.serviceRegistry.getCopyService().copyAndRename(sourceNodeRef, folderInfo.getNodeRef(), ContentModel.ASSOC_CONTAINS, null, false);
            fileFolderService.setHidden(newNodeRef, false);
            messageFile = fileFolderService.getFileInfo(newNodeRef);
        }
        long newMessageUid = (Long)messageFile.getProperties().get(ContentModel.PROP_NODE_DBID);
        this.imapService.persistMessageHeaders(messageFile.getNodeRef(), message);
        Flags newFlags = new Flags(flags);
        newFlags.add(Flags.Flag.RECENT);
        this.imapService.setFlags(messageFile, newFlags, true);
        this.imapService.setFlag(messageFile, Flags.Flag.DELETED, false);
        return newMessageUid;
    }

    private NodeRef extractNodeRef(MimeMessage message) {
        String uuid = null;
        String messageId = null;
        NodeRef result = null;
        NodeService nodeService = this.serviceRegistry.getNodeService();
        try {
            messageId = message.getMessageID();
        }
        catch (MessagingException messagingException) {}
        if (messageId != null) {
            if (messageId.startsWith("<")) {
                messageId = messageId.substring(1);
            }
            if (!nodeService.exists(result = new NodeRef("workspace", "SpacesStore", uuid = messageId.indexOf("@") != -1 ? messageId.substring(0, messageId.indexOf("@")) : messageId))) {
                result = null;
            }
        }
        if (result == null) {
            try {
                if (message.getHeader("X-Alfresco-NodeRef-ID") != null && !nodeService.exists(result = new NodeRef("workspace", "SpacesStore", uuid = message.getHeader("X-Alfresco-NodeRef-ID")[0]))) {
                    result = null;
                }
            }
            catch (MessagingException messagingException) {}
        }
        return result;
    }

    private boolean isMoveOperation(NodeRef sourceNodeRef) {
        FileFolderService fileFolderService;
        FileInfo node;
        NodeService nodeService;
        return sourceNodeRef != null && (nodeService = this.serviceRegistry.getNodeService()).exists(sourceNodeRef) && (node = (fileFolderService = this.serviceRegistry.getFileFolderService()).getFileInfo(sourceNodeRef)) != null && fileFolderService.isHidden(sourceNodeRef);
    }

    @Override
    protected long copyMessageInternal(long uid, MailFolder toFolder) throws MessagingException, FileExistsException, FileNotFoundException, IOException {
        AlfrescoImapFolder toImapMailFolder = (AlfrescoImapFolder)toFolder;
        NodeRef destFolderNodeRef = toImapMailFolder.getFolderInfo().getNodeRef();
        FileInfo sourceMessageFileInfo = (FileInfo)this.searchMails().get(uid);
        if (this.serviceRegistry.getNodeService().hasAspect(sourceMessageFileInfo.getNodeRef(), ImapModel.ASPECT_IMAP_CONTENT)) {
            ImapModelMessage newMessage = new ImapModelMessage(sourceMessageFileInfo, this.serviceRegistry, true);
            return toImapMailFolder.appendMessageInternal(newMessage, this.imapService.getFlags(sourceMessageFileInfo), new Date());
        }
        String fileName = (String)((Object)this.serviceRegistry.getNodeService().getProperty(sourceMessageFileInfo.getNodeRef(), ContentModel.PROP_NAME));
        String newFileName = this.imapService.generateUniqueFilename(destFolderNodeRef, fileName);
        FileInfo messageFileInfo = this.serviceRegistry.getFileFolderService().copy(sourceMessageFileInfo.getNodeRef(), destFolderNodeRef, newFileName);
        return (Long)messageFileInfo.getProperties().get(ContentModel.PROP_NODE_DBID);
    }

    @Override
    public void deleteAllMessagesInternal() throws FolderException {
        if (this.isReadOnly()) {
            throw new FolderException("Can't delete all - Permission denied");
        }
        for (Map.Entry entry : this.searchMails().entrySet()) {
            this.imapService.setFlag((FileInfo)entry.getValue(), Flags.Flag.DELETED, true);
        }
    }

    @Override
    protected void expungeInternal() throws FolderException {
        if (this.isReadOnly()) {
            throw new FolderException("Can't expunge - Permission denied");
        }
        for (Map.Entry entry : this.searchMails().entrySet()) {
            this.imapService.expungeMessage((FileInfo)entry.getValue());
        }
    }

    @Override
    protected void expungeInternal(long uid) throws Exception {
        if (this.isReadOnly()) {
            throw new FolderException("Can't expunge - Permission denied");
        }
        FileInfo messageFileInfo = (FileInfo)this.searchMails().get(uid);
        this.imapService.expungeMessage(messageFileInfo);
    }

    public int getFirstUnseen() {
        return this.getFolderStatus().firstUnseen;
    }

    @Override
    protected SimpleStoredMessage getMessageInternal(long uid) throws MessagingException {
        FileInfo mesInfo;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[getMessageInternal] " + String.valueOf(this)));
        }
        if ((mesInfo = (FileInfo)this.searchMails().get(uid)) == null) {
            return null;
        }
        return this.imapService.getMessage(mesInfo);
    }

    public int getMessageCount() {
        return this.getFolderStatus().messageCount;
    }

    public long[] getMessageUids() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[getMessageUidsInternal] " + String.valueOf(this)));
        }
        Set uidSet = this.searchMails().keySet();
        long[] uids = new long[uidSet.size()];
        int i = 0;
        for (Long uid : uidSet) {
            uids[i++] = uid;
        }
        return uids;
    }

    @Override
    protected List<SimpleStoredMessage> getMessagesInternal() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[getMessagesInternal] " + String.valueOf(this)));
        }
        return this.convertToMessages(this.searchMails().values());
    }

    private List<SimpleStoredMessage> convertToMessages(Collection<FileInfo> fileInfos) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[convertToMessages] " + String.valueOf(this)));
        }
        if (fileInfos == null || fileInfos.size() == 0) {
            this.logger.debug((Object)"[convertToMessages] - fileInfos is empty or null");
            return Collections.emptyList();
        }
        LinkedList<SimpleStoredMessage> result = new LinkedList<SimpleStoredMessage>();
        for (FileInfo fileInfo : fileInfos) {
            try {
                result.add(this.imapService.createImapMessage(fileInfo, true));
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("[convertToMessages] Message added: " + fileInfo.getName()));
            }
            catch (MessagingException e) {
                this.logger.warn((Object)("[convertToMessages] Invalid message! File name:" + fileInfo.getName()), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    protected List<SimpleStoredMessage> getMessagesInternal(MsgRangeFilter msgRangeFilter) {
        throw new UnsupportedOperationException("IMAP implementation doesn't support POP3 requests");
    }

    public int getMsn(long uid) throws FolderException {
        NavigableMap<Long, FileInfo> messages = this.searchMails();
        if (!messages.containsKey(uid)) {
            throw new FolderException("No such message.");
        }
        return messages.headMap(uid, true).size();
    }

    @Override
    protected List<SimpleStoredMessage> getNonDeletedMessagesInternal() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[getNonDeletedMessagesInternal] " + String.valueOf(this)));
        }
        ArrayList<SimpleStoredMessage> result = new ArrayList<SimpleStoredMessage>();
        List<SimpleStoredMessage> values = this.getMessagesInternal();
        for (SimpleStoredMessage message : values) {
            if (this.getFlags(message).contains(Flags.Flag.DELETED)) continue;
            result.add(message);
        }
        if (this.logger.isDebugEnabled() && this.folderInfo != null) {
            this.logger.debug((Object)(this.folderInfo.getName() + " - Non deleted messages count:" + result.size()));
        }
        return result;
    }

    public Flags getPermanentFlags() {
        return PERMANENT_FLAGS;
    }

    public int getRecentCount(boolean reset) {
        int recent;
        block3: {
            recent = this.getFolderStatus().recentCount;
            if (reset && recent > 0) {
                AbstractImapFolder.CommandCallback<Void> command = new AbstractImapFolder.CommandCallback<Void>((AbstractImapFolder)this){

                    @Override
                    public Void command() throws Throwable {
                        for (FileInfo fileInfo : AlfrescoImapFolder.this.folderStatus.search.values()) {
                            Flags flags = AlfrescoImapFolder.this.imapService.getFlags(fileInfo);
                            if (!flags.contains(Flags.Flag.RECENT)) continue;
                            AlfrescoImapFolder.this.imapService.setFlag(fileInfo, Flags.Flag.RECENT, false);
                        }
                        return null;
                    }
                };
                try {
                    command.run();
                }
                catch (AccessDeniedException accessDeniedException) {
                    if (!this.logger.isDebugEnabled()) break block3;
                    this.logger.debug((Object)"Access denied to reset RECENT FLAG");
                }
            }
        }
        return recent;
    }

    public long getUidNext() {
        NavigableMap<Long, FileInfo> search = this.getFolderStatus().search;
        return search.isEmpty() ? 1L : (Long)search.lastKey() + 1L;
    }

    public long getUidValidity() {
        return this.getFolderStatus().uidValidity / 1000L + (long)this.mountPointId;
    }

    public int getUnseenCount() {
        return this.getFolderStatus().unseenCount;
    }

    @Override
    protected void replaceFlagsInternal(Flags flags, long uid, FolderListener silentListener, boolean addUid) throws FolderException, MessagingException {
        int msn = this.getMsn(uid);
        FileInfo fileInfo = (FileInfo)this.searchMails().get(uid);
        this.imapService.setFlags(fileInfo, MessageFlags.ALL_FLAGS, false);
        this.imapService.setFlags(fileInfo, flags, true);
        Long uidNotification = addUid ? Long.valueOf(uid) : null;
        this.notifyFlagUpdate(msn, flags, uidNotification, silentListener);
    }

    @Override
    protected long[] searchInternal(SearchTerm searchTerm) {
        List<SimpleStoredMessage> messages = this.getMessages();
        long[] result = new long[messages.size()];
        int i = 0;
        for (SimpleStoredMessage message : messages) {
            if (!searchTerm.match((Message)message.getMimeMessage())) continue;
            result[i] = message.getUid();
            ++i;
        }
        return Arrays.copyOfRange(result, 0, i);
    }

    @Override
    protected void setFlagsInternal(Flags flags, boolean value, long uid, FolderListener silentListener, boolean addUid) throws MessagingException, FolderException {
        int msn = this.getMsn(uid);
        FileInfo fileInfo = (FileInfo)this.searchMails().get(uid);
        this.imapService.setFlags(fileInfo, flags, value);
        Long uidNotification = null;
        if (addUid) {
            uidNotification = uid;
        }
        this.notifyFlagUpdate(msn, flags, uidNotification, silentListener);
    }

    private Flags getFlags(SimpleStoredMessage mess) {
        return ((AbstractMimeMessage)mess.getMimeMessage()).getFlags();
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public FileInfo getFolderInfo() {
        return this.folderInfo;
    }

    public boolean isMarked() {
        ImapService.FolderStatus folderStatus = this.getFolderStatus();
        return folderStatus.recentCount > 0 || folderStatus.unseenCount > 0;
    }

    @Override
    protected boolean isReadOnly() {
        AccessStatus status = this.serviceRegistry.getPublicServiceAccessService().hasAccess(ServiceRegistry.NODE_SERVICE.getLocalName(), "createNode", this.folderInfo.getNodeRef(), null, null, null);
        return status == AccessStatus.DENIED;
    }

    public AlfrescoImapConst.ImapViewMode getViewMode() {
        return this.viewMode;
    }

    private long createMimeMessageInFolder(FileInfo folderFileInfo, MimeMessage message, Flags flags) throws FileExistsException, FileNotFoundException, IOException, MessagingException {
        String name = "Message_" + GUID.generate();
        FileFolderService fileFolderService = this.serviceRegistry.getFileFolderService();
        FileInfo messageFile = fileFolderService.create(folderFileInfo.getNodeRef(), name, ContentModel.TYPE_CONTENT);
        long newMessageUid = (Long)messageFile.getProperties().get(ContentModel.PROP_NODE_DBID);
        name = "Message_" + newMessageUid + ".eml";
        fileFolderService.rename(messageFile.getNodeRef(), name);
        Flags newFlags = new Flags(flags);
        newFlags.add(Flags.Flag.RECENT);
        this.imapService.setFlags(messageFile, newFlags, true);
        if (this.extractAttachmentsEnabled) {
            this.imapService.extractAttachments(messageFile.getNodeRef(), message);
        }
        new IncomingImapMessage(messageFile, this.serviceRegistry, message);
        return newMessageUid;
    }
}

