/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rating;

import java.util.Arrays;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class RatingsRelatedAspectBehaviours
implements CopyServicePolicies.OnCopyNodePolicy {
    private PolicyComponent policyComponent;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void init() {
        for (QName aspect : this.getAspectsNotToCopy()) {
            this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), aspect, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        }
    }

    protected List<QName> getAspectsNotToCopy() {
        return Arrays.asList(ContentModel.ASPECT_RATEABLE, ContentModel.ASPECT_LIKES_RATING_SCHEME_ROLLUPS, ContentModel.ASPECT_FIVESTAR_RATING_SCHEME_ROLLUPS);
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return RatingRelatedAspectsCopyBehaviourCallback.INSTANCE;
    }

    private static class RatingRelatedAspectsCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new RatingRelatedAspectsCopyBehaviourCallback();

        private RatingRelatedAspectsCopyBehaviourCallback() {
        }

        @Override
        public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
            return false;
        }

        @Override
        public Pair<CopyBehaviourCallback.AssocCopySourceAction, CopyBehaviourCallback.AssocCopyTargetAction> getAssociationCopyAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyAssociationDetails assocCopyDetails) {
            return new Pair((Object)CopyBehaviourCallback.AssocCopySourceAction.IGNORE, (Object)CopyBehaviourCallback.AssocCopyTargetAction.USE_COPIED_OTHERWISE_ORIGINAL_TARGET);
        }

        @Override
        public CopyBehaviourCallback.ChildAssocCopyAction getChildAssociationCopyAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyChildAssociationDetails childAssocCopyDetails) {
            return CopyBehaviourCallback.ChildAssocCopyAction.IGNORE;
        }
    }
}

