/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.repo.audit.model.AuditModelRegistryImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ResourceUtils;

@Category(value={LuceneTests.class})
public class AuditMethodInterceptorTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuditModelRegistryImpl auditModelRegistry;
    private TransactionServiceImpl transactionServiceImpl;
    private NodeService nodeService;
    private SearchService searchService;
    private ServiceRegistry serviceRegistry;
    private AuditComponent auditComponent;
    private AuditService auditService;
    private TransactionService transactionService;
    private NodeRef nodeRef;
    private static String APPLICATION_NAME_MNT_11072 = "alfresco-mnt-11072";
    private static String APPLICATION_NAME_MNT_16748 = "SearchAudit";
    private static final Log logger = LogFactory.getLog(AuditMethodInterceptorTest.class);

    public void setUp() throws Exception {
        this.auditModelRegistry = (AuditModelRegistryImpl)ctx.getBean("auditModel.modelRegistry");
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.auditComponent = (AuditComponent)ctx.getBean("auditComponent");
        this.auditService = this.serviceRegistry.getAuditService();
        this.transactionService = this.serviceRegistry.getTransactionService();
        this.transactionServiceImpl = (TransactionServiceImpl)ctx.getBean("transactionService");
        this.nodeService = this.serviceRegistry.getNodeService();
        this.searchService = this.serviceRegistry.getSearchService();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.nodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        URL modelUrlMnt11072 = ResourceUtils.getURL((String)"classpath:alfresco/testaudit/alfresco-audit-test-mnt-11072.xml");
        URL modelUrlMnt16748 = ResourceUtils.getURL((String)"classpath:alfresco/testaudit/alfresco-audit-test-mnt-16748.xml");
        this.auditModelRegistry.registerModel(modelUrlMnt11072);
        this.auditModelRegistry.registerModel(modelUrlMnt16748);
        this.auditModelRegistry.loadAuditModels();
    }

    public void tearDown() {
        this.auditService.clearAudit(APPLICATION_NAME_MNT_11072, null, null);
        this.auditService.clearAudit(APPLICATION_NAME_MNT_16748, null, null);
        this.auditModelRegistry.destroy();
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void testAuditInReadOnly_MNT11072() throws Exception {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        QName veto = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"TestVeto");
        this.transactionServiceImpl.setAllowWrite(false, veto);
        try {
            Map props = (Map)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Map<QName, Serializable>>(){

                public Map<QName, Serializable> execute() throws Throwable {
                    return AuditMethodInterceptorTest.this.nodeService.getProperties(AuditMethodInterceptorTest.this.nodeRef);
                }
            }, true, false);
            AuditMethodInterceptorTest.assertNotNull((String)"The props should exsist.", (Object)props);
            final StringBuilder sb = new StringBuilder();
            final MutableInt rowCount = new MutableInt();
            AuditService.AuditQueryCallback callback = new AuditService.AuditQueryCallback(){

                public boolean valuesRequired() {
                    return true;
                }

                public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                    AuditMethodInterceptorTest.assertNotNull((Object)applicationName);
                    AuditMethodInterceptorTest.assertNotNull((Object)user);
                    sb.append("Row: ").append(entryId).append(" | ").append(applicationName).append(" | ").append(user).append(" | ").append(new Date(time)).append(" | ").append(values).append(" | ").append("\n");
                    rowCount.setValue(rowCount.intValue() + 1);
                    return true;
                }

                public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                    throw new AlfrescoRuntimeException(errorMsg, error);
                }
            };
            AuditQueryParameters params = new AuditQueryParameters();
            params.setForward(true);
            params.setUser(AuthenticationUtil.getAdminUserName());
            params.setApplicationName(APPLICATION_NAME_MNT_11072);
            rowCount.setValue(0);
            this.auditComponent.auditQuery(callback, params, Integer.MAX_VALUE);
            AuditMethodInterceptorTest.assertEquals((String)"There should be one audit entry.", (int)1, (int)rowCount.intValue());
            AuditMethodInterceptorTest.assertTrue((String)"The requested nodeRef should be in the audit entry.", (boolean)sb.toString().contains(this.nodeRef.toString()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)sb.toString());
            }
        }
        finally {
            this.transactionServiceImpl.setAllowWrite(true, veto);
        }
    }

    public void testAuditSearchServiceQuery() throws Exception {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        ResultSet cfr_ignored_0 = (ResultSet)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<ResultSet>(){

            public ResultSet execute() throws Throwable {
                return AuditMethodInterceptorTest.this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", "/app:company_home");
            }
        }, true, false);
        this.checkAuditEntries(APPLICATION_NAME_MNT_16748, "xpath", "/app:company_home", 1);
    }

    public void testAuditSearchServiceSearchParametersQuery() throws Exception {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        final SearchParameters sp = new SearchParameters();
        sp.setLanguage("xpath");
        sp.setQuery("/app:company_home/app:dictionary");
        sp.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        ResultSet cfr_ignored_0 = (ResultSet)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<ResultSet>(){

            public ResultSet execute() throws Throwable {
                return AuditMethodInterceptorTest.this.searchService.query(sp);
            }
        }, true, false);
        this.checkAuditEntries(APPLICATION_NAME_MNT_16748, "xpath", "/app:company_home/app:dictionary", 1);
    }

    private void checkAuditEntries(String applicationName, String language, String query, int resultsNumber) {
        final StringBuilder sb = new StringBuilder();
        final MutableInt rowCount = new MutableInt();
        AuditService.AuditQueryCallback callback = new AuditService.AuditQueryCallback(){

            public boolean valuesRequired() {
                return true;
            }

            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                AuditMethodInterceptorTest.assertNotNull((Object)applicationName);
                AuditMethodInterceptorTest.assertNotNull((Object)user);
                sb.append("Row: ").append(entryId).append(" | ").append(applicationName).append(" | ").append(user).append(" | ").append(new Date(time)).append(" | ").append(values).append(" | ").append("\n");
                rowCount.setValue(rowCount.intValue() + 1);
                return true;
            }

            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException(errorMsg, error);
            }
        };
        AuditQueryParameters params = new AuditQueryParameters();
        params.setForward(true);
        params.setUser(AuthenticationUtil.getAdminUserName());
        params.setApplicationName(applicationName);
        rowCount.setValue(0);
        this.auditComponent.auditQuery(callback, params, Integer.MAX_VALUE);
        AuditMethodInterceptorTest.assertEquals((String)"Incorrect number of audit entries", (int)resultsNumber, (int)rowCount.intValue());
        AuditMethodInterceptorTest.assertTrue((String)"The requested language should be in the audit entry.", (boolean)sb.toString().contains(language));
        AuditMethodInterceptorTest.assertTrue((String)"The used query should be in the audit entry.", (boolean)sb.toString().contains(query));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sb.toString());
        }
    }
}

