/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.io.File;
import org.alfresco.repo.content.AbstractReadOnlyContentStoreTest;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.TempFileProvider;
import org.junit.Before;
import org.junit.experimental.categories.Category;

@Category(value={OwnJVMTestsCategory.class})
public class ReadOnlyFileContentStoreTest
extends AbstractReadOnlyContentStoreTest {
    private FileContentStore store;
    private String contentUrl;

    @Override
    @Before
    public void before() throws Exception {
        File tempDir = TempFileProvider.getTempDir();
        this.store = new FileContentStore(AbstractReadOnlyContentStoreTest.ctx, tempDir.getAbsolutePath() + File.separatorChar + this.getName());
        ContentWriter writer = this.store.getWriter(new ContentContext(null, null));
        writer.putContent("Content for getExistingContentUrl");
        this.contentUrl = writer.getContentUrl();
        this.store.setReadOnly(true);
    }

    @Override
    protected ContentStore getStore() {
        return this.store;
    }

    @Override
    protected String getExistingContentUrl() {
        return this.contentUrl;
    }
}

