/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.event2.shared.QNameMatcher;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Test;

public class QNameMatcherUnitTest {
    @Test
    public void shouldMatchOnlyQNamesFromUserModelURI() {
        QNameMatcher qNameMatcher = new QNameMatcher(Set.of(QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)"*")));
        Assert.assertTrue((boolean)qNameMatcher.isMatching(ContentModel.PROP_USER_USERNAME));
        Assert.assertTrue((boolean)qNameMatcher.isMatching(ContentModel.TYPE_USER));
        Assert.assertFalse((boolean)qNameMatcher.isMatching(ContentModel.PROP_TITLE));
        Assert.assertFalse((boolean)qNameMatcher.isMatching(TransferModel.PROP_USERNAME));
        Assert.assertFalse((boolean)qNameMatcher.isMatching(null));
    }

    @Test
    public void shouldOnlyMatchSpecificQName() {
        QNameMatcher qNameMatcher = new QNameMatcher(Set.of(ContentModel.PROP_USER_USERNAME));
        Assert.assertTrue((boolean)qNameMatcher.isMatching(ContentModel.PROP_USER_USERNAME));
        Assert.assertFalse((boolean)qNameMatcher.isMatching(ContentModel.PROP_NAME));
        Assert.assertFalse((boolean)qNameMatcher.isMatching(ContentModel.PROP_USERNAME));
        Assert.assertFalse((boolean)qNameMatcher.isMatching(TransferModel.PROP_USERNAME));
        Assert.assertFalse((boolean)qNameMatcher.isMatching(null));
    }
}

