/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.TypeNames;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.util.DBScriptUtil;
import org.alfresco.util.DatabaseMetaDataHelper;
import org.alfresco.util.DialectUtil;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.schemacomp.model.Column;
import org.alfresco.util.schemacomp.model.ForeignKey;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.PrimaryKey;
import org.alfresco.util.schemacomp.model.Schema;
import org.alfresco.util.schemacomp.model.Sequence;
import org.alfresco.util.schemacomp.model.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ExportDb {
    private static final String SCHEMA_REFERENCE_SEQUENCES_SQL_FILE = "classpath:alfresco/dbscripts/create/${db.script.dialect}/Schema-Reference-Sequences.sql";
    private final Map<String, Integer> reverseTypeMap = new TreeMap<String, Integer>();
    private DatabaseMetaDataHelper databaseMetaDataHelper;
    private DataSource dataSource;
    private Schema schema;
    private Dialect dialect;
    private DescriptorService descriptorService;
    private String namePrefix = "alf_";
    private String dbSchemaName;
    private static final Log log = LogFactory.getLog(ExportDb.class);
    private ResourcePatternResolver rpr = new PathMatchingResourcePatternResolver(this.getClass().getClassLoader());

    public ExportDb(ApplicationContext context) {
        this((DataSource)context.getBean("dataSource"), (Dialect)context.getBean("dialect"), (DescriptorService)context.getBean("descriptorComponent"), (DatabaseMetaDataHelper)context.getBean("databaseMetaDataHelper"));
    }

    public ExportDb(DataSource dataSource, Dialect dialect, DescriptorService descriptorService, DatabaseMetaDataHelper databaseMetaDataHelper) {
        this.dataSource = dataSource;
        this.dialect = dialect;
        this.descriptorService = descriptorService;
        this.databaseMetaDataHelper = databaseMetaDataHelper;
        this.init();
    }

    private void init() {
        try {
            this.attemptInit();
        }
        catch (SecurityException error) {
            throw new RuntimeException("Unable to generate type map using hibernate.", error);
        }
        catch (IllegalArgumentException error) {
            throw new RuntimeException("Unable to generate type map using hibernate.", error);
        }
        catch (NoSuchFieldException error) {
            throw new RuntimeException("Unable to generate type map using hibernate.", error);
        }
        catch (IllegalAccessException error) {
            throw new RuntimeException("Unable to generate type map using hibernate.", error);
        }
    }

    private void attemptInit() throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field typeNamesField = Dialect.class.getDeclaredField("typeNames");
        typeNamesField.setAccessible(true);
        TypeNames typeNames = (TypeNames)typeNamesField.get(this.dialect);
        Field defaultsField = TypeNames.class.getDeclaredField("defaults");
        defaultsField.setAccessible(true);
        Map forwardMap2 = (Map)defaultsField.get(typeNames);
        for (Map.Entry e : forwardMap2.entrySet()) {
            this.reverseTypeMap.put(((String)e.getValue()).toLowerCase(), (Integer)e.getKey());
        }
        Field weightedField = TypeNames.class.getDeclaredField("weighted");
        weightedField.setAccessible(true);
        Map forwardMap1 = (Map)weightedField.get(typeNames);
        for (Map.Entry e : forwardMap1.entrySet()) {
            for (String type : ((Map)e.getValue()).values()) {
                this.reverseTypeMap.put(type.toLowerCase(), (Integer)e.getKey());
            }
        }
    }

    public void execute() {
        PropertyCheck.mandatory((Object)this, (String)"dataSource", (Object)this.dataSource);
        PropertyCheck.mandatory((Object)this, (String)"dialect", (Object)this.dialect);
        PropertyCheck.mandatory((Object)this, (String)"descriptorService", (Object)this.descriptorService);
        Connection connection = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                connection.setAutoCommit(false);
                Descriptor descriptor = this.descriptorService.getServerDescriptor();
                int schemaVersion = descriptor.getSchema();
                this.execute(connection, schemaVersion);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to execute export.", e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Throwable throwable) {}
    }

    private void execute(Connection con, int schemaVersion) throws Exception {
        String[] prefixFilters;
        DatabaseMetaData dbmd = con.getMetaData();
        String schemaName = this.databaseMetaDataHelper.getSchema(con);
        this.schema = new Schema(schemaName, this.namePrefix, schemaVersion, true);
        String[] stringArray = prefixFilters = this.namePrefixFilters(dbmd);
        int n = prefixFilters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            this.extractSchema(dbmd, schemaName, filter);
            ++n2;
        }
    }

    private void extractSchema(DatabaseMetaData dbmd, String schemaName, String prefixFilter) throws SQLException, IllegalArgumentException, IllegalAccessException, IOException {
        String[] tableTypes;
        Resource sequencesRefResource;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving tables: schemaName=[" + schemaName + "], prefixFilter=[" + prefixFilter + "]"));
        }
        if ((sequencesRefResource = this.getSequencesReferenceResource()) != null && sequencesRefResource.exists()) {
            tableTypes = new String[]{"TABLE", "VIEW"};
            this.retrieveAndProcessSequences(dbmd, sequencesRefResource, schemaName, prefixFilter);
        } else {
            tableTypes = new String[]{"TABLE", "VIEW", "SEQUENCE"};
        }
        ResultSet tables = dbmd.getTables(null, schemaName, prefixFilter, tableTypes);
        this.processTables(dbmd, tables);
    }

    /*
     * Unable to fully structure code
     */
    private void processTables(DatabaseMetaData dbmd, ResultSet tables) throws SQLException, IllegalArgumentException, IllegalAccessException {
        if (tables != null) ** GOTO lbl99
        return;
lbl-1000:
        // 1 sources

        {
            tableName = tables.getString("TABLE_NAME");
            if (ExportDb.log.isDebugEnabled()) {
                ExportDb.log.debug((Object)("Examining table tableName=[" + tableName + "]"));
            }
            if (tableName.startsWith("BIN$") || this.schema.containsByName(tableName)) continue;
            if (tables.getString("TABLE_TYPE").equals("SEQUENCE")) {
                sequence = new Sequence(tableName);
                this.schema.add(sequence);
                continue;
            }
            table = new Table(tableName);
            this.schema.add(table);
            columns = dbmd.getColumns(null, tables.getString("TABLE_SCHEM"), tableName, "%");
            while (columns.next()) {
                columnName = columns.getString("COLUMN_NAME");
                column = new Column(columnName);
                dbType = columns.getString("TYPE_NAME");
                colSize = columns.getInt("COLUMN_SIZE");
                scale = columns.getInt("DECIMAL_DIGITS");
                jdbcType = columns.getInt("DATA_TYPE");
                type = this.generateType(dbType, colSize, scale, jdbcType);
                column.setType((String)type);
                nullableString = columns.getString("IS_NULLABLE");
                column.setNullable(this.parseBoolean(nullableString));
                column.setOrder(columns.getInt("ORDINAL_POSITION"));
                try {
                    autoIncString = columns.getString("IS_AUTOINCREMENT");
                    column.setAutoIncrement(this.parseBoolean(autoIncString));
                }
                catch (SQLException v0) {
                    column.setAutoIncrement(dbType.endsWith("identity"));
                }
                column.setParent(table);
                table.getColumns().add(column);
            }
            columns.close();
            primarykeycols = dbmd.getPrimaryKeys(null, tables.getString("TABLE_SCHEM"), tableName);
            pk = null;
            keySeqsAndColumnNames = new LinkedHashMap<Integer, String>();
            while (primarykeycols.next()) {
                if (pk == null) {
                    pkName = primarykeycols.getString("PK_NAME");
                    pk = new PrimaryKey(pkName);
                }
                columnOrder = primarykeycols.getInt("KEY_SEQ");
                columnName = primarykeycols.getString("COLUMN_NAME");
                keySeqsAndColumnNames.put(columnOrder, columnName);
            }
            keyseqSortedColumnNames = new LinkedList<String>();
            keySeqSortedColumnOrders = keySeqsAndColumnNames.keySet().stream().sorted().collect(Collectors.toList());
            type = keySeqSortedColumnOrders.iterator();
            while (type.hasNext()) {
                keySeq = (Integer)type.next();
                keyseqSortedColumnNames.add((String)keySeqsAndColumnNames.get(keySeq));
            }
            pk.setColumnOrders(keySeqSortedColumnOrders);
            pk.setColumnNames(keyseqSortedColumnNames);
            primarykeycols.close();
            if (pk != null) {
                pk.setParent(table);
                table.setPrimaryKey(pk);
            }
            indexes = dbmd.getIndexInfo(null, tables.getString("TABLE_SCHEM"), tableName, false, true);
            lastIndexName = "";
            index = null;
            while (indexes.next()) {
                indexName = indexes.getString("INDEX_NAME");
                if (indexName == null || indexName.equals(table.getPrimaryKey().getName())) continue;
                if (!indexName.equals(lastIndexName)) {
                    index = new Index(indexName);
                    index.setUnique(indexes.getBoolean("NON_UNIQUE") == false);
                    index.setParent(table);
                    table.getIndexes().add(index);
                    lastIndexName = indexName;
                }
                if (index == null) continue;
                columnName = indexes.getString("COLUMN_NAME");
                index.getColumnNames().add(columnName);
            }
            indexes.close();
            foreignkeys = dbmd.getImportedKeys(null, tables.getString("TABLE_SCHEM"), tableName);
            lastKeyName = "";
            fk = null;
            while (foreignkeys.next()) {
                keyName = foreignkeys.getString("FK_NAME");
                if (!keyName.equals(lastKeyName)) {
                    fk = new ForeignKey(keyName);
                    fk.setParent(table);
                    table.getForeignKeys().add(fk);
                    lastKeyName = keyName;
                }
                if (fk == null) continue;
                fk.setLocalColumn(foreignkeys.getString("FKCOLUMN_NAME"));
                fk.setTargetTable(foreignkeys.getString("PKTABLE_NAME"));
                fk.setTargetColumn(foreignkeys.getString("PKCOLUMN_NAME"));
            }
            foreignkeys.close();
lbl99:
            // 4 sources

            ** while (tables.next())
        }
lbl100:
        // 1 sources

        tables.close();
    }

    private boolean parseBoolean(String nullableString) {
        if (nullableString.equals("NO")) {
            return false;
        }
        if (nullableString.equals("YES")) {
            return true;
        }
        throw new IllegalArgumentException("Unsupported term \"" + nullableString + "\", perhaps this database doesn't use YES/NO for booleans?");
    }

    protected String generateType(String dbTypeRaw, int size, int digits, int sqlType) throws IllegalArgumentException, IllegalAccessException {
        String dbType = dbTypeRaw.toLowerCase();
        String sizeType = dbType + "(" + size + ")";
        if (this.reverseTypeMap.containsKey(sizeType)) {
            return sizeType;
        }
        String precisionScaleType = dbType + "(" + size + ", " + digits + ")";
        if (this.reverseTypeMap.containsKey(precisionScaleType)) {
            return precisionScaleType;
        }
        for (String key : this.reverseTypeMap.keySet()) {
            String popKey = key.replaceAll("\\$p", String.valueOf(size));
            popKey = popKey.replaceAll("\\$s", String.valueOf(digits));
            popKey = popKey.replaceAll("\\$l", String.valueOf(size));
            String charSizeType = dbType + "(" + size + " char)";
            if (!popKey.equals(precisionScaleType) && !popKey.equals(sizeType) && !popKey.equals(charSizeType)) continue;
            return popKey;
        }
        return dbType;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    private String[] namePrefixFilters(DatabaseMetaData dbmd) throws SQLException {
        String filter = this.namePrefix + "%";
        return new String[]{filter.toLowerCase(), filter.toUpperCase()};
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public void setDbSchemaName(String dbSchemaName) {
        this.dbSchemaName = dbSchemaName;
    }

    private Resource getSequencesReferenceResource() {
        return DialectUtil.getDialectResource(this.rpr, this.dialect.getClass(), SCHEMA_REFERENCE_SEQUENCES_SQL_FILE);
    }

    private void retrieveAndProcessSequences(DatabaseMetaData dbmd, Resource resource, String schemaName, String prefixFilter) throws SQLException, IllegalArgumentException, IllegalAccessException, IOException {
        String script = DBScriptUtil.readScript(new EncodedResource(resource, "UTF-8"));
        if (!script.isEmpty()) {
            this.retrieveAndProcessSequences(dbmd, script, schemaName, prefixFilter);
        }
    }

    private void retrieveAndProcessSequences(DatabaseMetaData dbmd, String script, String schemaName, String prefixFilter) throws SQLException, IllegalArgumentException, IllegalAccessException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving DB sequences...");
        }
        PreparedStatement stmt = null;
        try {
            stmt = dbmd.getConnection().prepareStatement(script);
            stmt.setString(1, schemaName);
            stmt.setString(2, prefixFilter);
            boolean haveResults = stmt.execute();
            if (haveResults) {
                ResultSet sequences = stmt.getResultSet();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Sequences processing started...");
                }
                this.processTables(dbmd, sequences);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Sequences processing completed.");
                }
            }
        }
        catch (Throwable throwable) {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

