/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.util.HashMap;
import org.alfresco.service.cmr.repository.TransformationOptionPair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@Deprecated
public class TransformationOptionPairTest {
    TransformationOptionPair pair;

    @Before
    public void setUp() throws Exception {
        this.pair = new TransformationOptionPair();
    }

    @Test
    public void testUnset() throws Exception {
        long value = -1L;
        long actual = this.pair.getMax();
        Assert.assertEquals((String)"Getter did not return unset value", (long)value, (long)actual);
        Assert.assertEquals((String)"getValue() did not return set value", (long)value, (long)this.pair.getValue());
        Assert.assertEquals((String)"Expected action not returned", null, (Object)this.pair.getAction());
    }

    @Test
    public void testMax() throws Exception {
        long value = 1234L;
        this.pair.setMax(value, null);
        long actual = this.pair.getMax();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
        Assert.assertEquals((String)"getValue() did not return set value", (long)value, (long)this.pair.getValue());
        Assert.assertEquals((String)"Expected action not returned", (Object)TransformationOptionPair.Action.THROW_EXCEPTION, (Object)this.pair.getAction());
    }

    @Test
    public void testLimit() throws Exception {
        long value = 1234L;
        this.pair.setLimit(value, null);
        long actual = this.pair.getLimit();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
        Assert.assertEquals((String)"getValue() did not return set value", (long)value, (long)this.pair.getValue());
        Assert.assertEquals((String)"Expected action not returned", (Object)TransformationOptionPair.Action.RETURN_EOF, (Object)this.pair.getAction());
    }

    @Test
    public void testMaxAlreadySet() throws Exception {
        String message = "Oh no the other value is set";
        String actual = null;
        this.pair.setMax(1234L, null);
        try {
            this.pair.setLimit(111L, message);
        }
        catch (IllegalArgumentException e) {
            actual = e.getMessage();
        }
        Assert.assertEquals((String)"Expected an IllegalArgumentException message", (Object)message, (Object)actual);
    }

    @Test
    public void testLimitAlreadySet() throws Exception {
        String message = "Oh no the other value is set";
        String actual = null;
        this.pair.setLimit(1234L, null);
        try {
            this.pair.setMax(111L, message);
        }
        catch (IllegalArgumentException e) {
            actual = e.getMessage();
        }
        Assert.assertEquals((String)"Expected an IllegalArgumentException message", (Object)message, (Object)actual);
    }

    @Test
    public void testSetMaxMultipleTimes() throws Exception {
        long value = 1234L;
        this.pair.setMax(1L, null);
        this.pair.setMax(2L, null);
        this.pair.setMax(value, null);
        long actual = this.pair.getMax();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testSetLimitMultipleTimes() throws Exception {
        long value = 1234L;
        this.pair.setLimit(1L, null);
        this.pair.setLimit(2L, null);
        this.pair.setLimit(value, null);
        long actual = this.pair.getLimit();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testSetMaxClearLimit() throws Exception {
        long value = 1234L;
        this.pair.setMax(value, null);
        this.pair.setLimit(-1L, null);
        long actual = this.pair.getMax();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testSetLimitClearMax() throws Exception {
        long value = 1234L;
        this.pair.setLimit(value, null);
        this.pair.setMax(-1L, null);
        long actual = this.pair.getLimit();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testSetClearSet() throws Exception {
        String message = "Oh no the other value is set";
        this.pair.setLimit(1L, message);
        this.pair.setLimit(-1L, message);
        this.pair.setMax(1L, message);
        this.pair.setMax(-1L, message);
        this.pair.setLimit(1L, message);
    }

    @Test
    public void testMapMax() throws Exception {
        String maxKey = "Max";
        String limitKey = "Limit";
        String message = "Oh no the other value is set";
        this.pair.setMax(123L, null);
        HashMap optionsMap = new HashMap();
        this.pair.toMap(optionsMap, maxKey, limitKey);
        TransformationOptionPair actual = new TransformationOptionPair();
        actual.set(optionsMap, maxKey, limitKey, message);
        Assert.assertEquals((String)"Did not match original values", (Object)this.pair, (Object)actual);
    }

    @Test
    public void testMapLimit() throws Exception {
        String maxKey = "Max";
        String limitKey = "Limit";
        String message = "Oh no the other value is set";
        this.pair.setLimit(123L, null);
        HashMap optionsMap = new HashMap();
        this.pair.toMap(optionsMap, maxKey, limitKey);
        TransformationOptionPair actual = new TransformationOptionPair();
        actual.set(optionsMap, maxKey, limitKey, message);
        Assert.assertEquals((String)"Did not match original values", (Object)this.pair, (Object)actual);
    }

    @Test
    public void testMapBothSet() throws Exception {
        String maxKey = "Max";
        String limitKey = "Limit";
        String message = "Oh no the other value is set";
        this.pair.setLimit(123L, null);
        HashMap<String, Long> optionsMap = new HashMap<String, Long>();
        this.pair.toMap(optionsMap, maxKey, limitKey);
        optionsMap.put(maxKey, 456L);
        String actual = null;
        TransformationOptionPair pair2 = new TransformationOptionPair();
        try {
            pair2.set(optionsMap, maxKey, limitKey, message);
        }
        catch (IllegalArgumentException e) {
            actual = e.getMessage();
        }
        Assert.assertEquals((String)"Expected an IllegalArgumentException message", (Object)message, (Object)actual);
    }

    @Test
    public void testMapNeitherSet() throws Exception {
        long value = 1234L;
        String maxKey = "Max";
        String limitKey = "Limit";
        String message = "Oh no the other value is set";
        this.pair.setLimit(value, null);
        HashMap<String, Long> optionsMap = new HashMap<String, Long>();
        optionsMap.put("AnotherKey", 456L);
        this.pair.set(optionsMap, maxKey, limitKey, message);
        long actual = this.pair.getLimit();
        Assert.assertEquals((String)"Original value should not be changed", (long)value, (long)actual);
    }

    @Test
    public void testCombineOrder() throws Exception {
        TransformationOptionPair second = new TransformationOptionPair();
        this.pair.setMax(123L, null);
        second.setMax(12L, null);
        TransformationOptionPair combined = this.pair.combine(second);
        TransformationOptionPair combinedOtherWay = second.combine(this.pair);
        Assert.assertEquals((String)"The combine order should not matter", (Object)combined, (Object)combinedOtherWay);
    }

    @Test
    public void testCombineMax() throws Exception {
        TransformationOptionPair second = new TransformationOptionPair();
        this.pair.setMax(123L, null);
        second.setMax(12L, null);
        TransformationOptionPair combined = this.pair.combine(second);
        Assert.assertEquals((String)"Expected the lower value", (long)12L, (long)combined.getValue());
        Assert.assertEquals((String)"Expected the lower value", (long)12L, (long)combined.getMax());
    }

    @Test
    public void testCombineLimit() throws Exception {
        TransformationOptionPair second = new TransformationOptionPair();
        this.pair.setLimit(123L, null);
        second.setLimit(12L, null);
        TransformationOptionPair combined = this.pair.combine(second);
        Assert.assertEquals((String)"Expected the lower value", (long)12L, (long)combined.getValue());
        Assert.assertEquals((String)"Expected the lower value", (long)12L, (long)combined.getLimit());
    }

    @Test
    public void testCombineMaxWins() throws Exception {
        TransformationOptionPair second = new TransformationOptionPair();
        this.pair.setLimit(123L, null);
        second.setMax(12L, null);
        TransformationOptionPair combined = this.pair.combine(second);
        Assert.assertEquals((String)"Expected the lower value", (long)12L, (long)combined.getValue());
        Assert.assertEquals((String)"Expected the lower value", (long)12L, (long)combined.getMax());
        Assert.assertEquals((String)"Expected unset value", (long)-1L, (long)combined.getLimit());
    }

    @Test
    public void testCombineLimitWins() throws Exception {
        TransformationOptionPair second = new TransformationOptionPair();
        this.pair.setMax(123L, null);
        second.setLimit(12L, null);
        TransformationOptionPair combined = this.pair.combine(second);
        Assert.assertEquals((String)"Expected the lower value", (long)12L, (long)combined.getValue());
        Assert.assertEquals((String)"Expected the lower value", (long)12L, (long)combined.getLimit());
        Assert.assertEquals((String)"Expected unset value", (long)-1L, (long)combined.getMax());
    }

    @Test
    public void testCombineDynamicChange() throws Exception {
        TransformationOptionPair second = new TransformationOptionPair();
        this.pair.setMax(123L, null);
        second.setMax(1234L, null);
        TransformationOptionPair combined = this.pair.combine(second);
        this.pair.setMax(45L, null);
        Assert.assertEquals((String)"Expected the lower value", (long)45L, (long)combined.getMax());
        Assert.assertEquals((String)"Expected an unset value", (long)-1L, (long)combined.getLimit());
        second.setMax(-1L, null);
        second.setLimit(10L, null);
        Assert.assertEquals((String)"Expected an unset value", (long)-1L, (long)combined.getMax());
        Assert.assertEquals((String)"Expected the lower value", (long)10L, (long)combined.getLimit());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCombineSetMax() throws Exception {
        TransformationOptionPair combined = this.pair.combine(this.pair);
        combined.setMax(1L, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCombineSetLimit() throws Exception {
        TransformationOptionPair combined = this.pair.combine(this.pair);
        combined.setLimit(1L, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCombineSetMap() throws Exception {
        TransformationOptionPair combined = this.pair.combine(this.pair);
        combined.set(null, null, null, null);
    }
}

