/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.version.common.VersionLabelComparator;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionDoesNotExistException;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionServiceException;
import org.alfresco.util.EqualsHelper;

public class VersionHistoryImpl
implements VersionHistory {
    private static final long serialVersionUID = 3257001051558326840L;
    private static final String ERR_MSG = "The root version must be specified when creating a version history object.";
    private transient List<Version> versions;
    private HashMap<String, String> versionHistory = null;
    private Map<String, Version> versionsByLabel = null;
    private Comparator<Version> versionComparatorDesc;

    public VersionHistoryImpl(Version rootVersion, Comparator<Version> versionComparatorDesc) {
        if (rootVersion == null) {
            throw new VersionServiceException(ERR_MSG);
        }
        this.versionHistory = new HashMap();
        this.versionsByLabel = new LinkedHashMap<String, Version>();
        this.versionComparatorDesc = versionComparatorDesc;
        this.addVersion(rootVersion, null);
    }

    @Override
    public Version getRootVersion() {
        return this.versionsByLabel.values().iterator().next();
    }

    @Override
    public Version getHeadVersion() {
        return this.getAllVersions().iterator().next();
    }

    @Override
    public Collection<Version> getAllVersions() {
        return this.sortDescending(this.versionsByLabel.values());
    }

    private Collection<Version> sortDescending(Collection<Version> versions) {
        ArrayList<Version> sortedVersions = new ArrayList<Version>(versions);
        if (this.versionComparatorDesc == null) {
            Collections.reverse(sortedVersions);
        } else {
            Collections.sort(sortedVersions, this.versionComparatorDesc);
        }
        return sortedVersions;
    }

    @Override
    public Version getPredecessor(Version version) {
        Version result = null;
        if (version != null) {
            result = this.getVersion(this.versionHistory.get(version.getVersionLabel()));
        }
        return result;
    }

    @Override
    public Collection<Version> getSuccessors(Version version) {
        String versionLabel;
        ArrayList<Version> result = new ArrayList<Version>();
        if (version != null && this.versionHistory.containsValue(versionLabel = version.getVersionLabel())) {
            for (Map.Entry<String, Version> entry : this.versionsByLabel.entrySet()) {
                String key = entry.getKey();
                if (!EqualsHelper.nullSafeEquals((Object)this.versionHistory.get(key), (Object)versionLabel)) continue;
                result.add(entry.getValue());
            }
        }
        return this.sortDescending(result);
    }

    @Override
    public Version getVersion(String versionLabel) {
        Version result = null;
        if (versionLabel != null && (result = this.versionsByLabel.get(versionLabel)) == null) {
            throw new VersionDoesNotExistException(versionLabel);
        }
        return result;
    }

    public void addVersion(Version version, Version predecessor) {
        this.versionsByLabel.put(version.getVersionLabel(), version);
        if (predecessor != null) {
            this.versionHistory.put(version.getVersionLabel(), predecessor.getVersionLabel());
        }
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = is.readFields();
        if (fields.defaulted("versionsByLabel")) {
            this.versionsByLabel = (HashMap)fields.get("versions", new HashMap());
            this.versionHistory = (HashMap)fields.get("versionHistory", new HashMap());
            this.versionComparatorDesc = new VersionLabelComparator();
        } else if (fields.defaulted("versionComparatorDesc")) {
            this.versionsByLabel = (HashMap)fields.get("versionsByLabel", new HashMap());
            this.versionHistory = (HashMap)fields.get("versionHistory", new HashMap());
            this.versionComparatorDesc = new VersionLabelComparator();
        } else {
            this.versionsByLabel = (Map)fields.get("versionsByLabel", new LinkedHashMap());
            this.versionHistory = (HashMap)fields.get("versionHistory", new HashMap());
            this.versionComparatorDesc = (Comparator)fields.get("versionComparatorDesc", null);
        }
    }

    public String toString() {
        Collection<Version> allVersions = this.getAllVersions();
        StringBuilder msg = new StringBuilder();
        msg.append(VersionHistoryImpl.class.getSimpleName()).append(" [").append(allVersions.size()).append("] ");
        if (!allVersions.isEmpty()) {
            msg.append(", { '").append(this.getHeadVersion().getVersionLabel()).append("', tail... }");
        }
        return msg.toString();
    }
}

