/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.virtual.page.InvalidPageBounds;
import org.alfresco.repo.virtual.page.PageCollationException;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PageCollator<R> {
    private static Log logger = LogFactory.getLog(PageCollator.class);

    public PagingResults<R> collate(List<R> objects, PagingResultsSource<R> objectPageSurce, PagingRequest pagingRequest, Comparator<R> comparator) throws PageCollationException {
        int skip = pagingRequest.getSkipCount();
        int pageSize = pagingRequest.getMaxItems();
        if (skip < 0 || pageSize < 0) {
            throw new InvalidPageBounds("Negative page skip index and/or bounds.");
        }
        int preemptiveSkip = Math.max(0, skip - objects.size());
        int pageSkip = skip - preemptiveSkip;
        int preemptiveSize = pageSize + pageSkip;
        PagingResults pageResults = null;
        try {
            PagingRequest preemptiveRequest = new PagingRequest(preemptiveSkip, preemptiveSize, pagingRequest.getQueryExecutionId());
            preemptiveRequest.setRequestTotalCountMax(pagingRequest.getRequestTotalCountMax());
            pageResults = objectPageSurce.retrieve(preemptiveRequest);
        }
        catch (InvalidPageBounds e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e);
            }
            pageResults = new PagingResults<R>(){

                public List<R> getPage() {
                    return Collections.emptyList();
                }

                public boolean hasMoreItems() {
                    return false;
                }

                public Pair<Integer, Integer> getTotalResultCount() {
                    return new Pair(null, null);
                }

                public String getQueryExecutionId() {
                    return null;
                }
            };
        }
        return this.collate(objects, pageResults, pageSkip, pagingRequest, comparator);
    }

    private PagingResults<R> collate(List<R> objects, PagingResults<R> objectPageSurce, int pageSkip, final PagingRequest pagingRequest, Comparator<R> comparator) {
        int pageSize = pagingRequest.getMaxItems();
        List inPageList = objectPageSurce.getPage();
        final LinkedList collatedPageList = new LinkedList();
        boolean endOfCollation = this.collate(objects, inPageList, pageSkip, pageSize, comparator, collatedPageList);
        int resultsSize = objects.size();
        Pair pageTotal = objectPageSurce.getTotalResultCount();
        Integer pageTotalFirst = null;
        Integer pageTotalSecond = null;
        if (pageTotal != null) {
            pageTotalFirst = (Integer)pageTotal.getFirst();
            pageTotalSecond = (Integer)pageTotal.getSecond();
        }
        final Pair total = new Pair((Object)(pageTotalFirst == null ? null : Integer.valueOf(pageTotalFirst + resultsSize)), pageTotalSecond == null ? null : Integer.valueOf(pageTotalSecond + resultsSize));
        final boolean hasMoreItems = objectPageSurce.hasMoreItems() || !endOfCollation;
        return new PagingResults<R>(){

            public List<R> getPage() {
                return collatedPageList;
            }

            public boolean hasMoreItems() {
                return hasMoreItems;
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return total;
            }

            public String getQueryExecutionId() {
                return pagingRequest.getQueryExecutionId();
            }
        };
    }

    private boolean collate(List<R> objects, List<R> pageObjects, int pageSkip, int pageSize, Comparator<R> comparator, List<R> collatedResult) {
        int inPageSize;
        int resultsSize = objects.size();
        if (pageSkip >= resultsSize + (inPageSize = pageObjects.size())) {
            return true;
        }
        ArrayList<R> collation = new ArrayList<R>(objects.size() + pageObjects.size());
        collation.addAll(pageObjects);
        int i = 0;
        while (i < resultsSize) {
            int collationSize = collation.size();
            R result = objects.get(i);
            int j = 0;
            if (comparator != null) {
                while (j < collationSize) {
                    Object collated = collation.get(j);
                    if (comparator.compare(result, collated) <= 0) break;
                    ++j;
                }
            }
            collation.add(j, result);
            ++i;
        }
        Object[] collationArray = collation.toArray();
        int zeroPageSize = pageSize == 0 ? collationArray.length - pageSkip : pageSize;
        int to = Math.min(pageSkip + zeroPageSize, collationArray.length);
        collatedResult.addAll(Arrays.asList(Arrays.copyOfRange(collationArray, pageSkip, to)));
        return to == collationArray.length;
    }

    public static interface PagingResultsSource<R> {
        public PagingResults<R> retrieve(PagingRequest var1) throws PageCollationException;
    }
}

