/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.ArrayList;
import java.util.HashMap;
import org.alfresco.repo.search.impl.AbstractJSONAPIResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrActionReportResult
extends AbstractJSONAPIResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolrActionReportResult.class);

    public SolrActionReportResult(JSONObject json) {
        try {
            this.processJson(json);
        }
        catch (NullPointerException | JSONException e) {
            LOGGER.info(e.getMessage());
        }
    }

    @Override
    protected void processCoresInfoJson(JSONObject json) throws JSONException {
        this.cores = new ArrayList();
        this.coresInfo = new HashMap();
        if (json.has("report")) {
            JSONObject coreList = json.getJSONObject("report");
            JSONArray coreNameList = coreList.names();
            int i = 0;
            while (i < coreNameList.length()) {
                String coreName = String.valueOf(coreNameList.get(i));
                this.cores.add(coreName);
                HashMap<String, Object> coreInfo = new HashMap<String, Object>();
                JSONObject coreProperties = coreList.getJSONObject(coreName);
                JSONArray propertyNameList = coreProperties.names();
                int j = 0;
                while (j < propertyNameList.length()) {
                    String propertyName = String.valueOf(propertyNameList.get(j));
                    coreInfo.put(propertyName, coreProperties.get(propertyName));
                    ++j;
                }
                this.coresInfo.put(coreName, coreInfo);
                ++i;
            }
        }
    }
}

