/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.event.v1.model.ContentInfo;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event2.AbstractContextAwareRepoEvent;
import org.alfresco.service.cmr.dictionary.CustomModelDefinition;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.junit.Test;

public class UpdateRepoEventIT
extends AbstractContextAwareRepoEvent {
    @Test
    public void testUpdateNodeResourceContent() {
        ContentService contentService = (ContentService)this.applicationContext.getBean("contentService");
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        RepoEvent resultRepoEvent = this.getRepoEvent(1);
        UpdateRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        NodeResource resource = this.getNodeResource(resultRepoEvent);
        UpdateRepoEventIT.assertNull((String)"Content should have been null.", (Object)resource.getContent());
        this.retryingTransactionHelper.doInTransaction(() -> {
            ContentWriter writer = contentService.getWriter(nodeRef, ContentModel.TYPE_CONTENT, true);
            writer.setMimetype("application/pdf");
            writer.setEncoding("UTF-8");
            writer.putContent("test content.");
            return null;
        });
        this.checkNumOfEvents(2);
        resultRepoEvent = this.getRepoEvent(2);
        UpdateRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_UPDATED.getType(), (String)resultRepoEvent.getType());
        resource = this.getNodeResource(resultRepoEvent);
        ContentInfo content = resource.getContent();
        UpdateRepoEventIT.assertNotNull((Object)content);
        UpdateRepoEventIT.assertEquals((String)"application/pdf", (String)content.getMimeType());
        UpdateRepoEventIT.assertEquals((String)"UTF-8", (String)content.getEncoding());
        UpdateRepoEventIT.assertTrue((content.getSizeInBytes() > 0L ? 1 : 0) != 0);
        NodeResource resourceBefore = this.getNodeResourceBefore(resultRepoEvent);
        UpdateRepoEventIT.assertNotNull((String)"Content should not have been null.", (Object)resourceBefore.getContent());
        this.retryingTransactionHelper.doInTransaction(() -> {
            ContentWriter writer = contentService.getWriter(nodeRef, ContentModel.TYPE_CONTENT, true);
            writer.setMimetype("application/pdf");
            writer.setEncoding("UTF-8");
            writer.putContent("A quick brown fox jumps over the lazy dog.");
            return null;
        });
        resource = this.getNodeResource(3);
        content = resource.getContent();
        UpdateRepoEventIT.assertNotNull((Object)content);
        UpdateRepoEventIT.assertEquals((String)"application/pdf", (String)content.getMimeType());
        UpdateRepoEventIT.assertEquals((String)"UTF-8", (String)content.getEncoding());
        UpdateRepoEventIT.assertTrue((content.getSizeInBytes() > 0L ? 1 : 0) != 0);
        resourceBefore = this.getNodeResourceBefore(3);
        UpdateRepoEventIT.assertNotNull((String)"Content should not have been null.", (Object)resourceBefore.getContent());
        content = resourceBefore.getContent();
        UpdateRepoEventIT.assertNotNull((Object)content);
        UpdateRepoEventIT.assertEquals((String)"application/pdf", (String)content.getMimeType());
        UpdateRepoEventIT.assertEquals((String)"UTF-8", (String)content.getEncoding());
        UpdateRepoEventIT.assertTrue((content.getSizeInBytes() > 0L ? 1 : 0) != 0);
        UpdateRepoEventIT.assertNotNull((Object)resourceBefore.getModifiedAt());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getId());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getName());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getNodeType());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.isFile());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.isFolder());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getModifiedByUser());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getCreatedAt());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getCreatedByUser());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getProperties());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getAspectNames());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getPrimaryHierarchy());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getPrimaryAssocQName());
    }

    @Test
    public void testUpdateNodeResourceContent_NullBefore() {
        ContentService contentService = (ContentService)this.applicationContext.getBean("contentService");
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        RepoEvent resultRepoEvent = this.getRepoEvent(1);
        UpdateRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        NodeResource resource = this.getNodeResource(resultRepoEvent);
        UpdateRepoEventIT.assertNull((String)"Content should have been null.", (Object)resource.getContent());
        this.retryingTransactionHelper.doInTransaction(() -> {
            ContentWriter writer = contentService.getWriter(nodeRef, ContentModel.TYPE_CONTENT, true);
            writer.setMimetype("application/pdf");
            writer.setEncoding("UTF-8");
            writer.putContent("test content.");
            return null;
        });
        this.checkNumOfEvents(2);
        resultRepoEvent = this.getRepoEvent(2);
        UpdateRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_UPDATED.getType(), (String)resultRepoEvent.getType());
        resource = this.getNodeResource(resultRepoEvent);
        ContentInfo content = resource.getContent();
        UpdateRepoEventIT.assertNotNull((Object)content);
        UpdateRepoEventIT.assertEquals((String)"application/pdf", (String)content.getMimeType());
        UpdateRepoEventIT.assertEquals((String)"UTF-8", (String)content.getEncoding());
        UpdateRepoEventIT.assertTrue((content.getSizeInBytes() > 0L ? 1 : 0) != 0);
        NodeResource resourceBefore = this.getNodeResourceBefore(resultRepoEvent);
        UpdateRepoEventIT.assertNotNull((String)"Content should not have been null.", (Object)resourceBefore.getContent());
        content = resourceBefore.getContent();
        UpdateRepoEventIT.assertNull((Object)content.getMimeType());
        UpdateRepoEventIT.assertNull((Object)content.getEncoding());
        UpdateRepoEventIT.assertNull((Object)content.getSizeInBytes());
        UpdateRepoEventIT.assertNotNull((Object)resourceBefore.getModifiedAt());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getId());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getName());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getNodeType());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.isFile());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.isFolder());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getModifiedByUser());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getCreatedAt());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getCreatedByUser());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getProperties());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getAspectNames());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getPrimaryHierarchy());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getPrimaryAssocQName());
    }

    @Test
    public void testUpdateNodeResourceContentSameContentSize() {
        ContentService contentService = (ContentService)this.applicationContext.getBean("contentService");
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        RepoEvent resultRepoEvent = this.getRepoEvent(1);
        UpdateRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        NodeResource resource = this.getNodeResource(resultRepoEvent);
        UpdateRepoEventIT.assertNull((String)"Content should have been null.", (Object)resource.getContent());
        this.retryingTransactionHelper.doInTransaction(() -> {
            ContentWriter writer = contentService.getWriter(nodeRef, ContentModel.TYPE_CONTENT, true);
            writer.setMimetype("application/pdf");
            writer.setEncoding("UTF-8");
            writer.putContent("test content a");
            return null;
        });
        this.checkNumOfEvents(2);
        resultRepoEvent = this.getRepoEvent(2);
        UpdateRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_UPDATED.getType(), (String)resultRepoEvent.getType());
        resource = this.getNodeResource(resultRepoEvent);
        ContentInfo content = resource.getContent();
        UpdateRepoEventIT.assertNotNull((Object)content);
        UpdateRepoEventIT.assertEquals((String)"application/pdf", (String)content.getMimeType());
        UpdateRepoEventIT.assertEquals((String)"UTF-8", (String)content.getEncoding());
        UpdateRepoEventIT.assertEquals((long)14L, (long)content.getSizeInBytes());
        NodeResource resourceBefore = this.getNodeResourceBefore(resultRepoEvent);
        UpdateRepoEventIT.assertNotNull((String)"Content should not have been null.", (Object)resourceBefore.getContent());
        this.retryingTransactionHelper.doInTransaction(() -> {
            ContentWriter writer = contentService.getWriter(nodeRef, ContentModel.TYPE_CONTENT, true);
            writer.setMimetype("application/pdf");
            writer.setEncoding("UTF-8");
            writer.putContent("test content b");
            return null;
        });
        resource = this.getNodeResource(3);
        content = resource.getContent();
        UpdateRepoEventIT.assertNotNull((Object)content);
        UpdateRepoEventIT.assertEquals((String)"application/pdf", (String)content.getMimeType());
        UpdateRepoEventIT.assertEquals((String)"UTF-8", (String)content.getEncoding());
        UpdateRepoEventIT.assertEquals((long)14L, (long)content.getSizeInBytes());
        resourceBefore = this.getNodeResourceBefore(3);
        UpdateRepoEventIT.assertNotNull((String)"Content should not have been null.", (Object)resourceBefore.getContent());
        content = resourceBefore.getContent();
        UpdateRepoEventIT.assertNotNull((Object)content);
        UpdateRepoEventIT.assertEquals((String)"application/pdf", (String)content.getMimeType());
        UpdateRepoEventIT.assertEquals((String)"UTF-8", (String)content.getEncoding());
        UpdateRepoEventIT.assertEquals((long)14L, (long)content.getSizeInBytes());
        UpdateRepoEventIT.assertNotNull((Object)resourceBefore.getModifiedAt());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getId());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getName());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getNodeType());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.isFile());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.isFolder());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getModifiedByUser());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getCreatedAt());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getCreatedByUser());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getProperties());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getAspectNames());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getPrimaryHierarchy());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getPrimaryAssocQName());
    }

    @Test
    public void testUpdateContentWithLocalizedProperties() {
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeResource resource = this.getNodeResource(1);
        UpdateRepoEventIT.assertNull(this.getProperty(resource, "cm:description"));
        UpdateRepoEventIT.assertNull((Object)resource.getLocalizedProperties());
        UpdateRepoEventIT.assertNull((Object)this.getEventData(1).getResourceBefore());
        this.retryingTransactionHelper.doInTransaction(() -> {
            MLText localizedDescription = new MLText(this.germanLocale, "german description");
            localizedDescription.addValue(this.defaultLocale, "default description");
            localizedDescription.addValue(this.japaneseLocale, "japanese description");
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)localizedDescription);
            return null;
        });
        resource = this.getNodeResource(2);
        NodeResource resourceBefore = this.getNodeResourceBefore(2);
        UpdateRepoEventIT.assertEquals((String)"default description", (String)((String)this.getProperty(resource, "cm:description")));
        UpdateRepoEventIT.assertEquals((String)"default description", (String)this.getLocalizedProperty(resource, "cm:description", this.defaultLocale));
        UpdateRepoEventIT.assertEquals((String)"german description", (String)this.getLocalizedProperty(resource, "cm:description", this.germanLocale));
        UpdateRepoEventIT.assertEquals((String)"japanese description", (String)this.getLocalizedProperty(resource, "cm:description", this.japaneseLocale));
        UpdateRepoEventIT.assertNull((Object)this.getLocalizedProperty(resourceBefore, "cm:description", this.defaultLocale));
        UpdateRepoEventIT.assertNull((Object)this.getLocalizedProperty(resourceBefore, "cm:description", this.germanLocale));
        UpdateRepoEventIT.assertNull((Object)this.getLocalizedProperty(resourceBefore, "cm:description", this.japaneseLocale));
        this.retryingTransactionHelper.doInTransaction(() -> {
            MLText localizedDescription = new MLText(this.frenchLocale, "french description added");
            localizedDescription.addValue(this.defaultLocale, "default description modified");
            localizedDescription.addValue(this.japaneseLocale, "japanese description");
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)localizedDescription);
            return null;
        });
        resource = this.getNodeResource(3);
        resourceBefore = this.getNodeResourceBefore(3);
        UpdateRepoEventIT.assertEquals((String)"default description modified", (String)((String)this.getProperty(resource, "cm:description")));
        UpdateRepoEventIT.assertEquals((String)"default description modified", (String)this.getLocalizedProperty(resource, "cm:description", this.defaultLocale));
        UpdateRepoEventIT.assertEquals((String)"french description added", (String)this.getLocalizedProperty(resource, "cm:description", this.frenchLocale));
        UpdateRepoEventIT.assertEquals((String)"japanese description", (String)this.getLocalizedProperty(resource, "cm:description", this.japaneseLocale));
        UpdateRepoEventIT.assertFalse((boolean)this.containsLocalizedProperty(resource, "cm:description", this.germanLocale));
        UpdateRepoEventIT.assertEquals((String)"default description", (String)this.getLocalizedProperty(resourceBefore, "cm:description", this.defaultLocale));
        UpdateRepoEventIT.assertEquals((String)"german description", (String)this.getLocalizedProperty(resourceBefore, "cm:description", this.germanLocale));
        UpdateRepoEventIT.assertNull((Object)this.getLocalizedProperty(resourceBefore, "cm:description", this.frenchLocale));
        UpdateRepoEventIT.assertFalse((boolean)this.containsLocalizedProperty(resourceBefore, "cm:description", this.japaneseLocale));
    }

    @Test
    public void testUpdateContentTitle() {
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeResource resource = this.getNodeResource(1);
        UpdateRepoEventIT.assertNotNull((Object)resource.getProperties());
        String title = (String)this.getProperty(resource, "cm:title");
        UpdateRepoEventIT.assertNull((String)"Title should have been null.", (Object)title);
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"test title"));
            return null;
        });
        resource = this.getNodeResource(2);
        NodeResource resourceBefore = this.getNodeResourceBefore(2);
        title = (String)this.getProperty(resource, "cm:title");
        UpdateRepoEventIT.assertEquals((String)"test title", (String)title);
        UpdateRepoEventIT.assertEquals((String)"test title", (String)this.getLocalizedProperty(resource, "cm:title", this.defaultLocale));
        UpdateRepoEventIT.assertNull((Object)this.getLocalizedProperty(resourceBefore, "cm:title", this.defaultLocale));
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"new test title"));
            return null;
        });
        resource = this.getNodeResource(3);
        title = (String)this.getProperty(resource, "cm:title");
        UpdateRepoEventIT.assertEquals((String)"new test title", (String)title);
        UpdateRepoEventIT.assertEquals((String)"new test title", (String)this.getLocalizedProperty(resource, "cm:title", this.defaultLocale));
        resourceBefore = this.getNodeResourceBefore(3);
        title = (String)this.getProperty(resourceBefore, "cm:title");
        UpdateRepoEventIT.assertEquals((String)"Wrong old property.", (String)"test title", (String)title);
        UpdateRepoEventIT.assertEquals((String)"test title", (String)this.getLocalizedProperty(resourceBefore, "cm:title", this.defaultLocale));
        UpdateRepoEventIT.assertNotNull((Object)resourceBefore.getModifiedAt());
    }

    @Test
    public void testUpdateContentTitleFromNull() {
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeResource resource = this.getNodeResource(1);
        UpdateRepoEventIT.assertNotNull((Object)resource.getProperties());
        String title = (String)this.getProperty(resource, "cm:title");
        UpdateRepoEventIT.assertNull((String)"Title should have been null.", (Object)title);
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"test title"));
            return null;
        });
        resource = this.getNodeResource(2);
        title = (String)this.getProperty(resource, "cm:title");
        UpdateRepoEventIT.assertEquals((String)"test title", (String)title);
        NodeResource resourceBefore = this.getNodeResourceBefore(2);
        HashMap<String, Object> expectedResourceBeforeProperties = new HashMap<String, Object>();
        expectedResourceBeforeProperties.put("cm:title", null);
        UpdateRepoEventIT.assertEquals(expectedResourceBeforeProperties, (Object)resourceBefore.getProperties());
        UpdateRepoEventIT.assertNotNull((Object)resourceBefore.getModifiedAt());
    }

    @Test
    public void testUpdateContentDescription() {
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeResource resource = this.getNodeResource(1);
        String desc = (String)this.getProperty(resource, "cm:description");
        UpdateRepoEventIT.assertNull((String)"Description should have been null.", (Object)desc);
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"test description"));
            return null;
        });
        resource = this.getNodeResource(2);
        desc = (String)this.getProperty(resource, "cm:description");
        UpdateRepoEventIT.assertEquals((String)"test description", (String)desc);
        NodeResource resourceBefore = this.getNodeResourceBefore(2);
        UpdateRepoEventIT.assertNotNull((Object)resourceBefore.getProperties());
        HashMap<String, Object> expectedResourceBeforeProperties = new HashMap<String, Object>();
        expectedResourceBeforeProperties.put("cm:description", null);
        UpdateRepoEventIT.assertEquals(expectedResourceBeforeProperties, (Object)resourceBefore.getProperties());
    }

    @Test
    public void testUpdateContentName() {
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeResource resource = this.getNodeResource(1);
        String oldName = resource.getName();
        UpdateRepoEventIT.assertEquals((String)nodeRef.getId(), (String)oldName);
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"test_new_name"));
            return null;
        });
        resource = this.getNodeResource(2);
        UpdateRepoEventIT.assertEquals((String)"test_new_name", (String)resource.getName());
        NodeResource resourceBefore = this.getNodeResourceBefore(2);
        UpdateRepoEventIT.assertEquals((String)oldName, (String)resourceBefore.getName());
        UpdateRepoEventIT.assertNotNull((Object)resourceBefore.getModifiedAt());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getId());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getContent());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getNodeType());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.isFile());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.isFolder());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getModifiedByUser());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getCreatedAt());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getCreatedByUser());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getProperties());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getAspectNames());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getPrimaryHierarchy());
    }

    @Test
    public void testAddAspectToContent() {
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeResource resource = this.getNodeResource(1);
        Set originalAspects = resource.getAspectNames();
        UpdateRepoEventIT.assertNotNull((Object)originalAspects);
        UpdateRepoEventIT.assertFalse((boolean)originalAspects.contains("cm:versionable"));
        UpdateRepoEventIT.assertTrue((boolean)resource.getProperties().isEmpty());
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
            return null;
        });
        resource = this.getNodeResource(2);
        UpdateRepoEventIT.assertNotNull((Object)resource.getAspectNames());
        UpdateRepoEventIT.assertTrue((boolean)resource.getAspectNames().contains("cm:versionable"));
        HashSet<String> expectedAspects = new HashSet<String>(originalAspects);
        expectedAspects.add("cm:versionable");
        UpdateRepoEventIT.assertEquals(expectedAspects, (Object)resource.getAspectNames());
        UpdateRepoEventIT.assertFalse((boolean)resource.getProperties().isEmpty());
        NodeResource resourceBefore = this.getNodeResourceBefore(2);
        UpdateRepoEventIT.assertNotNull((Object)resourceBefore.getAspectNames());
        UpdateRepoEventIT.assertEquals((Object)originalAspects, (Object)resourceBefore.getAspectNames());
        UpdateRepoEventIT.assertNotNull((Object)resourceBefore.getProperties());
        HashMap<String, Object> expectedResourceBeforeProperties = new HashMap<String, Object>();
        expectedResourceBeforeProperties.put("cm:autoVersion", null);
        expectedResourceBeforeProperties.put("cm:initialVersion", null);
        expectedResourceBeforeProperties.put("cm:versionType", null);
        expectedResourceBeforeProperties.put("cm:autoVersionOnUpdateProps", null);
        expectedResourceBeforeProperties.put("cm:versionLabel", null);
        UpdateRepoEventIT.assertEquals(expectedResourceBeforeProperties, (Object)resourceBefore.getProperties());
    }

    @Test
    public void testRemoveAspectFromContentTest() {
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeResource resource = this.getNodeResource(1);
        Set originalAspects = resource.getAspectNames();
        UpdateRepoEventIT.assertNotNull((Object)originalAspects);
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_GEOGRAPHIC, null);
            return null;
        });
        resource = this.getNodeResource(2);
        Set aspectsBeforeRemove = resource.getAspectNames();
        UpdateRepoEventIT.assertNotNull((Object)aspectsBeforeRemove);
        UpdateRepoEventIT.assertTrue((boolean)aspectsBeforeRemove.contains("cm:geographic"));
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_GEOGRAPHIC);
            return null;
        });
        resource = this.getNodeResource(3);
        UpdateRepoEventIT.assertEquals((Object)originalAspects, (Object)resource.getAspectNames());
        NodeResource resourceBefore = this.getNodeResourceBefore(3);
        UpdateRepoEventIT.assertNotNull((Object)resourceBefore.getAspectNames());
        UpdateRepoEventIT.assertEquals((Object)aspectsBeforeRemove, (Object)resourceBefore.getAspectNames());
    }

    @Test
    public void testRemoveAspectPropertiesTest() {
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeResource resource = this.getNodeResource(1);
        Set originalAspects = resource.getAspectNames();
        UpdateRepoEventIT.assertNotNull((Object)originalAspects);
        this.retryingTransactionHelper.doInTransaction(() -> {
            HashMap<QName, String> aspectProperties = new HashMap<QName, String>();
            aspectProperties.put(ContentModel.PROP_LATITUDE, "12.345678");
            aspectProperties.put(ContentModel.PROP_LONGITUDE, "12.345678");
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_GEOGRAPHIC, aspectProperties);
            return null;
        });
        resource = this.getNodeResource(2);
        Set aspectsBeforeRemove = resource.getAspectNames();
        UpdateRepoEventIT.assertNotNull((Object)aspectsBeforeRemove);
        UpdateRepoEventIT.assertTrue((boolean)aspectsBeforeRemove.contains("cm:geographic"));
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_GEOGRAPHIC);
            return null;
        });
        resource = this.getNodeResource(3);
        UpdateRepoEventIT.assertEquals((Object)originalAspects, (Object)resource.getAspectNames());
        NodeResource resourceBefore = this.getNodeResourceBefore(3);
        UpdateRepoEventIT.assertNotNull((Object)resourceBefore.getAspectNames());
        UpdateRepoEventIT.assertEquals((Object)aspectsBeforeRemove, (Object)resourceBefore.getAspectNames());
        UpdateRepoEventIT.assertNotNull((Object)resourceBefore.getProperties());
        UpdateRepoEventIT.assertTrue((boolean)resourceBefore.getProperties().containsKey("cm:latitude"));
        UpdateRepoEventIT.assertTrue((boolean)resourceBefore.getProperties().containsKey("cm:longitude"));
        UpdateRepoEventIT.assertNotNull((Object)resource.getProperties());
        UpdateRepoEventIT.assertFalse((boolean)resource.getProperties().containsKey("cm:latitude"));
        UpdateRepoEventIT.assertFalse((boolean)resource.getProperties().containsKey("cm:longitude"));
    }

    @Test
    public void testCreateAndUpdateInTheSameTransaction() {
        this.retryingTransactionHelper.doInTransaction(() -> {
            NodeRef node1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)GUID.generate()), ContentModel.TYPE_CONTENT).getChildRef();
            this.nodeService.setProperty(node1, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"test description"));
            return null;
        });
        this.checkNumOfEvents(1);
    }

    @Test
    public void testUpdateNodeType() {
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        UpdateRepoEventIT.assertEquals((String)"Created node does not have the correct type", (Object)ContentModel.TYPE_CONTENT, (Object)this.nodeService.getType(nodeRef));
        RepoEvent resultRepoEvent = this.getRepoEvent(1);
        UpdateRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        NodeResource nodeResource = this.getNodeResource(resultRepoEvent);
        UpdateRepoEventIT.assertEquals((String)"cm:content node type was not found", (String)"cm:content", (String)nodeResource.getNodeType());
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.setType(nodeRef, ContentModel.TYPE_FOLDER);
            UpdateRepoEventIT.assertEquals((String)"Wrong node type", (Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(nodeRef));
            return null;
        });
        this.checkNumOfEvents(2);
        resultRepoEvent = this.getRepoEvent(2);
        UpdateRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_UPDATED.getType(), (String)resultRepoEvent.getType());
        nodeResource = this.getNodeResource(resultRepoEvent);
        UpdateRepoEventIT.assertEquals((String)"Incorrect node type was found", (String)"cm:folder", (String)nodeResource.getNodeType());
        NodeResource resourceBefore = this.getNodeResourceBefore(2);
        UpdateRepoEventIT.assertEquals((String)"Incorrect node type was found", (String)"cm:content", (String)resourceBefore.getNodeType());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getId());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getContent());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.isFile());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.isFolder());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getModifiedByUser());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getCreatedAt());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getCreatedByUser());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getProperties());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getAspectNames());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getPrimaryHierarchy());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getPrimaryAssocQName());
    }

    @Test
    public void testUpdateNodeTypeWithCustomType() {
        String modelName = "testModel" + System.currentTimeMillis();
        String modelDescription = "testModel description";
        Pair<String, String> namespacePair = this.getNamespacePair();
        M2Model model = M2Model.createModel((String)((String)namespacePair.getSecond() + ":" + modelName));
        model.createNamespace((String)namespacePair.getFirst(), (String)namespacePair.getSecond());
        model.setDescription(modelDescription);
        String typeName = "testType";
        M2Type m2Type = model.createType((String)namespacePair.getSecond() + ":" + typeName);
        m2Type.setTitle("Test type title");
        CustomModelDefinition modelDefinition = (CustomModelDefinition)this.retryingTransactionHelper.doInTransaction(() -> this.customModelService.createCustomModel(model, true));
        UpdateRepoEventIT.assertNotNull((Object)modelDefinition);
        UpdateRepoEventIT.assertEquals((String)modelName, (String)modelDefinition.getName().getLocalName());
        UpdateRepoEventIT.assertEquals((String)modelDescription, (String)modelDefinition.getDescription());
        Collection types = modelDefinition.getTypeDefinitions();
        UpdateRepoEventIT.assertEquals((int)1, (int)types.size());
        this.checkNumOfEvents(2);
        RepoEvent resultRepoEvent = this.getFilteredEvent(EventType.NODE_CREATED, 0);
        UpdateRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        NodeResource nodeResource = this.getNodeResource(resultRepoEvent);
        UpdateRepoEventIT.assertEquals((String)"Incorrect node type was found", (String)"cm:dictionaryModel", (String)nodeResource.getNodeType());
        this.initTestNamespacePrefixMapping();
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        UpdateRepoEventIT.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)this.nodeService.getType(nodeRef));
        resultRepoEvent = this.getRepoEvent(3);
        nodeResource = this.getNodeResource(resultRepoEvent);
        UpdateRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        UpdateRepoEventIT.assertEquals((String)"cm:content node type was not found", (String)"cm:content", (String)nodeResource.getNodeType());
        QName typeQName = QName.createQName((String)("{" + (String)namespacePair.getFirst() + "}" + typeName));
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.setType(nodeRef, typeQName);
            UpdateRepoEventIT.assertEquals((Object)typeQName, (Object)this.nodeService.getType(nodeRef));
            return null;
        });
        this.checkNumOfEvents(4);
        resultRepoEvent = this.getRepoEvent(4);
        UpdateRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_UPDATED.getType(), (String)resultRepoEvent.getType());
        nodeResource = this.getNodeResource(resultRepoEvent);
        UpdateRepoEventIT.assertEquals((String)"Incorrect node type was found", (String)((String)namespacePair.getSecond() + ":" + typeName), (String)nodeResource.getNodeType());
        NodeResource resourceBefore = this.getNodeResourceBefore(4);
        UpdateRepoEventIT.assertEquals((String)"Incorrect node type was found", (String)"cm:content", (String)resourceBefore.getNodeType());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getId());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getContent());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.isFile());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.isFolder());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getModifiedByUser());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getCreatedAt());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getCreatedByUser());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getProperties());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getAspectNames());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getPrimaryHierarchy());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getPrimaryAssocQName());
    }

    @Test
    public void testUpdateTwiceNodeTypeInTheSameTransaction() {
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        RepoEvent resultRepoEvent = this.getRepoEvent(1);
        UpdateRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        NodeResource nodeResource = this.getNodeResource(resultRepoEvent);
        UpdateRepoEventIT.assertEquals((String)"Incorrect node type was found", (String)"cm:content", (String)nodeResource.getNodeType());
        UpdateRepoEventIT.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)this.nodeService.getType(nodeRef));
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.setType(nodeRef, ContentModel.TYPE_FOLDER);
            this.nodeService.setType(nodeRef, ContentModel.TYPE_CONTENT);
            UpdateRepoEventIT.assertEquals((String)"Wrong node type", (Object)ContentModel.TYPE_CONTENT, (Object)this.nodeService.getType(nodeRef));
            return null;
        });
        this.checkNumOfEvents(2);
        resultRepoEvent = this.getRepoEvent(2);
        UpdateRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_UPDATED.getType(), (String)resultRepoEvent.getType());
        nodeResource = this.getNodeResource(resultRepoEvent);
        UpdateRepoEventIT.assertEquals((String)"Incorrect node type was found", (String)"cm:content", (String)nodeResource.getNodeType());
        NodeResource resourceBefore = this.getNodeResourceBefore(2);
        UpdateRepoEventIT.assertEquals((String)"Incorrect node type was found", (String)"cm:folder", (String)resourceBefore.getNodeType());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getId());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getContent());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.isFile());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.isFolder());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getModifiedByUser());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getCreatedAt());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getCreatedByUser());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getProperties());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getAspectNames());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getPrimaryHierarchy());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getPrimaryAssocQName());
    }

    @Test
    public void testCreateAndUpdateNodeTypeInTheSameTransaction() {
        this.retryingTransactionHelper.doInTransaction(() -> {
            NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)GUID.generate()), ContentModel.TYPE_CONTENT).getChildRef();
            UpdateRepoEventIT.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)this.nodeService.getType(nodeRef));
            this.nodeService.setType(nodeRef, ContentModel.TYPE_FOLDER);
            UpdateRepoEventIT.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(nodeRef));
            return null;
        });
        this.checkNumOfEvents(1);
        RepoEvent resultRepoEvent = this.getRepoEvent(1);
        UpdateRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        NodeResource nodeResource = this.getNodeResource(resultRepoEvent);
        UpdateRepoEventIT.assertEquals((String)"Incorrect node type was found", (String)"cm:folder", (String)nodeResource.getNodeType());
    }

    private Pair<String, String> getNamespacePair() {
        long timeMillis = System.currentTimeMillis();
        String uri = "http://www.alfresco.org/model/testcmmservicenamespace" + timeMillis + "/1.0";
        String prefix = "testcmmservice" + timeMillis;
        return new Pair((Object)uri, (Object)prefix);
    }

    @Test
    public void testMoveFile() {
        NodeRef folder1 = this.createNode(ContentModel.TYPE_FOLDER);
        String folder1ID = this.getNodeResource(1).getId();
        NodeRef folder2 = this.createNode(ContentModel.TYPE_FOLDER);
        String folder2ID = this.getNodeResource(2).getId();
        NodeRef moveFile = this.createNode(ContentModel.TYPE_CONTENT, folder1);
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.moveNode(moveFile, folder2, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent"));
            return null;
        });
        this.checkNumOfEvents(4);
        NodeResource resourceBefore = this.getNodeResourceBefore(4);
        NodeResource resource = this.getNodeResource(4);
        String moveFileParentBeforeMove = (String)resourceBefore.getPrimaryHierarchy().get(0);
        String moveFileParentAfterMove = (String)resource.getPrimaryHierarchy().get(0);
        UpdateRepoEventIT.assertEquals((String)"Wrong node parent.", (String)folder1ID, (String)moveFileParentBeforeMove);
        UpdateRepoEventIT.assertEquals((String)"Wrong node parent.", (String)folder2ID, (String)moveFileParentAfterMove);
        UpdateRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_UPDATED.getType(), (String)this.getRepoEvent(4).getType());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getId());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getName());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getNodeType());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.isFile());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.isFolder());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getModifiedByUser());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getCreatedAt());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getCreatedByUser());
        UpdateRepoEventIT.assertNotNull((Object)resourceBefore.getProperties());
        UpdateRepoEventIT.assertNull((Object)resourceBefore.getAspectNames());
        UpdateRepoEventIT.assertNotNull((Object)resourceBefore.getPrimaryHierarchy());
        UpdateRepoEventIT.assertNull((String)"Content should have been null.", (Object)resource.getContent());
        UpdateRepoEventIT.assertNull((String)"Content should have been null.", (Object)resourceBefore.getContent());
        UpdateRepoEventIT.assertNotNull((Object)resource.getModifiedAt());
        UpdateRepoEventIT.assertNotNull((Object)resource.getModifiedByUser());
        UpdateRepoEventIT.assertNotNull((Object)resource.getAspectNames());
        UpdateRepoEventIT.assertNull((Object)resource.getContent());
        UpdateRepoEventIT.assertFalse((boolean)resource.getProperties().isEmpty());
    }

    @Test
    public void testMoveFolder() {
        NodeRef grandParent = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef parent = this.createNode(ContentModel.TYPE_FOLDER, grandParent);
        NodeRef moveFolder = this.createNode(ContentModel.TYPE_FOLDER, parent);
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.moveNode(moveFolder, grandParent, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent"));
            return null;
        });
        this.checkNumOfEvents(4);
        String grandParentID = this.getNodeResource(1).getId();
        String parentID = this.getNodeResource(2).getId();
        String moveFolderParentBeforeMove = (String)this.getNodeResourceBefore(4).getPrimaryHierarchy().get(0);
        String moveFolderParentAfterMove = (String)this.getNodeResource(4).getPrimaryHierarchy().get(0);
        UpdateRepoEventIT.assertEquals((String)"Wrong node parent.", (String)parentID, (String)moveFolderParentBeforeMove);
        UpdateRepoEventIT.assertEquals((String)"Wrong node parent.", (String)grandParentID, (String)moveFolderParentAfterMove);
        UpdateRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_UPDATED.getType(), (String)this.getRepoEventWithoutWait(4).getType());
    }

    @Test
    public void testMoveFolderStructure() {
        NodeRef root1 = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef root2 = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef grandParent = this.createNode(ContentModel.TYPE_FOLDER, root1);
        NodeRef parent = this.createNode(ContentModel.TYPE_FOLDER, grandParent);
        this.createNode(ContentModel.TYPE_CONTENT, parent);
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.moveNode(grandParent, root2, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent"));
            return null;
        });
        this.checkNumOfEvents(6);
        String root2ID = this.getNodeResource(2).getId();
        String grandParentParentAfterMove = (String)this.getNodeResource(6).getPrimaryHierarchy().get(0);
        UpdateRepoEventIT.assertEquals((String)"Wrong node parent.", (String)root2ID, (String)grandParentParentAfterMove);
        String grandParentID = this.getNodeResource(3).getId();
        String parentIDOfTheParentFolder = (String)this.getNodeResource(4).getPrimaryHierarchy().get(0);
        UpdateRepoEventIT.assertEquals((String)"Wrong node parent.", (String)grandParentID, (String)parentIDOfTheParentFolder);
        String parentID = this.getNodeResource(4).getId();
        String contentParentID = (String)this.getNodeResource(5).getPrimaryHierarchy().get(0);
        UpdateRepoEventIT.assertEquals((String)"Wrong node parent.", (String)parentID, (String)contentParentID);
    }

    @Test
    public void testMoveNodeWithAspects() {
        NodeRef folder1 = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef folder2 = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef moveFile = this.createNode(ContentModel.TYPE_CONTENT, folder1);
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.addAspect(moveFile, ContentModel.ASPECT_VERSIONABLE, null);
            return null;
        });
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.moveNode(moveFile, folder2, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent"));
            return null;
        });
        NodeResource resource = this.getNodeResource(5);
        UpdateRepoEventIT.assertNotNull((Object)resource.getAspectNames());
        UpdateRepoEventIT.assertTrue((String)"Wrong aspect.", (boolean)resource.getAspectNames().contains("cm:versionable"));
        String folder2ID = this.getNodeResource(2).getId();
        String moveFileParentAfterMove = (String)this.getNodeResource(5).getPrimaryHierarchy().get(0);
        UpdateRepoEventIT.assertEquals((String)"Wrong node parent.", (String)folder2ID, (String)moveFileParentAfterMove);
    }

    @Test
    public void testMoveNodeWithProperties() {
        NodeRef folder1 = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef folder2 = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef moveFile = this.createNode(ContentModel.TYPE_CONTENT, folder1);
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.setProperty(moveFile, ContentModel.PROP_NAME, (Serializable)((Object)"test_new_name"));
            this.nodeService.moveNode(moveFile, folder2, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent"));
            return null;
        });
        NodeResource resource = this.getNodeResource(4);
        UpdateRepoEventIT.assertEquals((String)"test_new_name", (String)resource.getName());
        String folder2ID = this.getNodeResource(2).getId();
        String moveFileParentAfterMove = (String)this.getNodeResource(4).getPrimaryHierarchy().get(0);
        UpdateRepoEventIT.assertEquals((String)"Wrong node parent.", (String)folder2ID, (String)moveFileParentAfterMove);
    }

    @Test
    public void testCreateAndMoveFileInTheSameTransaction() {
        this.retryingTransactionHelper.doInTransaction(() -> {
            NodeRef folder1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent"), ContentModel.TYPE_FOLDER).getChildRef();
            NodeRef folder2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent"), ContentModel.TYPE_FOLDER).getChildRef();
            NodeRef fileToMove = this.nodeService.createNode(folder1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent"), ContentModel.TYPE_CONTENT).getChildRef();
            this.nodeService.moveNode(fileToMove, folder2, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent"));
            UpdateRepoEventIT.assertEquals((Object)folder2, (Object)this.nodeService.getPrimaryParent(fileToMove).getParentRef());
            return null;
        });
        this.checkNumOfEvents(3);
        String folder2ID = this.getNodeResource(2).getId();
        String moveFileParentAfterMove = (String)this.getNodeResource(3).getPrimaryHierarchy().get(0);
        UpdateRepoEventIT.assertEquals((String)"Wrong node parent.", (String)folder2ID, (String)moveFileParentAfterMove);
    }

    @Test
    public void testAddAspectRemoveAspectFromContentSameTransactionTest() {
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeResource resource = this.getNodeResource(1);
        Set originalAspects = resource.getAspectNames();
        UpdateRepoEventIT.assertNotNull((Object)originalAspects);
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_GEOGRAPHIC, null);
            this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_GEOGRAPHIC);
            return null;
        });
        this.checkNumOfEvents(1);
    }

    @Test
    public void testAddAspectRemoveAspectAddAspectFromContentSameTransactionTest() {
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeResource resource = this.getNodeResource(1);
        Set originalAspects = resource.getAspectNames();
        UpdateRepoEventIT.assertNotNull((Object)originalAspects);
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_GEOGRAPHIC, null);
            this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_GEOGRAPHIC);
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_GEOGRAPHIC, null);
            return null;
        });
        this.checkNumOfEvents(2);
        resource = this.getNodeResource(2);
        Set aspectsAfter = resource.getAspectNames();
        UpdateRepoEventIT.assertNotNull((Object)aspectsAfter);
        UpdateRepoEventIT.assertEquals((int)2, (int)aspectsAfter.size());
        UpdateRepoEventIT.assertTrue((boolean)aspectsAfter.contains("cm:auditable"));
        UpdateRepoEventIT.assertTrue((boolean)aspectsAfter.contains("cm:auditable"));
        NodeResource resourceBefore = this.getNodeResourceBefore(2);
        Set aspectsBefore = resourceBefore.getAspectNames();
        UpdateRepoEventIT.assertNotNull((Object)aspectsBefore);
        UpdateRepoEventIT.assertEquals((int)1, (int)aspectsBefore.size());
        UpdateRepoEventIT.assertTrue((boolean)aspectsBefore.contains("cm:auditable"));
    }

    @Test
    public void testAddAndRemovePropertyInTheSameTransaction() {
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        this.checkNumOfEvents(1);
        NodeResource resource = this.getNodeResource(1);
        UpdateRepoEventIT.assertTrue((boolean)resource.getProperties().isEmpty());
        this.retryingTransactionHelper.doInTransaction(() -> {
            Map<QName, String> properties = Map.of(ContentModel.PROP_USERNAME, "user1");
            this.nodeService.addProperties(nodeRef, properties);
            this.nodeService.removeProperty(nodeRef, ContentModel.PROP_USERNAME);
            return null;
        });
        resource = this.getNodeResource(1);
        UpdateRepoEventIT.assertTrue((boolean)resource.getProperties().isEmpty());
        List nodeUpdatedEvents = this.getFilteredEvents(EventType.NODE_UPDATED);
        UpdateRepoEventIT.assertEquals((int)0, (int)nodeUpdatedEvents.size());
    }
}

