/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.SpoofedTextContentReader;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.ArgumentHelper;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class FileFolderPerformanceTester
extends TestCase {
    private static Log logger = LogFactory.getLog(FileFolderPerformanceTester.class);
    protected static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    protected RetryingTransactionHelper retryingTransactionHelper;
    protected NodeService nodeService;
    private AuthenticationComponent authenticationComponent;
    private FileFolderService fileFolderService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private NodeRef rootFolderRef;
    private File dataFile;
    private String USERNAME = AuthenticationUtil.getAdminUserName();

    protected NodeService getNodeService() {
        return (NodeService)ctx.getBean("NodeService");
    }

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.retryingTransactionHelper = (RetryingTransactionHelper)ctx.getBean("retryingTransactionHelper");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.searchService = serviceRegistry.getSearchService();
        this.namespaceService = serviceRegistry.getNamespaceService();
        this.nodeService = this.getNodeService();
        this.authenticate(this.USERNAME);
        this.rootFolderRef = this.getOrCreateRootFolder();
        this.dataFile = AbstractContentTransformerTest.loadQuickTestFile("txt");
    }

    private void authenticate(String userName) {
        if (AuthenticationUtil.getSystemUserName().equals(userName)) {
            this.authenticationComponent.setSystemUserAsCurrentUser();
        } else {
            this.authenticationComponent.setCurrentUser(userName);
        }
    }

    public void testSetUp() throws Exception {
        FileFolderPerformanceTester.assertNotNull((Object)this.dataFile);
    }

    protected NodeRef getOrCreateRootFolder() {
        StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        List results = this.searchService.selectNodes(storeRootNodeRef, "/app:company_home", null, (NamespacePrefixResolver)this.namespaceService, false, "xpath");
        if (results.size() == 0) {
            throw new AlfrescoRuntimeException("Didn't find Company Home");
        }
        NodeRef companyHomeNodeRef = (NodeRef)results.get(0);
        return this.fileFolderService.create(companyHomeNodeRef, this.getName() + "_" + System.currentTimeMillis(), ContentModel.TYPE_FOLDER).getNodeRef();
    }

    private void buildStructure(final NodeRef parentNodeRef, int threadCount, final boolean randomOrder, final int folderCount, final int batchCount, final int filesPerBatch, final boolean realFile, final double[] dumpPoints) {
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef[]> createFoldersCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef[]>(){

            public NodeRef[] execute() throws Exception {
                NodeRef[] folders = new NodeRef[folderCount];
                int i = 0;
                while (i < folderCount) {
                    FileInfo folderInfo = FileFolderPerformanceTester.this.fileFolderService.create(parentNodeRef, GUID.generate(), ContentModel.TYPE_FOLDER);
                    folders[i] = folderInfo.getNodeRef();
                    ++i;
                }
                return folders;
            }
        };
        final NodeRef[] folders = (NodeRef[])this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFoldersCallback);
        Runnable runnable = new Runnable(){
            private long start;

            @Override
            public void run() {
                FileFolderPerformanceTester.this.authenticate(FileFolderPerformanceTester.this.USERNAME);
                this.start = System.currentTimeMillis();
                int nextDumpNumber = 0;
                int i = 0;
                while (i < batchCount) {
                    double nextDumpCount;
                    double completedCount = i;
                    double d = nextDumpCount = dumpPoints == null || dumpPoints.length == 0 || nextDumpNumber >= dumpPoints.length ? -1.0 : (double)batchCount * dumpPoints[nextDumpNumber];
                    if (nextDumpCount - 0.5 < completedCount && completedCount < nextDumpCount + 0.5) {
                        this.dumpResults(i);
                        ++nextDumpNumber;
                    }
                    List<NodeRef> foldersList = Arrays.asList(folders);
                    if (randomOrder) {
                        Collections.shuffle(foldersList);
                    }
                    int j = 0;
                    while (j < folders.length) {
                        final NodeRef folderRef = folders[j];
                        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            public Void execute() throws Exception {
                                int i = 0;
                                while (i < filesPerBatch) {
                                    FileInfo fileInfo = (this).FileFolderPerformanceTester.this.fileFolderService.create(folderRef, GUID.generate(), ContentModel.TYPE_CONTENT);
                                    NodeRef nodeRef = fileInfo.getNodeRef();
                                    if (realFile) {
                                        ContentWriter writer = (this).FileFolderPerformanceTester.this.fileFolderService.getWriter(nodeRef);
                                        writer.setEncoding("UTF-8");
                                        writer.setMimetype("text/plain");
                                        writer.putContent((this).FileFolderPerformanceTester.this.dataFile);
                                    } else {
                                        String contentUrl = SpoofedTextContentReader.createContentUrl((Locale)Locale.ENGLISH, (long)((long)Math.random() * 1000L), (long)((long)Math.random() * 1024L), (String[])new String[0]);
                                        SpoofedTextContentReader reader = new SpoofedTextContentReader(contentUrl);
                                        ContentData contentData = reader.getContentData();
                                        (this).FileFolderPerformanceTester.this.nodeService.setProperty(nodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
                                    }
                                    ++i;
                                }
                                return null;
                            }
                        };
                        FileFolderPerformanceTester.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFileCallback);
                        ++j;
                    }
                    ++i;
                }
                this.dumpResults(batchCount);
            }

            private void dumpResults(int currentBatchCount) {
                long end = System.currentTimeMillis();
                long time = end - this.start;
                double average = (double)time / (double)(folderCount * currentBatchCount * filesPerBatch);
                double percentComplete = (double)currentBatchCount / (double)batchCount * 100.0;
                if (percentComplete > 0.0) {
                    System.out.println("\n[" + Thread.currentThread().getName() + "] \n   Created " + currentBatchCount * filesPerBatch + " files in each of " + folderCount + " folders (" + (randomOrder ? "shuffled" : "in order") + ") with " + (realFile ? "real files" : "spoofed content") + " :\n   Progress: " + String.format("%9.2f", percentComplete) + " percent complete \n   Average: " + String.format("%10.2f", average) + " ms per file \n   Average: " + String.format("%10.2f", 1000.0 / average) + " files per second");
                }
            }
        };
        System.out.println("\nStarting " + threadCount + " threads loading " + batchCount * filesPerBatch + " files in each of " + folderCount + " folders (" + (randomOrder ? "shuffled" : "in order") + (String)(filesPerBatch > 1 ? " and " + filesPerBatch + " files per txn" : "") + ").");
        ThreadGroup threadGroup = new ThreadGroup(this.getName());
        Thread[] threads = new Thread[threadCount];
        int i = 0;
        while (i < threadCount) {
            threads[i] = new Thread(threadGroup, runnable, String.format("FileLoader-%02d", i));
            threads[i].start();
            ++i;
        }
        i = 0;
        while (i < threads.length) {
            try {
                threads[i].join();
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
    }

    private void readStructure(NodeRef parentNodeRef, int threadCount, final int repetitions, double[] dumpPoints) {
        final List children = this.fileFolderService.list(parentNodeRef);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FileFolderPerformanceTester.this.authenticate(FileFolderPerformanceTester.this.USERNAME);
                int i = 0;
                while (i < repetitions) {
                    for (final FileInfo fileInfo : children) {
                        final NodeRef folderRef = fileInfo.getNodeRef();
                        RetryingTransactionHelper.RetryingTransactionCallback<Object> readCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                            public Object execute() throws Exception {
                                List tmp = null;
                                if (!fileInfo.isFolder()) {
                                    throw new AlfrescoRuntimeException("Not a folder: " + String.valueOf(folderRef));
                                }
                                long start = System.currentTimeMillis();
                                tmp = (this).FileFolderPerformanceTester.this.fileFolderService.list(folderRef);
                                logger.debug((Object)("List " + tmp.size() + " items in " + (System.currentTimeMillis() - start) + " msecs"));
                                return null;
                            }
                        };
                        FileFolderPerformanceTester.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)readCallback, true);
                    }
                    ++i;
                }
            }
        };
        logger.debug((Object)("\nStarting " + threadCount + " threads reading properties and children of " + children.size() + " folders " + repetitions + " times."));
        long start = System.currentTimeMillis();
        ThreadGroup threadGroup = new ThreadGroup(this.getName());
        Thread[] threads = new Thread[threadCount];
        int i = 0;
        while (i < threadCount) {
            threads[i] = new Thread(threadGroup, runnable, String.format("FileReader-%02d", i));
            threads[i].start();
            ++i;
        }
        i = 0;
        while (i < threads.length) {
            try {
                threads[i].join();
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        logger.debug((Object)("\nFinished reading in " + (System.currentTimeMillis() - start) + " msecs"));
    }

    public void test_4_ordered_3_2_100_spoofed() throws Exception {
        this.buildStructure(this.rootFolderRef, 4, false, 3, 2, 100, false, new double[]{0.05, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9});
        System.out.println("rootFolderRef: " + String.valueOf(this.rootFolderRef));
        this.readStructure(this.rootFolderRef, 4, 5, new double[]{0.25, 0.5, 0.75});
    }

    public void test_4_shuffled_3_2_100_spoofed() throws Exception {
        this.buildStructure(this.rootFolderRef, 4, true, 3, 2, 100, false, new double[]{0.05, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9});
        System.out.println("rootFolderRef: " + String.valueOf(this.rootFolderRef));
        this.readStructure(this.rootFolderRef, 4, 5, new double[]{0.25, 0.5, 0.75});
    }

    public void test_4_shuffled_3_2_100_real() throws Exception {
        this.buildStructure(this.rootFolderRef, 4, true, 3, 2, 100, true, new double[]{0.05, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9});
        System.out.println("rootFolderRef: " + String.valueOf(this.rootFolderRef));
        this.readStructure(this.rootFolderRef, 4, 5, new double[]{0.25, 0.5, 0.75});
    }

    public static void main(String ... args) {
        try (ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();){
            try {
                FileFolderPerformanceTester.run((ApplicationContext)ctx, args);
            }
            catch (Throwable e) {
                System.out.println("Failed to run FileFolder performance test");
                e.printStackTrace();
                ctx.close();
            }
        }
    }

    private static void run(final ApplicationContext ctx, String ... args) throws Throwable {
        ArgumentHelper argHelper = new ArgumentHelper(FileFolderPerformanceTester.getUsage(), args);
        final int fileCount = argHelper.getIntegerValue("files", true, 1, 10000);
        String folderRefStr = argHelper.getStringValue("folder", false, true);
        int threadCount = argHelper.getIntegerValue("threads", false, 1, 100);
        final NodeRef selectedFolderNodeRef = folderRefStr == null ? null : new NodeRef(folderRefStr);
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        final MutableAuthenticationService authenticationService = serviceRegistry.getAuthenticationService();
        final PermissionService permissionService = serviceRegistry.getPermissionService();
        final NodeService nodeService = serviceRegistry.getNodeService();
        final SearchService searchService = serviceRegistry.getSearchService();
        final TransactionService transactionService = serviceRegistry.getTransactionService();
        final FileFolderService fileFolderService = serviceRegistry.getFileFolderService();
        AuthenticationUtil.RunAsWork<String> createUserRunAs = new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                String user = GUID.generate();
                authenticationService.createAuthentication(user, user.toCharArray());
                return user;
            }
        };
        final String user = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)createUserRunAs, (String)AuthenticationUtil.getSystemUserName());
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef folderNodeRef;
                block14: {
                    AuthenticationUtil.pushAuthentication();
                    DictionaryDAO dictionaryDao = (DictionaryDAO)ctx.getBean("dictionaryDAO");
                    M2Model model = M2Model.createModel((String)"tempModel");
                    model.createNamespace("test", "t");
                    model.createNamespace("testx", "");
                    int m = 0;
                    while (m < 30) {
                        model.createAspect("t:aspect_" + m);
                        ++m;
                    }
                    dictionaryDao.putModel(model);
                    folderNodeRef = null;
                    try {
                        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                        if (selectedFolderNodeRef == null) {
                            StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
                            try (ResultSet rs = searchService.query(storeRef, "xpath", "/app:company_home");){
                                if (rs.length() == 0) {
                                    throw new AlfrescoRuntimeException("Didn't find Company Home");
                                }
                                NodeRef companyHomeNodeRef = rs.getNodeRef(0);
                                folderNodeRef = fileFolderService.create(companyHomeNodeRef, "TOP_FOLDER_" + System.currentTimeMillis(), ContentModel.TYPE_FOLDER).getNodeRef();
                                System.out.println("Created folder " + String.valueOf(folderNodeRef) + " with user " + user);
                            }
                            permissionService.setPermission(folderNodeRef, user, "All", true);
                            break block14;
                        }
                        folderNodeRef = selectedFolderNodeRef;
                        permissionService.setPermission(folderNodeRef, user, "All", true);
                        System.out.println("Reusing folder " + String.valueOf(folderNodeRef) + " with user " + user);
                    }
                    finally {
                        AuthenticationUtil.popAuthentication();
                    }
                }
                if (selectedFolderNodeRef == null) {
                    ArrayList<String> largeCollection = new ArrayList<String>(1000);
                    int i = 0;
                    while (i < 50) {
                        largeCollection.add(String.format("Large-collection-value-%05d", i));
                        ++i;
                    }
                    i = 0;
                    while (i < fileCount) {
                        FileInfo fileInfo = fileFolderService.create(folderNodeRef, String.format("FILE-%4d", i), ContentModel.TYPE_CONTENT);
                        NodeRef nodeRef = fileInfo.getNodeRef();
                        nodeService.setProperty(nodeRef, QName.createQName((String)"{test}mv"), (Serializable)largeCollection);
                        int m = 0;
                        while (m < 30) {
                            nodeService.addAspect(nodeRef, QName.createQName((String)("{test}aspect_" + m)), null);
                            ++m;
                        }
                        ContentWriter writer = fileFolderService.getWriter(nodeRef);
                        writer.setEncoding("UTF-8");
                        writer.setMimetype("text/plain");
                        writer.putContent("Some small text data");
                        ++i;
                    }
                    System.out.println("Created " + fileCount + " files in folder " + String.valueOf(folderNodeRef));
                }
                return folderNodeRef;
            }
        };
        AuthenticationUtil.RunAsWork<NodeRef> createRunAs = new AuthenticationUtil.RunAsWork<NodeRef>((RetryingTransactionHelper.RetryingTransactionCallback)createCallback){
            private final /* synthetic */ RetryingTransactionHelper.RetryingTransactionCallback val$createCallback;
            {
                this.val$createCallback = retryingTransactionCallback;
            }

            public NodeRef doWork() throws Exception {
                return (NodeRef)transactionService.getRetryingTransactionHelper().doInTransaction(this.val$createCallback);
            }
        };
        final NodeRef folderNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)createRunAs, (String)user);
        System.out.print("Hit any key to commence directory listing ...");
        System.in.read();
        AuthenticationUtil.RunAsWork<List<FileInfo>> readRunAs = new AuthenticationUtil.RunAsWork<List<FileInfo>>(){

            public List<FileInfo> doWork() throws Exception {
                return fileFolderService.list(folderNodeRef);
            }
        };
        Thread[] threads = new Thread[threadCount];
        int i = 0;
        while (i < threadCount) {
            Thread readThread = new Thread("FolderList-" + i, (AuthenticationUtil.RunAsWork)readRunAs, user, fileCount, folderRefStr){
                int iteration;
                private final /* synthetic */ AuthenticationUtil.RunAsWork val$readRunAs;
                private final /* synthetic */ String val$user;
                private final /* synthetic */ int val$fileCount;
                private final /* synthetic */ String val$folderRefStr;
                {
                    this.val$readRunAs = runAsWork;
                    this.val$user = string;
                    this.val$fileCount = n;
                    this.val$folderRefStr = string2;
                    super($anonymous0);
                    this.iteration = 0;
                }

                @Override
                public void run() {
                    while (++this.iteration <= 2) {
                        this.runImpl();
                    }
                }

                private void runImpl() {
                    String threadName = Thread.currentThread().getName();
                    long start = System.currentTimeMillis();
                    List nodeRefs = (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)this.val$readRunAs, (String)this.val$user);
                    long time = System.currentTimeMillis() - start;
                    double average = (double)time / (double)this.val$fileCount;
                    if (this.val$folderRefStr != null && nodeRefs.size() != this.val$fileCount) {
                        System.err.println("WARNING: Thread " + threadName + " got " + nodeRefs.size() + " but expected " + this.val$fileCount);
                    }
                    System.out.print("\nThread " + threadName + ": \n   Read " + String.format("%4d", this.val$fileCount) + " files \n   Average: " + String.format("%10.2f", average) + " ms per file \n   Average: " + String.format("%10.2f", 1000.0 / average) + " files per second");
                }
            };
            readThread.start();
            threads[i] = readThread;
            ++i;
        }
        i = 0;
        while (i < threads.length) {
            threads[i].join();
            ++i;
        }
    }

    private static String getUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("FileFolderPerformanceTester usage: ").append("\n");
        sb.append("   FileFolderPerformanceTester --files=<filecount> --threads=<threadcount> --folder=<folderref>").append("\n");
        sb.append("      filecount: number of files in the folder").append("\n");
        sb.append("      threadcount: number of threads to do the directory listing").append("\n");
        return sb.toString();
    }
}

