/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import jakarta.transaction.UserTransaction;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transfer.Transfer;
import org.alfresco.repo.transfer.TransferCommons;
import org.alfresco.repo.transfer.TransferServiceImpl2;
import org.alfresco.repo.transfer.TransferTransmitter;
import org.alfresco.repo.transfer.TransferVersionImpl;
import org.alfresco.repo.transfer.reportd.XMLTransferDestinationReportWriter;
import org.alfresco.repo.transfer.requisite.XMLTransferRequsiteWriter;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.transfer.TransferCallback;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferEvent;
import org.alfresco.service.cmr.transfer.TransferEventBegin;
import org.alfresco.service.cmr.transfer.TransferEventCommittingStatus;
import org.alfresco.service.cmr.transfer.TransferEventEndState;
import org.alfresco.service.cmr.transfer.TransferEventEnterState;
import org.alfresco.service.cmr.transfer.TransferEventError;
import org.alfresco.service.cmr.transfer.TransferEventReport;
import org.alfresco.service.cmr.transfer.TransferEventSendingContent;
import org.alfresco.service.cmr.transfer.TransferEventSendingSnapshot;
import org.alfresco.service.cmr.transfer.TransferEventSuccess;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferFailureException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.cmr.transfer.TransferService2;
import org.alfresco.service.cmr.transfer.TransferTarget;
import org.alfresco.service.cmr.transfer.TransferVersion;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class TransferServiceCallbackTest
extends TestCase {
    private static final String TRANSFER_TARGET_NAME = "TransferServiceImplUnitTest";
    private ApplicationContext applicationContext;
    private TransferServiceImpl2 transferServiceImpl;
    private AuthenticationComponent authenticationComponent;
    private TransferTransmitter mockedTransferTransmitter;
    private TransferService2 transferService;
    private DescriptorService descriptorService;
    private TransactionService transactionService;
    private UserTransaction tx;
    private Repository repository;
    private NodeRef companyHome;
    private FileFolderService fileFolderService;
    private NodeRef folder1;
    private NodeRef file1;
    private NodeRef file2;
    private NodeRef file3;
    private String file1ContentUrl;
    private String file2ContentUrl;
    private String file3ContentUrl;
    private TransferVersion version;
    private String localRepositoryId;
    private TransferTarget target;
    private Transfer transfer;
    private TransferCallback mockedCallback;

    protected void setUp() throws Exception {
        this.applicationContext = ApplicationContextHelper.getApplicationContext();
        this.descriptorService = (DescriptorService)this.applicationContext.getBean("DescriptorService");
        this.transferServiceImpl = (TransferServiceImpl2)this.applicationContext.getBean("transferService2");
        this.transferService = this.transferServiceImpl;
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.repository = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("fileFolderService");
        this.localRepositoryId = this.descriptorService.getCurrentRepositoryDescriptor().getId();
        this.version = new TransferVersionImpl(this.descriptorService.getServerDescriptor());
        this.mockedTransferTransmitter = (TransferTransmitter)Mockito.mock(TransferTransmitter.class);
        this.mockedCallback = (TransferCallback)Mockito.mock(TransferCallback.class);
        this.transferServiceImpl.setTransmitter(this.mockedTransferTransmitter);
        this.authenticationComponent.setCurrentUser("admin");
        this.tx = this.transactionService.getUserTransaction();
        this.tx.begin();
        this.target = this.createTransferTarget(TRANSFER_TARGET_NAME);
        this.tx.commit();
        this.tx = this.transactionService.getUserTransaction();
        this.tx.begin();
        this.transfer = new Transfer();
        this.transfer.setTransferTarget(this.target);
        this.transfer.setTransferId(GUID.generate());
        this.transfer.setToVersion(this.version);
        this.companyHome = this.repository.getCompanyHome();
        this.folder1 = this.fileFolderService.create(this.companyHome, "folder1", ContentModel.TYPE_FOLDER).getNodeRef();
        this.file1 = this.fileFolderService.create(this.folder1, "file1", ContentModel.TYPE_CONTENT).getNodeRef();
        this.fileFolderService.getWriter(this.file1).putContent("This is purely test content.");
        this.file1ContentUrl = this.fileFolderService.getFileInfo(this.file1).getContentData().getContentUrl();
        this.file2 = this.fileFolderService.create(this.folder1, "file2", ContentModel.TYPE_CONTENT).getNodeRef();
        this.fileFolderService.getWriter(this.file2).putContent("This is purely test content.");
        this.file2ContentUrl = this.fileFolderService.getFileInfo(this.file2).getContentData().getContentUrl();
        this.file3 = this.fileFolderService.create(this.folder1, "file3", ContentModel.TYPE_CONTENT).getNodeRef();
        this.fileFolderService.getWriter(this.file3).putContent("This is purely test content.");
        this.file3ContentUrl = this.fileFolderService.getFileInfo(this.file3).getContentData().getContentUrl();
    }

    protected void tearDown() throws Exception {
        if (this.tx.getStatus() == 0) {
            this.tx.rollback();
        }
        this.authenticationComponent.clearCurrentSecurityContext();
        super.tearDown();
    }

    public void testCompleteSuccess() {
        TransferProgress status0 = new TransferProgress();
        status0.setStatus(TransferProgress.Status.COMMIT_REQUESTED);
        status0.setCurrentPosition(0);
        status0.setEndPosition(0);
        TransferProgress status1 = new TransferProgress();
        status1.setStatus(TransferProgress.Status.COMMITTING);
        status1.setCurrentPosition(0);
        status1.setEndPosition(4);
        TransferProgress status2 = new TransferProgress();
        status2.setStatus(TransferProgress.Status.COMMITTING);
        status2.setCurrentPosition(3);
        status2.setEndPosition(4);
        TransferProgress status3 = new TransferProgress();
        status3.setStatus(TransferProgress.Status.COMMITTING);
        status3.setCurrentPosition(5);
        status3.setEndPosition(8);
        TransferProgress status4 = new TransferProgress();
        status4.setStatus(TransferProgress.Status.COMPLETE);
        status4.setCurrentPosition(8);
        status4.setEndPosition(8);
        TransferProgress[] statuses = new TransferProgress[]{status0, status1, status2, status3, status4};
        this.configureBasicMockTransmitter(statuses);
        Mockito.when((Object)this.mockedTransferTransmitter.begin(this.target, this.localRepositoryId, this.version)).thenReturn((Object)this.transfer);
        TransferDefinition transferDef = new TransferDefinition();
        transferDef.setNodes(new NodeRef[]{this.folder1, this.file1, this.file2, this.file3});
        this.transferService.transfer(TRANSFER_TARGET_NAME, transferDef, new TransferCallback[]{this.mockedCallback});
        ArrayList<TransferEvent> expectedEvents = new ArrayList<TransferEvent>();
        TransferEventEnterState event = new TransferEventEnterState();
        event.setTransferState(TransferEvent.TransferState.START);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventBegin();
        event.setTransferState(TransferEvent.TransferState.START);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventEndState();
        event.setTransferState(TransferEvent.TransferState.START);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventEnterState();
        event.setTransferState(TransferEvent.TransferState.SENDING_SNAPSHOT);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventSendingSnapshot();
        event.setTransferState(TransferEvent.TransferState.SENDING_SNAPSHOT);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventEndState();
        event.setTransferState(TransferEvent.TransferState.SENDING_SNAPSHOT);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventEnterState();
        event.setTransferState(TransferEvent.TransferState.SENDING_CONTENT);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventSendingContent();
        event.setTransferState(TransferEvent.TransferState.SENDING_CONTENT);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventSendingContent();
        event.setTransferState(TransferEvent.TransferState.SENDING_CONTENT);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventSendingContent();
        event.setTransferState(TransferEvent.TransferState.SENDING_CONTENT);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventEndState();
        event.setTransferState(TransferEvent.TransferState.SENDING_CONTENT);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventEnterState();
        event.setTransferState(TransferEvent.TransferState.PREPARING);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventEndState();
        event.setTransferState(TransferEvent.TransferState.PREPARING);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventEnterState();
        event.setTransferState(TransferEvent.TransferState.COMMITTING);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventCommittingStatus();
        event.setTransferState(TransferEvent.TransferState.COMMITTING);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventCommittingStatus();
        event.setTransferState(TransferEvent.TransferState.COMMITTING);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventCommittingStatus();
        event.setTransferState(TransferEvent.TransferState.COMMITTING);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventCommittingStatus();
        event.setTransferState(TransferEvent.TransferState.COMMITTING);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventEndState();
        event.setTransferState(TransferEvent.TransferState.COMMITTING);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventEnterState();
        event.setTransferState(TransferEvent.TransferState.SUCCESS);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventReport();
        event.setTransferState(TransferEvent.TransferState.SUCCESS);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventReport();
        event.setTransferState(TransferEvent.TransferState.SUCCESS);
        expectedEvents.add((TransferEvent)event);
        event = new TransferEventSuccess();
        event.setTransferState(TransferEvent.TransferState.SUCCESS);
        expectedEvents.add((TransferEvent)event);
        this.verifyCallback(expectedEvents);
    }

    public void testErrorDuringCommit() {
        TransferException error = new TransferException("Commit failed");
        TransferProgress status0 = new TransferProgress();
        status0.setStatus(TransferProgress.Status.COMMIT_REQUESTED);
        status0.setCurrentPosition(0);
        status0.setEndPosition(0);
        TransferProgress status1 = new TransferProgress();
        status1.setStatus(TransferProgress.Status.COMMITTING);
        status1.setCurrentPosition(0);
        status1.setEndPosition(4);
        TransferProgress status2 = new TransferProgress();
        status2.setStatus(TransferProgress.Status.COMMITTING);
        status2.setCurrentPosition(3);
        status2.setEndPosition(4);
        TransferProgress status3 = new TransferProgress();
        status3.setStatus(TransferProgress.Status.COMMITTING);
        status3.setCurrentPosition(5);
        status3.setEndPosition(8);
        TransferProgress status4 = new TransferProgress();
        status4.setStatus(TransferProgress.Status.ERROR);
        status4.setCurrentPosition(8);
        status4.setEndPosition(8);
        status4.setError((Throwable)error);
        TransferProgress[] statuses = new TransferProgress[]{status0, status1, status2, status3, status4};
        this.configureBasicMockTransmitter(statuses);
        Mockito.when((Object)this.mockedTransferTransmitter.begin(this.target, this.localRepositoryId, this.version)).thenReturn((Object)this.transfer);
        TransferDefinition transferDef = new TransferDefinition();
        transferDef.setNodes(new NodeRef[]{this.folder1, this.file1, this.file2, this.file3});
        try {
            this.transferService.transfer(TRANSFER_TARGET_NAME, transferDef, new TransferCallback[]{this.mockedCallback});
            TransferServiceCallbackTest.fail();
        }
        catch (TransferFailureException transferFailureException) {
            ArrayList<TransferEvent> expectedEvents = new ArrayList<TransferEvent>();
            TransferEventEnterState event = new TransferEventEnterState();
            event.setTransferState(TransferEvent.TransferState.START);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventBegin();
            event.setTransferState(TransferEvent.TransferState.START);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventEndState();
            event.setTransferState(TransferEvent.TransferState.START);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventEnterState();
            event.setTransferState(TransferEvent.TransferState.SENDING_SNAPSHOT);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventSendingSnapshot();
            event.setTransferState(TransferEvent.TransferState.SENDING_SNAPSHOT);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventEndState();
            event.setTransferState(TransferEvent.TransferState.SENDING_SNAPSHOT);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventEnterState();
            event.setTransferState(TransferEvent.TransferState.SENDING_CONTENT);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventSendingContent();
            event.setTransferState(TransferEvent.TransferState.SENDING_CONTENT);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventSendingContent();
            event.setTransferState(TransferEvent.TransferState.SENDING_CONTENT);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventSendingContent();
            event.setTransferState(TransferEvent.TransferState.SENDING_CONTENT);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventEndState();
            event.setTransferState(TransferEvent.TransferState.SENDING_CONTENT);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventEnterState();
            event.setTransferState(TransferEvent.TransferState.PREPARING);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventEndState();
            event.setTransferState(TransferEvent.TransferState.PREPARING);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventEnterState();
            event.setTransferState(TransferEvent.TransferState.COMMITTING);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventCommittingStatus();
            event.setTransferState(TransferEvent.TransferState.COMMITTING);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventCommittingStatus();
            event.setTransferState(TransferEvent.TransferState.COMMITTING);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventCommittingStatus();
            event.setTransferState(TransferEvent.TransferState.COMMITTING);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventEndState();
            event.setTransferState(TransferEvent.TransferState.COMMITTING);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventEnterState();
            event.setTransferState(TransferEvent.TransferState.ERROR);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventReport();
            event.setTransferState(TransferEvent.TransferState.ERROR);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventReport();
            event.setTransferState(TransferEvent.TransferState.ERROR);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventError();
            event.setTransferState(TransferEvent.TransferState.ERROR);
            ((TransferEventError)event).setException((Exception)error);
            expectedEvents.add((TransferEvent)event);
            this.verifyCallback(expectedEvents);
        }
    }

    public void testTargetAlreadyLocked() {
        this.configureBasicMockTransmitter(null);
        Mockito.when((Object)this.mockedTransferTransmitter.begin(this.target, "localRepositoryId", this.version)).thenThrow(new Throwable[]{new TransferException("Simulate lock unavailable")});
        TransferDefinition transferDef = new TransferDefinition();
        transferDef.setNodes(new NodeRef[]{this.folder1, this.file1, this.file2, this.file3});
        try {
            this.transferService.transfer(TRANSFER_TARGET_NAME, transferDef, new TransferCallback[]{this.mockedCallback});
            TransferServiceCallbackTest.fail((String)"Transfer expected to throw an exception, but it didn't.");
        }
        catch (TransferFailureException ex) {
            ArrayList<TransferEvent> expectedEvents = new ArrayList<TransferEvent>();
            TransferEventEnterState event = new TransferEventEnterState();
            event.setTransferState(TransferEvent.TransferState.START);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventEndState();
            event.setTransferState(TransferEvent.TransferState.START);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventEnterState();
            event.setTransferState(TransferEvent.TransferState.ERROR);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventReport();
            event.setTransferState(TransferEvent.TransferState.ERROR);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventError();
            event.setTransferState(TransferEvent.TransferState.ERROR);
            ((TransferEventError)event).setException((Exception)ex.getCause());
            expectedEvents.add((TransferEvent)event);
            this.verifyCallback(expectedEvents);
        }
    }

    public void testSendContentFailed() {
        TransferProgress status0 = new TransferProgress();
        status0.setStatus(TransferProgress.Status.CANCELLED);
        status0.setCurrentPosition(0);
        status0.setEndPosition(0);
        TransferProgress[] statuses = new TransferProgress[]{status0};
        this.configureBasicMockTransmitter(statuses);
        Mockito.when((Object)this.mockedTransferTransmitter.begin(this.target, this.localRepositoryId, this.version)).thenReturn((Object)this.transfer);
        ((TransferTransmitter)Mockito.doThrow((Throwable[])new Throwable[]{new TransferException("Simulate failure to write content")}).when((Object)this.mockedTransferTransmitter)).sendManifest((Transfer)ArgumentMatchers.any(Transfer.class), (File)ArgumentMatchers.any(File.class), (OutputStream)ArgumentMatchers.any(OutputStream.class));
        Mockito.when((Object)this.mockedTransferTransmitter.getStatus(this.transfer)).thenReturn((Object)statuses[0]);
        TransferDefinition transferDef = new TransferDefinition();
        transferDef.setNodes(new NodeRef[]{this.folder1, this.file1, this.file2, this.file3});
        try {
            this.transferService.transfer(TRANSFER_TARGET_NAME, transferDef, new TransferCallback[]{this.mockedCallback});
            TransferServiceCallbackTest.fail((String)"Transfer expected to throw an exception, but it didn't.");
        }
        catch (TransferFailureException ex) {
            ArrayList<TransferEvent> expectedEvents = new ArrayList<TransferEvent>();
            TransferEventEnterState event = new TransferEventEnterState();
            event.setTransferState(TransferEvent.TransferState.START);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventBegin();
            event.setTransferState(TransferEvent.TransferState.START);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventEndState();
            event.setTransferState(TransferEvent.TransferState.START);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventEnterState();
            event.setTransferState(TransferEvent.TransferState.SENDING_SNAPSHOT);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventSendingSnapshot();
            event.setTransferState(TransferEvent.TransferState.SENDING_SNAPSHOT);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventEndState();
            event.setTransferState(TransferEvent.TransferState.SENDING_SNAPSHOT);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventEnterState();
            event.setTransferState(TransferEvent.TransferState.ERROR);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventReport();
            event.setTransferState(TransferEvent.TransferState.ERROR);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventReport();
            event.setTransferState(TransferEvent.TransferState.ERROR);
            expectedEvents.add((TransferEvent)event);
            event = new TransferEventError();
            event.setTransferState(TransferEvent.TransferState.ERROR);
            ((TransferEventError)event).setException((Exception)ex.getCause());
            expectedEvents.add((TransferEvent)event);
            this.verifyCallback(expectedEvents);
        }
    }

    private void verifyCallback(List<TransferEvent> expectedEvents) {
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(TransferEvent.class);
        ((TransferCallback)Mockito.verify((Object)this.mockedCallback, (VerificationMode)Mockito.atLeastOnce())).processEvent((TransferEvent)eventCaptor.capture());
        List capturedEvents = eventCaptor.getAllValues();
        TransferServiceCallbackTest.assertEquals((int)expectedEvents.size(), (int)capturedEvents.size());
        int count = capturedEvents.size();
        int index = 0;
        while (index < count) {
            TransferEvent expectedEvent = expectedEvents.get(index);
            TransferEvent capturedEvent = (TransferEvent)capturedEvents.get(index);
            TransferServiceCallbackTest.assertEquals((String)("Event " + index), expectedEvent.getClass(), capturedEvent.getClass());
            TransferServiceCallbackTest.assertEquals((String)("Event " + index), (Object)expectedEvent.getTransferState(), (Object)capturedEvent.getTransferState());
            if (TransferEventError.class.isAssignableFrom(expectedEvent.getClass())) {
                TransferServiceCallbackTest.assertEquals((Object)((TransferEventError)expectedEvent).getException(), (Object)((TransferEventError)capturedEvent).getException());
            }
            ++index;
        }
    }

    private void configureBasicMockTransmitter(TransferProgress[] statuses) {
        ((TransferTransmitter)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                OutputStream os = (OutputStream)invocation.getArguments()[2];
                OutputStreamWriter writer = new OutputStreamWriter(os);
                XMLTransferRequsiteWriter requisiteWriter = new XMLTransferRequsiteWriter((Writer)writer);
                requisiteWriter.startTransferRequsite();
                requisiteWriter.missingContent(TransferServiceCallbackTest.this.file1, ContentModel.PROP_CONTENT, TransferCommons.URLToPartName((String)TransferServiceCallbackTest.this.file1ContentUrl));
                requisiteWriter.missingContent(TransferServiceCallbackTest.this.file2, ContentModel.PROP_CONTENT, TransferCommons.URLToPartName((String)TransferServiceCallbackTest.this.file2ContentUrl));
                requisiteWriter.missingContent(TransferServiceCallbackTest.this.file3, ContentModel.PROP_CONTENT, TransferCommons.URLToPartName((String)TransferServiceCallbackTest.this.file3ContentUrl));
                requisiteWriter.endTransferRequsite();
                ((Writer)writer).flush();
                ((Writer)writer).close();
                return null;
            }
        }).when((Object)this.mockedTransferTransmitter)).sendManifest((Transfer)ArgumentMatchers.any(Transfer.class), (File)ArgumentMatchers.any(File.class), (OutputStream)ArgumentMatchers.any(OutputStream.class));
        ((TransferTransmitter)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                OutputStream os = (OutputStream)invocation.getArguments()[1];
                OutputStreamWriter writer = new OutputStreamWriter(os);
                XMLTransferDestinationReportWriter reportWriter = new XMLTransferDestinationReportWriter();
                reportWriter.startTransferReport("UTF-8", (Writer)writer);
                reportWriter.writeComment("This is a comment");
                reportWriter.writeChangeState("COMMITTING");
                reportWriter.writeCreated(TransferServiceCallbackTest.this.file1, TransferServiceCallbackTest.this.file1, TransferServiceCallbackTest.this.folder1, "");
                reportWriter.writeDeleted(TransferServiceCallbackTest.this.file3, TransferServiceCallbackTest.this.file3, "");
                reportWriter.writeMoved(TransferServiceCallbackTest.this.file2, TransferServiceCallbackTest.this.file2, "", TransferServiceCallbackTest.this.folder1, "");
                reportWriter.endTransferReport();
                return null;
            }
        }).when((Object)this.mockedTransferTransmitter)).getTransferReport((Transfer)ArgumentMatchers.any(Transfer.class), (OutputStream)ArgumentMatchers.any(OutputStream.class));
        if (statuses != null) {
            if (statuses.length > 1) {
                Mockito.when((Object)this.mockedTransferTransmitter.getStatus(this.transfer)).thenReturn((Object)statuses[0], (Object[])Arrays.copyOfRange(statuses, 1, statuses.length));
            } else if (statuses.length == 1) {
                Mockito.when((Object)this.mockedTransferTransmitter.getStatus(this.transfer)).thenReturn((Object)statuses[0]);
            }
        }
    }

    private TransferTarget createTransferTarget(String name) {
        TransferTarget target;
        try {
            target = this.transferService.getTransferTarget(name);
        }
        catch (TransferException transferException) {
            String title = "title";
            String description = "description";
            String endpointProtocol = "http";
            String endpointHost = "host";
            int endpointPort = 8080;
            String endpointPath = "/alfresco/service/api/transfer";
            String username = "user";
            char[] password = "password".toCharArray();
            target = this.transferService.createAndSaveTransferTarget(name, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
        }
        return target;
    }
}

