/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import junit.framework.TestCase;
import org.alfresco.util.HttpClientHelper;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.UsernamePasswordCredentials;

public class HttpClientHelperTest
extends TestCase {
    private static final String HTTP = "http";
    private static final int DEFAULT_HTTP_PORT = 8888;
    private static final int DEFAULT_HTTPS_PORT = 444;

    protected void tearDown() throws Exception {
        this.clearHTTPSystemProperties();
    }

    public void testHTTPProxySettings() {
        String host = "testHost";
        Integer port = 8080;
        this.setHTTPSystemProperties(host, port, "user1", "password", null);
        ProxyHost proxyHost = HttpClientHelper.createProxyHost((String)"http.proxyHost", (String)"http.proxyPort", (int)8888);
        UsernamePasswordCredentials proxyCredentials = (UsernamePasswordCredentials)HttpClientHelper.createProxyCredentials((String)"http.proxyUser", (String)"http.proxyPassword");
        HttpClientHelperTest.assertEquals((String)HTTP, (String)proxyHost.getProtocol().getScheme());
        HttpClientHelperTest.assertEquals((String)host, (String)proxyHost.getHostName());
        HttpClientHelperTest.assertEquals((Object)port, (Object)proxyHost.getPort());
        HttpClientHelperTest.assertEquals((String)"user1", (String)proxyCredentials.getUserName());
        HttpClientHelperTest.assertEquals((String)"password", (String)proxyCredentials.getPassword());
        this.setHTTPSystemProperties(host, null, null, null, null);
        proxyHost = HttpClientHelper.createProxyHost((String)"http.proxyHost", (String)"http.proxyPort", (int)8888);
        proxyCredentials = (UsernamePasswordCredentials)HttpClientHelper.createProxyCredentials((String)"http.proxyUser", (String)"http.proxyPassword");
        HttpClientHelperTest.assertEquals((String)HTTP, (String)proxyHost.getProtocol().getScheme());
        HttpClientHelperTest.assertEquals((String)host, (String)proxyHost.getHostName());
        HttpClientHelperTest.assertEquals((int)8888, (int)proxyHost.getPort());
        HttpClientHelperTest.assertNull((Object)proxyCredentials);
    }

    public void testHTTPSProxySettings() {
        String host = "testHost";
        Integer port = 8444;
        this.setHTTPSSystemProperties(host, port, "user1", "password", null);
        ProxyHost proxyHost = HttpClientHelper.createProxyHost((String)"https.proxyHost", (String)"https.proxyPort", (int)444);
        UsernamePasswordCredentials proxyCredentials = (UsernamePasswordCredentials)HttpClientHelper.createProxyCredentials((String)"https.proxyUser", (String)"https.proxyPassword");
        HttpClientHelperTest.assertEquals((String)HTTP, (String)proxyHost.getProtocol().getScheme());
        HttpClientHelperTest.assertEquals((String)host, (String)proxyHost.getHostName());
        HttpClientHelperTest.assertEquals((Object)port, (Object)proxyHost.getPort());
        HttpClientHelperTest.assertEquals((String)"user1", (String)proxyCredentials.getUserName());
        HttpClientHelperTest.assertEquals((String)"password", (String)proxyCredentials.getPassword());
        this.setHTTPSSystemProperties(host, null, null, null, null);
        proxyHost = HttpClientHelper.createProxyHost((String)"https.proxyHost", (String)"https.proxyPort", (int)444);
        proxyCredentials = (UsernamePasswordCredentials)HttpClientHelper.createProxyCredentials((String)"https.proxyUser", (String)"https.proxyPassword");
        HttpClientHelperTest.assertEquals((String)host, (String)proxyHost.getHostName());
        HttpClientHelperTest.assertEquals((int)444, (int)proxyHost.getPort());
        HttpClientHelperTest.assertNull((Object)proxyCredentials);
    }

    public void testNonProxyHosts() {
        String host = "testHost";
        Integer port = 8080;
        String nonProxyHosts = "local*|127.0.*|100.100.100.*|11.*.*23|www.foo.*|";
        this.setHTTPSystemProperties(host, port, null, null, nonProxyHosts);
        HttpClientHelperTest.assertEquals((boolean)false, (boolean)HttpClientHelper.requiresProxy((String)"localhost"));
        HttpClientHelperTest.assertEquals((boolean)false, (boolean)HttpClientHelper.requiresProxy((String)"100.100.100.222"));
        HttpClientHelperTest.assertEquals((boolean)false, (boolean)HttpClientHelper.requiresProxy((String)"11.11.11.123"));
        HttpClientHelperTest.assertEquals((boolean)false, (boolean)HttpClientHelper.requiresProxy((String)"www.foo.com"));
        HttpClientHelperTest.assertEquals((boolean)true, (boolean)HttpClientHelper.requiresProxy((String)"search.com"));
        HttpClientHelperTest.assertEquals((boolean)true, (boolean)HttpClientHelper.requiresProxy((String)"11.11.11.111"));
        HttpClientHelperTest.assertEquals((boolean)true, (boolean)HttpClientHelper.requiresProxy((String)"foo.com"));
        this.setHTTPSystemProperties(host, port, null, null, null);
        HttpClientHelperTest.assertEquals((boolean)true, (boolean)HttpClientHelper.requiresProxy((String)"search.com"));
        HttpClientHelperTest.assertEquals((boolean)true, (boolean)HttpClientHelper.requiresProxy((String)"127.0.0.1"));
        HttpClientHelperTest.assertEquals((boolean)true, (boolean)HttpClientHelper.requiresProxy((String)"localhost"));
        this.setHTTPSystemProperties(host, port, null, null, "*");
        HttpClientHelperTest.assertEquals((boolean)false, (boolean)HttpClientHelper.requiresProxy((String)"search.com"));
        HttpClientHelperTest.assertEquals((boolean)false, (boolean)HttpClientHelper.requiresProxy((String)"127.0.0.1"));
    }

    private void setHTTPSystemProperties(String host, Integer port, String user, String password, String nonProxyHosts) {
        this.clearHTTPSystemProperties();
        if (host != null) {
            System.setProperty("http.proxyHost", host);
        }
        if (port != null) {
            System.setProperty("http.proxyPort", port.toString());
        }
        if (user != null) {
            System.setProperty("http.proxyUser", user);
        }
        if (password != null) {
            System.setProperty("http.proxyPassword", password);
        }
        if (nonProxyHosts != null) {
            System.setProperty("http.nonProxyHosts", nonProxyHosts);
        }
    }

    private void setHTTPSSystemProperties(String host, Integer port, String user, String password, String nonProxyHosts) {
        this.clearHTTPSystemProperties();
        if (host != null) {
            System.setProperty("https.proxyHost", host);
        }
        if (port != null) {
            System.setProperty("https.proxyPort", port.toString());
        }
        if (user != null) {
            System.setProperty("https.proxyUser", user);
        }
        if (password != null) {
            System.setProperty("https.proxyPassword", password);
        }
        if (nonProxyHosts != null) {
            System.setProperty("http.nonProxyHosts", nonProxyHosts);
        }
    }

    private void clearHTTPSystemProperties() {
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
        System.clearProperty("http.proxyUser");
        System.clearProperty("http.proxyPassword");
        System.clearProperty("https.proxyHost");
        System.clearProperty("https.proxyPort");
        System.clearProperty("https.proxyUser");
        System.clearProperty("https.proxyPassword");
        System.clearProperty("http.nonProxyHosts");
    }
}

