/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.AbstractContentAccessor;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.service.cmr.repository.ArchivedIOException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.TransformationOptionLimits;
import org.alfresco.service.cmr.repository.TransformationOptionPair;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.TempFileProvider;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.util.FileCopyUtils;

@AlfrescoPublicApi
public abstract class AbstractContentReader
extends AbstractContentAccessor
implements ContentReader {
    private static final Log logger = LogFactory.getLog(AbstractContentReader.class);
    private static final Timer timer = new Timer(true);
    private List<ContentStreamListener> listeners = new ArrayList<ContentStreamListener>(2);
    private ReadableByteChannel channel;
    @Deprecated
    private TransformationOptionLimits limits;
    @Deprecated
    private TransformerDebug transformerDebug;
    private boolean useBufferedInputStream = true;

    protected AbstractContentReader(String contentUrl) {
        super(contentUrl);
    }

    @Deprecated
    public void setLimits(TransformationOptionLimits limits) {
        this.limits = limits;
    }

    @Deprecated
    public TransformationOptionLimits getLimits() {
        return this.limits;
    }

    @Deprecated
    public void setTransformerDebug(TransformerDebug transformerDebug) {
        this.transformerDebug = transformerDebug;
    }

    @Deprecated
    public TransformerDebug getTransformerDebug() {
        return this.transformerDebug;
    }

    public void setUseBufferedInputStream(boolean useBufferedInputStream) {
        this.useBufferedInputStream = useBufferedInputStream;
    }

    public boolean getUseBufferedInputStream() {
        return this.useBufferedInputStream;
    }

    public synchronized void addListener(ContentStreamListener listener) {
        if (this.channel != null) {
            throw new RuntimeException("Channel is already in use");
        }
        this.listeners.add(listener);
    }

    protected abstract ContentReader createReader() throws ContentIOException;

    public final ContentReader getReader() throws ContentIOException {
        ContentReader reader = this.createReader();
        if (reader == null) {
            throw new AlfrescoRuntimeException("ContentReader failed to create new reader: \n   reader: " + String.valueOf(this));
        }
        if (reader.getContentUrl() == null || !reader.getContentUrl().equals(this.getContentUrl())) {
            throw new AlfrescoRuntimeException("ContentReader has different URL: \n   reader: " + String.valueOf(this) + "\n   new reader: " + String.valueOf(reader));
        }
        reader.setMimetype(this.getMimetype());
        reader.setEncoding(this.getEncoding());
        reader.setLocale(this.getLocale());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reader spawned new reader: \n   reader: " + String.valueOf(this) + "\n   new reader: " + String.valueOf(reader)));
        }
        return reader;
    }

    public final synchronized boolean isClosed() {
        if (this.channel != null) {
            return !this.channel.isOpen();
        }
        return false;
    }

    public synchronized boolean isChannelOpen() {
        if (this.channel != null) {
            return this.channel.isOpen();
        }
        return false;
    }

    protected abstract ReadableByteChannel getDirectReadableChannel() throws ContentIOException;

    private ReadableByteChannel getCallbackReadableChannel(ReadableByteChannel directChannel, List<ContentStreamListener> listeners) throws ContentIOException {
        ReadableByteChannel callbackChannel = null;
        if (directChannel instanceof FileChannel) {
            callbackChannel = this.getCallbackFileChannel((FileChannel)directChannel, listeners);
        } else {
            AbstractContentAccessor.ChannelCloseCallbackAdvise advise = new AbstractContentAccessor.ChannelCloseCallbackAdvise(this, listeners);
            ProxyFactory proxyFactory = new ProxyFactory((Object)directChannel);
            proxyFactory.addAdvice((Advice)advise);
            callbackChannel = (ReadableByteChannel)proxyFactory.getProxy();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created callback byte channel: \n   original: " + String.valueOf(directChannel) + "\n   new: " + String.valueOf(callbackChannel)));
        }
        return callbackChannel;
    }

    public final synchronized ReadableByteChannel getReadableChannel() throws ContentIOException {
        if (this.channel != null) {
            throw new RuntimeException("A channel has already been opened");
        }
        ReadableByteChannel directChannel = this.getDirectReadableChannel();
        this.channel = this.getCallbackReadableChannel(directChannel, this.listeners);
        super.channelOpened();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Opened channel onto content: " + String.valueOf(this)));
        }
        return this.channel;
    }

    public FileChannel getFileChannel() throws ContentIOException {
        this.channel = this.getReadableChannel();
        FileChannel clientFileChannel = null;
        if (this.channel instanceof FileChannel) {
            clientFileChannel = (FileChannel)this.channel;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Content reader provided direct support for FileChannel: \n   reader: " + String.valueOf(this)));
            }
        } else {
            File tempFile = TempFileProvider.createTempFile((String)"random_read_spoof_", (String)".bin");
            FileContentWriter spoofWriter = new FileContentWriter(tempFile);
            FileChannel spoofWriterChannel = spoofWriter.getFileChannel(false);
            try {
                try {
                    long spoofFileSize = this.getSize();
                    spoofWriterChannel.transferFrom(this.channel, 0L, spoofFileSize);
                }
                catch (IOException e) {
                    throw new ContentIOException("Failed to copy from permanent channel to spoofed temporary channel: \n   reader: " + String.valueOf(this) + "\n   temp: " + String.valueOf(spoofWriter), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                try {
                    spoofWriterChannel.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                spoofWriterChannel.close();
            }
            catch (IOException iOException) {}
            ContentReader spoofReader = spoofWriter.getReader();
            ContentStreamListener spoofListener = new ContentStreamListener(){

                public void contentStreamClosed() throws ContentIOException {
                    try {
                        AbstractContentReader.this.channel.close();
                    }
                    catch (IOException e) {
                        throw new ContentIOException("Failed to close underlying channel", (Throwable)e);
                    }
                }
            };
            spoofReader.addListener(spoofListener);
            clientFileChannel = spoofReader.getFileChannel();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Content writer provided indirect support for FileChannel: \n   writer: " + String.valueOf(this) + "\n   temp writer: " + String.valueOf(spoofWriter)));
            }
        }
        return clientFileChannel;
    }

    public InputStream getContentInputStream() throws ContentIOException {
        try {
            ReadableByteChannel channel = this.getReadableChannel();
            InputStream is = Channels.newInputStream(channel);
            if (this.limits != null) {
                TransformationOptionPair time = this.limits.getTimePair();
                TransformationOptionPair kBytes = this.limits.getKBytesPair();
                long timeoutMs = time.getValue();
                long readLimitBytes = kBytes.getValue() * 1024L;
                if (timeoutMs > 0L || readLimitBytes > 0L) {
                    TransformationOptionPair.Action timeoutAction = time.getAction();
                    TransformationOptionPair.Action readLimitAction = kBytes.getAction();
                    is = new TimeSizeRestrictedInputStream(is, timeoutMs, timeoutAction, readLimitBytes, readLimitAction, this.transformerDebug);
                }
            }
            is = new BufferedInputStream(is);
            return is;
        }
        catch (Throwable e) {
            if (e instanceof ArchivedIOException) {
                throw e;
            }
            throw new ContentIOException("Failed to open stream onto channel: \n   accessor: " + String.valueOf(this), e);
        }
    }

    public final void getContent(OutputStream os) throws ContentIOException {
        try {
            InputStream is = this.getContentInputStream();
            FileCopyUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new ContentIOException("Failed to copy content to output stream: \n   accessor: " + String.valueOf(this), (Throwable)e);
        }
    }

    public final void getContent(File file) throws ContentIOException {
        try {
            InputStream is = this.getContentInputStream();
            FileOutputStream os = new FileOutputStream(file);
            FileCopyUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new ContentIOException("Failed to copy content to file: \n   accessor: " + String.valueOf(this) + "\n   file: " + String.valueOf(file), (Throwable)e);
        }
    }

    public final String getContentString(int length) throws ContentIOException {
        if (length < 0 || length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Character count must be positive and within range");
        }
        Reader reader = null;
        try {
            char[] buffer = new char[length];
            String encoding = this.getEncoding();
            reader = encoding == null ? new InputStreamReader(this.getContentInputStream()) : new InputStreamReader(this.getContentInputStream(), encoding);
            int count = reader.read(buffer, 0, length);
            String string = count != -1 ? new String(buffer, 0, count) : "";
            return string;
        }
        catch (IOException e) {
            throw new ContentIOException("Failed to copy content to string: \n   accessor: " + String.valueOf(this) + "\n   length: " + length, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    public final String getContentString() throws ContentIOException {
        try {
            InputStream is = this.getContentInputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            FileCopyUtils.copy((InputStream)is, (OutputStream)os);
            byte[] bytes = os.toByteArray();
            String encoding = this.getEncoding();
            String content = encoding == null ? new String(bytes) : new String(bytes, encoding);
            return content;
        }
        catch (ArchivedIOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContentIOException("Failed to copy content to string: \n   accessor: " + String.valueOf(this), (Throwable)e);
        }
    }

    public static boolean compareContentReaders(ContentReader left, ContentReader right) throws ContentIOException {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.getSize() != right.getSize()) {
            return false;
        }
        InputStream leftIs = left.getContentInputStream();
        InputStream rightIs = right.getContentInputStream();
        try {
            return EqualsHelper.binaryStreamEquals((InputStream)leftIs, (InputStream)rightIs);
        }
        catch (IOException iOException) {
            throw new ContentIOException("Failed to compare content reader streams: \n   Left:  " + String.valueOf(left) + "\n   right: " + String.valueOf(right));
        }
    }

    private class TimeSizeRestrictedInputStream
    extends InputStream {
        private final AtomicBoolean timeoutFlag = new AtomicBoolean(false);
        private final InputStream is;
        private final long timeoutMs;
        private final long readLimitBytes;
        private final TransformationOptionPair.Action timeoutAction;
        private final TransformationOptionPair.Action readLimitAction;
        private final TransformerDebug transformerDebug;
        private long readCount = 0L;

        public TimeSizeRestrictedInputStream(InputStream is, long timeoutMs, TransformationOptionPair.Action timeoutAction, long readLimitBytes, TransformationOptionPair.Action readLimitAction, TransformerDebug transformerDebug) {
            this.is = AbstractContentReader.this.useBufferedInputStream ? new BufferedInputStream(is) : is;
            this.timeoutMs = timeoutMs;
            this.timeoutAction = timeoutAction;
            this.readLimitBytes = readLimitBytes;
            this.readLimitAction = readLimitAction;
            this.transformerDebug = transformerDebug;
            if (timeoutMs > 0L) {
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        TimeSizeRestrictedInputStream.this.timeoutFlag.set(true);
                    }
                }, timeoutMs);
            }
        }

        @Override
        public int read() throws IOException {
            if (this.hitTimeout() || this.hitReadLimit()) {
                return -1;
            }
            int n = this.is.read();
            if (n > 0) {
                ++this.readCount;
            }
            return n;
        }

        private boolean hitTimeout() throws IOException {
            if (this.timeoutMs > 0L && this.timeoutFlag.get()) {
                this.timeoutAction.throwIOExceptionIfRequired("Transformation has taken too long (" + this.timeoutMs / 1000L + " seconds)", this.transformerDebug);
                return true;
            }
            return false;
        }

        private boolean hitReadLimit() throws IOException {
            if (this.readLimitBytes > 0L && this.readCount >= this.readLimitBytes) {
                this.readLimitAction.throwIOExceptionIfRequired("Transformation has read too many bytes (" + this.readLimitBytes / 1024L + "K)", this.transformerDebug);
                return true;
            }
            return false;
        }

        @Override
        public void close() throws IOException {
            try {
                this.is.close();
            }
            finally {
                super.close();
            }
        }
    }
}

