/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl.stores;

import java.util.Iterator;
import java.util.Map;
import org.alfresco.repo.bulkimport.ContentStoreMapProvider;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public abstract class AbstractContentStoreMapProvider
extends AbstractLifecycleBean
implements ContentStoreMapProvider {
    private static final Log logger = LogFactory.getLog(AbstractContentStoreMapProvider.class);
    protected ContentStore contentStore;
    protected Map<String, ContentStore> storeMap;

    protected abstract void setUpStoreMap();

    protected void onBootstrap(ApplicationEvent event) {
        this.setUpStoreMap();
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    @Override
    public ContentStore checkAndGetStore(String storeName) {
        ContentStore store = this.storeMap.get(storeName);
        if (store == null) {
            Object validStores = "";
            Iterator<String> it = this.storeMap.keySet().iterator();
            while (it.hasNext()) {
                validStores = (String)validStores + "'" + it.next() + "'" + (it.hasNext() ? " , " : "");
            }
            throw new IllegalArgumentException("given store name : '" + storeName + "' is not part of the registered stores : " + (String)validStores);
        }
        if (!(store instanceof FileContentStore) && logger.isWarnEnabled()) {
            logger.warn((Object)("selected store '" + storeName + "' is not a FileContentStore. Is the implementation based on local files ?"));
        }
        return store;
    }

    @Override
    public Map<String, ContentStore> getStoreMap() {
        return this.storeMap;
    }

    public ContentStore getContentStore() {
        return this.contentStore;
    }

    public void setContentStore(ContentStore contentStore) {
        this.contentStore = contentStore;
    }
}

