/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.impl.lucene.LuceneQueryLanguageSPI;
import org.alfresco.repo.search.impl.solr.SolrQueryLanguage;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.StatsParameters;
import org.alfresco.service.cmr.search.StatsResultSet;
import org.alfresco.service.cmr.search.StatsService;

public class SolrStatsService
implements StatsService {
    private IndexerAndSearcher searcher;

    public void setSearcher(IndexerAndSearcher searcher) {
        this.searcher = searcher;
    }

    public StatsResultSet query(StatsParameters searchParameters) {
        searchParameters.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        LuceneQueryLanguageSPI language = this.searcher.getQueryLanguages().get(searchParameters.getLanguage().toLowerCase());
        if (language != null && "index-fts-alfresco".equals(language.getName())) {
            SolrQueryLanguage solr = (SolrQueryLanguage)language;
            return solr.executeStatsQuery(searchParameters);
        }
        throw new SearcherException("Unknown stats query language: " + searchParameters.getLanguage());
    }
}

