/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.GUID;
import org.alfresco.util.test.junitrules.AbstractPersonRule;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.springframework.context.ApplicationContext;

public class AlfrescoPerson
extends AbstractPersonRule {
    private final String userName;
    private NodeRef personNodeRef;

    public AlfrescoPerson(ApplicationContext appContext) {
        this(appContext, GUID.generate());
    }

    public AlfrescoPerson(ApplicationContextInit appContextRule) {
        this(appContextRule, GUID.generate());
    }

    public AlfrescoPerson(ApplicationContext appContext, String userName) {
        super(appContext);
        this.userName = userName;
    }

    public AlfrescoPerson(ApplicationContextInit appContextRule, String userName) {
        super(appContextRule);
        this.userName = userName;
    }

    protected void before() {
        ApplicationContext ctxt = this.getApplicationContext();
        RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)ctxt.getBean("retryingTransactionHelper");
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AlfrescoPerson.this.personNodeRef = AlfrescoPerson.this.createPerson(AlfrescoPerson.this.userName);
                return null;
            }
        });
    }

    protected void after() {
        ApplicationContext ctxt = this.getApplicationContext();
        RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)ctxt.getBean("retryingTransactionHelper");
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AlfrescoPerson.this.deletePerson(AlfrescoPerson.this.userName);
                return null;
            }
        });
    }

    public String getUsername() {
        return this.userName;
    }

    public NodeRef getPersonNode() {
        return this.personNodeRef;
    }
}

