/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class Repository
implements ApplicationContextAware {
    private ProcessorLifecycle lifecycle = new ProcessorLifecycle();
    private RetryingTransactionHelper retryingTransactionHelper;
    private NamespaceService namespaceService;
    private SearchService searchService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private PersonService personService;
    private StoreRef companyHomeStore;
    private String companyHomePath;
    private String sharedHomePath;
    private String guestHomePath;
    private SimpleCache<String, NodeRef> singletonCache;
    private final String KEY_COMPANYHOME_NODEREF = "key.companyhome.noderef";
    private final String KEY_GUESTHOME_NODEREF = "key.guesthome.noderef";
    private final String KEY_SHAREDHOME_NODEREF = "key.sharedhome.noderef";

    public void setCompanyHomeStore(String companyHomeStore) {
        this.companyHomeStore = new StoreRef(companyHomeStore);
    }

    public void setCompanyHomePath(String companyHomePath) {
        this.companyHomePath = companyHomePath;
    }

    public void setSharedHomePath(String sharedHomePath) {
        this.sharedHomePath = sharedHomePath;
    }

    public void setSingletonCache(SimpleCache<String, NodeRef> singletonCache) {
        this.singletonCache = singletonCache;
    }

    public void setGuestHomePath(String guestHomePath) {
        this.guestHomePath = guestHomePath;
    }

    public void setTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.lifecycle.setApplicationContext(applicationContext);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        this.lifecycle.onApplicationEvent(event);
    }

    protected void initContext() {
    }

    public NodeRef getRootHome() {
        return this.nodeService.getRootNode(this.companyHomeStore);
    }

    public NodeRef getCompanyHome() {
        NodeRef companyHomeRef = (NodeRef)this.singletonCache.get((Serializable)((Object)"key.companyhome.noderef"));
        if (companyHomeRef == null) {
            companyHomeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    return Repository.this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                        @Override
                        public NodeRef execute() throws Exception {
                            List refs = (this).Repository.this.searchService.selectNodes((this).Repository.this.nodeService.getRootNode((this).Repository.this.companyHomeStore), (this).Repository.this.companyHomePath, null, (NamespacePrefixResolver)(this).Repository.this.namespaceService, false);
                            if (refs.size() != 1) {
                                throw new IllegalStateException("Invalid company home path: " + (this).Repository.this.companyHomePath + " - found: " + refs.size());
                            }
                            return (NodeRef)refs.get(0);
                        }
                    }, true);
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            this.singletonCache.put((Serializable)((Object)"key.companyhome.noderef"), (Object)companyHomeRef);
        }
        return companyHomeRef;
    }

    public NodeRef getGuestHome() {
        NodeRef guestHomeRef = (NodeRef)this.singletonCache.get((Serializable)((Object)"key.guesthome.noderef"));
        if (guestHomeRef == null) {
            guestHomeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    return Repository.this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                        @Override
                        public NodeRef execute() throws Exception {
                            List refs = (this).Repository.this.searchService.selectNodes((this).Repository.this.nodeService.getRootNode((this).Repository.this.companyHomeStore), (this).Repository.this.guestHomePath, null, (NamespacePrefixResolver)(this).Repository.this.namespaceService, false);
                            if (refs.size() != 1) {
                                throw new IllegalStateException("Invalid guest home path: " + (this).Repository.this.guestHomePath + " - found: " + refs.size());
                            }
                            return (NodeRef)refs.get(0);
                        }
                    }, true);
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            this.singletonCache.put((Serializable)((Object)"key.companyhome.noderef"), (Object)guestHomeRef);
        }
        return guestHomeRef;
    }

    public NodeRef getSharedHome() {
        NodeRef sharedHomeRef = (NodeRef)this.singletonCache.get((Serializable)((Object)"key.sharedhome.noderef"));
        if (sharedHomeRef == null) {
            sharedHomeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    return Repository.this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                        @Override
                        public NodeRef execute() throws Exception {
                            List refs = (this).Repository.this.searchService.selectNodes((this).Repository.this.nodeService.getRootNode((this).Repository.this.companyHomeStore), (this).Repository.this.sharedHomePath, null, (NamespacePrefixResolver)(this).Repository.this.namespaceService, false);
                            if (refs.size() != 1) {
                                throw new IllegalStateException("Invalid shared home path: " + (this).Repository.this.sharedHomePath + " - found: " + refs.size());
                            }
                            return (NodeRef)refs.get(0);
                        }
                    }, true);
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            this.singletonCache.put((Serializable)((Object)"key.sharedhome.noderef"), (Object)sharedHomeRef);
        }
        return sharedHomeRef;
    }

    public NodeRef getPerson() {
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> callback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                NodeRef person = null;
                String currentUserName = AuthenticationUtil.getRunAsUser();
                if (currentUserName != null && Repository.this.personService.personExists(currentUserName)) {
                    person = Repository.this.personService.getPerson(currentUserName);
                }
                return person;
            }
        };
        return this.retryingTransactionHelper.doInTransaction(callback, true);
    }

    public NodeRef getFullyAuthenticatedPerson() {
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> callback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                NodeRef person = null;
                String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
                if (currentUserName != null && Repository.this.personService.personExists(currentUserName)) {
                    person = Repository.this.personService.getPerson(currentUserName);
                }
                return person;
            }
        };
        return this.retryingTransactionHelper.doInTransaction(callback, true);
    }

    public NodeRef getUserHome(final NodeRef person) {
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> callback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                NodeRef homeFolderRef = (NodeRef)Repository.this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER);
                if (homeFolderRef != null && Repository.this.nodeService.exists(homeFolderRef)) {
                    return homeFolderRef;
                }
                return null;
            }
        };
        return this.retryingTransactionHelper.doInTransaction(callback, true);
    }

    public NodeRef findNodeRef(String referenceType, String[] reference) {
        NodeRef nodeRef = null;
        if (reference.length < 3) {
            throw new AlfrescoRuntimeException("Reference " + Arrays.toString(reference) + " is not properly formed");
        }
        StoreRef storeRef = new StoreRef(reference[0], reference[1]);
        if (this.nodeService.exists(storeRef)) {
            if (referenceType.equals("node")) {
                NodeRef relRef = new NodeRef(storeRef, reference[2]);
                if (this.nodeService.exists(relRef)) {
                    if (reference.length == 3 || reference.length == 4) {
                        nodeRef = relRef;
                    } else {
                        ArrayList<String> paths = new ArrayList<String>(reference.length - 3);
                        int i = 3;
                        while (i < reference.length) {
                            paths.add(reference[i]);
                            ++i;
                        }
                        try {
                            NodeRef parentRef = this.nodeService.getPrimaryParent(relRef).getParentRef();
                            FileInfo fileInfo = this.fileFolderService.resolveNamePath(parentRef, paths);
                            nodeRef = fileInfo.getNodeRef();
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                }
            } else if (referenceType.equals("path")) {
                NodeRef rootNodeRef = this.getCompanyHome();
                if (reference.length == 3) {
                    if (reference[2].equals(this.nodeService.getPrimaryParent(rootNodeRef).getQName().toPrefixString((NamespacePrefixResolver)this.namespaceService))) {
                        nodeRef = rootNodeRef;
                    }
                } else {
                    String[] path = new String[reference.length - 3];
                    System.arraycopy(reference, 3, path, 0, path.length);
                    try {
                        FileInfo fileInfo = this.fileFolderService.resolveNamePath(rootNodeRef, Arrays.asList(path));
                        nodeRef = fileInfo.getNodeRef();
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                }
            } else {
                throw new AlfrescoRuntimeException("Web Script Node URL specified an invalid reference style of '" + referenceType + "'");
            }
        }
        return nodeRef;
    }

    private class ProcessorLifecycle
    extends AbstractLifecycleBean {
        private ProcessorLifecycle() {
        }

        protected void onBootstrap(ApplicationEvent event) {
            Repository.this.initContext();
        }

        protected void onShutdown(ApplicationEvent event) {
        }
    }
}

