/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import org.alfresco.repo.virtual.ref.UuidNodeIdRadixHasher;
import org.junit.Assert;
import org.junit.Test;

public class UuidNodeIdRadixHasherTest {
    @Test
    public void testRadix36Hashing() {
        UuidNodeIdRadixHasher nodeIdHasher = new UuidNodeIdRadixHasher(36);
        String uuid = "0d3b26ff-c4c1-4680-8622-8608ea7ab4b2";
        String hashedUuid = nodeIdHasher.hash(uuid);
        String expected = "s765ou6qn3lf446dbvrkv3qq";
        Assert.assertEquals((Object)expected, (Object)hashedUuid);
    }

    @Test
    public void testRadix36Lookup() {
        UuidNodeIdRadixHasher nodeIdHasher = new UuidNodeIdRadixHasher(36);
        String hashedUuid = "s765ou6qn3lf446dbvrkv3qq";
        String uuid = nodeIdHasher.lookup(hashedUuid);
        String expected = "0d3b26ff-c4c1-4680-8622-8608ea7ab4b2";
        Assert.assertEquals((Object)expected, (Object)uuid);
    }

    @Test
    public void testRadix16Hashing() {
        UuidNodeIdRadixHasher nodeIdHasher = new UuidNodeIdRadixHasher(16);
        String uuid = "0d3b26ff-c4c1-4680-8622-8608ea7ab4b2";
        String hashedUuid = nodeIdHasher.hash(uuid);
        String expected = "d3b26ffc4c1468086228608ea7ab4b2";
        Assert.assertEquals((Object)expected, (Object)hashedUuid);
    }

    @Test
    public void testRadix16Lookup() {
        UuidNodeIdRadixHasher nodeIdHasher = new UuidNodeIdRadixHasher(16);
        String hashedUuid = "d3b26ffc4c1468086228608ea7ab4b2";
        String uuid = nodeIdHasher.lookup(hashedUuid);
        String expected = "0d3b26ff-c4c1-4680-8622-8608ea7ab4b2";
        Assert.assertEquals((Object)expected, (Object)uuid);
    }

    @Test(expected=RuntimeException.class)
    public void testHashForEmptyUuid() {
        UuidNodeIdRadixHasher nodeIdHasher = new UuidNodeIdRadixHasher(36);
        String uuid = "";
        nodeIdHasher.hash(uuid);
    }

    @Test(expected=RuntimeException.class)
    public void testLookupForEmptyUuid() {
        UuidNodeIdRadixHasher nodeIdHasher = new UuidNodeIdRadixHasher(36);
        String hashedUuid = "";
        nodeIdHasher.lookup(hashedUuid);
    }
}

