/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.PropertyMap;
import org.junit.After;
import org.junit.Before;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class BaseAlfrescoSpringTest
extends BaseSpringTest {
    protected NodeService nodeService;
    protected ContentService contentService;
    protected MutableAuthenticationService authenticationService;
    protected StoreRef storeRef;
    protected NodeRef rootNodeRef;
    protected ActionService actionService;
    protected TransactionService transactionService;
    protected AuthenticationComponent authenticationComponent;

    @Before
    public void before() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
    }

    @After
    public void after() throws Exception {
        this.authenticationService.clearCurrentSecurityContext();
    }

    protected NodeRef createNode(NodeRef parentNode, String name, QName type) {
        HashMap<QName, CallSite> props = new HashMap<QName, CallSite>();
        String fullName = name + System.currentTimeMillis();
        props.put(ContentModel.PROP_NAME, (CallSite)((Object)fullName));
        QName childName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)fullName);
        ChildAssociationRef childAssoc = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, childName, type, props);
        return childAssoc.getChildRef();
    }

    protected void createUser(String userName) {
        this.createUser(userName, userName);
    }

    protected void createUser(String userName, String nameSuffix) {
        this.createUser(userName, userName, "PWD");
    }

    protected void createUser(String userName, String nameSuffix, String password) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, password.toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)("firstName" + nameSuffix));
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)("lastName" + nameSuffix));
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)("email" + nameSuffix + "@email.com"));
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            PersonService personService = (PersonService)this.applicationContext.getBean("personService");
            personService.createPerson((Map)ppOne);
        }
    }

    protected void deleteUser(String userName) {
        PersonService personService = (PersonService)this.applicationContext.getBean("personService");
        personService.deletePerson(userName);
    }
}

