/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import org.alfresco.repo.jscript.AlfrescoScriptThreadMxBeanWrapper;
import org.mozilla.javascript.Context;

public class AlfrescoScriptContext
extends Context {
    private long startTime;
    private long threadId;
    private long startMemory = -1L;
    private boolean limitsEnabled = false;
    private AlfrescoScriptThreadMxBeanWrapper threadMxBeanWrapper = null;

    public void setStartMemory() {
        if (this.isMemoryLimitSupported()) {
            this.startMemory = this.threadMxBeanWrapper.getThreadAllocatedBytes(this.threadId);
        }
    }

    public long getUsedMemory() {
        long usedMemory = -1L;
        if (this.isMemoryLimitSupported()) {
            long currentAllocatedBytes = this.threadMxBeanWrapper.getThreadAllocatedBytes(this.threadId);
            usedMemory = currentAllocatedBytes - this.startMemory;
        }
        return usedMemory;
    }

    public boolean isMemoryLimitSupported() {
        AlfrescoScriptThreadMxBeanWrapper tmxw = this.getThreadMxBeanWrapper();
        return tmxw != null && tmxw.isThreadAllocatedMemorySupported();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public long getStartMemory() {
        return this.startMemory;
    }

    public void setStartMemory(long startMemory) {
        this.startMemory = startMemory;
    }

    public boolean isLimitsEnabled() {
        return this.limitsEnabled;
    }

    public void setLimitsEnabled(boolean limitsEnabled) {
        this.limitsEnabled = limitsEnabled;
    }

    public AlfrescoScriptThreadMxBeanWrapper getThreadMxBeanWrapper() {
        if (this.threadMxBeanWrapper == null) {
            this.threadMxBeanWrapper = new AlfrescoScriptThreadMxBeanWrapper();
        }
        return this.threadMxBeanWrapper;
    }

    public void setThreadMxBeanWrapper(AlfrescoScriptThreadMxBeanWrapper threadMxBeanWrapper) {
        this.threadMxBeanWrapper = threadMxBeanWrapper;
    }
}

