/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PackageManager {
    private static final QName PCKG_CONTAINS = WorkflowModel.ASSOC_PACKAGE_CONTAINS;
    private static final QName PCKG_ASPECT = WorkflowModel.ASPECT_WORKFLOW_PACKAGE;
    private static final String CM_URL = "http://www.alfresco.org/model/content/1.0";
    private static final Log LOGGER = LogFactory.getLog(PackageManager.class);
    private final WorkflowService workflowService;
    private final NodeService nodeService;
    private final Log logger;
    private final BehaviourFilter behaviourFilter;
    private final Set<NodeRef> addItems = new HashSet<NodeRef>();
    private final Set<NodeRef> removeItems = new HashSet<NodeRef>();

    public PackageManager(WorkflowService workflowService, NodeService nodeService, BehaviourFilter behaviourFilter, Log logger) {
        this.workflowService = workflowService;
        this.nodeService = nodeService;
        this.behaviourFilter = behaviourFilter;
        this.logger = logger == null ? LOGGER : logger;
    }

    public void addItems(List<NodeRef> items) {
        this.addItems.addAll(items);
    }

    public void addItems(String items) {
        List nodes = NodeRef.getNodeRefs((String)items);
        this.addItems(nodes);
    }

    public void addItemsAsStrings(List<String> itemStrs) {
        for (String itemStr : itemStrs) {
            this.addItem(itemStr);
        }
    }

    public void addItem(NodeRef item) {
        this.addItems.add(item);
    }

    public void addItem(String itemStr) {
        this.addItem(new NodeRef(itemStr));
    }

    public void removeItems(List<NodeRef> items) {
        this.removeItems.addAll(items);
    }

    public void removeItems(String items) {
        List nodes = NodeRef.getNodeRefs((String)items);
        this.removeItems(nodes);
    }

    public void removeItemsAsStrings(List<String> itemStrs) {
        for (String itemStr : itemStrs) {
            this.removeItem(itemStr);
        }
    }

    public void removeItem(NodeRef item) {
        this.removeItems.add(item);
    }

    public void removeItem(String itemStr) {
        this.removeItem(new NodeRef(itemStr));
    }

    public NodeRef create(NodeRef container) throws WorkflowException {
        NodeRef packageRef = this.workflowService.createPackage(container);
        this.update(packageRef);
        return packageRef;
    }

    public void update(final NodeRef packageRef) {
        if (this.addItems.isEmpty() && this.removeItems.isEmpty()) {
            return;
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                PackageManager.this.checkPackage(packageRef);
                PackageManager.this.checkPackageItems(packageRef);
                PackageManager.this.addPackageItems(packageRef);
                PackageManager.this.removePackageItems(packageRef);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        this.addItems.clear();
        this.removeItems.clear();
    }

    private void checkPackage(NodeRef packageRef) {
        if (packageRef == null || !this.nodeService.hasAspect(packageRef, PCKG_ASPECT)) {
            String msg = "The package NodeRef must implement the aspect: " + String.valueOf(PCKG_ASPECT);
            throw new WorkflowException(msg);
        }
    }

    private void removePackageItems(NodeRef packageRef) {
        for (NodeRef item : this.removeItems) {
            this.nodeService.removeChild(packageRef, item);
        }
    }

    private void addPackageItems(NodeRef packageRef) {
        for (NodeRef item : this.addItems) {
            String name = (String)((Object)this.nodeService.getProperty(item, ContentModel.PROP_NAME));
            if (name == null) {
                name = GUID.generate();
            }
            String localName = QName.createValidLocalName((String)name);
            QName qName = QName.createQName((String)CM_URL, (String)localName);
            this.behaviourFilter.disableBehaviour(item, ContentModel.ASPECT_AUDITABLE);
            try {
                this.nodeService.addChild(packageRef, item, PCKG_CONTAINS, qName);
            }
            finally {
                this.behaviourFilter.enableBehaviour(item, ContentModel.ASPECT_AUDITABLE);
            }
        }
    }

    private List<NodeRef> getCurrentItems(NodeRef packageRef) {
        List children = this.nodeService.getChildAssocs(packageRef, (QNamePattern)PCKG_CONTAINS, RegexQNamePattern.MATCH_ALL);
        ArrayList<NodeRef> results = new ArrayList<NodeRef>(children.size());
        for (ChildAssociationRef child : children) {
            results.add(child.getChildRef());
        }
        return results;
    }

    private void checkPackageItems(NodeRef packageRef) {
        List<NodeRef> currentitems = this.getCurrentItems(packageRef);
        Collection intersection = CollectionUtils.intersection(this.addItems, this.removeItems);
        this.addItems.removeAll(intersection);
        this.removeItems.removeAll(intersection);
        for (NodeRef node : intersection) {
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Item was added and removed from package! Ignoring item: " + String.valueOf(node)));
        }
        this.checkAddedItems(currentitems);
        this.checkRemovedItems(currentitems);
    }

    private void checkRemovedItems(List<NodeRef> currentitems) {
        Iterator<NodeRef> iter = this.removeItems.iterator();
        while (iter.hasNext()) {
            NodeRef removeItem = iter.next();
            if (currentitems.contains(removeItem)) continue;
            iter.remove();
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Ignoring item to remove, item not in package: " + String.valueOf(removeItem)));
        }
    }

    private void checkAddedItems(List<NodeRef> currentitems) {
        Iterator<NodeRef> iter = this.addItems.iterator();
        while (iter.hasNext()) {
            NodeRef addItem = iter.next();
            if (!currentitems.contains(addItem)) continue;
            iter.remove();
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Ignoring item to add, item already in package: " + String.valueOf(addItem)));
        }
    }
}

