/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.service.cmr.repository.AbstractTransformationSourceOptions;
import org.alfresco.service.cmr.repository.SerializedTransformationOptionsAccessor;
import org.alfresco.service.cmr.repository.TransformationSourceOptions;

public class CropSourceOptions
extends AbstractTransformationSourceOptions {
    private int height = -1;
    private int width = -1;
    private int xOffset = 0;
    private int yOffset = 0;
    private boolean isPercentageCrop = false;
    private String gravity = null;

    @Override
    public boolean isApplicableForMimetype(String sourceMimetype) {
        return sourceMimetype != null && sourceMimetype.startsWith("image/") || super.isApplicableForMimetype(sourceMimetype);
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public boolean isPercentageCrop() {
        return this.isPercentageCrop;
    }

    public void setPercentageCrop(boolean isPercentageCrop) {
        this.isPercentageCrop = isPercentageCrop;
    }

    public void setGravity(String gravity) {
        this.gravity = gravity;
    }

    public String getGravity() {
        return this.gravity;
    }

    @Override
    public TransformationSourceOptions.TransformationSourceOptionsSerializer getSerializer() {
        return CropSourceOptions.createSerializerInstance();
    }

    public static TransformationSourceOptions.TransformationSourceOptionsSerializer createSerializerInstance() {
        return new CropSourceOptions().new CropSourceOptionsSerializer();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CropSourceOptions [height=").append(this.height).append(", width=").append(this.width).append(", xOffset=").append(this.xOffset).append(", yOffset=").append(this.yOffset).append(", isPercentageCrop=").append(this.isPercentageCrop).append(", gravity=").append(this.gravity).append("]");
        return builder.toString();
    }

    public class CropSourceOptionsSerializer
    implements TransformationSourceOptions.TransformationSourceOptionsSerializer {
        public static final String PARAM_CROP_WIDTH = "crop_width";
        public static final String PARAM_CROP_HEIGHT = "crop_height";
        public static final String PARAM_CROP_X_OFFSET = "crop_x";
        public static final String PARAM_CROP_Y_OFFSET = "crop_y";
        public static final String PARAM_CROP_GRAVITY = "crop_gravity";
        public static final String PARAM_IS_PERCENT_CROP = "percent_crop";

        @Override
        public TransformationSourceOptions deserialize(SerializedTransformationOptionsAccessor serializedOptions) {
            int newWidth = serializedOptions.getIntegerParam(PARAM_CROP_WIDTH, -1);
            int newHeight = serializedOptions.getIntegerParam(PARAM_CROP_HEIGHT, -1);
            if (newHeight == -1 && newWidth == -1) {
                return null;
            }
            int xOffset = serializedOptions.getIntegerParam(PARAM_CROP_X_OFFSET, 0);
            int yOffset = serializedOptions.getIntegerParam(PARAM_CROP_Y_OFFSET, 0);
            boolean isPercentCrop = serializedOptions.getParamWithDefault(PARAM_IS_PERCENT_CROP, false);
            String gravity = serializedOptions.getCheckedParam(PARAM_CROP_GRAVITY, String.class);
            CropSourceOptions cropOptions = new CropSourceOptions();
            cropOptions.setGravity(gravity);
            cropOptions.setHeight(newHeight);
            cropOptions.setPercentageCrop(isPercentCrop);
            cropOptions.setWidth(newWidth);
            cropOptions.setXOffset(xOffset);
            cropOptions.setYOffset(yOffset);
            return cropOptions;
        }

        @Override
        public void serialize(TransformationSourceOptions sourceOptions, Map<String, Serializable> parameters) {
            if (parameters == null || sourceOptions == null) {
                return;
            }
            CropSourceOptions cropSourceOptions = (CropSourceOptions)sourceOptions;
            parameters.put(PARAM_CROP_WIDTH, Integer.valueOf(cropSourceOptions.getWidth()));
            parameters.put(PARAM_CROP_HEIGHT, Integer.valueOf(cropSourceOptions.getHeight()));
            parameters.put(PARAM_CROP_X_OFFSET, Integer.valueOf(cropSourceOptions.getXOffset()));
            parameters.put(PARAM_CROP_Y_OFFSET, Integer.valueOf(cropSourceOptions.getYOffset()));
            parameters.put(PARAM_CROP_GRAVITY, (Serializable)((Object)cropSourceOptions.getGravity()));
            parameters.put(PARAM_IS_PERCENT_CROP, Boolean.valueOf(cropSourceOptions.isPercentageCrop()));
        }
    }
}

